/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.contacts;

public class ContactValidator {
    private static final String EMAIL_PATTERN = "[a-z0-9%+-\\.]+\\@([a-z0-9]*\\.)+[a-z]{2,6}";
    private static final String FULL_EMAIL_PATTERN = "(.*<[a-z0-9%+-\\.]+\\@([a-z0-9]*\\.)+[a-z]{2,6}>.*|[a-z0-9%+-\\.]+\\@([a-z0-9]*\\.)+[a-z]{2,6})";
    private static final int EMAIL_MAX_LENGTH = 150;
    private static final String PHONE_STRIP_PATTERN = "[\\+\\(\\)\\-\\. x]+";

    private ContactValidator() {
    }

    public static boolean validateEmail(String email) {
        return email == null || email.trim().length() == 0 || email.length() <= 150 && email.toLowerCase().matches(FULL_EMAIL_PATTERN);
    }

    public static boolean validatePhone(String phone) {
        if (phone != null && phone.length() > 0) {
            String phoneStr = phone.replaceAll(PHONE_STRIP_PATTERN, "");
            try {
                Long.parseLong(phoneStr);
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }
}

