/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.contract;

import com.ericsson.cms.contractmgmt.client.model.UiContract;
import com.ericsson.cms.contractmgmt.client.model.UiCopyrightHolder;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerServiceAsync;
import com.ericsson.cms.contractmgmt.client.tab.contract.ContractListPanel;
import com.ericsson.cms.contractmgmt.client.tab.contract.UiContractRecord;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;

public class ContractAnchorChangeListener
implements WidgetMenuItem.AnchorChangeListener {
    private static final String CONTRACT_ID = "contractId";
    private static final String COPYRIGHT_HOLDER_ID = "copyrightId";
    private static final String PARAMETER_DELIMITER = "&";
    private static final String VALUE_DELIMITER = "=";
    private final ContractListPanel widget;

    public ContractAnchorChangeListener(ContractListPanel listPanel) {
        this.widget = listPanel;
    }

    public void anchorChanged(String anchor) {
        long contractId = 0L;
        long copyrightHolderId = 0L;
        if (anchor != null && anchor.contains(CONTRACT_ID)) {
            String[] params;
            this.widget.getContractTable().reset();
            anchor = anchor.substring(5);
            String[] stringArray = params = anchor.split(PARAMETER_DELIMITER);
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                String p = stringArray[n2];
                String[] paramValue = p.split(VALUE_DELIMITER);
                if (paramValue[0].equalsIgnoreCase(CONTRACT_ID)) {
                    contractId = Long.parseLong(paramValue[1]);
                }
                ++n2;
            }
            IContractManagerServiceAsync cmService = (IContractManagerServiceAsync)GWT.create(IContractManagerService.class);
            cmService.getContract(contractId, (AsyncCallback<UiContract>)new NeptuneAsyncCallback<UiContract>(){

                public void onNeptuneFailure(Throwable caught) {
                    Window.alert((String)caught.getLocalizedMessage());
                }

                public void onNeptuneSuccess(UiContract result) {
                    ContractAnchorChangeListener.this.widget.getContractTable().showDetailView((Record)new UiContractRecord(result));
                }
            });
        } else if (anchor != null && !anchor.contains(CONTRACT_ID) && anchor.contains(COPYRIGHT_HOLDER_ID)) {
            String[] params;
            this.widget.getContractTable().reset();
            anchor = anchor.substring(7);
            String[] stringArray = params = anchor.split(PARAMETER_DELIMITER);
            int n = params.length;
            int n3 = 0;
            while (n3 < n) {
                String p = stringArray[n3];
                String[] paramValue = p.split(VALUE_DELIMITER);
                if (paramValue[0].equalsIgnoreCase(COPYRIGHT_HOLDER_ID)) {
                    copyrightHolderId = Long.parseLong(paramValue[1]);
                }
                ++n3;
            }
            final UiContract uiContract = new UiContract();
            IContractManagerServiceAsync cmService = (IContractManagerServiceAsync)GWT.create(IContractManagerService.class);
            cmService.getCopyrightHolder(copyrightHolderId, (AsyncCallback<UiCopyrightHolder>)new NeptuneAsyncCallback<UiCopyrightHolder>(){

                public void onNeptuneFailure(Throwable caught) {
                    Window.alert((String)caught.getLocalizedMessage());
                }

                public void onNeptuneSuccess(UiCopyrightHolder result) {
                    uiContract.setCopyrightHolder(result);
                    uiContract.setName("");
                    ContractAnchorChangeListener.this.widget.getContractTable().showDetailView((Record)new UiContractRecord(uiContract));
                }
            });
        } else {
            this.widget.clearMessages();
            this.widget.getContractTable().setAnchor(anchor);
        }
    }
}

