/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.contract;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.model.ContractSearchResult;
import com.ericsson.cms.contractmgmt.client.model.UiContract;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerServiceAsync;
import com.ericsson.cms.contractmgmt.client.tab.contract.ContractListPanel;
import com.ericsson.cms.contractmgmt.client.tab.contract.UiContractRecord;
import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelStringView;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ContractDataProvider
implements DataProvider<Long, UiContractRecord> {
    private final List<Column<?, UiContractRecord>> columns;
    private final ColumnBase<String, UiContractRecord> nameColumn;
    private final ColumnBase<String, UiContractRecord> typeColumn;
    private final ColumnBase<String, UiContractRecord> expiryColumn;
    private final ContractComponentConstants constants = (ContractComponentConstants)GWT.create(ContractComponentConstants.class);
    private final IContractManagerServiceAsync contractManagerService = (IContractManagerServiceAsync)GWT.create(IContractManagerService.class);
    private PageFeature parentPageFeature;
    private SortFeatureImpl<Long, UiContractRecord> parentSortFeature;
    private static String NAME_COLUMN = "name";
    private static String TYPE_COLUMN = "contractType";
    private static String EXPIRY_DATE_COLUMN = "expiryDate";
    private IBusyNotifier busyNotifier;
    private static final String NON_ACTIVE_STYLE = "cell-NonActive";
    private static final String EXPIRED_STYLE = "cell-Expired";
    private static final String NON_ACTIVE_AND_EXPIRED = "cell-Expired-NonActive";
    private String cellStyle = null;

    public ContractDataProvider(ContractListPanel listsPanel) {
        this.columns = new ArrayList();
        this.nameColumn = new ColumnBase<String, UiContractRecord>(NAME_COLUMN, this.constants.contractName()){

            public View<String> getView(UiContractRecord record) {
                ContractDataProvider.this.cellStyle = ContractDataProvider.this.getCellStyle(record);
                return new LabelStringView(String.valueOf(record.getContract().getName()));
            }
        };
        this.nameColumn.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        this.columns.add((Column<?, UiContractRecord>)this.nameColumn);
        this.typeColumn = new ColumnBase<String, UiContractRecord>(TYPE_COLUMN, this.constants.contractType()){

            public View<String> getView(UiContractRecord record) {
                LabelStringView lb = new LabelStringView(record.getContract().getType().getName());
                if (ContractDataProvider.this.cellStyle != null) {
                    lb.setStyleName(ContractDataProvider.this.cellStyle);
                }
                return lb;
            }
        };
        this.typeColumn.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        this.columns.add((Column<?, UiContractRecord>)this.typeColumn);
        this.expiryColumn = new ColumnBase<String, UiContractRecord>(EXPIRY_DATE_COLUMN, this.constants.contractExpiryDate()){

            public View<String> getView(UiContractRecord record) {
                LabelStringView lb = new LabelStringView(record.getContract().getExpiryDate());
                if (ContractDataProvider.this.cellStyle != null) {
                    lb.setStyleName(ContractDataProvider.this.cellStyle);
                }
                return lb;
            }
        };
        this.expiryColumn.setCellStyle("nwt-TableColumnPanel-dataCell-date");
        this.columns.add((Column<?, UiContractRecord>)this.expiryColumn);
    }

    private final String getCellStyle(UiContractRecord record) {
        DateTimeFormat dateFormatter = DateTimeFormat.getFormat((String)this.constants.dateFormat());
        String now = dateFormatter.format(new Date());
        if (!record.getContract().isActive() && now.compareTo(record.getContract().getExpiryDate()) > 0) {
            return NON_ACTIVE_AND_EXPIRED;
        }
        if (!record.getContract().isActive()) {
            return NON_ACTIVE_STYLE;
        }
        if (now.compareTo(record.getContract().getExpiryDate()) > 0) {
            return EXPIRED_STYLE;
        }
        return null;
    }

    public ColumnBase<String, UiContractRecord> getDefaultSortColumn() {
        return this.nameColumn;
    }

    public List<Column<?, UiContractRecord>> getSortColumns() {
        return this.columns;
    }

    public List<Column<?, UiContractRecord>> getColumns() {
        return this.columns;
    }

    public void getRecord(Long key, final AsyncCallback<UiContractRecord> callback) {
        this.notifyBusyStart();
        this.contractManagerService.getContract(key, (AsyncCallback<UiContract>)new NeptuneAsyncCallback<UiContract>(){

            public void onNeptuneFailure(Throwable caught) {
                callback.onFailure(caught);
                ContractDataProvider.this.notifyBusyFinish();
            }

            public void onNeptuneSuccess(UiContract result) {
                callback.onSuccess((Object)new UiContractRecord(result));
                ContractDataProvider.this.notifyBusyFinish();
            }
        });
    }

    public void getRecords(final AsyncCallback<List<UiContractRecord>> callback) {
        int length = this.getParentPageFeature().getPageSize();
        int start = (this.getParentPageFeature().getPageNumber() - 1) * length;
        this.notifyBusyStart();
        this.contractManagerService.getContractList(start, length, this.getParentSortFeature().getSortColumnName(), this.getParentSortFeature().isAscending(), (AsyncCallback<ContractSearchResult>)new NeptuneAsyncCallback<ContractSearchResult>(){

            public void onNeptuneFailure(Throwable caught) {
                ContractDataProvider.this.getParentPageFeature().setRecordCount(-1);
                callback.onFailure(caught);
                ContractDataProvider.this.notifyBusyFinish();
            }

            public void onNeptuneSuccess(ContractSearchResult result) {
                ContractDataProvider.this.getParentPageFeature().setRecordCount(result.getTotalCount());
                callback.onSuccess(ContractDataProvider.this.getContractRecordList((ArrayList)result.getUiContractList()));
                ContractDataProvider.this.notifyBusyFinish();
            }
        });
    }

    public List<UiContractRecord> getContractRecordList(List<UiContract> uiContractList) {
        ArrayList<UiContractRecord> list = new ArrayList<UiContractRecord>();
        for (UiContract uiContract : uiContractList) {
            UiContractRecord record = new UiContractRecord();
            record.setContract(uiContract);
            list.add(record);
        }
        return list;
    }

    public void initialize(AsyncCallback<Void> callback) {
        callback.onSuccess(null);
    }

    public boolean isCheckboxEnabled() {
        return true;
    }

    public boolean isRecordCountEnabled() {
        return true;
    }

    public PageFeature getParentPageFeature() {
        return this.parentPageFeature;
    }

    public void setParentPageFeature(PageFeature parentPageFeature) {
        this.parentPageFeature = parentPageFeature;
    }

    public SortFeatureImpl<Long, UiContractRecord> getParentSortFeature() {
        return this.parentSortFeature;
    }

    public void setParentSortFeature(SortFeatureImpl<Long, UiContractRecord> parentSortFeature) {
        this.parentSortFeature = parentSortFeature;
    }

    public void setBusyNotifier(IBusyNotifier busyNotifier) {
        this.busyNotifier = busyNotifier;
    }

    private void notifyBusyStart() {
        if (this.busyNotifier != null) {
            this.busyNotifier.startingToBeBusy();
        }
    }

    private void notifyBusyFinish() {
        if (this.busyNotifier != null) {
            this.busyNotifier.doneBeingBusy();
        }
    }

    public static interface IBusyNotifier {
        public void startingToBeBusy();

        public void doneBeingBusy();
    }
}

