/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.contract;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.ContractComponentMessages;
import com.ericsson.cms.contractmgmt.client.model.UiContract;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerServiceAsync;
import com.ericsson.cms.contractmgmt.client.tab.UiLongKeySerializer;
import com.ericsson.cms.contractmgmt.client.tab.contract.ContractDetailView;
import com.ericsson.cms.contractmgmt.client.tab.contract.ContractListPanel;
import com.ericsson.cms.contractmgmt.client.tab.contract.UiContractRecord;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.KeySerializer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.AbstractDetailFeature;
import java.util.ArrayList;
import java.util.List;

public class ContractDetailFeature
extends AbstractDetailFeature<Long, UiContractRecord> {
    private final ContractComponentConstants constants = (ContractComponentConstants)GWT.create(ContractComponentConstants.class);
    private final ContractComponentMessages messages = (ContractComponentMessages)GWT.create(ContractComponentMessages.class);
    private final IContractManagerServiceAsync contractManagerService = (IContractManagerServiceAsync)GWT.create(IContractManagerService.class);
    private final ContractListPanel parentPanel;
    private Long copyrightHolderId;

    public ContractDetailFeature(ContractListPanel parentPanel) {
        super((KeySerializer)new UiLongKeySerializer());
        this.parentPanel = parentPanel;
    }

    public void delete(List<UiContractRecord> records, final AsyncCallback<Void> callback) {
        if (records != null && !records.isEmpty()) {
            if (Window.confirm((String)this.messages.deleteContractConfirmation())) {
                ArrayList<UiContract> contractList = new ArrayList<UiContract>();
                for (UiContractRecord record : records) {
                    contractList.add(record.getContract());
                }
                this.contractManagerService.deleteContracts(contractList, (AsyncCallback<Boolean>)new NeptuneAsyncCallback<Boolean>(){

                    public void onNeptuneFailure(Throwable caught) {
                        ContractDetailFeature.this.parentPanel.getErrorPanel().showMessage(ContractDetailFeature.this.messages.deleteContractError());
                        callback.onFailure(caught);
                    }

                    public void onNeptuneSuccess(Boolean result) {
                        ContractDetailFeature.this.parentPanel.getSuccessPanel().showMessage(ContractDetailFeature.this.messages.deleteContractSucceeded());
                        callback.onSuccess(null);
                    }
                });
            }
        } else {
            Window.alert((String)this.messages.noContractSelected());
        }
    }

    public void getNew(AsyncCallback<UiContractRecord> callback) {
        this.parentPanel.clearMessages();
        callback.onSuccess((Object)new UiContractRecord(new UiContract()));
    }

    public DetailView<Long, UiContractRecord> getView(UiContractRecord record, DetailViewCallback<Long, UiContractRecord> callback) {
        this.parentPanel.clearMessages();
        ContractDetailView view = new ContractDetailView(record, callback);
        return view;
    }

    public boolean hasDetailLink(Column<?, UiContractRecord> column) {
        return column.getDisplayName().equals(this.constants.contractNameColumn()) && ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_View"});
    }

    public void save(UiContractRecord record, final AsyncCallback<Void> callback) {
        this.contractManagerService.saveContract(record.getContract(), (AsyncCallback<Boolean>)new NeptuneAsyncCallback<Boolean>(){

            public void onNeptuneFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onNeptuneSuccess(Boolean result) {
                History.back();
            }
        });
    }

    public boolean showCreateButton() {
        return ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Create"});
    }

    public boolean showDeleteButton() {
        return ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Delete"});
    }

    public Long getCopyrightHolderId() {
        return this.copyrightHolderId;
    }

    public void setCopyrightHolderId(Long copyrightHolderId) {
        this.copyrightHolderId = copyrightHolderId;
    }
}

