/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.contract;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.ContractComponentMessages;
import com.ericsson.cms.contractmgmt.client.HelpWidget;
import com.ericsson.cms.contractmgmt.client.customfield.CustomFieldFactory;
import com.ericsson.cms.contractmgmt.client.customfield.CustomFieldValidator;
import com.ericsson.cms.contractmgmt.client.customfield.UiUserDefinedField;
import com.ericsson.cms.contractmgmt.client.customfield.UiUserDefinedFieldValue;
import com.ericsson.cms.contractmgmt.client.document.DocumentComponentFactory;
import com.ericsson.cms.contractmgmt.client.model.UiContact;
import com.ericsson.cms.contractmgmt.client.model.UiContactType;
import com.ericsson.cms.contractmgmt.client.model.UiContract;
import com.ericsson.cms.contractmgmt.client.model.UiContractType;
import com.ericsson.cms.contractmgmt.client.model.UiCopyrightHolder;
import com.ericsson.cms.contractmgmt.client.model.UiDeal;
import com.ericsson.cms.contractmgmt.client.model.UiDocument;
import com.ericsson.cms.contractmgmt.client.model.UiDocumentType;
import com.ericsson.cms.contractmgmt.client.model.UiKeyName;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownServiceAsync;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerServiceAsync;
import com.ericsson.cms.contractmgmt.client.tab.ContractFormContainer;
import com.ericsson.cms.contractmgmt.client.tab.ErrorPanel;
import com.ericsson.cms.contractmgmt.client.tab.SuccessPanel;
import com.ericsson.cms.contractmgmt.client.tab.config.PositiveIntegerConverter;
import com.ericsson.cms.contractmgmt.client.tab.contacts.ContactListTable;
import com.ericsson.cms.contractmgmt.client.tab.contract.UiContractRecord;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.RoundedDisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.DataTypeWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedDateBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedTextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.DateConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IDateConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IValueConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IntegerConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.StringConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ContractDetailView
extends Composite
implements DetailView<Long, UiContractRecord> {
    private static final String ROW_HEADER_STYLE = "contract-table-row-header";
    private static final String TABLE_STYLE = "contract-table";
    private static final String ROW_STYLE = "contract-table-row";
    private static final String ROW_BODY_STYLE = "contract-table-row-body";
    private static final String CELL_STYLE = "contract-table-cell";
    private static final String CELL_HEADER_STYLE = "contract-table-cell-header";
    private static final String LINK_BEHAVIOUR = "contract-Link";
    private static final String CONTAINER_STYLE = "realm-UserForm contract-Container";
    private static final String EB_ICON_DISABLED = "ebIcon_disabled";
    private static final String CONTENT_LISTBOX_WIDTH = "130px";
    private static final String TEXTBOXWIDGET_WIDTH = "150px";
    private static final String DATE_BOX_WIDTH = "90px";
    private static final int MAX_LENGTH = 50;
    private static final int EXTERNAL_ID_MAX_LENGTH = 100;
    private static final String DELETE_IMAGE = "cms_contractmgmt_ui/images/delete.png";
    private static final String DELETE_CELL_STYLE = "contract-table-cell-body-delete";
    private final ContractComponentConstants constants = (ContractComponentConstants)GWT.create(ContractComponentConstants.class);
    private final ContractComponentMessages messages = (ContractComponentMessages)GWT.create(ContractComponentMessages.class);
    private final IContractManagerServiceAsync contractManagerService = (IContractManagerServiceAsync)GWT.create(IContractManagerService.class);
    private final IContractManagerDropDownServiceAsync dropDownService = (IContractManagerDropDownServiceAsync)GWT.create(IContractManagerDropDownService.class);
    private final UiContractRecord record;
    private final DetailViewCallback<Long, UiContractRecord> callback;
    private final VerticalContainer mainContainer;
    private RoundedDisclosureContainer dealsContainer;
    private ContractFormContainer formUserDefinedFields;
    private ContractFormContainer formContainer;
    private FlexTableContainer tableDeals;
    private ButtonWidget addButton;
    private ButtonWidget saveButton;
    private DocumentComponentFactory documentComponent;
    private RoundedDisclosureContainer documentsContainer;
    private final Map<DataTypeWidget<?>, UiUserDefinedField> widgetCustomFieldMap = new HashMap();
    private TypedListBoxWidget<Long> copyrightHolder;
    private final TypedListBoxWidget<Long> type;
    private TypedTextBoxWidget<String> name;
    private TypedTextBoxWidget<Integer> expiryReminder;
    private TypedTextBoxWidget<String> externalIdTextBox;
    private final SuccessPanel successPanel = new SuccessPanel();
    private final ErrorPanel errorPanel = new ErrorPanel();
    private final TypedDateBoxWidget contractCreationDate = new TypedDateBoxWidget((IDateConverter)new DateConverter(this.constants.dateFormat(), this.constants.dateFormat()));
    private final TypedDateBoxWidget contractEffectiveDate = new TypedDateBoxWidget((IDateConverter)new DateConverter(this.constants.dateFormat(), this.constants.dateFormat()));
    private final TypedDateBoxWidget contractExpiryDate = new TypedDateBoxWidget((IDateConverter)new DateConverter(this.constants.dateFormat(), this.constants.dateFormat()));
    private HorizontalContainer buttonsContainer;
    private final ContactListTable contactListPanel;
    private final BusyIndicator busyIndicator = new BusyIndicator();
    private List<UiDocument> documentsList = new ArrayList<UiDocument>();
    private final List<UiUserDefinedFieldValue> userDefinedFieldValueList = new ArrayList<UiUserDefinedFieldValue>();
    private final VerticalContainer contractDtlsContainer;
    private final VerticalContainer contractDocContainer;
    private RoundedDisclosureContainer contactsContainer;
    private VerticalContainer dealsVerticalContainer;

    public ContractDetailView(UiContractRecord record, DetailViewCallback<Long, UiContractRecord> callback) {
        this.record = record;
        this.callback = callback;
        this.mainContainer = new VerticalContainer();
        this.mainContainer.add((Widget)this.successPanel);
        this.mainContainer.add((Widget)this.errorPanel);
        this.busyIndicator.center();
        this.initWidget((Widget)this.mainContainer);
        this.contractDtlsContainer = new VerticalContainer();
        this.contractDocContainer = new VerticalContainer();
        this.type = this.getTypeListBox(0L);
        if (record.getContract().getUiContactList() == null) {
            record.getContract().setUiContactList(new ArrayList<UiContact>());
        }
        this.contactListPanel = new ContactListTable(record.getContract().getUiContactList(), this.constants.contactRecordDisplayName());
        this.contactListPanel.setContactType(UiContactType.CONTRACT);
        this.contactListPanel.createTable();
    }

    private void fillForm() {
        this.externalIdTextBox.setValue((Object)this.record.getContract().getExternalId());
        this.name.setValue((Object)this.record.getContract().getName());
        this.type.setSelectedItem((Object)this.record.getContract().getType().getKey());
        this.copyrightHolder.setSelectedItem((Object)this.record.getContract().getCopyrightHolder().getKey());
        this.contractCreationDate.setValue(this.record.getContract().getCreationDate());
        this.contractEffectiveDate.setValue(this.record.getContract().getEffectiveDate());
        this.contractExpiryDate.setValue(this.record.getContract().getExpiryDate());
        if (this.record.getContract().getDealExpiryReminder() != null) {
            this.expiryReminder.setValue((Object)this.record.getContract().getDealExpiryReminder().intValue());
        }
        for (UiDocument doc : this.documentsList) {
            this.documentComponent.addRow(doc);
        }
        if (this.record.getContract().getUiDealsList() != null && !this.record.getContract().getUiDealsList().isEmpty()) {
            this.fillDealTable(this.record.getContract().getUiDealsList());
        }
    }

    private void addRowDeals(UiDeal deal) {
        this.insertRow();
        int row = this.getRow();
        this.tableDeals.getRowFormatter().setStyleName(row, row % 2 == 0 ? "table-data-even-row" : "table-data-odd-row");
        LabelWidget link = new LabelWidget();
        link.setText(deal.getName());
        final String url = "Contracts.Deal.Edit?dealId=" + this.record.getContract().getUiDealsList().get(row - 1).getKey();
        link.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                History.newItem((String)url);
            }
        });
        link.setStyleName(LINK_BEHAVIOUR);
        this.tableDeals.setWidget(row, 0, (Widget)link);
        LabelWidget label = new LabelWidget();
        label.setText(deal.getType().getName());
        this.tableDeals.setWidget(row, 1, (Widget)label);
        label = new LabelWidget();
        label.setText(deal.getExpiryDate());
        this.tableDeals.setWidget(row, 2, (Widget)label);
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Delete"}) && this.record.getKey() != null) {
            ImageWidget removeButton = new ImageWidget(DELETE_IMAGE);
            removeButton.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    ContractDetailView.this.removeRow(event);
                }
            });
            this.tableDeals.setWidget(row, 3, (Widget)removeButton);
            this.tableDeals.getCellFormatter().setStyleName(row, 3, DELETE_CELL_STYLE);
        }
    }

    private void insertRow() {
        this.tableDeals.insertRow(this.tableDeals.getRowCount());
        this.tableDeals.getRowFormatter().addStyleName(this.getRow(), ROW_STYLE);
        this.tableDeals.getRowFormatter().addStyleName(this.getRow(), ROW_BODY_STYLE);
    }

    private void init() {
        this.buttonsContainer = new HorizontalContainer();
        this.formContainer = new ContractFormContainer(HasHorizontalAlignment.ALIGN_LEFT);
        this.formUserDefinedFields = new ContractFormContainer(HasHorizontalAlignment.ALIGN_LEFT);
        this.copyrightHolder.setWidth(CONTENT_LISTBOX_WIDTH);
        this.copyrightHolder.ensureDebugId("contract-copyrightHolder");
        this.externalIdTextBox = new TypedTextBoxWidget((IValueConverter)new StringConverter());
        this.externalIdTextBox.setMaxLength(100);
        this.name = new TypedTextBoxWidget((IValueConverter)new StringConverter());
        this.name.setMaxLength(50);
        this.name.ensureDebugId("contract-name");
        this.type.setWidth(CONTENT_LISTBOX_WIDTH);
        this.type.ensureDebugId("contract-type");
        this.contractCreationDate.setWidth(DATE_BOX_WIDTH);
        this.contractCreationDate.ensureDebugId("contract-createDate");
        this.contractEffectiveDate.setWidth(DATE_BOX_WIDTH);
        this.contractEffectiveDate.ensureDebugId("contract-effectiveDate");
        this.contractExpiryDate.setWidth(DATE_BOX_WIDTH);
        this.contractExpiryDate.ensureDebugId("contract-expireDate");
        this.expiryReminder = new TypedTextBoxWidget((IValueConverter)new PositiveIntegerConverter());
        this.expiryReminder.setWidth(TEXTBOXWIDGET_WIDTH);
        this.formContainer.addRow(this.constants.contractCopyrightHolder(), (Widget)this.copyrightHolder, true);
        this.formContainer.addRow(this.constants.externalID(), (Widget)this.externalIdTextBox);
        this.formContainer.addRow(this.constants.contractName(), (Widget)this.name, true);
        this.formContainer.addRow(this.constants.contractType(), (Widget)this.type, true);
        this.formContainer.addRow(this.constants.contractCreationDate(), (Widget)this.contractCreationDate, true);
        this.formContainer.addRow(this.constants.contractEffectiveDate(), (Widget)this.contractEffectiveDate, true);
        this.formContainer.addRow(this.constants.contractExpiryDate(), (Widget)this.contractExpiryDate, true);
        this.formContainer.addRow(this.constants.contractExpiryReminder(), (Widget)this.expiryReminder);
        final Long editing = this.record.getKey();
        this.contractManagerService.getUserDefinedFields("CONTRACT", (AsyncCallback<List<UiUserDefinedField>>)new NeptuneAsyncCallback<List<UiUserDefinedField>>(){

            public void onNeptuneFailure(Throwable caught) {
                ContractDetailView.this.errorPanel.showMessage(caught.getLocalizedMessage());
            }

            public void onNeptuneSuccess(List<UiUserDefinedField> result) {
                CustomFieldFactory factory = new CustomFieldFactory(null);
                factory.addFieldsToForm(ContractDetailView.this.formUserDefinedFields, result, ContractDetailView.this.widgetCustomFieldMap);
                for (UiUserDefinedField uiUserDefinedField : result) {
                    UiUserDefinedFieldValue value = new UiUserDefinedFieldValue();
                    value.setIdUserDefinedField(uiUserDefinedField.getIdUserDefinedField());
                    if (editing == null) {
                        value.setValue(uiUserDefinedField.getDefaultValue());
                    }
                    ContractDetailView.this.userDefinedFieldValueList.add(value);
                }
                ContractDetailView.this.createUpdateUserDefinedFieldValues();
                if (ContractDetailView.this.record.getContract().getUserDefinedFieldsValues() != null) {
                    ContractDetailView.this.updateFormFromUserDefinedFieldValues(ContractDetailView.this.record.getContract().getUserDefinedFieldsValues());
                }
            }
        });
        this.buildDisclosureDeals();
        this.addButtons();
        this.contactListPanel.setContactType(UiContactType.CONTRACT);
        this.contractDtlsContainer.addStyleName(CONTAINER_STYLE);
        this.contractDtlsContainer.add((Widget)this.formContainer);
        RoundedDisclosureContainer userDefinedContainer = new RoundedDisclosureContainer(this.constants.userDefinedFields());
        userDefinedContainer.add((Widget)this.formUserDefinedFields);
        userDefinedContainer.setOpen(false);
        this.contractDtlsContainer.add((Widget)userDefinedContainer);
        this.contactsContainer = new RoundedDisclosureContainer(this.constants.copyrightHolderContactSectionHeading());
        this.contactsContainer.add((Widget)this.contactListPanel);
        this.contactsContainer.setOpen(true);
        this.contractDtlsContainer.add((Widget)this.contactsContainer);
        this.mainContainer.add((Widget)this.contractDtlsContainer);
        this.mainContainer.add((Widget)this.buttonsContainer);
        this.documentComponent = new DocumentComponentFactory(this.record.getKey(), this.constants.contractDocuments(), UiDocumentType.CONTRACT, this.errorPanel);
        this.documentsContainer = this.documentComponent.getDocumentPanel();
        this.contractDocContainer.add((Widget)this.documentsContainer);
        this.contractDocContainer.add((Widget)this.dealsContainer);
        this.contractDocContainer.addStyleName(CONTAINER_STYLE);
        this.mainContainer.add((Widget)this.contractDocContainer);
        if (this.record.getKey() != null) {
            this.documentsList = this.record.getContract().getUiDocumentList();
            this.documentComponent.setDocumentsList(this.documentsList);
            this.fillForm();
        } else if (this.record.getContract().getCopyrightHolder() != null) {
            this.copyrightHolder.setSelectedItem((Object)this.record.getContract().getCopyrightHolder().getKey());
        }
        this.verifyPermissions();
        this.busyIndicator.hide();
    }

    private void addHeading(String heading, FlexTableContainer table) {
        int column = table.getCellCount(0);
        table.insertCell(0, column);
        table.getCellFormatter().addStyleName(0, column, CELL_STYLE);
        table.getCellFormatter().addStyleName(0, column, CELL_HEADER_STYLE);
        this.updateHeading(table, heading, column);
    }

    private void updateHeading(FlexTableContainer table, String heading, int column) {
        LabelWidget label = this.getHeadingWidget(table, column);
        if (label == null) {
            label = new LabelWidget(heading);
            label.addStyleName("table-header-nonSortable-text");
            table.setWidget(0, column, (Widget)label);
        } else {
            label.setText(heading);
        }
    }

    private LabelWidget getHeadingWidget(FlexTableContainer table, int column) {
        Widget widget = table.getWidget(0, column);
        return widget instanceof LabelWidget ? (LabelWidget)widget : null;
    }

    private void addButtons() {
        this.buttonsContainer.setWidth("10%");
        this.buttonsContainer.addStyleName("cms_button_container");
        this.saveButton = new ButtonWidget(this.constants.saveButtonName(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (ContractDetailView.this.validate()) {
                    ContractDetailView.this.commit();
                    ContractDetailView.this.callback.save((DetailView)ContractDetailView.this);
                }
            }
        });
        this.saveButton.removeStyleName("gwt-Button");
        this.saveButton.addStyleName("ebBtn");
        this.saveButton.addStyleName("ebBtn_color_green");
        this.saveButton.addStyleName("save_button_icon");
        this.saveButton.setEnabled(false);
        this.saveButton.ensureDebugId("contract-save");
        this.buttonsContainer.add((Widget)this.saveButton);
        ButtonWidget cancelButton = new ButtonWidget(this.constants.cancelButtonName(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                ContractDetailView.this.errorPanel.reset();
                History.back();
            }
        });
        cancelButton.removeStyleName("gwt-Button");
        cancelButton.addStyleName("ebBtn");
        this.buttonsContainer.add((Widget)cancelButton);
    }

    private boolean validate() {
        boolean valid;
        this.errorPanel.reset();
        boolean bl = valid = this.formContainer.validate() && this.formUserDefinedFields.validate();
        if (valid) {
            if (this.record.getKey() != null) {
                for (UiDeal uiDeal : this.record.getContract().getUiDealsList()) {
                    if (uiDeal.getCreationDate().compareTo(this.contractCreationDate.getTextValue()) < 0) {
                        valid = false;
                        this.errorPanel.addHeading1(this.messages.contractDealCreationDateValidation(uiDeal.getName()));
                        continue;
                    }
                    if (uiDeal.getEffectiveDate().compareTo(this.contractEffectiveDate.getTextValue()) < 0) {
                        valid = false;
                        this.errorPanel.addHeading1(this.messages.contractDealEffectiveDateValidation(uiDeal.getName()));
                        continue;
                    }
                    if (uiDeal.getExpiryDate().compareTo(this.contractExpiryDate.getTextValue()) <= 0) continue;
                    valid = false;
                    this.errorPanel.addHeading1(this.messages.contractDealExpiryDateValidation(uiDeal.getName()));
                }
            }
            if ((Long)this.copyrightHolder.getSelectedItem() == 0L) {
                valid = false;
                this.errorPanel.addHeading1(this.constants.contractCRHValidation());
            }
            if (this.contractCreationDate.getDatePicker().getValue().after(this.contractEffectiveDate.getDatePicker().getValue())) {
                valid = false;
                this.errorPanel.addHeading1(this.constants.contractCreationDateValidation());
            }
            if (this.contractEffectiveDate.getDatePicker().getValue().after(this.contractExpiryDate.getDatePicker().getValue())) {
                valid = false;
                this.errorPanel.addHeading1(this.constants.contractEffectiveDateValidation());
            }
            Set<Map.Entry<DataTypeWidget<?>, UiUserDefinedField>> entrySet = this.widgetCustomFieldMap.entrySet();
            for (Map.Entry<DataTypeWidget<?>, UiUserDefinedField> entry : entrySet) {
                DataTypeWidget<?> dataTypeWidget = entry.getKey();
                CustomFieldValidator.validate(dataTypeWidget, entry.getValue());
                if (dataTypeWidget.isValidValue() && !dataTypeWidget.hasValidationError()) continue;
                valid = false;
            }
        }
        if (!valid) {
            this.errorPanel.addHeading1("Contract with validation errors.");
        }
        return valid;
    }

    private void fillDealTable(List<UiDeal> result) {
        for (UiDeal deal : result) {
            this.addRowDeals(deal);
        }
    }

    private void buildDisclosureDeals() {
        this.dealsContainer = new RoundedDisclosureContainer(this.constants.contractDeals());
        this.dealsVerticalContainer = new VerticalContainer();
        this.tableDeals = new FlexTableContainer();
        this.tableDeals.addStyleName(TABLE_STYLE);
        this.tableDeals.insertRow(0);
        this.tableDeals.getRowFormatter().addStyleName(0, ROW_STYLE);
        this.tableDeals.getRowFormatter().addStyleName(0, ROW_HEADER_STYLE);
        this.createTableDealsHeader();
        LabelWidget label = new LabelWidget();
        label.setHeight("30px");
        this.dealsVerticalContainer.add((Widget)this.tableDeals);
        this.addButtonsDeals();
        this.dealsContainer.add((Widget)this.dealsVerticalContainer);
        this.dealsContainer.setOpen(true);
    }

    private void createTableDealsHeader() {
        this.tableDeals.getRowFormatter().setStyleName(0, "table-header-row");
        this.addHeading(this.constants.contractDealName(), this.tableDeals);
        this.addHeading(this.constants.contractDealType(), this.tableDeals);
        this.addHeading(this.constants.dealExpiryDate(), this.tableDeals);
    }

    private TypedListBoxWidget<Long> getCopyrightHolderListBox(final Long selected) {
        final TypedListBoxWidget lbCopyrightHolder = new TypedListBoxWidget((IValueConverter)new IntegerConverter());
        this.dropDownService.getCopyrightHolderKeyNameList((AsyncCallback<List<UiKeyName>>)new NeptuneAsyncCallback<List<UiKeyName>>(){

            public void onNeptuneFailure(Throwable caught) {
                Window.alert((String)ContractDetailView.this.constants.failureGettingCopyrightHolders());
            }

            public void onNeptuneSuccess(List<UiKeyName> result) {
                ContractDetailView.this.fillListBox((TypedListBoxWidget<Long>)lbCopyrightHolder, selected, result);
                ContractDetailView.this.init();
            }
        });
        return lbCopyrightHolder;
    }

    private void fillListBox(TypedListBoxWidget<Long> listBox, Long selected, List<UiKeyName> result) {
        listBox.addItem("", null);
        for (UiKeyName keyName : result) {
            listBox.addItem(keyName.getName(), (Object)keyName.getKey());
        }
        listBox.setSelectedItem((Object)selected);
    }

    private void addButtonsDeals() {
        HorizontalContainer buttons = new HorizontalContainer();
        this.addButton = new ButtonWidget(this.constants.addContractDealButtonName(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (ContractDetailView.this.contactListPanel.isDirty() && !Window.confirm((String)ContractDetailView.this.constants.confirmLoseContactChanges())) {
                    return;
                }
                History.newItem((String)("Contracts.Deal.Create?contractId=" + ContractDetailView.this.record.getKey()));
            }
        });
        this.addButton.removeStyleName("gwt-Button");
        this.addButton.addStyleName("ebBtn");
        this.addButton.addStyleName("addgreen_button_icon");
        this.addButton.setEnabled(false);
        buttons.add((Widget)this.addButton);
        buttons.setCellVerticalAlignment((Widget)this.addButton, HasVerticalAlignment.ALIGN_MIDDLE);
        if (this.record.getKey() == null) {
            HelpWidget helpWidget = new HelpWidget(this.messages.addThingLater(this.constants.deal()));
            buttons.add((Widget)helpWidget);
            buttons.setCellVerticalAlignment((Widget)helpWidget, HasVerticalAlignment.ALIGN_MIDDLE);
            this.addButton.addStyleName(EB_ICON_DISABLED);
        }
        this.dealsVerticalContainer.add((Widget)buttons);
    }

    private int getRow() {
        return this.tableDeals.getRowCount() - 1;
    }

    private void removeRow(ClickEvent event) {
        ArrayList<UiDeal> deleteList = new ArrayList<UiDeal>();
        final int rowdeleteIndex = this.tableDeals.getCellForEvent(event).getRowIndex();
        deleteList.add(this.record.getContract().getUiDealsList().get(rowdeleteIndex - 1));
        if (deleteList.isEmpty()) {
            Window.alert((String)this.messages.noDealSelected());
        } else if (Window.confirm((String)this.messages.deleteDealConfirmation())) {
            this.busyIndicator.center();
            this.contractManagerService.deleteDeals(deleteList, (AsyncCallback<Boolean>)new NeptuneAsyncCallback<Boolean>(){

                public void onNeptuneFailure(Throwable caught) {
                    ContractDetailView.this.errorPanel.showMessage(caught.getLocalizedMessage());
                    ContractDetailView.this.busyIndicator.hide();
                }

                public void onNeptuneSuccess(Boolean result) {
                    ContractDetailView.this.tableDeals.removeRow(rowdeleteIndex);
                    ContractDetailView.this.record.getContract().getUiDealsList().remove(rowdeleteIndex - 1);
                    ContractDetailView.this.busyIndicator.hide();
                }
            });
        }
    }

    private TypedListBoxWidget<Long> getTypeListBox(final Long selected) {
        final TypedListBoxWidget lbType = new TypedListBoxWidget((IValueConverter)new IntegerConverter());
        this.dropDownService.getContractTypeKeyNameList((AsyncCallback<List<UiKeyName>>)new NeptuneAsyncCallback<List<UiKeyName>>(){

            public void onNeptuneFailure(Throwable caught) {
                ContractDetailView.this.errorPanel.showMessage(caught.getLocalizedMessage());
            }

            public void onNeptuneSuccess(List<UiKeyName> result) {
                ContractDetailView.this.fillListBox((TypedListBoxWidget<Long>)lbType, selected, result);
                if (ContractDetailView.this.record.getKey() != null) {
                    ContractDetailView.this.getDealsList();
                } else {
                    ContractDetailView.this.copyrightHolder = ContractDetailView.this.getCopyrightHolderListBox(0L);
                }
            }
        });
        return lbType;
    }

    private void getDealsList() {
        this.contractManagerService.getContractDealsList(this.record.getKey(), (AsyncCallback<List<UiDeal>>)new NeptuneAsyncCallback<List<UiDeal>>(){

            public void onNeptuneFailure(Throwable caught) {
                ContractDetailView.this.errorPanel.showMessage(caught.getLocalizedMessage());
            }

            public void onNeptuneSuccess(List<UiDeal> result) {
                ContractDetailView.this.record.getContract().setUiDealsList(result);
                ContractDetailView.this.copyrightHolder = ContractDetailView.this.getCopyrightHolderListBox(0L);
            }
        });
    }

    public void commit() {
        UiContract contract = new UiContract();
        UiCopyrightHolder copyright = new UiCopyrightHolder();
        copyright.setKey((Long)this.copyrightHolder.getSelectedItem());
        contract.setCopyrightHolder(copyright);
        UiContractType uiType = new UiContractType();
        uiType.setKey((Long)this.type.getSelectedItem());
        uiType.setName(this.type.getItemText(this.type.getSelectedIndex()));
        contract.setType(uiType);
        contract.setKey(this.record.getContract().getKey());
        contract.setExternalId(this.externalIdTextBox.getText() != null ? this.externalIdTextBox.getText().trim() : null);
        contract.setActive(true);
        contract.setCreationDate(this.contractCreationDate.getTextValue());
        contract.setEffectiveDate(this.contractEffectiveDate.getTextValue());
        contract.setExpiryDate(this.contractExpiryDate.getTextValue());
        if (this.expiryReminder.getValue() != null) {
            contract.setDealExpiryReminder(new Long(((Integer)this.expiryReminder.getValue()).toString()));
        }
        contract.setName(this.name.getText().trim());
        contract.setUiContactList(this.contactListPanel.getCollapsedRecordList());
        contract.setUiDocumentList(this.documentsList);
        this.updateUserDefinedFieldsValuesFromForm(this.userDefinedFieldValueList);
        contract.setUserDefinedFieldsValues(this.userDefinedFieldValueList);
        contract.setUiDealsList(this.record.getContract().getUiDealsList());
        this.record.setContract(contract);
    }

    private void createUpdateUserDefinedFieldValues() {
        for (UiUserDefinedField uiUserDefinedField : this.widgetCustomFieldMap.values()) {
            UiUserDefinedFieldValue uiUserDefinedFieldValue = this.findUiUserDefinedFieldValue(uiUserDefinedField.getIdUserDefinedField(), this.record.getContract().getUserDefinedFieldsValues());
            if (uiUserDefinedFieldValue != null) continue;
            uiUserDefinedFieldValue = new UiUserDefinedFieldValue();
            uiUserDefinedFieldValue.setIdUserDefinedField(uiUserDefinedField.getIdUserDefinedField());
            uiUserDefinedFieldValue.setValue(uiUserDefinedField.getDefaultValue());
            this.record.getContract().getUserDefinedFieldsValues().add(uiUserDefinedFieldValue);
        }
    }

    private UiUserDefinedFieldValue findUiUserDefinedFieldValue(Long idUserDefinedField, List<UiUserDefinedFieldValue> userDefinedFieldsValues) {
        UiUserDefinedFieldValue uiUserDefinedFieldValue = null;
        for (UiUserDefinedFieldValue fieldValue : userDefinedFieldsValues) {
            if (fieldValue.getIdUserDefinedField() == null || !fieldValue.getIdUserDefinedField().equals(idUserDefinedField)) continue;
            uiUserDefinedFieldValue = fieldValue;
            break;
        }
        return uiUserDefinedFieldValue;
    }

    protected void updateUserDefinedFieldsValuesFromForm(Collection<UiUserDefinedFieldValue> oldValuesList) {
        Set<Map.Entry<DataTypeWidget<?>, UiUserDefinedField>> entrySet = this.widgetCustomFieldMap.entrySet();
        for (Map.Entry<DataTypeWidget<?>, UiUserDefinedField> entry : entrySet) {
            DataTypeWidget<?> dataTypeWidget = entry.getKey();
            UiUserDefinedField userDefinedField = entry.getValue();
            UiUserDefinedFieldValue userDefinedFieldValue = this.getValueForFieldType(oldValuesList, userDefinedField.getIdUserDefinedField());
            if (userDefinedFieldValue == null) continue;
            userDefinedFieldValue.setValue(dataTypeWidget.getTextValue());
        }
    }

    protected void updateFormFromUserDefinedFieldValues(Collection<UiUserDefinedFieldValue> newValuesList) {
        Set<Map.Entry<DataTypeWidget<?>, UiUserDefinedField>> entrySet = this.widgetCustomFieldMap.entrySet();
        for (Map.Entry<DataTypeWidget<?>, UiUserDefinedField> entry : entrySet) {
            DataTypeWidget<?> dataTypeWidget = entry.getKey();
            UiUserDefinedField userDefinedField = entry.getValue();
            UiUserDefinedFieldValue userDefinedFieldValue = this.getValueForFieldType(newValuesList, userDefinedField.getIdUserDefinedField());
            if (userDefinedFieldValue == null) continue;
            dataTypeWidget.setTextValue(userDefinedFieldValue.getValue());
        }
    }

    private UiUserDefinedFieldValue getValueForFieldType(Collection<UiUserDefinedFieldValue> newValuesList, Long idUserDefinedField) {
        UiUserDefinedFieldValue userDefinedFieldValue = null;
        for (UiUserDefinedFieldValue newUserDefinedFieldValue : newValuesList) {
            Long newIdUserDefinedField = newUserDefinedFieldValue.getIdUserDefinedField();
            if (!newIdUserDefinedField.equals(idUserDefinedField)) continue;
            userDefinedFieldValue = newUserDefinedFieldValue;
            break;
        }
        return userDefinedFieldValue;
    }

    private void verifyPermissions() {
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Create"}) && this.record.getKey() == null) {
            this.saveButton.setEnabled(true);
        }
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Create"}) && this.record.getKey() != null) {
            this.addButton.setEnabled(true);
        }
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Modify"}) && this.record.getKey() != null) {
            this.saveButton.setEnabled(true);
        }
    }

    public UiContractRecord getRecord() {
        return this.record;
    }

    public void revert() {
    }

    public String getStyleName() {
        return null;
    }

    public Widget getWidget() {
        return this;
    }

    public void release() {
    }

    public void saveFailed(Throwable throwable) {
        this.errorPanel.showMessage(throwable.getLocalizedMessage());
    }

    protected void onUnload() {
        super.onUnload();
    }
}

