/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.contract;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.tab.ErrorPanel;
import com.ericsson.cms.contractmgmt.client.tab.SuccessPanel;
import com.ericsson.cms.contractmgmt.client.tab.contract.ContractAnchorChangeListener;
import com.ericsson.cms.contractmgmt.client.tab.contract.ContractDataProvider;
import com.ericsson.cms.contractmgmt.client.tab.contract.ContractDetailFeature;
import com.ericsson.cms.contractmgmt.client.tab.contract.UiContractRecord;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableDetailViewEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableViewChangeHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableViewEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.BookmarkFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.BookmarkFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.PageFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class ContractListPanel
extends Composite {
    private ContractDataProvider dataProvider;
    private PageFeature pageFeature;
    private SortFeatureImpl<Long, UiContractRecord> sortFeature;
    private ContractDetailFeature detailFeature;
    private BookmarkFeature bookmarkFeature;
    private WidgetMenuItem.AnchorChangeListener anchorChangeListener;
    private VerticalContainer mainContainer;
    private Table<Long, UiContractRecord> table;
    private BusyIndicator busyIndicator = new BusyIndicator();
    private HeaderPanel header;
    private final SuccessPanel successPanel = new SuccessPanel();
    private final ErrorPanel errorPanel = new ErrorPanel();
    private ContractComponentConstants constants = (ContractComponentConstants)GWT.create(ContractComponentConstants.class);
    private static final int SPACING = 2;
    private static final String STYLE_NAME = "content-ContractPanel";
    private static final String IMAGE_URL = "cms_contractmgmt_ui/images/ico_contracts.png";
    private static final String STYLE_HEADER_IMAGE = "nwt-HeaderPanel-image";

    public ContractListPanel() {
        this.dataProvider = new ContractDataProvider(this);
        this.dataProvider.setBusyNotifier(new ContractDataProvider.IBusyNotifier(){

            @Override
            public void startingToBeBusy() {
                ContractListPanel.this.busyIndicator.center();
            }

            @Override
            public void doneBeingBusy() {
                ContractListPanel.this.busyIndicator.hide();
            }
        });
        this.init();
    }

    private void init() {
        this.initWidgets();
        this.setContainers();
    }

    public SuccessPanel getSuccessPanel() {
        return this.successPanel;
    }

    public ErrorPanel getErrorPanel() {
        return this.errorPanel;
    }

    private void setContainers() {
        this.mainContainer.add((Widget)this.header);
        this.mainContainer.add((Widget)this.successPanel);
        this.mainContainer.add((Widget)this.errorPanel);
        this.mainContainer.add(this.table);
    }

    private void initWidgets() {
        this.mainContainer = new VerticalContainer();
        this.mainContainer.setSpacing(2);
        this.mainContainer.setStylePrimaryName(STYLE_NAME);
        this.initWidget((Widget)this.mainContainer);
        this.header = new HeaderPanel("");
        this.table = new Table((DataProvider)this.dataProvider);
        final Image image = new Image(IMAGE_URL);
        image.setStyleName(STYLE_HEADER_IMAGE);
        this.table.addTableViewChangeHandler((TableViewChangeHandler)new TableViewChangeHandler<Long, UiContractRecord>(){

            public void onShowDetailView(TableDetailViewEvent<Long, UiContractRecord> event) {
                if (event.isCreateView()) {
                    ContractListPanel.this.header.setLabel(ContractListPanel.this.constants.contractCreateHeading());
                } else {
                    ContractListPanel.this.header.setLabel(String.valueOf(ContractListPanel.this.constants.contractViewEditHeading()) + " " + ((UiContractRecord)event.getRecord()).getContract().getName());
                }
                ContractListPanel.this.header.setImage(image);
            }

            public void onShowListView(TableViewEvent event) {
                ContractListPanel.this.header.setLabel(ContractListPanel.this.constants.contractListHeading());
                ContractListPanel.this.header.setImage(image);
            }
        });
        this.pageFeature = new PageFeatureImpl();
        this.dataProvider.setParentPageFeature(this.pageFeature);
        this.sortFeature = new SortFeatureImpl(this.dataProvider.getDefaultSortColumn(), SortOrder.ASCENDING);
        for (Column<?, UiContractRecord> col : this.dataProvider.getSortColumns()) {
            this.sortFeature.addSortableColumn(col);
        }
        this.dataProvider.setParentSortFeature(this.sortFeature);
        this.detailFeature = new ContractDetailFeature(this);
        this.bookmarkFeature = new BookmarkFeatureImpl();
        this.table.addSortFeature(this.sortFeature);
        this.table.addPageFeature(this.pageFeature);
        this.table.addDetailFeature((DetailFeature)this.detailFeature);
        this.table.addBookmarkFeature(this.bookmarkFeature);
        this.table.initialize((AsyncCallback)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
            }

            public void onNeptuneSuccess(Void result) {
            }
        });
        this.anchorChangeListener = new ContractAnchorChangeListener(this);
    }

    public Table<Long, UiContractRecord> getContractTable() {
        return this.table;
    }

    public WidgetMenuItem.AnchorChangeListener getAnchorChangeListener() {
        return this.anchorChangeListener;
    }

    public void setReverseAnchorChangeListener(WidgetMenuItem.AnchorChangeListener reverseAnchorChangeListener) {
        this.table.setAnchorChangeNotifier(reverseAnchorChangeListener);
    }

    public void clearMessages() {
        this.successPanel.reset();
        this.errorPanel.reset();
    }
}

