/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.copyrightholder;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.model.CopyrightHolderSearchResult;
import com.ericsson.cms.contractmgmt.client.model.UiCopyrightHolder;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerServiceAsync;
import com.ericsson.cms.contractmgmt.client.tab.copyrightholder.CopyrightHolderListPanel;
import com.ericsson.cms.contractmgmt.client.tab.copyrightholder.UiCopyrightHolderRecord;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelStringView;
import java.util.ArrayList;
import java.util.List;

public class CopyrightHolderDataProvider
implements DataProvider<Long, UiCopyrightHolderRecord> {
    private final List<Column<?, UiCopyrightHolderRecord>> columns;
    private final ColumnBase<String, UiCopyrightHolderRecord> addressColumn;
    private final ColumnBase<String, UiCopyrightHolderRecord> nameColumn;
    private final ColumnBase<String, UiCopyrightHolderRecord> affiliationColumn;
    private ContractComponentConstants constants = (ContractComponentConstants)GWT.create(ContractComponentConstants.class);
    private IContractManagerServiceAsync contractManagerService = (IContractManagerServiceAsync)GWT.create(IContractManagerService.class);
    private PageFeature parentPageFeature;
    private SortFeatureImpl<Long, UiCopyrightHolderRecord> parentSortFeature;
    private static String ADDRESS_COLUMN = "address";
    private static String NAME_COLUMN = "name";
    private static String AFFILIATION_COLUMN = "affiliation";
    private IBusyNotifier busyNotifier;

    public CopyrightHolderDataProvider(CopyrightHolderListPanel listsPanel) {
        this.columns = new ArrayList();
        this.nameColumn = new ColumnBase<String, UiCopyrightHolderRecord>(NAME_COLUMN, this.constants.copyrightHolderNameColumn()){

            public View<String> getView(UiCopyrightHolderRecord record) {
                return new LabelStringView(record.getCopyrightHolder().getName());
            }
        };
        this.nameColumn.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        this.columns.add((Column<?, UiCopyrightHolderRecord>)this.nameColumn);
        this.addressColumn = new ColumnBase<String, UiCopyrightHolderRecord>(ADDRESS_COLUMN, this.constants.copyrightHolderDataProviderAddress()){

            public View<String> getView(UiCopyrightHolderRecord record) {
                return new LabelStringView(String.valueOf(record.getCopyrightHolder().getAddress()));
            }
        };
        this.addressColumn.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        this.columns.add((Column<?, UiCopyrightHolderRecord>)this.addressColumn);
        this.affiliationColumn = new ColumnBase<String, UiCopyrightHolderRecord>(AFFILIATION_COLUMN, this.constants.copyrightHolderAffiliation()){

            public View<String> getView(UiCopyrightHolderRecord record) {
                return new LabelStringView(String.valueOf(record.getCopyrightHolder().getAffiliation()));
            }
        };
        this.affiliationColumn.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        this.columns.add((Column<?, UiCopyrightHolderRecord>)this.affiliationColumn);
    }

    public ColumnBase<String, UiCopyrightHolderRecord> getDefaultSortColumn() {
        return this.nameColumn;
    }

    public List<Column<?, UiCopyrightHolderRecord>> getSortColumns() {
        return this.columns;
    }

    public List<Column<?, UiCopyrightHolderRecord>> getColumns() {
        return this.columns;
    }

    public void getRecord(Long key, final AsyncCallback<UiCopyrightHolderRecord> callback) {
        this.notifyBusyStart();
        this.contractManagerService.getCopyrightHolder(key, (AsyncCallback<UiCopyrightHolder>)new NeptuneAsyncCallback<UiCopyrightHolder>(){

            public void onNeptuneFailure(Throwable caught) {
                callback.onFailure(caught);
                CopyrightHolderDataProvider.this.notifyBusyFinish();
            }

            public void onNeptuneSuccess(UiCopyrightHolder result) {
                UiCopyrightHolderRecord record = new UiCopyrightHolderRecord();
                record.setCopyrightHolder(result);
                callback.onSuccess((Object)record);
                CopyrightHolderDataProvider.this.notifyBusyFinish();
            }
        });
    }

    public void getRecords(final AsyncCallback<List<UiCopyrightHolderRecord>> callback) {
        int length = this.getParentPageFeature().getPageSize();
        int start = (this.getParentPageFeature().getPageNumber() - 1) * length;
        this.notifyBusyStart();
        this.contractManagerService.getCopyrightHolderList(start, length, this.getParentSortFeature().getSortColumnName(), this.getParentSortFeature().isAscending(), (AsyncCallback<CopyrightHolderSearchResult>)new NeptuneAsyncCallback<CopyrightHolderSearchResult>(){

            public void onNeptuneFailure(Throwable caught) {
                CopyrightHolderDataProvider.this.getParentPageFeature().setRecordCount(-1);
                callback.onFailure(caught);
                CopyrightHolderDataProvider.this.notifyBusyFinish();
            }

            public void onNeptuneSuccess(CopyrightHolderSearchResult result) {
                CopyrightHolderDataProvider.this.getParentPageFeature().setRecordCount(result.getTotalCount());
                ArrayList<UiCopyrightHolderRecord> recordList = new ArrayList<UiCopyrightHolderRecord>();
                for (UiCopyrightHolder cp : result.getUiCopyrightHolderList()) {
                    UiCopyrightHolderRecord record = new UiCopyrightHolderRecord(cp);
                    recordList.add(record);
                }
                callback.onSuccess(recordList);
                CopyrightHolderDataProvider.this.notifyBusyFinish();
            }
        });
    }

    public void initialize(AsyncCallback<Void> callback) {
        callback.onSuccess(null);
    }

    public boolean isCheckboxEnabled() {
        return true;
    }

    public boolean isRecordCountEnabled() {
        return true;
    }

    public PageFeature getParentPageFeature() {
        return this.parentPageFeature;
    }

    public void setParentPageFeature(PageFeature parentPageFeature) {
        this.parentPageFeature = parentPageFeature;
    }

    public SortFeatureImpl<Long, UiCopyrightHolderRecord> getParentSortFeature() {
        return this.parentSortFeature;
    }

    public void setParentSortFeature(SortFeatureImpl<Long, UiCopyrightHolderRecord> parentSortFeature) {
        this.parentSortFeature = parentSortFeature;
    }

    public void setBusyNotifier(IBusyNotifier busyNotifier) {
        this.busyNotifier = busyNotifier;
    }

    private void notifyBusyStart() {
        if (this.busyNotifier != null) {
            this.busyNotifier.startingToBeBusy();
        }
    }

    private void notifyBusyFinish() {
        if (this.busyNotifier != null) {
            this.busyNotifier.doneBeingBusy();
        }
    }

    public static interface IBusyNotifier {
        public void startingToBeBusy();

        public void doneBeingBusy();
    }
}

