/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.copyrightholder;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.ContractComponentMessages;
import com.ericsson.cms.contractmgmt.client.model.UiCopyrightHolder;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerServiceAsync;
import com.ericsson.cms.contractmgmt.client.tab.UiLongKeySerializer;
import com.ericsson.cms.contractmgmt.client.tab.copyrightholder.CopyrightHolderDetailView;
import com.ericsson.cms.contractmgmt.client.tab.copyrightholder.CopyrightHolderListPanel;
import com.ericsson.cms.contractmgmt.client.tab.copyrightholder.UiCopyrightHolderRecord;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.KeySerializer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.AbstractDetailFeature;
import java.util.ArrayList;
import java.util.List;

public class CopyrightHolderDetailFeature
extends AbstractDetailFeature<Long, UiCopyrightHolderRecord> {
    private final ContractComponentConstants constants = (ContractComponentConstants)GWT.create(ContractComponentConstants.class);
    private final IContractManagerServiceAsync contractManagerService = (IContractManagerServiceAsync)GWT.create(IContractManagerService.class);
    private final ContractComponentMessages messages = (ContractComponentMessages)GWT.create(ContractComponentMessages.class);
    private final CopyrightHolderListPanel parentPanel;

    public CopyrightHolderDetailFeature(CopyrightHolderListPanel parentPanel) {
        super((KeySerializer)new UiLongKeySerializer());
        this.parentPanel = parentPanel;
    }

    public void delete(List<UiCopyrightHolderRecord> records, final AsyncCallback<Void> callback) {
        if (records != null && !records.isEmpty()) {
            if (Window.confirm((String)this.messages.deleteCopyrightHolderConfirmation())) {
                ArrayList<UiCopyrightHolder> copyrightHolderList = new ArrayList<UiCopyrightHolder>();
                for (UiCopyrightHolderRecord record : records) {
                    copyrightHolderList.add(record.getCopyrightHolder());
                }
                this.contractManagerService.deleteCopyrightHolders(copyrightHolderList, (AsyncCallback<Boolean>)new NeptuneAsyncCallback<Boolean>(){

                    public void onNeptuneFailure(Throwable caught) {
                        CopyrightHolderDetailFeature.this.parentPanel.getErrorPanel().showMessage(CopyrightHolderDetailFeature.this.messages.deleteCopyrightHolderError());
                        callback.onFailure(caught);
                    }

                    public void onNeptuneSuccess(Boolean result) {
                        CopyrightHolderDetailFeature.this.parentPanel.getSuccessPanel().showMessage(CopyrightHolderDetailFeature.this.messages.deleteCopyrightHolderSucceeded());
                        callback.onSuccess(null);
                    }
                });
            }
        } else {
            Window.alert((String)this.messages.noCopyrightHolderSelected());
        }
    }

    public void getNew(AsyncCallback<UiCopyrightHolderRecord> callback) {
        this.parentPanel.clearMessages();
        if (callback != null) {
            callback.onSuccess((Object)new UiCopyrightHolderRecord(new UiCopyrightHolder()));
        }
    }

    public DetailView<Long, UiCopyrightHolderRecord> getView(UiCopyrightHolderRecord record, DetailViewCallback<Long, UiCopyrightHolderRecord> callback) {
        this.parentPanel.clearMessages();
        CopyrightHolderDetailView view = new CopyrightHolderDetailView(record, callback);
        return view;
    }

    public boolean hasDetailLink(Column<?, UiCopyrightHolderRecord> column) {
        return column.getDisplayName().equals(this.constants.copyrightHolderNameColumn()) && ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_View"});
    }

    public void save(UiCopyrightHolderRecord record, final AsyncCallback<Void> callback) {
        this.contractManagerService.saveCopyrightHolder(record.getCopyrightHolder(), (AsyncCallback<Boolean>)new NeptuneAsyncCallback<Boolean>(){

            public void onNeptuneFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onNeptuneSuccess(Boolean result) {
                CopyrightHolderDetailFeature.this.parentPanel.getSuccessPanel().showMessage(CopyrightHolderDetailFeature.this.messages.saveCopyrightHolderSucceeded());
                callback.onSuccess(null);
            }
        });
    }

    public boolean showCreateButton() {
        return ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Create"});
    }

    public boolean showDeleteButton() {
        return ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Delete"});
    }
}

