/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.copyrightholder;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.ContractComponentMessages;
import com.ericsson.cms.contractmgmt.client.HelpWidget;
import com.ericsson.cms.contractmgmt.client.customfield.CustomFieldFactory;
import com.ericsson.cms.contractmgmt.client.customfield.CustomFieldValidator;
import com.ericsson.cms.contractmgmt.client.customfield.UiUserDefinedField;
import com.ericsson.cms.contractmgmt.client.customfield.UiUserDefinedFieldValue;
import com.ericsson.cms.contractmgmt.client.document.DocumentComponentFactory;
import com.ericsson.cms.contractmgmt.client.model.UiContact;
import com.ericsson.cms.contractmgmt.client.model.UiContactType;
import com.ericsson.cms.contractmgmt.client.model.UiContract;
import com.ericsson.cms.contractmgmt.client.model.UiCopyrightHolder;
import com.ericsson.cms.contractmgmt.client.model.UiDocument;
import com.ericsson.cms.contractmgmt.client.model.UiDocumentType;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerServiceAsync;
import com.ericsson.cms.contractmgmt.client.tab.ContractFormContainer;
import com.ericsson.cms.contractmgmt.client.tab.ErrorPanel;
import com.ericsson.cms.contractmgmt.client.tab.SuccessPanel;
import com.ericsson.cms.contractmgmt.client.tab.contacts.ContactListTable;
import com.ericsson.cms.contractmgmt.client.tab.copyrightholder.UiCopyrightHolderRecord;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.RoundedDisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.DataTypeWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedTextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IValueConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.StringConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CopyrightHolderDetailView
extends Composite
implements DetailView<Long, UiCopyrightHolderRecord> {
    private static final String TABLE_STYLE = "contract-table";
    private static final String ROW_STYLE = "contract-table-row";
    private static final String ROW_HEADER_STYLE = "contract-table-row-header";
    private static final String ROW_BODY_STYLE = "contract-table-row-body";
    private static final String CELL_STYLE = "contract-table-cell";
    private static final String CELL_HEADER_STYLE = "contract-table-cell-header";
    private static final String LINK_BEHAVIOUR = "contract-Link";
    private static final String CONTAINER_STYLE = "realm-UserForm contract-Container";
    private static final String DELETE_CELL_STYLE = "contract-table-cell-body-delete";
    private static final String EB_ICON_DISABLED = "ebIcon_disabled";
    private static final String TEXTBOXWIDGET_WIDTH = "150px";
    private static final int COPYRIGHTHOLDER_NAME_MAX_LENGTH = 50;
    private static final int COPYRIGHTHOLDER_AFFILIATION_MAX_LENGTH = 50;
    private static final int COPYRIGHTHOLDER_ADDRESS_MAX_LENGTH = 100;
    private static final int COPYRIGHTHOLDER_CITY_MAX_LENGTH = 50;
    private static final int COPYRIGHTHOLDER_ZIP_MAX_LENGTH = 10;
    private static final int COPYRIGHTHOLDER_EXTERNAL_ID_MAX_LENGTH = 100;
    private final ContractComponentConstants constants = (ContractComponentConstants)GWT.create(ContractComponentConstants.class);
    private final IContractManagerServiceAsync contractManagerService = (IContractManagerServiceAsync)GWT.create(IContractManagerService.class);
    private final ContractComponentMessages messages = (ContractComponentMessages)GWT.create(ContractComponentMessages.class);
    private final UiCopyrightHolderRecord record;
    private final DetailViewCallback<Long, UiCopyrightHolderRecord> callback;
    private RoundedDisclosureContainer contractsContainer;
    private VerticalContainer contractsTableContainer;
    private ContractFormContainer formContainer;
    private ContractFormContainer formUserDefinedFields;
    private FlexTableContainer tableContracts;
    private ButtonWidget addButton;
    private ButtonWidget saveButton;
    private final ContactListTable contactListPanel;
    private final SuccessPanel successPanel = new SuccessPanel();
    private final ErrorPanel errorPanel = new ErrorPanel();
    private TypedTextBoxWidget<String> externalIdTextBox;
    private TypedTextBoxWidget<String> name;
    private TypedTextBoxWidget<String> address1;
    private TypedTextBoxWidget<String> address2;
    private TypedTextBoxWidget<String> address3;
    private TypedTextBoxWidget<String> address4;
    private TypedTextBoxWidget<String> affiliation;
    private final DocumentComponentFactory documentComponent;
    private final HorizontalContainer buttonsHorizontalContainer;
    private List<UiDocument> documentsList = new ArrayList<UiDocument>();
    private final List<UiUserDefinedFieldValue> userDefinedFieldValueList = new ArrayList<UiUserDefinedFieldValue>();
    private final Map<DataTypeWidget<?>, UiUserDefinedField> widgetCustomFieldMap = new HashMap();
    private final BusyIndicator busyIndicator = new BusyIndicator();
    private static final String DELETE_IMAGE = "cms_contractmgmt_ui/images/delete.png";

    public CopyrightHolderDetailView(UiCopyrightHolderRecord record, DetailViewCallback<Long, UiCopyrightHolderRecord> callback) {
        this.record = record;
        this.callback = callback;
        VerticalContainer mainContainer = new VerticalContainer();
        this.buttonsHorizontalContainer = new HorizontalContainer();
        mainContainer.add((Widget)this.successPanel);
        mainContainer.add((Widget)this.errorPanel);
        this.initWidget((Widget)mainContainer);
        this.busyIndicator.center();
        this.init();
        if (record.getCopyrightHolder().getUiContactList() == null) {
            record.getCopyrightHolder().setUiContactList(new ArrayList<UiContact>());
        }
        this.contactListPanel = new ContactListTable(record.getCopyrightHolder().getUiContactList(), this.constants.contactRecordDisplayName());
        this.contactListPanel.setContactType(UiContactType.COPYRIGHT_HOLDER);
        this.contactListPanel.createTable();
        this.addButtons();
        VerticalContainer topContainer = new VerticalContainer();
        topContainer.add((Widget)this.formContainer);
        RoundedDisclosureContainer userDefinedFieldsContainer = new RoundedDisclosureContainer(this.constants.userDefinedFields());
        userDefinedFieldsContainer.add((Widget)this.formUserDefinedFields);
        userDefinedFieldsContainer.setOpen(false);
        topContainer.add((Widget)userDefinedFieldsContainer);
        RoundedDisclosureContainer contactsContainer = new RoundedDisclosureContainer(this.constants.copyrightHolderContactSectionHeading());
        contactsContainer.add((Widget)this.contactListPanel);
        contactsContainer.setOpen(true);
        topContainer.add((Widget)contactsContainer);
        topContainer.addStyleName(CONTAINER_STYLE);
        mainContainer.add((Widget)topContainer);
        mainContainer.add((Widget)this.buttonsHorizontalContainer);
        this.documentComponent = new DocumentComponentFactory(record.getKey(), this.constants.copyrightHolderDocument(), UiDocumentType.COPYRIGHT_HOLDER, this.errorPanel);
        RoundedDisclosureContainer documentsContainer = this.documentComponent.getDocumentPanel();
        VerticalContainer bottomContainer = new VerticalContainer();
        bottomContainer.add((Widget)documentsContainer);
        bottomContainer.add((Widget)this.contractsContainer);
        bottomContainer.addStyleName(CONTAINER_STYLE);
        mainContainer.add((Widget)bottomContainer);
        if (record.getKey() != null) {
            this.busyIndicator.center();
            this.getContractList();
        } else {
            this.getUserDefinedFields();
        }
        this.verifyPermissions();
        this.busyIndicator.hide();
    }

    private void getContractList() {
        this.contractManagerService.getCopyrightHolderContractList(this.record.getKey(), (AsyncCallback<List<UiContract>>)new NeptuneAsyncCallback<List<UiContract>>(){

            public void onNeptuneFailure(Throwable caught) {
                CopyrightHolderDetailView.this.errorPanel.showMessage(caught.getLocalizedMessage());
            }

            public void onNeptuneSuccess(List<UiContract> result) {
                CopyrightHolderDetailView.this.record.getCopyrightHolder().setUiContractList(result);
                CopyrightHolderDetailView.this.getUserDefinedFields();
                CopyrightHolderDetailView.this.documentsList = CopyrightHolderDetailView.this.record.getCopyrightHolder().getUiDocumentList();
                CopyrightHolderDetailView.this.documentComponent.setDocumentsList(CopyrightHolderDetailView.this.documentsList);
                CopyrightHolderDetailView.this.fillForm();
            }
        });
    }

    private void getUserDefinedFields() {
        this.contractManagerService.getUserDefinedFields("COPYRIGHTHOLDER", (AsyncCallback<List<UiUserDefinedField>>)new NeptuneAsyncCallback<List<UiUserDefinedField>>(){

            public void onNeptuneFailure(Throwable caught) {
                CopyrightHolderDetailView.this.errorPanel.showMessage(caught.getLocalizedMessage());
            }

            public void onNeptuneSuccess(List<UiUserDefinedField> result) {
                CustomFieldFactory factory = new CustomFieldFactory(null);
                factory.addFieldsToForm(CopyrightHolderDetailView.this.formUserDefinedFields, result, CopyrightHolderDetailView.this.widgetCustomFieldMap);
                for (UiUserDefinedField uiUserDefinedField : result) {
                    UiUserDefinedFieldValue value = new UiUserDefinedFieldValue();
                    value.setIdUserDefinedField(uiUserDefinedField.getIdUserDefinedField());
                    if (CopyrightHolderDetailView.this.record.getKey() == null) {
                        value.setValue(uiUserDefinedField.getDefaultValue());
                    }
                    CopyrightHolderDetailView.this.userDefinedFieldValueList.add(value);
                }
                CopyrightHolderDetailView.this.createUpdateUserDefinedFieldValues();
                if (CopyrightHolderDetailView.this.record.getCopyrightHolder().getUserDefinedFieldsValues() != null) {
                    CopyrightHolderDetailView.this.updateFormFromUserDefinedFieldValues(CopyrightHolderDetailView.this.record.getCopyrightHolder().getUserDefinedFieldsValues());
                }
            }
        });
    }

    private void fillForm() {
        this.externalIdTextBox.setValue((Object)this.record.getCopyrightHolder().getExternalId());
        this.name.setValue((Object)this.record.getCopyrightHolder().getName());
        String[] address = this.record.getCopyrightHolder().getAddress().split("\n");
        this.address1.setValue((Object)address[0]);
        if (address.length >= 2) {
            this.address2.setValue((Object)address[1]);
        }
        if (address.length >= 3) {
            this.address3.setValue((Object)address[2]);
        }
        if (address.length >= 4) {
            this.address4.setValue((Object)address[3]);
        }
        this.affiliation.setValue((Object)this.record.getCopyrightHolder().getAffiliation());
        for (UiDocument doc : this.documentsList) {
            this.documentComponent.addRow(doc);
        }
        this.fillContractTable(this.record.getCopyrightHolder().getUiContractList());
    }

    private void init() {
        this.buildInfo();
        this.buildDisclosureContracts();
    }

    private void buildInfo() {
        this.formContainer = new ContractFormContainer(HasHorizontalAlignment.ALIGN_LEFT);
        this.formUserDefinedFields = new ContractFormContainer(HasHorizontalAlignment.ALIGN_LEFT);
        this.externalIdTextBox = new TypedTextBoxWidget((IValueConverter)new StringConverter());
        this.externalIdTextBox.setMaxLength(100);
        this.externalIdTextBox.setWidth(TEXTBOXWIDGET_WIDTH);
        this.name = new TypedTextBoxWidget((IValueConverter)new StringConverter());
        this.name.setMaxLength(50);
        this.name.ensureDebugId("copyright-name");
        this.address1 = new TypedTextBoxWidget((IValueConverter)new StringConverter());
        this.address1.setMaxLength(100);
        this.address1.ensureDebugId("copyright-address");
        this.address2 = new TypedTextBoxWidget((IValueConverter)new StringConverter());
        this.address2.setMaxLength(100);
        this.address3 = new TypedTextBoxWidget((IValueConverter)new StringConverter());
        this.address3.setMaxLength(50);
        this.address3.setWidth(TEXTBOXWIDGET_WIDTH);
        this.address4 = new TypedTextBoxWidget((IValueConverter)new StringConverter());
        this.address4.setMaxLength(10);
        this.address4.setWidth(TEXTBOXWIDGET_WIDTH);
        this.affiliation = new TypedTextBoxWidget((IValueConverter)new StringConverter());
        this.affiliation.setMaxLength(50);
        this.affiliation.setWidth(TEXTBOXWIDGET_WIDTH);
        this.affiliation.ensureDebugId("copyright-affiliation");
        this.formContainer.addRow(this.constants.externalID(), (Widget)this.externalIdTextBox);
        this.formContainer.addRow(this.constants.copyrightHolderName(), (Widget)this.name, true);
        this.formContainer.addRow(this.constants.copyrightHolderAddress(), (Widget)this.address1, true);
        this.formContainer.addRow(this.constants.copyrightHolderAddress2(), (Widget)this.address2);
        this.formContainer.addRow(this.constants.copyrightHolderCity(), (Widget)this.address3);
        this.formContainer.addRow(this.constants.copyrightHolderZipCode(), (Widget)this.address4);
        this.formContainer.addRow(this.constants.copyrightHolderAffiliation(), (Widget)this.affiliation, true);
    }

    private void addHeading(String heading, FlexTableContainer table) {
        int column = table.getCellCount(0);
        table.insertCell(0, column);
        table.getFlexCellFormatter().setStyleName(0, column, CELL_STYLE);
        table.getFlexCellFormatter().setStyleName(0, column, CELL_HEADER_STYLE);
        this.updateHeading(table, heading, column);
    }

    private void updateHeading(FlexTableContainer table, String heading, int column) {
        LabelWidget label = this.getHeadingWidget(table, column);
        if (label == null) {
            label = new LabelWidget(heading);
            label.addStyleName("table-header-nonSortable-text");
            table.setWidget(0, column, (Widget)label);
        } else {
            label.setText(heading);
        }
    }

    private LabelWidget getHeadingWidget(FlexTableContainer table, int column) {
        Widget widget = table.getWidget(0, column);
        return widget instanceof LabelWidget ? (LabelWidget)widget : null;
    }

    private void addButtons() {
        this.buttonsHorizontalContainer.setWidth("10%");
        this.buttonsHorizontalContainer.addStyleName("cms_button_container");
        this.saveButton = new ButtonWidget(this.constants.saveButtonName(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (CopyrightHolderDetailView.this.validate()) {
                    CopyrightHolderDetailView.this.commit();
                    CopyrightHolderDetailView.this.callback.save((DetailView)CopyrightHolderDetailView.this);
                }
            }
        });
        this.saveButton.removeStyleName("gwt-Button");
        this.saveButton.addStyleName("ebBtn");
        this.saveButton.addStyleName("ebBtn_color_green");
        this.saveButton.addStyleName("save_button_icon");
        this.saveButton.setEnabled(false);
        this.saveButton.ensureDebugId("copyright-save");
        this.buttonsHorizontalContainer.add((Widget)this.saveButton);
        ButtonWidget cancelButton = new ButtonWidget(this.constants.cancelButtonName(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                CopyrightHolderDetailView.this.errorPanel.reset();
                CopyrightHolderDetailView.this.callback.cancel((DetailView)CopyrightHolderDetailView.this);
            }
        });
        cancelButton.removeStyleName("gwt-Button");
        cancelButton.addStyleName("ebBtn");
        this.buttonsHorizontalContainer.add((Widget)cancelButton);
    }

    private void buildDisclosureContracts() {
        this.contractsContainer = new RoundedDisclosureContainer(this.constants.contractContract());
        this.contractsTableContainer = new VerticalContainer();
        this.tableContracts = new FlexTableContainer();
        this.tableContracts.addStyleName(TABLE_STYLE);
        this.tableContracts.insertRow(0);
        this.tableContracts.getRowFormatter().addStyleName(0, ROW_STYLE);
        this.tableContracts.getRowFormatter().addStyleName(0, ROW_HEADER_STYLE);
        this.createTableContractsHeader();
        this.contractsTableContainer.add((Widget)this.tableContracts);
        this.addButtonsContracts();
        this.contractsContainer.add((Widget)this.contractsTableContainer);
        this.contractsContainer.setOpen(true);
    }

    private void fillContractTable(List<UiContract> result) {
        if (result != null) {
            for (UiContract contract : result) {
                this.addRowContracts(contract);
            }
        }
    }

    private void addRowContracts(UiContract contract) {
        this.insertRow();
        int row = this.getRow();
        this.tableContracts.getRowFormatter().setStyleName(row, row % 2 == 0 ? "table-data-even-row" : "table-data-odd-row");
        DateTimeFormat.getFormat((String)this.constants.dateFormat());
        LabelWidget link = new LabelWidget();
        link.setText(contract.getName());
        final String url = "Contracts.Contract.Edit?contractId=" + this.record.getCopyrightHolder().getUiContractList().get(row - 1).getKey();
        link.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                History.newItem((String)url);
            }
        });
        link.setStyleName(LINK_BEHAVIOUR);
        this.tableContracts.setWidget(row, 0, (Widget)link);
        LabelWidget label = new LabelWidget();
        label.setText(contract.getType().getName());
        this.tableContracts.setWidget(row, 1, (Widget)label);
        label = new LabelWidget();
        label.setText(contract.getExpiryDate());
        this.tableContracts.setWidget(row, 2, (Widget)label);
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Delete"}) && this.record.getKey() != null) {
            ImageWidget removeButton = new ImageWidget(DELETE_IMAGE);
            removeButton.addClickHandler((ClickHandler)new DeleteContractHandler());
            this.tableContracts.setWidget(row, 3, (Widget)removeButton);
            this.tableContracts.getCellFormatter().setStyleName(row, 3, DELETE_CELL_STYLE);
        }
    }

    private void insertRow() {
        this.tableContracts.insertRow(this.tableContracts.getRowCount());
        this.tableContracts.getRowFormatter().addStyleName(this.getRow(), ROW_STYLE);
        this.tableContracts.getRowFormatter().addStyleName(this.getRow(), ROW_BODY_STYLE);
    }

    private int getRow() {
        return this.tableContracts.getRowCount() - 1;
    }

    private void createTableContractsHeader() {
        this.tableContracts.getRowFormatter().setStyleName(0, "table-header-row");
        this.addHeading(this.constants.contractCName(), this.tableContracts);
        this.addHeading(this.constants.contractCType(), this.tableContracts);
        this.addHeading(this.constants.contractExpiryDate(), this.tableContracts);
    }

    private void addButtonsContracts() {
        HorizontalContainer buttons = new HorizontalContainer();
        this.addButton = new ButtonWidget(this.constants.addContractButtonName(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (CopyrightHolderDetailView.this.contactListPanel.isDirty() && !Window.confirm((String)CopyrightHolderDetailView.this.constants.confirmLoseContactChanges())) {
                    return;
                }
                History.newItem((String)("Contracts.Contract.Create?copyrightId=" + CopyrightHolderDetailView.this.record.getKey()));
            }
        });
        this.addButton.removeStyleName("gwt-Button");
        this.addButton.addStyleName("ebBtn");
        this.addButton.addStyleName("addgreen_button_icon");
        this.addButton.setEnabled(false);
        buttons.add((Widget)this.addButton);
        buttons.setCellVerticalAlignment((Widget)this.addButton, HasVerticalAlignment.ALIGN_MIDDLE);
        if (this.record.getKey() == null) {
            HelpWidget helpWidget = new HelpWidget(this.messages.addThingLater(this.constants.contract()));
            buttons.add((Widget)helpWidget);
            buttons.setCellVerticalAlignment((Widget)this.addButton, HasVerticalAlignment.ALIGN_MIDDLE);
            this.addButton.addStyleName(EB_ICON_DISABLED);
        }
        this.contractsTableContainer.add((Widget)buttons);
    }

    private boolean validate() {
        boolean valid;
        this.errorPanel.reset();
        boolean bl = valid = this.formContainer.validate() && this.formUserDefinedFields.validate();
        if (!valid) {
            this.errorPanel.addHeading1(this.constants.copyrightHolderValidationMessage());
        }
        Set<Map.Entry<DataTypeWidget<?>, UiUserDefinedField>> entrySet = this.widgetCustomFieldMap.entrySet();
        for (Map.Entry<DataTypeWidget<?>, UiUserDefinedField> entry : entrySet) {
            DataTypeWidget<?> dataTypeWidget = entry.getKey();
            CustomFieldValidator.validate(dataTypeWidget, entry.getValue());
            if (dataTypeWidget.isValidValue() && !dataTypeWidget.hasValidationError()) continue;
            valid = false;
        }
        return valid;
    }

    public void commit() {
        UiCopyrightHolder copyright = new UiCopyrightHolder();
        if (this.record.getKey() != null) {
            copyright.setKey(this.record.getCopyrightHolder().getKey());
        }
        copyright.setExternalId(this.externalIdTextBox.getText() != null ? this.externalIdTextBox.getText().trim() : null);
        copyright.setName(this.name.getText().trim());
        copyright.setAddress(String.valueOf(this.address1.getText()) + "\n" + this.address2.getText() + "\n" + this.address3.getText() + "\n" + this.address4.getText());
        copyright.setAffiliation(this.affiliation.getText());
        copyright.setUiContactList(this.contactListPanel.getCollapsedRecordList());
        copyright.setUiDocumentList(this.documentsList);
        this.updateUserDefinedFieldsValuesFromForm(this.userDefinedFieldValueList);
        copyright.setUserDefinedFieldsValues(this.userDefinedFieldValueList);
        copyright.setUiContractList(this.record.getCopyrightHolder().getUiContractList());
        this.record.setCopyrightHolder(copyright);
    }

    private void createUpdateUserDefinedFieldValues() {
        for (UiUserDefinedField uiUserDefinedField : this.widgetCustomFieldMap.values()) {
            UiUserDefinedFieldValue uiUserDefinedFieldValue = this.findUiUserDefinedFieldValue(uiUserDefinedField.getIdUserDefinedField(), this.record.getCopyrightHolder().getUserDefinedFieldsValues());
            if (uiUserDefinedFieldValue != null) continue;
            uiUserDefinedFieldValue = new UiUserDefinedFieldValue();
            uiUserDefinedFieldValue.setIdUserDefinedField(uiUserDefinedField.getIdUserDefinedField());
            uiUserDefinedFieldValue.setValue(uiUserDefinedField.getDefaultValue());
            this.record.getCopyrightHolder().getUserDefinedFieldsValues().add(uiUserDefinedFieldValue);
        }
    }

    private UiUserDefinedFieldValue findUiUserDefinedFieldValue(Long idUserDefinedField, List<UiUserDefinedFieldValue> userDefinedFieldsValues) {
        UiUserDefinedFieldValue uiUserDefinedFieldValue = null;
        for (UiUserDefinedFieldValue fieldValue : userDefinedFieldsValues) {
            if (fieldValue.getIdUserDefinedField() == null || !fieldValue.getIdUserDefinedField().equals(idUserDefinedField)) continue;
            uiUserDefinedFieldValue = fieldValue;
            break;
        }
        return uiUserDefinedFieldValue;
    }

    protected void updateUserDefinedFieldsValuesFromForm(Collection<UiUserDefinedFieldValue> oldValuesList) {
        Set<Map.Entry<DataTypeWidget<?>, UiUserDefinedField>> entrySet = this.widgetCustomFieldMap.entrySet();
        for (Map.Entry<DataTypeWidget<?>, UiUserDefinedField> entry : entrySet) {
            DataTypeWidget<?> dataTypeWidget = entry.getKey();
            UiUserDefinedField userDefinedField = entry.getValue();
            UiUserDefinedFieldValue userDefinedFieldValue = this.getValueForFieldType(oldValuesList, userDefinedField.getIdUserDefinedField());
            if (userDefinedFieldValue == null) continue;
            userDefinedFieldValue.setValue(dataTypeWidget.getTextValue());
        }
    }

    protected void updateFormFromUserDefinedFieldValues(Collection<UiUserDefinedFieldValue> newValuesList) {
        Set<Map.Entry<DataTypeWidget<?>, UiUserDefinedField>> entrySet = this.widgetCustomFieldMap.entrySet();
        for (Map.Entry<DataTypeWidget<?>, UiUserDefinedField> entry : entrySet) {
            DataTypeWidget<?> dataTypeWidget = entry.getKey();
            UiUserDefinedField userDefinedField = entry.getValue();
            UiUserDefinedFieldValue userDefinedFieldValue = this.getValueForFieldType(newValuesList, userDefinedField.getIdUserDefinedField());
            if (userDefinedFieldValue == null) continue;
            dataTypeWidget.setTextValue(userDefinedFieldValue.getValue());
        }
    }

    private UiUserDefinedFieldValue getValueForFieldType(Collection<UiUserDefinedFieldValue> newValuesList, Long idUserDefinedField) {
        UiUserDefinedFieldValue userDefinedFieldValue = null;
        for (UiUserDefinedFieldValue newUserDefinedFieldValue : newValuesList) {
            Long newIdUserDefinedField = newUserDefinedFieldValue.getIdUserDefinedField();
            if (!newIdUserDefinedField.equals(idUserDefinedField)) continue;
            userDefinedFieldValue = newUserDefinedFieldValue;
            break;
        }
        return userDefinedFieldValue;
    }

    private void verifyPermissions() {
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Create"}) && this.record.getKey() == null) {
            this.saveButton.setEnabled(true);
        }
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Create"}) && this.record.getKey() != null) {
            this.addButton.setEnabled(true);
        }
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Modify"}) && this.record.getKey() != null) {
            this.saveButton.setEnabled(true);
        }
    }

    public UiCopyrightHolderRecord getRecord() {
        return this.record;
    }

    public void revert() {
    }

    public String getStyleName() {
        return null;
    }

    public Widget getWidget() {
        return this;
    }

    public void release() {
    }

    public void saveFailed(Throwable throwable) {
        this.errorPanel.addMessage(throwable.getLocalizedMessage());
    }

    private class DeleteContractHandler
    implements ClickHandler {
        public void onClick(ClickEvent event) {
            final int rowIndex = CopyrightHolderDetailView.this.tableContracts.getCellForEvent(event).getRowIndex();
            ArrayList<UiContract> deleteList = new ArrayList<UiContract>();
            deleteList.add(CopyrightHolderDetailView.this.record.getCopyrightHolder().getUiContractList().get(rowIndex - 1));
            if (deleteList.isEmpty()) {
                Window.alert((String)CopyrightHolderDetailView.this.messages.noContractSelected());
            } else if (Window.confirm((String)CopyrightHolderDetailView.this.messages.deleteContractConfirmation())) {
                CopyrightHolderDetailView.this.busyIndicator.center();
                CopyrightHolderDetailView.this.contractManagerService.deleteContracts(deleteList, (AsyncCallback<Boolean>)new NeptuneAsyncCallback<Boolean>(){

                    public void onNeptuneFailure(Throwable caught) {
                        CopyrightHolderDetailView.this.errorPanel.showMessage(caught.getLocalizedMessage());
                        CopyrightHolderDetailView.this.busyIndicator.hide();
                    }

                    public void onNeptuneSuccess(Boolean result) {
                        CopyrightHolderDetailView.this.tableContracts.removeRow(rowIndex);
                        CopyrightHolderDetailView.this.record.getCopyrightHolder().getUiContractList().remove(rowIndex - 1);
                        CopyrightHolderDetailView.this.busyIndicator.hide();
                    }
                });
            }
        }
    }
}

