/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.deal;

import com.ericsson.cms.contractmgmt.client.model.UiContract;
import com.ericsson.cms.contractmgmt.client.model.UiDeal;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerServiceAsync;
import com.ericsson.cms.contractmgmt.client.tab.deal.DealListPanel;
import com.ericsson.cms.contractmgmt.client.tab.deal.UiDealRecord;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;

public class DealAnchorChangeListener
implements WidgetMenuItem.AnchorChangeListener {
    private static final String DEAL_ID = "dealId";
    private static final String CONTRACT_ID = "contractId";
    private static final String PARAMETER_DELIMITER = "&";
    private static final String VALUE_DELIMITER = "=";
    private final DealListPanel widget;

    public DealAnchorChangeListener(DealListPanel listPanel) {
        this.widget = listPanel;
    }

    public void anchorChanged(String anchor) {
        long dealId = 0L;
        long contractId = 0L;
        if (anchor != null && anchor.contains(DEAL_ID)) {
            String[] params;
            this.widget.getDealTable().reset();
            anchor = anchor.substring(5);
            String[] stringArray = params = anchor.split(PARAMETER_DELIMITER);
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                String p = stringArray[n2];
                String[] paramValue = p.split(VALUE_DELIMITER);
                if (paramValue[0].equalsIgnoreCase(DEAL_ID)) {
                    dealId = Long.parseLong(paramValue[1]);
                }
                ++n2;
            }
            IContractManagerServiceAsync cmService = (IContractManagerServiceAsync)GWT.create(IContractManagerService.class);
            cmService.getDeal(dealId, (AsyncCallback<UiDeal>)new NeptuneAsyncCallback<UiDeal>(){

                public void onNeptuneFailure(Throwable caught) {
                    Window.alert((String)caught.getLocalizedMessage());
                }

                public void onNeptuneSuccess(UiDeal result) {
                    DealAnchorChangeListener.this.widget.getDealTable().showDetailView((Record)new UiDealRecord(result));
                }
            });
        } else if (anchor != null && !anchor.contains(DEAL_ID) && anchor.contains(CONTRACT_ID)) {
            String[] params;
            this.widget.getDealTable().reset();
            anchor = anchor.substring(7);
            String[] stringArray = params = anchor.split(PARAMETER_DELIMITER);
            int n = params.length;
            int n3 = 0;
            while (n3 < n) {
                String p = stringArray[n3];
                String[] paramValue = p.split(VALUE_DELIMITER);
                if (paramValue[0].equalsIgnoreCase(CONTRACT_ID)) {
                    contractId = Long.parseLong(paramValue[1]);
                }
                ++n3;
            }
            final UiDeal uiDeal = new UiDeal();
            IContractManagerServiceAsync cmService = (IContractManagerServiceAsync)GWT.create(IContractManagerService.class);
            cmService.getContract(contractId, (AsyncCallback<UiContract>)new NeptuneAsyncCallback<UiContract>(){

                public void onNeptuneFailure(Throwable caught) {
                    Window.alert((String)caught.getLocalizedMessage());
                }

                public void onNeptuneSuccess(UiContract result) {
                    uiDeal.setName("");
                    uiDeal.setContract(result);
                    DealAnchorChangeListener.this.widget.getDealTable().showDetailView((Record)new UiDealRecord(uiDeal));
                }
            });
        } else {
            this.widget.clearMessages();
            this.widget.getDealTable().setAnchor(anchor);
        }
    }
}

