/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.deal;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.model.DealSearchResult;
import com.ericsson.cms.contractmgmt.client.model.UiDeal;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerServiceAsync;
import com.ericsson.cms.contractmgmt.client.tab.deal.DealListPanel;
import com.ericsson.cms.contractmgmt.client.tab.deal.UiDealRecord;
import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelStringView;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class DealDataProvider
implements DataProvider<Long, UiDealRecord> {
    private final List<Column<?, UiDealRecord>> columns;
    private final ColumnBase<String, UiDealRecord> nameColumn;
    private final ColumnBase<String, UiDealRecord> typeColumn;
    private final ColumnBase<String, UiDealRecord> expiryColumn;
    private final ContractComponentConstants constants = (ContractComponentConstants)GWT.create(ContractComponentConstants.class);
    private final IContractManagerServiceAsync contractManagerService = (IContractManagerServiceAsync)GWT.create(IContractManagerService.class);
    private PageFeature parentPageFeature;
    private SortFeatureImpl<Long, UiDealRecord> parentSortFeature;
    private static final String NAME_COLUMN = "name";
    private static final String TYPE_COLUMN = "dealType";
    private static final String EXPIRY_DATE_COLUMN = "expiryDate";
    private IBusyNotifier busyNotifier;
    private static final String NON_ACTIVE_STYLE = "cell-NonActive";
    private static final String EXPIRED_STYLE = "cell-Expired";
    private static final String NON_ACTIVE_AND_EXPIRED = "cell-Expired-NonActive";
    private String cellStyle = null;

    public DealDataProvider(DealListPanel listsPanel) {
        this.columns = new ArrayList();
        this.nameColumn = new ColumnBase<String, UiDealRecord>(NAME_COLUMN, this.constants.dealName()){

            public View<String> getView(UiDealRecord record) {
                DealDataProvider.this.cellStyle = DealDataProvider.this.getCellStyle(record);
                return new LabelStringView(String.valueOf(record.getDeal().getName()));
            }
        };
        this.nameColumn.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        this.columns.add((Column<?, UiDealRecord>)this.nameColumn);
        this.typeColumn = new ColumnBase<String, UiDealRecord>(TYPE_COLUMN, this.constants.dealType()){

            public View<String> getView(UiDealRecord record) {
                LabelStringView lb = new LabelStringView(record.getDeal().getType().getName());
                if (DealDataProvider.this.cellStyle != null) {
                    lb.setStyleName(DealDataProvider.this.cellStyle);
                }
                return lb;
            }
        };
        this.typeColumn.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        this.columns.add((Column<?, UiDealRecord>)this.typeColumn);
        this.expiryColumn = new ColumnBase<String, UiDealRecord>(EXPIRY_DATE_COLUMN, this.constants.dealExpiryDate()){

            public View<String> getView(UiDealRecord record) {
                LabelStringView lb = new LabelStringView(record.getDeal().getExpiryDate());
                if (DealDataProvider.this.cellStyle != null) {
                    lb.setStyleName(DealDataProvider.this.cellStyle);
                }
                return lb;
            }
        };
        this.expiryColumn.setCellStyle("nwt-TableColumnPanel-dataCell-date");
        this.columns.add((Column<?, UiDealRecord>)this.expiryColumn);
    }

    private final String getCellStyle(UiDealRecord record) {
        DateTimeFormat dateFormatter = DateTimeFormat.getFormat((String)this.constants.dateFormat());
        String now = dateFormatter.format(new Date());
        if (!record.getDeal().isActive() && now.compareTo(record.getDeal().getExpiryDate()) > 0) {
            return NON_ACTIVE_AND_EXPIRED;
        }
        if (!record.getDeal().isActive()) {
            return NON_ACTIVE_STYLE;
        }
        if (now.compareTo(record.getDeal().getExpiryDate()) > 0) {
            return EXPIRED_STYLE;
        }
        return null;
    }

    public ColumnBase<String, UiDealRecord> getDefaultSortColumn() {
        return this.nameColumn;
    }

    public List<Column<?, UiDealRecord>> getSortColumns() {
        return this.columns;
    }

    public List<Column<?, UiDealRecord>> getColumns() {
        return this.columns;
    }

    public void getRecord(Long key, final AsyncCallback<UiDealRecord> callback) {
        this.notifyBusyStart();
        this.contractManagerService.getDeal(key, (AsyncCallback<UiDeal>)new NeptuneAsyncCallback<UiDeal>(){

            public void onNeptuneFailure(Throwable caught) {
                callback.onFailure(caught);
                DealDataProvider.this.notifyBusyFinish();
            }

            public void onNeptuneSuccess(UiDeal result) {
                callback.onSuccess((Object)new UiDealRecord(result));
                DealDataProvider.this.notifyBusyFinish();
            }
        });
    }

    public void getRecords(final AsyncCallback<List<UiDealRecord>> callback) {
        int length = this.getParentPageFeature().getPageSize();
        int start = (this.getParentPageFeature().getPageNumber() - 1) * length;
        this.notifyBusyStart();
        this.contractManagerService.getDealsList(start, length, this.getParentSortFeature().getSortColumnName(), this.getParentSortFeature().isAscending(), (AsyncCallback<DealSearchResult>)new NeptuneAsyncCallback<DealSearchResult>(){

            public void onNeptuneFailure(Throwable caught) {
                DealDataProvider.this.getParentPageFeature().setRecordCount(-1);
                DealDataProvider.this.notifyBusyFinish();
                callback.onFailure(caught);
            }

            public void onNeptuneSuccess(DealSearchResult result) {
                DealDataProvider.this.getParentPageFeature().setRecordCount(result.getTotalCount());
                DealDataProvider.this.notifyBusyFinish();
                ArrayList<UiDealRecord> list = new ArrayList<UiDealRecord>();
                for (UiDeal uiDeal : result.getUiDealList()) {
                    UiDealRecord record = new UiDealRecord();
                    record.setDeal(uiDeal);
                    list.add(record);
                }
                callback.onSuccess(list);
            }
        });
    }

    public void initialize(AsyncCallback<Void> callback) {
        callback.onSuccess(null);
    }

    public boolean isCheckboxEnabled() {
        return true;
    }

    public boolean isRecordCountEnabled() {
        return true;
    }

    public PageFeature getParentPageFeature() {
        return this.parentPageFeature;
    }

    public void setParentPageFeature(PageFeature parentPageFeature) {
        this.parentPageFeature = parentPageFeature;
    }

    public SortFeatureImpl<Long, UiDealRecord> getParentSortFeature() {
        return this.parentSortFeature;
    }

    public void setParentSortFeature(SortFeatureImpl<Long, UiDealRecord> parentSortFeature) {
        this.parentSortFeature = parentSortFeature;
    }

    public void setBusyNotifier(IBusyNotifier busyNotifier) {
        this.busyNotifier = busyNotifier;
    }

    private void notifyBusyStart() {
        if (this.busyNotifier != null) {
            this.busyNotifier.startingToBeBusy();
        }
    }

    private void notifyBusyFinish() {
        if (this.busyNotifier != null) {
            this.busyNotifier.doneBeingBusy();
        }
    }

    public static interface IBusyNotifier {
        public void startingToBeBusy();

        public void doneBeingBusy();
    }
}

