/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.deal;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.ContractComponentMessages;
import com.ericsson.cms.contractmgmt.client.model.UiDeal;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerServiceAsync;
import com.ericsson.cms.contractmgmt.client.tab.UiLongKeySerializer;
import com.ericsson.cms.contractmgmt.client.tab.deal.DealDetailView;
import com.ericsson.cms.contractmgmt.client.tab.deal.DealListPanel;
import com.ericsson.cms.contractmgmt.client.tab.deal.UiDealRecord;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.KeySerializer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.AbstractDetailFeature;
import java.util.ArrayList;
import java.util.List;

public class DealDetailFeature
extends AbstractDetailFeature<Long, UiDealRecord> {
    private final ContractComponentConstants constants = (ContractComponentConstants)GWT.create(ContractComponentConstants.class);
    private final ContractComponentMessages messages = (ContractComponentMessages)GWT.create(ContractComponentMessages.class);
    private final IContractManagerServiceAsync contractManagerService = (IContractManagerServiceAsync)GWT.create(IContractManagerService.class);
    private final DealListPanel parentPanel;

    public DealDetailFeature(DealListPanel parentPanel) {
        super((KeySerializer)new UiLongKeySerializer());
        this.parentPanel = parentPanel;
    }

    public void delete(List<UiDealRecord> records, final AsyncCallback<Void> callback) {
        if (records != null && !records.isEmpty()) {
            if (Window.confirm((String)this.messages.deleteDealConfirmation())) {
                ArrayList<UiDeal> dealList = new ArrayList<UiDeal>();
                for (UiDealRecord record : records) {
                    dealList.add(record.getDeal());
                }
                this.contractManagerService.deleteDeals(dealList, (AsyncCallback<Boolean>)new NeptuneAsyncCallback<Boolean>(){

                    public void onNeptuneFailure(Throwable caught) {
                        DealDetailFeature.this.parentPanel.getErrorPanel().showMessage(DealDetailFeature.this.messages.deleteDealError());
                        callback.onFailure(caught);
                    }

                    public void onNeptuneSuccess(Boolean result) {
                        DealDetailFeature.this.parentPanel.getSuccessPanel().showMessage(DealDetailFeature.this.messages.deleteDealSucceeded());
                        callback.onSuccess(null);
                    }
                });
            }
        } else {
            Window.alert((String)this.messages.noDealSelected());
        }
    }

    public void getNew(AsyncCallback<UiDealRecord> callback) {
        this.parentPanel.clearMessages();
        callback.onSuccess((Object)new UiDealRecord(new UiDeal()));
    }

    public DetailView<Long, UiDealRecord> getView(UiDealRecord record, DetailViewCallback<Long, UiDealRecord> callback) {
        this.parentPanel.clearMessages();
        DealDetailView view = new DealDetailView(record, callback);
        return view;
    }

    public boolean hasDetailLink(Column<?, UiDealRecord> column) {
        return column.getDisplayName().equals(this.constants.dealNameColumn()) && ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_View"});
    }

    public void save(UiDealRecord record, final AsyncCallback<Void> callback) {
        this.contractManagerService.saveDeal(record.getDeal(), (AsyncCallback<Boolean>)new NeptuneAsyncCallback<Boolean>(){

            public void onNeptuneFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onNeptuneSuccess(Boolean result) {
                History.back();
            }
        });
    }

    public boolean showCreateButton() {
        return ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Create"});
    }

    public boolean showDeleteButton() {
        return ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Delete"});
    }
}

