/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.deal;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.ContractComponentMessages;
import com.ericsson.cms.contractmgmt.client.HelpWidget;
import com.ericsson.cms.contractmgmt.client.customfield.CustomFieldFactory;
import com.ericsson.cms.contractmgmt.client.customfield.CustomFieldValidator;
import com.ericsson.cms.contractmgmt.client.customfield.UiUserDefinedField;
import com.ericsson.cms.contractmgmt.client.customfield.UiUserDefinedFieldValue;
import com.ericsson.cms.contractmgmt.client.document.DocumentComponentFactory;
import com.ericsson.cms.contractmgmt.client.model.UiContact;
import com.ericsson.cms.contractmgmt.client.model.UiContactType;
import com.ericsson.cms.contractmgmt.client.model.UiContract;
import com.ericsson.cms.contractmgmt.client.model.UiDeal;
import com.ericsson.cms.contractmgmt.client.model.UiDealType;
import com.ericsson.cms.contractmgmt.client.model.UiDocument;
import com.ericsson.cms.contractmgmt.client.model.UiDocumentType;
import com.ericsson.cms.contractmgmt.client.model.UiKeyName;
import com.ericsson.cms.contractmgmt.client.model.UiLicense;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownServiceAsync;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerServiceAsync;
import com.ericsson.cms.contractmgmt.client.tab.ContractFormContainer;
import com.ericsson.cms.contractmgmt.client.tab.ErrorPanel;
import com.ericsson.cms.contractmgmt.client.tab.SuccessPanel;
import com.ericsson.cms.contractmgmt.client.tab.config.PositiveIntegerConverter;
import com.ericsson.cms.contractmgmt.client.tab.contacts.ContactListTable;
import com.ericsson.cms.contractmgmt.client.tab.deal.UiDealRecord;
import com.ericsson.cms.contractmgmt.client.tab.license.UiLicenseRecord;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.datepicker.client.CalendarUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.DisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.RoundedDisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.DataTypeWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedDateBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedTextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.DateConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IDateConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IValueConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IntegerConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.StringConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DealDetailView
extends Composite
implements DetailView<Long, UiDealRecord> {
    private static final String STYLE_DISCLOSURE_CONTAINER = "content-FileView-disclosureContainer";
    private static final String TABLE_STYLE = "contract-table";
    private static final String ROW_STYLE = "contract-table-row";
    private static final String ROW_HEADER_STYLE = "contract-table-row-header";
    private static final String ROW_BODY_STYLE = "contract-table-row-body";
    private static final String CELL_STYLE = "contract-table-cell";
    private static final String CELL_HEADER_STYLE = "contract-table-cell-header";
    private static final String LINK_BEHAVIOUR = "contract-Link";
    private static final String CONTAINER_STYLE = "realm-UserForm contract-Container";
    private static final String DELETE_CELL_STYLE = "contract-table-cell-body-delete";
    private static final String EB_ICON_DISABLED = "ebIcon_disabled";
    private static final String CONTENT_LISTBOX_WIDTH = "130px";
    private static final String TEXTBOXWIDGET_WIDTH = "150px";
    private static final String DATE_BOX_WIDTH = "90px";
    private static final int DEAL_NAME_MAX_LENGH = 50;
    private static final int EXTERNAL_ID_MAX_LENGTH = 100;
    private static final String DELETE_IMAGE = "cms_contractmgmt_ui/images/delete.png";
    private final ContractComponentConstants constants = (ContractComponentConstants)GWT.create(ContractComponentConstants.class);
    private final ContractComponentMessages messages = (ContractComponentMessages)GWT.create(ContractComponentMessages.class);
    private final IContractManagerServiceAsync contractManagerService = (IContractManagerServiceAsync)GWT.create(IContractManagerService.class);
    private final IContractManagerDropDownServiceAsync dropDownService = (IContractManagerDropDownServiceAsync)GWT.create(IContractManagerDropDownService.class);
    private final Map<DataTypeWidget<?>, UiUserDefinedField> widgetCustomFieldMap = new HashMap();
    private final UiDealRecord record;
    private final DetailViewCallback<Long, UiDealRecord> callback;
    private final VerticalContainer mainContainer;
    private final ContractFormContainer formUserDefinedFields;
    private DisclosureContainer licenseDisclosureContainer;
    private VerticalContainer licenseContainer;
    private final ContractFormContainer formContainer;
    private ButtonWidget addButton;
    private ButtonWidget saveButton;
    private TypedListBoxWidget<Long> copyrightHolder;
    private TypedListBoxWidget<Long> contract;
    private final TypedListBoxWidget<Long> type;
    private TypedTextBoxWidget<String> externalIdTextBox;
    private TextBoxWidget name;
    private TypedTextBoxWidget<Integer> expiryReminder;
    private final TypedDateBoxWidget dealCreationDate = new TypedDateBoxWidget((IDateConverter)new DateConverter(this.constants.dateFormat(), this.constants.dateFormat()));
    private final TypedDateBoxWidget dealEffectiveDate = new TypedDateBoxWidget((IDateConverter)new DateConverter(this.constants.dateFormat(), this.constants.dateFormat()));
    private final TypedDateBoxWidget dealExpiryDate = new TypedDateBoxWidget((IDateConverter)new DateConverter(this.constants.dateFormat(), this.constants.dateFormat()));
    private FlexTableContainer tableLicense;
    private final SuccessPanel successPanel = new SuccessPanel();
    private final ErrorPanel errorPanel = new ErrorPanel();
    private final ContactListTable contactListPanel;
    private List<UiDocument> documentsList = new ArrayList<UiDocument>();
    private final List<UiUserDefinedFieldValue> userDefinedFieldValueList = new ArrayList<UiUserDefinedFieldValue>();
    private RoundedDisclosureContainer documentsContainer;
    private final BusyIndicator busyIndicator = new BusyIndicator();
    private DocumentComponentFactory documentComponent;
    private UiContract uiContract;
    private final HorizontalContainer buttonsContainer;

    public DealDetailView(UiDealRecord record, DetailViewCallback<Long, UiDealRecord> callback) {
        this.record = record;
        this.callback = callback;
        this.busyIndicator.center();
        this.mainContainer = new VerticalContainer();
        this.buttonsContainer = new HorizontalContainer();
        this.mainContainer.add((Widget)this.successPanel);
        this.mainContainer.add((Widget)this.errorPanel);
        this.initWidget((Widget)this.mainContainer);
        this.formContainer = new ContractFormContainer(HasHorizontalAlignment.ALIGN_LEFT);
        this.formUserDefinedFields = new ContractFormContainer(HasHorizontalAlignment.ALIGN_LEFT);
        this.getCustomFields(record.getKey());
        if (record.getKey() != null) {
            this.getContract(record.getDeal().getContract().getKey());
        }
        this.type = this.getTypeListBox(0L);
        if (record.getDeal().getUiContactList() == null) {
            record.getDeal().setUiContactList(new ArrayList<UiContact>());
        }
        this.contactListPanel = new ContactListTable(record.getDeal().getUiContactList(), this.constants.contactRecordDisplayName());
        this.contactListPanel.setContactType(UiContactType.DEAL);
        this.contactListPanel.createTable();
    }

    private void getLicense() {
        if (this.record.getKey() != null) {
            this.contractManagerService.getDealsLicenseList(this.record.getDeal().getKey(), (AsyncCallback<List<UiLicense>>)new NeptuneAsyncCallback<List<UiLicense>>(){

                public void onNeptuneFailure(Throwable caught) {
                    DealDetailView.this.errorPanel.showMessage(caught.getLocalizedMessage());
                }

                public void onNeptuneSuccess(List<UiLicense> result) {
                    DealDetailView.this.record.getDeal().setUiLicenseList(result);
                    DealDetailView.this.fillLicenseTable(result);
                }
            });
        }
    }

    private void fillLicenseTable(List<UiLicense> result) {
        for (UiLicense license : result) {
            this.addRowLicense(license);
        }
    }

    private void addRowLicense(UiLicense license) {
        this.insertRow();
        int row = this.getRow();
        this.tableLicense.getRowFormatter().setStyleName(row, "table-data-even-row");
        DateTimeFormat.getFormat((String)this.constants.dateFormat());
        LabelWidget link = new LabelWidget();
        link.setText(license.getName());
        final String url = "Contracts.License.Edit?licenseId=" + this.record.getDeal().getUiLicenseList().get(row - 1).getKey();
        link.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                History.newItem((String)url);
            }
        });
        link.setStyleName(LINK_BEHAVIOUR);
        this.tableLicense.setWidget(row, 0, (Widget)link);
        LabelWidget label = new LabelWidget();
        label.setText(license.getType().getName());
        this.tableLicense.setWidget(row, 1, (Widget)label);
        label = new LabelWidget();
        label.setText(license.getExpiryDate());
        this.tableLicense.setWidget(row, 2, (Widget)label);
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Delete"}) && this.record.getKey() != null) {
            ImageWidget removeButton = new ImageWidget(DELETE_IMAGE);
            removeButton.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    final int rowIndex = DealDetailView.this.tableLicense.getCellForEvent(event).getRowIndex();
                    ArrayList<UiLicenseRecord> deleteList = new ArrayList<UiLicenseRecord>();
                    UiLicenseRecord liRecord = new UiLicenseRecord();
                    liRecord.setLicense(DealDetailView.this.record.getDeal().getUiLicenseList().get(rowIndex - 1));
                    deleteList.add(liRecord);
                    if (deleteList.isEmpty()) {
                        Window.alert((String)DealDetailView.this.messages.noLicenseSelected());
                    } else if (Window.confirm((String)DealDetailView.this.messages.deleteLicenseConfirmation())) {
                        DealDetailView.this.busyIndicator.center();
                        DealDetailView.this.contractManagerService.deleteLicenses(deleteList, (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

                            public void onNeptuneFailure(Throwable caught) {
                                DealDetailView.this.errorPanel.showMessage(caught.getLocalizedMessage());
                                DealDetailView.this.busyIndicator.hide();
                            }

                            public void onNeptuneSuccess(Void result) {
                                DealDetailView.this.tableLicense.removeRow(rowIndex);
                                DealDetailView.this.record.getDeal().getUiLicenseList().remove(rowIndex - 1);
                                DealDetailView.this.busyIndicator.hide();
                            }
                        });
                    }
                }
            });
            this.tableLicense.setWidget(row, 3, (Widget)removeButton);
            this.tableLicense.getCellFormatter().setStyleName(row, 3, DELETE_CELL_STYLE);
        }
    }

    private void insertRow() {
        this.tableLicense.insertRow(this.tableLicense.getRowCount());
        this.tableLicense.getRowFormatter().addStyleName(this.getRow(), ROW_STYLE);
        this.tableLicense.getRowFormatter().addStyleName(this.getRow(), ROW_BODY_STYLE);
    }

    private int getRow() {
        return this.tableLicense.getRowCount() - 1;
    }

    private void init() {
        this.buildComponents();
        this.copyrightHolder.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Long>(){

            public void onValueChange(ValueChangeEvent<Long> event) {
                if (DealDetailView.this.record.getKey() != null) {
                    DealDetailView.this.fillContractListBox((Long)event.getValue(), DealDetailView.this.record.getDeal().getContract().getKey());
                } else {
                    DealDetailView.this.fillContractListBox((Long)event.getValue(), 0L);
                }
            }
        });
        this.copyrightHolder.setWidth(CONTENT_LISTBOX_WIDTH);
        this.copyrightHolder.ensureDebugId("deal-copyrightHolder");
        this.buildDisclosureLicense();
        this.addButtons();
        VerticalContainer topContainer = new VerticalContainer();
        topContainer.add((Widget)this.formContainer);
        RoundedDisclosureContainer userDefinedFieldsContainer = new RoundedDisclosureContainer(this.constants.userDefinedFields());
        userDefinedFieldsContainer.add((Widget)this.formUserDefinedFields);
        userDefinedFieldsContainer.setOpen(false);
        topContainer.add((Widget)userDefinedFieldsContainer);
        RoundedDisclosureContainer contactsContainer = new RoundedDisclosureContainer(this.constants.copyrightHolderContactSectionHeading());
        contactsContainer.add((Widget)this.contactListPanel);
        contactsContainer.setOpen(true);
        topContainer.add((Widget)contactsContainer);
        topContainer.addStyleName(CONTAINER_STYLE);
        this.mainContainer.add((Widget)topContainer);
        this.mainContainer.add((Widget)this.buttonsContainer);
        this.documentComponent = new DocumentComponentFactory(this.record.getKey(), this.constants.contractDealDocuments(), UiDocumentType.DEAL, this.errorPanel);
        this.documentsContainer = this.documentComponent.getDocumentPanel();
        VerticalContainer bottomContainer = new VerticalContainer();
        bottomContainer.add((Widget)this.documentsContainer);
        bottomContainer.add((Widget)this.licenseDisclosureContainer);
        bottomContainer.addStyleName(CONTAINER_STYLE);
        this.mainContainer.add((Widget)bottomContainer);
        if (this.record.getKey() != null) {
            this.documentsList = this.record.getDeal().getUiDocumentList();
            this.documentComponent.setDocumentsList(this.documentsList);
            this.getLicense();
            this.fillForm();
        } else if (this.record.getDeal().getContract().getKey() != null) {
            this.getContract(this.record.getDeal().getContract().getKey());
            this.copyrightHolder.setSelectedItem((Object)this.record.getDeal().getContract().getCopyrightHolder().getKey());
            this.fillContractListBox(this.record.getDeal().getContract().getCopyrightHolder().getKey(), this.record.getDeal().getContract().getKey());
        }
        this.verifyPermissions();
        this.busyIndicator.hide();
    }

    private void buildComponents() {
        this.contract = new TypedListBoxWidget((IValueConverter)new IntegerConverter());
        this.contract.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Long>(){

            public void onValueChange(ValueChangeEvent<Long> event) {
                if (event != null && (Long)event.getValue() != 0L) {
                    DealDetailView.this.getContract((Long)event.getValue());
                }
            }
        });
        this.contract.setWidth(CONTENT_LISTBOX_WIDTH);
        this.contract.ensureDebugId("deal-contract");
        this.externalIdTextBox = new TypedTextBoxWidget((IValueConverter)new StringConverter());
        this.externalIdTextBox.setMaxLength(100);
        this.externalIdTextBox.setWidth(TEXTBOXWIDGET_WIDTH);
        this.name = new TextBoxWidget();
        this.name.setMaxLength(50);
        this.name.ensureDebugId("deal-name");
        this.type.setWidth(CONTENT_LISTBOX_WIDTH);
        this.type.ensureDebugId("deal-type");
        this.dealCreationDate.setWidth(DATE_BOX_WIDTH);
        this.dealCreationDate.ensureDebugId("deal-creationDate");
        this.dealEffectiveDate.setWidth(DATE_BOX_WIDTH);
        this.dealEffectiveDate.ensureDebugId("deal-effectiveDate");
        this.dealExpiryDate.setWidth(DATE_BOX_WIDTH);
        this.dealExpiryDate.ensureDebugId("deal-expiryDate");
        this.expiryReminder = new TypedTextBoxWidget((IValueConverter)new PositiveIntegerConverter());
        this.expiryReminder.setWidth(TEXTBOXWIDGET_WIDTH);
        this.formContainer.addRow(this.constants.contractCopyrightHolder(), (Widget)this.copyrightHolder, true);
        this.formContainer.addRow(this.constants.dealContract(), (Widget)this.contract, true);
        this.formContainer.addRow(this.constants.externalID(), (Widget)this.externalIdTextBox);
        this.formContainer.addRow(this.constants.contractName(), (Widget)this.name, true);
        this.formContainer.addRow(this.constants.contractType(), (Widget)this.type, true);
        this.formContainer.addRow(this.constants.contractCreationDate(), (Widget)this.dealCreationDate, true);
        this.formContainer.addRow(this.constants.contractEffectiveDate(), (Widget)this.dealEffectiveDate, true);
        this.formContainer.addRow(this.constants.contractExpiryDate(), (Widget)this.dealExpiryDate, true);
        this.formContainer.addRow(this.constants.dealExpiryReminder(), (Widget)this.expiryReminder);
    }

    private TypedListBoxWidget<Long> getTypeListBox(final Long selected) {
        final TypedListBoxWidget lbType = new TypedListBoxWidget((IValueConverter)new IntegerConverter());
        this.dropDownService.getDealTypeKeyNameList((AsyncCallback<List<UiKeyName>>)new NeptuneAsyncCallback<List<UiKeyName>>(){

            public void onNeptuneFailure(Throwable caught) {
                DealDetailView.this.errorPanel.showMessage(caught.getLocalizedMessage());
            }

            public void onNeptuneSuccess(List<UiKeyName> result) {
                DealDetailView.this.fillListBox((TypedListBoxWidget<Long>)lbType, selected, result);
                DealDetailView.this.copyrightHolder = DealDetailView.this.getCopyrightHolderListBox(0L);
            }
        });
        return lbType;
    }

    private TypedListBoxWidget<Long> getCopyrightHolderListBox(final Long selected) {
        final TypedListBoxWidget lbCopyrightHolder = new TypedListBoxWidget((IValueConverter)new IntegerConverter());
        this.dropDownService.getCopyrightHolderKeyNameList((AsyncCallback<List<UiKeyName>>)new NeptuneAsyncCallback<List<UiKeyName>>(){

            public void onNeptuneFailure(Throwable caught) {
                Window.alert((String)DealDetailView.this.constants.failureGettingCopyrightHolders());
            }

            public void onNeptuneSuccess(List<UiKeyName> result) {
                DealDetailView.this.fillListBox((TypedListBoxWidget<Long>)lbCopyrightHolder, selected, result);
                DealDetailView.this.init();
            }
        });
        return lbCopyrightHolder;
    }

    private void getCustomFields(final Long isEditing) {
        this.contractManagerService.getUserDefinedFields("DEAL", (AsyncCallback<List<UiUserDefinedField>>)new NeptuneAsyncCallback<List<UiUserDefinedField>>(){

            public void onNeptuneFailure(Throwable caught) {
                DealDetailView.this.errorPanel.showMessage(caught.getLocalizedMessage());
            }

            public void onNeptuneSuccess(List<UiUserDefinedField> result) {
                CustomFieldFactory factory = new CustomFieldFactory(null);
                factory.addFieldsToForm(DealDetailView.this.formUserDefinedFields, result, DealDetailView.this.widgetCustomFieldMap);
                for (UiUserDefinedField uiUserDefinedField : result) {
                    UiUserDefinedFieldValue value = new UiUserDefinedFieldValue();
                    value.setIdUserDefinedField(uiUserDefinedField.getIdUserDefinedField());
                    if (isEditing == null) {
                        value.setValue(uiUserDefinedField.getDefaultValue());
                    }
                    DealDetailView.this.userDefinedFieldValueList.add(value);
                }
                DealDetailView.this.createUpdateUserDefinedFieldValues();
                if (DealDetailView.this.record.getDeal().getUserDefinedFieldsValues() != null) {
                    DealDetailView.this.updateFormFromUserDefinedFieldValues(DealDetailView.this.record.getDeal().getUserDefinedFieldsValues());
                }
            }
        });
    }

    private UiContract getContract(Long key) {
        this.contractManagerService.getContract(key, (AsyncCallback<UiContract>)new NeptuneAsyncCallback<UiContract>(){

            public void onNeptuneFailure(Throwable caught) {
                DealDetailView.this.errorPanel.showMessage(caught.getLocalizedMessage());
            }

            public void onNeptuneSuccess(UiContract result) {
                DealDetailView.this.uiContract = result;
                DealDetailView.this.record.getDeal().setContract(DealDetailView.this.uiContract);
            }
        });
        return this.uiContract;
    }

    private void fillContractListBox(long copyrightHolderKey, final Long selected) {
        this.contract.clear();
        this.dropDownService.getContractKeyNameList(copyrightHolderKey, (AsyncCallback<List<UiKeyName>>)new NeptuneAsyncCallback<List<UiKeyName>>(){

            public void onNeptuneFailure(Throwable caught) {
                Window.alert((String)DealDetailView.this.constants.failureGettingCopyrightHolders());
            }

            public void onNeptuneSuccess(List<UiKeyName> result) {
                DealDetailView.this.fillListBox((TypedListBoxWidget<Long>)DealDetailView.this.contract, selected, result);
            }
        });
    }

    private void fillListBox(TypedListBoxWidget<Long> listBox, Long selected, List<UiKeyName> result) {
        listBox.addItem("", null);
        for (UiKeyName keyName : result) {
            listBox.addItem(keyName.getName(), (Object)keyName.getKey());
        }
        listBox.setSelectedItem((Object)selected);
    }

    private void addHeading(String heading, FlexTableContainer table) {
        int column = table.getCellCount(0);
        table.insertCell(0, column);
        table.getCellFormatter().addStyleName(0, column, CELL_STYLE);
        table.getCellFormatter().addStyleName(0, column, CELL_HEADER_STYLE);
        this.updateHeading(table, heading, column);
    }

    private void updateHeading(FlexTableContainer table, String heading, int column) {
        LabelWidget label = this.getHeadingWidget(table, column);
        if (label == null) {
            label = new LabelWidget(heading);
            label.addStyleName("table-header-nonSortable-text");
            table.setWidget(0, column, (Widget)label);
        } else {
            label.setText(heading);
        }
    }

    private LabelWidget getHeadingWidget(FlexTableContainer table, int column) {
        Widget widget = table.getWidget(0, column);
        return widget instanceof LabelWidget ? (LabelWidget)widget : null;
    }

    private void fillForm() {
        this.externalIdTextBox.setValue((Object)this.record.getDeal().getExternalId());
        this.name.setValue((Object)this.record.getDeal().getName());
        this.copyrightHolder.setValue((Object)this.record.getDeal().getContract().getCopyrightHolder().getKey(), true);
        this.contract.setSelectedItem((Object)this.record.getDeal().getContract().getKey());
        if (this.record.getDeal().getLicenseExpiryReminder() != null) {
            this.expiryReminder.setValue((Object)this.record.getDeal().getLicenseExpiryReminder().intValue());
        }
        if (this.record.getDeal().getUiLicenseList() != null && !this.record.getDeal().getUiLicenseList().isEmpty()) {
            this.fillLicenseTable(this.record.getDeal().getUiLicenseList());
        }
        for (UiDocument doc : this.documentsList) {
            this.documentComponent.addRow(doc);
        }
        this.type.setSelectedItem((Object)this.record.getDeal().getType().getKey());
        this.dealExpiryDate.setValue(this.record.getDeal().getExpiryDate());
        this.dealCreationDate.setValue(this.record.getDeal().getCreationDate());
        this.dealEffectiveDate.setValue(this.record.getDeal().getEffectiveDate());
        this.updateFormFromUserDefinedFieldValues(this.record.getDeal().getUserDefinedFieldsValues());
    }

    private void addButtons() {
        this.buttonsContainer.setWidth("10%");
        this.buttonsContainer.addStyleName("cms_button_container");
        this.saveButton = new ButtonWidget(this.constants.saveButtonName(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (DealDetailView.this.validate()) {
                    DealDetailView.this.commit();
                    DealDetailView.this.callback.save((DetailView)DealDetailView.this);
                }
            }
        });
        this.saveButton.removeStyleName("gwt-Button");
        this.saveButton.addStyleName("ebBtn");
        this.saveButton.addStyleName("ebBtn_color_green");
        this.saveButton.addStyleName("save_button_icon");
        this.saveButton.setEnabled(false);
        this.saveButton.ensureDebugId("deal-save");
        this.buttonsContainer.add((Widget)this.saveButton);
        ButtonWidget cancelButton = new ButtonWidget(this.constants.cancelButtonName(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                DealDetailView.this.errorPanel.reset();
                History.back();
            }
        });
        cancelButton.removeStyleName("gwt-Button");
        cancelButton.addStyleName("ebBtn");
        this.buttonsContainer.add((Widget)cancelButton);
    }

    private boolean validate() {
        boolean valid;
        this.errorPanel.reset();
        boolean bl = valid = this.formContainer.validate() && this.formUserDefinedFields.validate();
        if (this.record.getDeal().getContract().getKey() != null && valid) {
            for (UiLicense uiLicense : this.record.getDeal().getUiLicenseList()) {
                if (uiLicense.getCreationDate().compareTo(this.dealCreationDate.getTextValue()) < 0) {
                    valid = false;
                    this.errorPanel.addHeading1(this.messages.dealLicenseCreationDateValidation(uiLicense.getName()));
                    continue;
                }
                if (uiLicense.getEffectiveDate().compareTo(this.dealEffectiveDate.getTextValue()) < 0) {
                    valid = false;
                    this.errorPanel.addHeading1(this.messages.dealLicenseEffectiveDateValidation(uiLicense.getName()));
                    continue;
                }
                if (uiLicense.getExpiryDate().compareTo(this.dealExpiryDate.getTextValue()) <= 0) continue;
                valid = false;
                this.errorPanel.addHeading1(this.messages.dealLicenseExpiryDateValidation(uiLicense.getName()));
            }
            if (this.dealCreationDate.getDatePicker().getValue().after(this.dealEffectiveDate.getDatePicker().getValue())) {
                valid = false;
                this.errorPanel.addHeading1(this.constants.dealCreationDateValidation());
            }
            if (this.dealCreationDate.getTextValue().compareTo(this.uiContract.getCreationDate()) < 0) {
                valid = false;
                this.errorPanel.addHeading1(this.constants.dealContractCreationDateValidation());
            }
            if (this.dealEffectiveDate.getTextValue().compareTo(this.uiContract.getEffectiveDate()) < 0) {
                valid = false;
                this.errorPanel.addHeading1(this.constants.dealEffectiveDateValidation());
            }
            if (this.dealEffectiveDate.getTextValue().compareTo(this.uiContract.getExpiryDate()) >= 0) {
                valid = false;
                this.errorPanel.addHeading1(this.constants.dealContractEffectiveDateValidation());
            }
            if (this.dealEffectiveDate.getDatePicker().getValue().after(this.dealExpiryDate.getDatePicker().getValue()) || CalendarUtil.isSameDate((Date)this.dealEffectiveDate.getDatePicker().getValue(), (Date)this.dealExpiryDate.getDatePicker().getValue())) {
                valid = false;
                this.errorPanel.addHeading1(this.constants.dealExpiryEffectiveDateValidation());
            }
            if (this.dealExpiryDate.getTextValue().compareTo(this.uiContract.getEffectiveDate()) <= 0) {
                valid = false;
                this.errorPanel.addHeading1(this.constants.dealContractExpiryEffectiveDateValidation());
            }
            if (this.dealExpiryDate.getTextValue().compareTo(this.uiContract.getExpiryDate()) > 0) {
                valid = false;
                this.errorPanel.addHeading1(this.constants.dealContractExpiriesDateValidation());
            }
        }
        Set<Map.Entry<DataTypeWidget<?>, UiUserDefinedField>> entrySet = this.widgetCustomFieldMap.entrySet();
        for (Map.Entry<DataTypeWidget<?>, UiUserDefinedField> entry : entrySet) {
            DataTypeWidget<?> dataTypeWidget = entry.getKey();
            CustomFieldValidator.validate(dataTypeWidget, entry.getValue());
            if (dataTypeWidget.isValidValue() && !dataTypeWidget.hasValidationError()) continue;
            valid = false;
        }
        if (!valid) {
            this.errorPanel.addHeading1(this.constants.dealValidationMessage());
        }
        return valid;
    }

    private void buildDisclosureLicense() {
        this.licenseDisclosureContainer = new RoundedDisclosureContainer(this.constants.licenseDealDisplayName(), true);
        this.licenseDisclosureContainer.addStyleName(STYLE_DISCLOSURE_CONTAINER);
        this.licenseContainer = new VerticalContainer();
        this.tableLicense = new FlexTableContainer();
        this.tableLicense.addStyleName(TABLE_STYLE);
        this.tableLicense.insertRow(0);
        this.tableLicense.getRowFormatter().addStyleName(0, ROW_STYLE);
        this.tableLicense.getRowFormatter().addStyleName(0, ROW_HEADER_STYLE);
        this.createTableLicenseHeader();
        this.licenseContainer.add((Widget)this.tableLicense);
        this.addButtonsLicense();
        this.licenseDisclosureContainer.add((Widget)this.licenseContainer);
    }

    private void createTableLicenseHeader() {
        this.tableLicense.getRowFormatter().setStyleName(0, "table-header-row");
        this.addHeading(this.constants.licenseName(), this.tableLicense);
        this.addHeading(this.constants.licenseType(), this.tableLicense);
        this.addHeading(this.constants.dealExpiryDate(), this.tableLicense);
    }

    private void addButtonsLicense() {
        HorizontalContainer buttons = new HorizontalContainer();
        this.addButton = new ButtonWidget(this.constants.addLicenseButtonName(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (DealDetailView.this.contactListPanel.isDirty() && !Window.confirm((String)DealDetailView.this.constants.confirmLoseContactChanges())) {
                    return;
                }
                History.newItem((String)("Contracts.License.Create?dealId=" + DealDetailView.this.record.getKey()));
            }
        });
        this.addButton.removeStyleName("gwt-Button");
        this.addButton.addStyleName("ebBtn");
        this.addButton.addStyleName("addgreen_button_icon");
        this.addButton.setEnabled(false);
        buttons.add((Widget)this.addButton);
        buttons.setCellVerticalAlignment((Widget)this.addButton, HasVerticalAlignment.ALIGN_MIDDLE);
        if (this.record.getKey() == null) {
            HelpWidget helpWidget = new HelpWidget(this.messages.addThingLater(this.constants.license()));
            buttons.add((Widget)helpWidget);
            buttons.setCellVerticalAlignment((Widget)helpWidget, HasVerticalAlignment.ALIGN_MIDDLE);
            this.addButton.addStyleName(EB_ICON_DISABLED);
        }
        this.licenseContainer.add((Widget)buttons);
    }

    public void commit() {
        UiDeal deal = new UiDeal();
        if (this.record.getKey() != null) {
            deal.setKey(this.record.getDeal().getKey());
        }
        deal.setExternalId(this.externalIdTextBox.getText() != null ? this.externalIdTextBox.getText().trim() : null);
        UiContract dealUiContract = new UiContract();
        dealUiContract.setKey((Long)this.contract.getSelectedItem());
        deal.setContract(dealUiContract);
        deal.setActive(true);
        deal.setCreationDate(this.dealCreationDate.getTextValue());
        deal.setEffectiveDate(this.dealEffectiveDate.getTextValue());
        deal.setExpiryDate(this.dealExpiryDate.getTextValue());
        if (this.expiryReminder.getValue() != null) {
            deal.setLicenseExpiryReminder(new Long(((Integer)this.expiryReminder.getValue()).toString()));
        }
        deal.setName(this.name.getText().trim());
        UiDealType dealType = new UiDealType();
        dealType.setKey((Long)this.type.getSelectedItem());
        dealType.setName(this.type.getTextValue());
        deal.setType(dealType);
        deal.setUiContactList(this.contactListPanel.getCollapsedRecordList());
        deal.setUiDocumentList(this.documentsList);
        deal.setUiLicenseList(this.record.getDeal().getUiLicenseList());
        this.updateUserDefinedFieldsValuesFromForm(this.userDefinedFieldValueList);
        deal.setUserDefinedFieldsValues(this.userDefinedFieldValueList);
        this.record.setDeal(deal);
    }

    private void createUpdateUserDefinedFieldValues() {
        for (UiUserDefinedField uiUserDefinedField : this.widgetCustomFieldMap.values()) {
            UiUserDefinedFieldValue uiUserDefinedFieldValue = this.findUiUserDefinedFieldValue(uiUserDefinedField.getIdUserDefinedField(), this.record.getDeal().getUserDefinedFieldsValues());
            if (uiUserDefinedFieldValue != null) continue;
            uiUserDefinedFieldValue = new UiUserDefinedFieldValue();
            uiUserDefinedFieldValue.setIdUserDefinedField(uiUserDefinedField.getIdUserDefinedField());
            uiUserDefinedFieldValue.setValue(uiUserDefinedField.getDefaultValue());
            this.record.getDeal().getUserDefinedFieldsValues().add(uiUserDefinedFieldValue);
        }
    }

    private UiUserDefinedFieldValue findUiUserDefinedFieldValue(Long idUserDefinedField, List<UiUserDefinedFieldValue> userDefinedFieldsValues) {
        UiUserDefinedFieldValue uiUserDefinedFieldValue = null;
        for (UiUserDefinedFieldValue fieldValue : userDefinedFieldsValues) {
            if (fieldValue.getIdUserDefinedField() == null || !fieldValue.getIdUserDefinedField().equals(idUserDefinedField)) continue;
            uiUserDefinedFieldValue = fieldValue;
            break;
        }
        return uiUserDefinedFieldValue;
    }

    protected void updateUserDefinedFieldsValuesFromForm(Collection<UiUserDefinedFieldValue> oldValuesList) {
        Set<Map.Entry<DataTypeWidget<?>, UiUserDefinedField>> entrySet = this.widgetCustomFieldMap.entrySet();
        for (Map.Entry<DataTypeWidget<?>, UiUserDefinedField> entry : entrySet) {
            DataTypeWidget<?> dataTypeWidget = entry.getKey();
            UiUserDefinedField userDefinedField = entry.getValue();
            UiUserDefinedFieldValue userDefinedFieldValue = this.getValueForFieldType(oldValuesList, userDefinedField.getIdUserDefinedField());
            if (userDefinedFieldValue == null) continue;
            userDefinedFieldValue.setValue(dataTypeWidget.getTextValue());
        }
    }

    protected void updateFormFromUserDefinedFieldValues(Collection<UiUserDefinedFieldValue> newValuesList) {
        Set<Map.Entry<DataTypeWidget<?>, UiUserDefinedField>> entrySet = this.widgetCustomFieldMap.entrySet();
        for (Map.Entry<DataTypeWidget<?>, UiUserDefinedField> entry : entrySet) {
            DataTypeWidget<?> dataTypeWidget = entry.getKey();
            UiUserDefinedField userDefinedField = entry.getValue();
            UiUserDefinedFieldValue userDefinedFieldValue = this.getValueForFieldType(newValuesList, userDefinedField.getIdUserDefinedField());
            if (userDefinedFieldValue == null) continue;
            dataTypeWidget.setTextValue(userDefinedFieldValue.getValue());
        }
    }

    private UiUserDefinedFieldValue getValueForFieldType(Collection<UiUserDefinedFieldValue> newValuesList, Long idUserDefinedField) {
        UiUserDefinedFieldValue userDefinedFieldValue = null;
        for (UiUserDefinedFieldValue newUserDefinedFieldValue : newValuesList) {
            Long newIdUserDefinedField = newUserDefinedFieldValue.getIdUserDefinedField();
            if (!newIdUserDefinedField.equals(idUserDefinedField)) continue;
            userDefinedFieldValue = newUserDefinedFieldValue;
            break;
        }
        return userDefinedFieldValue;
    }

    private void verifyPermissions() {
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Create"}) && this.record.getKey() == null) {
            this.saveButton.setEnabled(true);
        }
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Create"}) && this.record.getKey() != null) {
            this.addButton.setEnabled(true);
        }
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Modify"}) && this.record.getKey() != null) {
            this.saveButton.setEnabled(true);
        }
    }

    public UiDealRecord getRecord() {
        return this.record;
    }

    public void revert() {
    }

    public String getStyleName() {
        return null;
    }

    public Widget getWidget() {
        return this;
    }

    public void release() {
    }

    public void saveFailed(Throwable throwable) {
        this.errorPanel.showMessage(throwable.getLocalizedMessage());
    }

    protected void onUnload() {
        super.onUnload();
    }
}

