/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.deal;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.tab.ErrorPanel;
import com.ericsson.cms.contractmgmt.client.tab.SuccessPanel;
import com.ericsson.cms.contractmgmt.client.tab.deal.DealAnchorChangeListener;
import com.ericsson.cms.contractmgmt.client.tab.deal.DealDataProvider;
import com.ericsson.cms.contractmgmt.client.tab.deal.DealDetailFeature;
import com.ericsson.cms.contractmgmt.client.tab.deal.UiDealRecord;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableDetailViewEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableViewChangeHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableViewEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.BookmarkFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.BookmarkFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.PageFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class DealListPanel
extends Composite {
    private DealDataProvider dataProvider;
    private PageFeature pageFeature;
    private SortFeatureImpl<Long, UiDealRecord> sortFeature;
    private DealDetailFeature detailFeature;
    private BookmarkFeature bookmarkFeature;
    private WidgetMenuItem.AnchorChangeListener anchorChangeListener;
    private VerticalContainer mainContainer;
    private Table<Long, UiDealRecord> table;
    private BusyIndicator busyIndicator = new BusyIndicator();
    private HeaderPanel header;
    private final SuccessPanel successPanel = new SuccessPanel();
    private final ErrorPanel errorPanel = new ErrorPanel();
    private ContractComponentConstants constants = (ContractComponentConstants)GWT.create(ContractComponentConstants.class);
    private static final int SPACING = 2;
    private static final String STYLE_NAME = "content-ContractPanel";
    private String IMAGE_URL = "cms_contractmgmt_ui/images/ico_contracts.png";
    private String STYLE_HEADER_IMAGE = "nwt-HeaderPanel-image";

    public DealListPanel() {
        this.dataProvider = new DealDataProvider(this);
        this.dataProvider.setBusyNotifier(new DealDataProvider.IBusyNotifier(){

            @Override
            public void startingToBeBusy() {
                DealListPanel.this.busyIndicator.center();
            }

            @Override
            public void doneBeingBusy() {
                DealListPanel.this.busyIndicator.hide();
            }
        });
        this.init();
    }

    private void init() {
        this.initWidgets();
        this.setContainers();
    }

    public SuccessPanel getSuccessPanel() {
        return this.successPanel;
    }

    public ErrorPanel getErrorPanel() {
        return this.errorPanel;
    }

    private void setContainers() {
        this.mainContainer.add((Widget)this.header);
        this.mainContainer.add((Widget)this.successPanel);
        this.mainContainer.add((Widget)this.errorPanel);
        this.mainContainer.add(this.table);
    }

    private void initWidgets() {
        this.mainContainer = new VerticalContainer();
        this.mainContainer.setSpacing(2);
        this.mainContainer.setStylePrimaryName(STYLE_NAME);
        this.initWidget((Widget)this.mainContainer);
        this.header = new HeaderPanel("");
        this.table = new Table((DataProvider)this.dataProvider);
        final Image image = new Image(this.IMAGE_URL);
        image.setStyleName(this.STYLE_HEADER_IMAGE);
        this.table.addTableViewChangeHandler((TableViewChangeHandler)new TableViewChangeHandler<Long, UiDealRecord>(){

            public void onShowDetailView(TableDetailViewEvent<Long, UiDealRecord> event) {
                if (event.isCreateView()) {
                    DealListPanel.this.header.setLabel(DealListPanel.this.constants.dealCreateHeading());
                } else {
                    DealListPanel.this.header.setLabel(String.valueOf(DealListPanel.this.constants.dealViewEditHeading()) + " " + ((UiDealRecord)event.getRecord()).getDeal().getName());
                }
                DealListPanel.this.header.setImage(image);
            }

            public void onShowListView(TableViewEvent event) {
                DealListPanel.this.header.setLabel(DealListPanel.this.constants.dealListHeading());
                DealListPanel.this.header.setImage(image);
            }
        });
        this.pageFeature = new PageFeatureImpl();
        this.dataProvider.setParentPageFeature(this.pageFeature);
        this.sortFeature = new SortFeatureImpl(this.dataProvider.getDefaultSortColumn(), SortOrder.ASCENDING);
        for (Column<?, UiDealRecord> col : this.dataProvider.getSortColumns()) {
            this.sortFeature.addSortableColumn(col);
        }
        this.dataProvider.setParentSortFeature(this.sortFeature);
        this.detailFeature = new DealDetailFeature(this);
        this.bookmarkFeature = new BookmarkFeatureImpl();
        this.table.addSortFeature(this.sortFeature);
        this.table.addPageFeature(this.pageFeature);
        this.table.addDetailFeature((DetailFeature)this.detailFeature);
        this.table.addBookmarkFeature(this.bookmarkFeature);
        this.table.initialize((AsyncCallback)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
            }

            public void onNeptuneSuccess(Void result) {
            }
        });
        this.anchorChangeListener = new DealAnchorChangeListener(this);
    }

    public Table<Long, UiDealRecord> getDealTable() {
        return this.table;
    }

    public WidgetMenuItem.AnchorChangeListener getAnchorChangeListener() {
        return this.anchorChangeListener;
    }

    public void setReverseAnchorChangeListener(WidgetMenuItem.AnchorChangeListener reverseAnchorChangeListener) {
        this.table.setAnchorChangeNotifier(reverseAnchorChangeListener);
    }

    public void clearMessages() {
        this.successPanel.reset();
        this.errorPanel.reset();
    }
}

