/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.license;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.ContractComponentMessages;
import com.ericsson.cms.contractmgmt.client.HelpWidget;
import com.ericsson.cms.contractmgmt.client.model.UiAsset;
import com.ericsson.cms.contractmgmt.client.model.UiLicense;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerServiceAsync;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HTMLTable;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.RadioButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AssetsTable
extends VerticalContainer {
    private static final String TABLE_STYLE = "contract-table";
    private static final String ROW_HEADER_STYLE = "contract-table-row-header";
    private static final String DELETE_IMAGE = "cms_contractmgmt_ui/images/delete.png";
    private static final String DELETE_CELL_STYLE = "contract-table-cell-body-delete";
    private FlexTableContainer table;
    private ButtonWidget addAssetsButton;
    private VerticalContainer tableContainer;
    private HorizontalContainer buttonsContainer;
    private final UiLicense uiLicense;
    private final BusyIndicator busyIndicator = new BusyIndicator();
    private final IContractManagerServiceAsync contractManagerService = (IContractManagerServiceAsync)GWT.create(IContractManagerService.class);
    private final ContractComponentConstants constants = (ContractComponentConstants)GWT.create(ContractComponentConstants.class);
    private final ContractComponentMessages messages = (ContractComponentMessages)GWT.create(ContractComponentMessages.class);

    public AssetsTable(UiLicense uiLicense) {
        this.uiLicense = uiLicense;
        this.init();
    }

    private void init() {
        boolean isCreating;
        RadioButtonWidget assetsInLicenseSelect = new RadioButtonWidget("assets", this.constants.select());
        assetsInLicenseSelect.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                if (((Boolean)event.getValue()).booleanValue()) {
                    AssetsTable.this.showAssetsTable();
                }
            }
        });
        boolean bl = isCreating = this.uiLicense.getKey() == null;
        if (isCreating && ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Create"}) || !isCreating && ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Modify"})) {
            HorizontalContainer assets = this.createRadioContainer(assetsInLicenseSelect);
            if (this.uiLicense.getKey() == null) {
                assets.add((Widget)new HelpWidget(this.messages.assetsSelectionAfterSave()));
            }
            this.add((Widget)assets);
        }
        assetsInLicenseSelect.setValue(Boolean.valueOf(true));
        assetsInLicenseSelect.setEnabled(false);
        this.tableContainer = new VerticalContainer();
        this.add((Widget)this.tableContainer);
        this.buttonsContainer = new HorizontalContainer();
        this.add((Widget)this.buttonsContainer);
        if (this.uiLicense.getKey() != null) {
            assetsInLicenseSelect.setEnabled(true);
            if (this.uiLicense.getAssetList().isEmpty()) {
                assetsInLicenseSelect.setValue(Boolean.valueOf(false));
                this.uiLicense.setAllAssets(true);
            } else {
                assetsInLicenseSelect.setValue(Boolean.valueOf(true));
                this.uiLicense.setAllAssets(false);
            }
            this.addAssetsButton = new ButtonWidget(this.constants.addButtonName(), new ClickHandler(){

                public void onClick(ClickEvent event) {
                    History.newItem((String)("Content.Search?licenseId=" + AssetsTable.this.uiLicense.getKey()));
                }
            });
            this.addAssetsButton.removeStyleName("gwt-Button");
            this.addAssetsButton.addStyleName("ebBtn");
            this.addAssetsButton.addStyleName("addgreen_button_icon");
            ArrayList<Long> titleIds = new ArrayList<Long>();
            for (UiAsset uiAsset : this.uiLicense.getAssetList()) {
                titleIds.add(uiAsset.getKey());
            }
            this.busyIndicator.center();
            this.contractManagerService.getAssets(titleIds, (AsyncCallback<List<UiAsset>>)new NeptuneAsyncCallback<List<UiAsset>>(){

                public void onNeptuneFailure(Throwable caught) {
                    AssetsTable.this.busyIndicator.hide();
                }

                public void onNeptuneSuccess(List<UiAsset> uiAssets) {
                    AssetsTable.this.uiLicense.getAssetList().clear();
                    AssetsTable.this.uiLicense.getAssetList().addAll(uiAssets);
                    AssetsTable.this.table = AssetsTable.this.prepareTable(uiAssets);
                    if (AssetsTable.this.uiLicense.getAllAssets() != null && !AssetsTable.this.uiLicense.getAllAssets().booleanValue()) {
                        AssetsTable.this.tableContainer.add((Widget)AssetsTable.this.table);
                        AssetsTable.this.addButtons();
                    } else {
                        AssetsTable.this.tableContainer.add((Widget)new LabelWidget(AssetsTable.this.constants.none()));
                    }
                    AssetsTable.this.busyIndicator.hide();
                }
            });
        } else {
            this.uiLicense.setAllAssets(false);
        }
        if (!ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Modify"})) {
            assetsInLicenseSelect.setEnabled(false);
        }
    }

    private void addButtons() {
        if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Modify"})) {
            this.buttonsContainer.add((Widget)this.addAssetsButton);
        }
    }

    private void removeAssetsFromLicense(final UiLicense uiLicense, final List<Long> assetsToRemove) {
        this.busyIndicator.center();
        this.contractManagerService.removeAssetsFromLicense(uiLicense.getKey(), assetsToRemove, (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
                AssetsTable.this.busyIndicator.hide();
            }

            public void onNeptuneSuccess(Void result) {
                block0: for (Long assetIdToRemove : assetsToRemove) {
                    for (UiAsset uiAsset : uiLicense.getAssetList()) {
                        if (!uiAsset.getKey().equals(assetIdToRemove)) continue;
                        uiLicense.getAssetList().remove(uiAsset);
                        continue block0;
                    }
                }
                AssetsTable.this.busyIndicator.hide();
            }
        });
    }

    private HorizontalContainer createRadioContainer(RadioButtonWidget selectRadio) {
        HorizontalContainer container = new HorizontalContainer();
        selectRadio.setValue(Boolean.valueOf(true));
        container.add((Widget)selectRadio);
        this.addSpace(container);
        return container;
    }

    private void addSpace(HorizontalContainer container) {
        if (container != null) {
            HorizontalPanel space = new HorizontalPanel();
            LabelWidget label = new LabelWidget();
            space.add((Widget)label);
            space.setCellWidth((Widget)label, "10");
            container.add((Widget)space);
        }
    }

    public boolean allAssetsSelected() {
        return false;
    }

    private FlexTableContainer prepareTable(List<UiAsset> uiAssets) {
        final FlexTableContainer flexTable = new FlexTableContainer();
        flexTable.setStylePrimaryName(TABLE_STYLE);
        int rowIndex = 0;
        int columnIndex = 0;
        flexTable.getRowFormatter().addStyleName(rowIndex, "table-header-row");
        flexTable.getRowFormatter().addStyleName(rowIndex, ROW_HEADER_STYLE);
        flexTable.setWidget(rowIndex, columnIndex++, this.createHeaderLabel(this.constants.licenseTitleIdColumn()));
        flexTable.setWidget(rowIndex, columnIndex++, this.createHeaderLabel(this.constants.licensePackageAssetIdColumn()));
        flexTable.setWidget(rowIndex, columnIndex++, this.createHeaderLabel(this.constants.licenseTitleBriefColumn()));
        HTMLTable.CellFormatter cellFormatter = flexTable.getCellFormatter();
        Iterator<UiAsset> iterator = uiAssets.iterator();
        while (iterator.hasNext()) {
            UiAsset ua;
            final UiAsset uiAsset = ua = iterator.next();
            rowIndex = flexTable.getRowCount();
            columnIndex = 0;
            flexTable.insertRow(rowIndex);
            String styleName = rowIndex % 2 == 0 ? "table-data-even-row" : "table-data-odd-row";
            flexTable.getRowFormatter().setStyleName(rowIndex, styleName);
            LabelWidget idLabel = new LabelWidget(uiAsset.getKey().toString());
            if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"AssetManagement_View"})) {
                idLabel.setStyleName("table-data-link");
                idLabel.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        History.newItem((String)("Content.Search.Id=" + uiAsset.getKey()));
                    }
                });
            } else {
                idLabel.addStyleName("table-data-text");
            }
            flexTable.setWidget(rowIndex, columnIndex, (Widget)idLabel);
            cellFormatter.addStyleName(rowIndex, columnIndex, "nwt-TableColumnPanel-dataCell");
            this.addDataCellToTable(flexTable, rowIndex, ++columnIndex, uiAsset.getPackageAssetId(), cellFormatter, "nwt-TableColumnPanel-dataCell-text");
            this.addDataCellToTable(flexTable, rowIndex, ++columnIndex, uiAsset.getName(), cellFormatter, "nwt-TableColumnPanel-dataCell-text");
            ++columnIndex;
            if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Modify"})) {
                Image removeButton = new Image(DELETE_IMAGE);
                removeButton.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        if (Window.confirm((String)AssetsTable.this.messages.deleteRecordConfirmation())) {
                            ArrayList<Long> assetsToRemove = new ArrayList<Long>();
                            int rowIndex = flexTable.getCellForEvent(event).getRowIndex();
                            assetsToRemove.add(uiAsset.getKey());
                            flexTable.removeRow(rowIndex);
                            AssetsTable.this.removeAssetsFromLicense(AssetsTable.this.uiLicense, assetsToRemove);
                        }
                    }
                });
                flexTable.setWidget(rowIndex, columnIndex, (Widget)removeButton);
                flexTable.getCellFormatter().setStyleName(rowIndex, columnIndex, DELETE_CELL_STYLE);
                ++columnIndex;
            }
            ++rowIndex;
        }
        return flexTable;
    }

    private void addDataCellToTable(FlexTableContainer table, int rowIndex, int columnIndex, String version, HTMLTable.CellFormatter cellFormatter, String style) {
        table.setWidget(rowIndex, columnIndex, this.createDataCellLabel(version));
        cellFormatter.addStyleName(rowIndex, columnIndex, "nwt-TableColumnPanel-dataCell");
        cellFormatter.addStyleName(rowIndex, columnIndex, style);
    }

    private Widget createHeaderLabel(String text) {
        LabelWidget label = new LabelWidget(text);
        label.addStyleName("table-header-nonSortable-text");
        return label;
    }

    private Widget createDataCellLabel(String text) {
        LabelWidget label = new LabelWidget(text);
        label.setStyleName("nwt-TableColumnPanel-dataCell-text");
        return label;
    }

    private void showAssetsTable() {
        this.tableContainer.clear();
        this.buttonsContainer.clear();
        this.tableContainer.add((Widget)this.table);
        this.addButtons();
    }
}

