/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.license;

import com.ericsson.cms.contractmgmt.client.model.UiDeal;
import com.ericsson.cms.contractmgmt.client.model.UiLicense;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerServiceAsync;
import com.ericsson.cms.contractmgmt.client.tab.license.LicenseListPanel;
import com.ericsson.cms.contractmgmt.client.tab.license.UiLicenseRecord;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;

public class LicenseAnchorChangeListener
implements WidgetMenuItem.AnchorChangeListener {
    private static final String LICENSE_ID = "licenseId";
    private static final String DEAL_ID = "dealId";
    private static final String PARAMETER_DELIMITER = "&";
    private static final String VALUE_DELIMITER = "=";
    private final LicenseListPanel widget;

    public LicenseAnchorChangeListener(LicenseListPanel listPanel) {
        this.widget = listPanel;
    }

    public void anchorChanged(String anchor) {
        long licenseId = 0L;
        long dealId = 0L;
        if (anchor != null && anchor.contains(LICENSE_ID)) {
            String[] params;
            this.widget.getLicenseTable().reset();
            anchor = anchor.substring(5);
            String[] stringArray = params = anchor.split(PARAMETER_DELIMITER);
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                String p = stringArray[n2];
                String[] paramValue = p.split(VALUE_DELIMITER);
                if (paramValue[0].equalsIgnoreCase(LICENSE_ID)) {
                    licenseId = Long.parseLong(paramValue[1]);
                }
                ++n2;
            }
            IContractManagerServiceAsync cmService = (IContractManagerServiceAsync)GWT.create(IContractManagerService.class);
            cmService.getLicense(licenseId, (AsyncCallback<UiLicense>)new NeptuneAsyncCallback<UiLicense>(){

                public void onNeptuneFailure(Throwable caught) {
                    Window.alert((String)caught.getLocalizedMessage());
                }

                public void onNeptuneSuccess(UiLicense result) {
                    LicenseAnchorChangeListener.this.widget.getLicenseTable().showDetailView((Record)new UiLicenseRecord(result));
                }
            });
        } else if (anchor != null && !anchor.contains(LICENSE_ID) && anchor.contains(DEAL_ID)) {
            String[] params;
            this.widget.getLicenseTable().reset();
            anchor = anchor.substring(7);
            String[] stringArray = params = anchor.split(PARAMETER_DELIMITER);
            int n = params.length;
            int n3 = 0;
            while (n3 < n) {
                String p = stringArray[n3];
                String[] paramValue = p.split(VALUE_DELIMITER);
                if (paramValue[0].equalsIgnoreCase(DEAL_ID)) {
                    dealId = Long.parseLong(paramValue[1]);
                }
                ++n3;
            }
            final UiLicense uiLicense = new UiLicense();
            IContractManagerServiceAsync cmService = (IContractManagerServiceAsync)GWT.create(IContractManagerService.class);
            cmService.getDeal(dealId, (AsyncCallback<UiDeal>)new NeptuneAsyncCallback<UiDeal>(){

                public void onNeptuneFailure(Throwable caught) {
                    Window.alert((String)caught.getLocalizedMessage());
                }

                public void onNeptuneSuccess(UiDeal result) {
                    uiLicense.setName("");
                    uiLicense.setDeal(result);
                    LicenseAnchorChangeListener.this.widget.getLicenseTable().showDetailView((Record)new UiLicenseRecord(uiLicense));
                }
            });
        } else {
            this.widget.getLicenseTable().setAnchor(anchor);
        }
    }
}

