/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.license;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.model.LicenseSearchResult;
import com.ericsson.cms.contractmgmt.client.model.UiLicense;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerServiceAsync;
import com.ericsson.cms.contractmgmt.client.tab.license.LicenseListPanel;
import com.ericsson.cms.contractmgmt.client.tab.license.UiLicenseRecord;
import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelStringView;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class LicenseDataProvider
implements DataProvider<Long, UiLicenseRecord> {
    private final List<Column<?, UiLicenseRecord>> columns;
    private final ColumnBase<String, UiLicenseRecord> idColumn;
    private final ColumnBase<String, UiLicenseRecord> nameColumn;
    private final ColumnBase<String, UiLicenseRecord> typeColumn;
    private final ColumnBase<String, UiLicenseRecord> expiryColumn;
    private final ColumnBase<String, UiLicenseRecord> activeColumn;
    private ContractComponentConstants constants = (ContractComponentConstants)GWT.create(ContractComponentConstants.class);
    private IContractManagerServiceAsync contractManagerService = (IContractManagerServiceAsync)GWT.create(IContractManagerService.class);
    private PageFeature parentPageFeature;
    private SortFeatureImpl<Long, UiLicenseRecord> parentSortFeature;
    private static final String ID_COLUMN = "id";
    private static final String NAME_COLUMN = "name";
    private static final String TYPE_COLUMN = "licenseType";
    private static final String EXPIRY_DATE_COLUMN = "expiryDate";
    private static final String ACTIVE_COLUMN = "active";
    private IBusyNotifier busyNotifier;
    private static final String NON_ACTIVE_STYLE = "cell-NonActive";
    private static final String EXPIRED_STYLE = "cell-Expired";
    private static final String NON_ACTIVE_AND_EXPIRED = "cell-Expired-NonActive";
    private String cellStyle = null;

    public LicenseDataProvider(LicenseListPanel listsPanel) {
        this.columns = new ArrayList();
        this.idColumn = new ColumnBase<String, UiLicenseRecord>(ID_COLUMN, this.constants.licenseId()){

            public View<String> getView(UiLicenseRecord record) {
                LicenseDataProvider.this.cellStyle = LicenseDataProvider.this.getCellStyle(record);
                LabelStringView lb = new LabelStringView(String.valueOf(record.getLicense().getKey()));
                if (LicenseDataProvider.this.cellStyle != null) {
                    lb.setStyleName(LicenseDataProvider.this.cellStyle);
                }
                return lb;
            }
        };
        this.idColumn.setCellStyle("nwt-TableColumnPanel-dataCell-numeric");
        this.columns.add((Column<?, UiLicenseRecord>)this.idColumn);
        this.nameColumn = new ColumnBase<String, UiLicenseRecord>(NAME_COLUMN, this.constants.licenseNameColumn()){

            public View<String> getView(UiLicenseRecord record) {
                return new LabelStringView(String.valueOf(record.getLicense().getName()));
            }
        };
        this.nameColumn.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        this.columns.add((Column<?, UiLicenseRecord>)this.nameColumn);
        this.typeColumn = new ColumnBase<String, UiLicenseRecord>(TYPE_COLUMN, this.constants.licenseTypeColumn()){

            public View<String> getView(UiLicenseRecord record) {
                LabelStringView lb = new LabelStringView(record.getLicense().getType().getName());
                if (LicenseDataProvider.this.cellStyle != null) {
                    lb.setStyleName(LicenseDataProvider.this.cellStyle);
                }
                return lb;
            }
        };
        this.typeColumn.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        this.columns.add((Column<?, UiLicenseRecord>)this.typeColumn);
        this.expiryColumn = new ColumnBase<String, UiLicenseRecord>(EXPIRY_DATE_COLUMN, this.constants.licenseExpiryDateColumn()){

            public View<String> getView(UiLicenseRecord record) {
                LabelStringView lb = new LabelStringView(record.getLicense().getExpiryDate());
                if (LicenseDataProvider.this.cellStyle != null) {
                    lb.setStyleName(LicenseDataProvider.this.cellStyle);
                }
                return lb;
            }
        };
        this.expiryColumn.setCellStyle("nwt-TableColumnPanel-dataCell-date");
        this.columns.add((Column<?, UiLicenseRecord>)this.expiryColumn);
        this.activeColumn = new ColumnBase<String, UiLicenseRecord>(ACTIVE_COLUMN, this.constants.licenseActiveColumn()){

            public View<String> getView(UiLicenseRecord record) {
                if (record.getLicense().isActive()) {
                    LabelStringView lb = new LabelStringView(LicenseDataProvider.this.constants.yes());
                    if (LicenseDataProvider.this.cellStyle != null) {
                        lb.setStyleName(LicenseDataProvider.this.cellStyle);
                    }
                    return lb;
                }
                LabelStringView lb = new LabelStringView(LicenseDataProvider.this.constants.no());
                if (LicenseDataProvider.this.cellStyle != null) {
                    lb.setStyleName(LicenseDataProvider.this.cellStyle);
                }
                return lb;
            }
        };
        this.activeColumn.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        this.columns.add((Column<?, UiLicenseRecord>)this.activeColumn);
    }

    private final String getCellStyle(UiLicenseRecord record) {
        DateTimeFormat dateFormatter = DateTimeFormat.getFormat((String)this.constants.dateFormat());
        String now = dateFormatter.format(new Date());
        if (!record.getLicense().isActive() && now.compareTo(record.getLicense().getExpiryDate()) > 0) {
            return NON_ACTIVE_AND_EXPIRED;
        }
        if (!record.getLicense().isActive()) {
            return NON_ACTIVE_STYLE;
        }
        if (now.compareTo(record.getLicense().getExpiryDate()) > 0) {
            return EXPIRED_STYLE;
        }
        return null;
    }

    public ColumnBase<String, UiLicenseRecord> getDefaultSortColumn() {
        return this.nameColumn;
    }

    public List<Column<?, UiLicenseRecord>> getSortColumns() {
        return this.columns;
    }

    public List<Column<?, UiLicenseRecord>> getColumns() {
        return this.columns;
    }

    public void getRecord(Long key, final AsyncCallback<UiLicenseRecord> callback) {
        this.notifyBusyStart();
        this.contractManagerService.getFullLicense(key, (AsyncCallback<UiLicense>)new NeptuneAsyncCallback<UiLicense>(){

            public void onNeptuneFailure(Throwable caught) {
                callback.onFailure(caught);
                LicenseDataProvider.this.notifyBusyFinish();
            }

            public void onNeptuneSuccess(UiLicense result) {
                callback.onSuccess((Object)new UiLicenseRecord(result));
                LicenseDataProvider.this.notifyBusyFinish();
            }
        });
    }

    public void getRecords(final AsyncCallback<List<UiLicenseRecord>> callback) {
        int length = this.getParentPageFeature().getPageSize();
        int start = (this.getParentPageFeature().getPageNumber() - 1) * length;
        this.notifyBusyStart();
        this.contractManagerService.getLicenseList(start, length, this.getParentSortFeature().getSortColumnName(), this.getParentSortFeature().isAscending(), (AsyncCallback<LicenseSearchResult>)new NeptuneAsyncCallback<LicenseSearchResult>(){

            public void onNeptuneFailure(Throwable caught) {
                LicenseDataProvider.this.getParentPageFeature().setRecordCount(-1);
                callback.onFailure(caught);
                LicenseDataProvider.this.notifyBusyFinish();
            }

            public void onNeptuneSuccess(LicenseSearchResult result) {
                LicenseDataProvider.this.getParentPageFeature().setRecordCount(result.getTotalCount());
                ArrayList<UiLicenseRecord> uiLicenseRecords = new ArrayList<UiLicenseRecord>();
                for (UiLicense uiLicense : result.getUiLicensesList()) {
                    uiLicenseRecords.add(new UiLicenseRecord(uiLicense));
                }
                callback.onSuccess(uiLicenseRecords);
                LicenseDataProvider.this.notifyBusyFinish();
            }
        });
    }

    public void initialize(AsyncCallback<Void> callback) {
        callback.onSuccess(null);
    }

    public boolean isCheckboxEnabled() {
        return true;
    }

    public boolean isRecordCountEnabled() {
        return true;
    }

    public PageFeature getParentPageFeature() {
        return this.parentPageFeature;
    }

    public void setParentPageFeature(PageFeature parentPageFeature) {
        this.parentPageFeature = parentPageFeature;
    }

    public SortFeatureImpl<Long, UiLicenseRecord> getParentSortFeature() {
        return this.parentSortFeature;
    }

    public void setParentSortFeature(SortFeatureImpl<Long, UiLicenseRecord> parentSortFeature) {
        this.parentSortFeature = parentSortFeature;
    }

    public void setBusyNotifier(IBusyNotifier busyNotifier) {
        this.busyNotifier = busyNotifier;
    }

    private void notifyBusyStart() {
        if (this.busyNotifier != null) {
            this.busyNotifier.startingToBeBusy();
        }
    }

    private void notifyBusyFinish() {
        if (this.busyNotifier != null) {
            this.busyNotifier.doneBeingBusy();
        }
    }

    public static interface IBusyNotifier {
        public void startingToBeBusy();

        public void doneBeingBusy();
    }
}

