/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.license;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.ContractComponentMessages;
import com.ericsson.cms.contractmgmt.client.customfield.UiUserDefinedField;
import com.ericsson.cms.contractmgmt.client.model.UiLicense;
import com.ericsson.cms.contractmgmt.client.model.UiLicenseDetails;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerServiceAsync;
import com.ericsson.cms.contractmgmt.client.tab.UiLongKeySerializer;
import com.ericsson.cms.contractmgmt.client.tab.license.LicenseDetailView;
import com.ericsson.cms.contractmgmt.client.tab.license.LicenseListPanel;
import com.ericsson.cms.contractmgmt.client.tab.license.UiLicenseRecord;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.KeySerializer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.AbstractDetailFeature;
import java.util.List;

public class LicenseDetailFeature
extends AbstractDetailFeature<Long, UiLicenseRecord> {
    private final LicenseListPanel parentPanel;
    private final IContractManagerServiceAsync contractManagerService = (IContractManagerServiceAsync)GWT.create(IContractManagerService.class);
    private final ContractComponentConstants constants = (ContractComponentConstants)GWT.create(ContractComponentConstants.class);
    private final ContractComponentMessages messages = (ContractComponentMessages)GWT.create(ContractComponentMessages.class);

    public LicenseDetailFeature(LicenseListPanel parentPanel) {
        super((KeySerializer)new UiLongKeySerializer());
        this.parentPanel = parentPanel;
    }

    public void delete(List<UiLicenseRecord> records, final AsyncCallback<Void> callback) {
        if (records.size() > 0) {
            if (Window.confirm((String)this.messages.deleteLicenseConfirmation())) {
                this.parentPanel.showBusyIndicator();
                this.contractManagerService.deleteLicenses(records, (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

                    public void onNeptuneFailure(Throwable caught) {
                        LicenseDetailFeature.this.parentPanel.getLicenseTable().refresh();
                        LicenseDetailFeature.this.parentPanel.getErrorPanel().showMessage(LicenseDetailFeature.this.messages.deleteLicenseError());
                        if (caught instanceof ValidationException) {
                            ValidationException ve = (ValidationException)caught;
                            for (String message : ve.getValidationMessages()) {
                                LicenseDetailFeature.this.parentPanel.getErrorPanel().addMessage(message);
                            }
                        } else {
                            callback.onFailure(caught);
                        }
                        LicenseDetailFeature.this.parentPanel.hideBusyIndicator();
                    }

                    public void onNeptuneSuccess(Void result) {
                        LicenseDetailFeature.this.parentPanel.getSuccessPanel().showMessage(LicenseDetailFeature.this.messages.deleteLicenseSucceeded());
                        callback.onSuccess(null);
                        LicenseDetailFeature.this.parentPanel.hideBusyIndicator();
                    }
                });
            }
        } else {
            Window.alert((String)this.messages.noLicenseSelected());
        }
    }

    public void getNew(final AsyncCallback<UiLicenseRecord> callback) {
        this.parentPanel.clearMessages();
        this.parentPanel.showBusyIndicator();
        this.contractManagerService.getLicenseUserDefinedFields((AsyncCallback<List<UiUserDefinedField>>)new NeptuneAsyncCallback<List<UiUserDefinedField>>(){

            public void onNeptuneFailure(Throwable caught) {
                callback.onFailure(caught);
                LicenseDetailFeature.this.parentPanel.hideBusyIndicator();
            }

            public void onNeptuneSuccess(List<UiUserDefinedField> result) {
                UiLicense license = new UiLicense();
                license.getUserDefinedFields().addAll(result);
                license.resetDefaultValues();
                UiLicenseDetails defaultLicenseDetails = new UiLicenseDetails(license);
                license.getLicenseDetailsList().add(defaultLicenseDetails);
                callback.onSuccess((Object)new UiLicenseRecord(license));
                LicenseDetailFeature.this.parentPanel.hideBusyIndicator();
            }
        });
    }

    public DetailView<Long, UiLicenseRecord> getView(UiLicenseRecord record, DetailViewCallback<Long, UiLicenseRecord> callback) {
        this.parentPanel.clearMessages();
        LicenseDetailView view = new LicenseDetailView(this.parentPanel, record, callback);
        return view;
    }

    public boolean hasDetailLink(Column<?, UiLicenseRecord> column) {
        return column.getDisplayName().equals(this.constants.licenseNameColumn()) && ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_View"});
    }

    public void save(UiLicenseRecord record, final AsyncCallback<Void> callback) {
        this.parentPanel.showBusyIndicator();
        this.contractManagerService.saveLicense(record, (AsyncCallback<Void>)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
                callback.onFailure(caught);
                LicenseDetailFeature.this.parentPanel.hideBusyIndicator();
            }

            public void onNeptuneSuccess(Void result) {
                LicenseDetailFeature.this.parentPanel.hideBusyIndicator();
                History.back();
            }
        });
    }

    public boolean showCreateButton() {
        return ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Create"});
    }

    public boolean showDeleteButton() {
        return ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Delete"});
    }
}

