/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.license;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.ContractComponentMessages;
import com.ericsson.cms.contractmgmt.client.customfield.UiUserDefinedField;
import com.ericsson.cms.contractmgmt.client.customfield.UiUserDefinedFieldValue;
import com.ericsson.cms.contractmgmt.client.model.UiDeal;
import com.ericsson.cms.contractmgmt.client.model.UiDeliveryLocation;
import com.ericsson.cms.contractmgmt.client.model.UiDevice;
import com.ericsson.cms.contractmgmt.client.model.UiLicense;
import com.ericsson.cms.contractmgmt.client.model.UiLicenseDetails;
import com.ericsson.cms.contractmgmt.client.model.UiPlatform;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerServiceAsync;
import com.ericsson.cms.contractmgmt.client.tab.ErrorPanel;
import com.ericsson.cms.contractmgmt.client.tab.SuccessPanel;
import com.ericsson.cms.contractmgmt.client.tab.license.AbstractLicenseTab;
import com.ericsson.cms.contractmgmt.client.tab.license.LicenseListPanel;
import com.ericsson.cms.contractmgmt.client.tab.license.LicenseMainForm;
import com.ericsson.cms.contractmgmt.client.tab.license.UiLicenseRecord;
import com.ericsson.cms.contractmgmt.client.tab.license.tab.AssetEnhancementTab;
import com.ericsson.cms.contractmgmt.client.tab.license.tab.DistributionTab;
import com.ericsson.cms.contractmgmt.client.tab.license.tab.LicenseDetailsUtils;
import com.ericsson.cms.contractmgmt.client.tab.license.tab.PricingTab;
import com.ericsson.cms.contractmgmt.client.tab.license.tab.StorageMetadataTab;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.TabContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LicenseDetailView
extends Composite
implements DetailView<Long, UiLicenseRecord> {
    private static final String STYLE_TABCONTAINER = "license-tabContainer";
    private static final String ASSETS_ALREADY_ADDED = "licenseAssetsAlreadyAdded";
    private static final String INVALID_ASSETS = "licenseInvalidAssets";
    private static final String ASSETS_ASSOCIATED_WITH_LICENSES = "licenseAssetsAssociated";
    private static final String STYLE_NAME = "content-ContractPanel";
    private static final String CONTAINER_STYLE = "realm-UserForm contract-Container";
    private final ContractComponentConstants constants = (ContractComponentConstants)GWT.create(ContractComponentConstants.class);
    private final ContractComponentMessages messages = (ContractComponentMessages)GWT.create(ContractComponentMessages.class);
    private final IContractManagerServiceAsync contractManagerService = (IContractManagerServiceAsync)GWT.create(IContractManagerService.class);
    private final UiLicenseRecord record;
    private final DetailViewCallback<Long, UiLicenseRecord> callback;
    private final LicenseListPanel parentPanel;
    private TabContainer tabContainer;
    private final List<AbstractLicenseTab> tabs;
    private final VerticalContainer contentContainer;
    private HorizontalContainer buttonsContainer;
    private final VerticalContainer bottomContainer = new VerticalContainer();
    private LicenseMainForm licenseMainForm;
    private final SuccessPanel successPanel = new SuccessPanel();
    private final ErrorPanel errorPanel = new ErrorPanel();
    private final BusyIndicator busyIndicator = new BusyIndicator();

    public LicenseDetailView(LicenseListPanel parentPanel, final UiLicenseRecord record, DetailViewCallback<Long, UiLicenseRecord> callback) {
        this.parentPanel = parentPanel;
        this.record = record;
        this.callback = callback;
        this.tabs = new ArrayList<AbstractLicenseTab>();
        VerticalContainer mainContainer = new VerticalContainer();
        mainContainer.add((Widget)this.successPanel);
        mainContainer.add((Widget)this.errorPanel);
        this.contentContainer = new VerticalContainer();
        this.contentContainer.setStylePrimaryName(STYLE_NAME);
        mainContainer.add((Widget)this.contentContainer);
        if (record.getKey() != null) {
            this.busyIndicator.center();
            this.contractManagerService.getFullLicense(record.getKey(), (AsyncCallback<UiLicense>)new NeptuneAsyncCallback<UiLicense>(){

                public void onNeptuneFailure(Throwable caught) {
                    LicenseDetailView.this.errorPanel.showMessage(caught.getLocalizedMessage());
                    LicenseDetailView.this.busyIndicator.hide();
                }

                public void onNeptuneSuccess(UiLicense result) {
                    record.setLicense(result);
                    LicenseDetailView.this.createMainForm();
                    LicenseDetailView.this.getErrorsFromSession();
                    LicenseDetailView.this.busyIndicator.hide();
                }
            });
        } else {
            this.createMainForm();
        }
        this.initWidget((Widget)mainContainer);
    }

    private void getErrorsFromSession() {
        this.contractManagerService.getLicenseErrorsFromHttpSession(this.record.getKey(), new AsyncCallback<Map<String, Object>>(){

            public void onFailure(Throwable caught) {
                Window.alert((String)LicenseDetailView.this.constants.errorsMapError());
            }

            public void onSuccess(Map<String, Object> errorsMap) {
                List assetsLicenseAssociated;
                Integer invalidAssets;
                Integer assetsAlreadyAdded = (Integer)errorsMap.get(LicenseDetailView.ASSETS_ALREADY_ADDED + LicenseDetailView.this.record.getKey());
                LicenseDetailView.this.successPanel.reset();
                if (assetsAlreadyAdded != null && assetsAlreadyAdded > 0) {
                    LicenseDetailView.this.successPanel.setVisible(true);
                    LicenseDetailView.this.successPanel.addMessage(LicenseDetailView.this.constants.assetsAlreadyAdded());
                }
                if ((invalidAssets = (Integer)errorsMap.get(LicenseDetailView.INVALID_ASSETS + LicenseDetailView.this.record.getKey())) != null && invalidAssets > 0) {
                    LicenseDetailView.this.successPanel.setVisible(true);
                    LicenseDetailView.this.successPanel.addMessage(LicenseDetailView.this.constants.invalidAssetsProvider());
                }
                if ((assetsLicenseAssociated = (List)errorsMap.get(LicenseDetailView.ASSETS_ASSOCIATED_WITH_LICENSES + LicenseDetailView.this.record.getKey())) != null && !assetsLicenseAssociated.isEmpty()) {
                    LicenseDetailView.this.errorPanel.setVisible(true);
                    for (String message : assetsLicenseAssociated) {
                        LicenseDetailView.this.errorPanel.addMessage(message);
                    }
                }
            }
        });
    }

    private void createMainForm() {
        this.licenseMainForm = new LicenseMainForm(this.record.getLicense(), this.errorPanel, HasHorizontalAlignment.ALIGN_LEFT, this.bottomContainer);
        this.showMainLicensePage();
    }

    private void showMainLicensePage() {
        this.contentContainer.clear();
        this.licenseMainForm.addStyleName(CONTAINER_STYLE);
        this.contentContainer.add((Widget)this.licenseMainForm);
        this.addMainFormButtons();
        this.bottomContainer.addStyleName(CONTAINER_STYLE);
        this.contentContainer.add((Widget)this.bottomContainer);
    }

    private void addMainFormButtons() {
        this.createButtonsContainer();
        this.addNextButton(this.buttonsContainer);
        this.addCancelButton(this.buttonsContainer);
    }

    private void createLicenceTabs() {
        this.contentContainer.clear();
        this.addBackButton(this.contentContainer);
        this.initTabs();
        this.createButtonsContainer();
        this.addSaveButton(this.buttonsContainer);
        this.addCancelButton(this.buttonsContainer);
    }

    private void createButtonsContainer() {
        this.buttonsContainer = new HorizontalContainer();
        this.buttonsContainer.setSpacing(5);
        this.buttonsContainer.addStyleName("cms_button_container");
        this.contentContainer.add((Widget)this.buttonsContainer);
        this.buttonsContainer.setWidth("10%");
    }

    private void addNextButton(HorizontalContainer buttonsContainer) {
        ButtonWidget nextButton = new ButtonWidget(this.constants.configureLicenseNextButton(), new ClickHandler(){

            /*
             * Unable to fully structure code
             */
            public void onClick(ClickEvent event) {
                block5: {
                    if (LicenseDetailView.access$6(LicenseDetailView.this).getLicense().getDeal().getKey() != null) {
                        LicenseDetailView.access$2(LicenseDetailView.this).center();
                        LicenseDetailView.access$8(LicenseDetailView.this).getDeal(LicenseDetailView.access$6(LicenseDetailView.this).getLicense().getDeal().getKey(), (AsyncCallback<UiDeal>)new NeptuneAsyncCallback<UiDeal>(){

                            public void onNeptuneFailure(Throwable caught) {
                                LicenseDetailView.this.errorPanel.showMessage(caught.getLocalizedMessage());
                                LicenseDetailView.this.busyIndicator.hide();
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public void onNeptuneSuccess(UiDeal result) {
                                block3: {
                                    LicenseDetailView.access$9(3.access$0(this)).setDeal(result);
                                    try {
                                        LicenseDetailView.access$9(3.access$0(this)).validateWithMessages();
                                        3.access$0(this).commit();
                                        LicenseDetailView.access$10(3.access$0(this));
                                        LicenseDetailView.access$11(3.access$0(this));
                                        LicenseDetailView.access$7(3.access$0(this)).reset();
                                        LicenseDetailView.access$1(3.access$0(this)).reset();
                                        LicenseDetailView.access$2(3.access$0(this)).hide();
                                        break block3;
                                    }
                                    catch (ValidationException e) {
                                        LicenseDetailView.access$1(3.access$0(this)).reset();
                                        LicenseDetailView.access$7(3.access$0(this)).reset();
                                        ** for (message : e.getValidationMessages())
                                    }
lbl-1000:
                                    // 1 sources

                                    {
                                        LicenseDetailView.access$1(3.access$0(this)).addMessage(message);
                                        continue;
                                    }
lbl17:
                                    // 1 sources

                                    LicenseDetailView.access$2(3.access$0(this)).hide();
                                }
                            }
                        });
                    } else {
                        try {
                            LicenseDetailView.access$1(LicenseDetailView.this).reset();
                            LicenseDetailView.access$9(LicenseDetailView.this).validateWithMessages();
                            break block5;
                        }
                        catch (ValidationException e) {
                            ** for (message : e.getValidationMessages())
                        }
lbl-1000:
                        // 1 sources

                        {
                            LicenseDetailView.access$1(LicenseDetailView.this).addMessage(message);
                            continue;
                        }
                    }
                }
            }
        });
        nextButton.removeStyleName("gwt-Button");
        nextButton.addStyleName("ebBtn");
        nextButton.addStyleName("ebBtn_color_green");
        nextButton.addStyleName("next_button_icon");
        nextButton.ensureDebugId("license-next");
        buttonsContainer.add((Widget)nextButton);
    }

    private void addCancelButton(HorizontalContainer buttonsContainer) {
        ButtonWidget cancelButton = new ButtonWidget(this.constants.cancelButtonName(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                LicenseDetailView.this.errorPanel.reset();
                LicenseDetailView.this.successPanel.reset();
                History.back();
            }
        });
        cancelButton.removeStyleName("gwt-Button");
        cancelButton.addStyleName("ebBtn");
        buttonsContainer.add((Widget)cancelButton);
    }

    private void addBackButton(VerticalContainer buttonsContainer) {
        ButtonWidget backButton = new ButtonWidget(this.constants.backToLicenseButtonName(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                for (AbstractLicenseTab tab : LicenseDetailView.this.tabs) {
                    if (!tab.isChanged()) continue;
                    tab.nodeSelected(null);
                }
                LicenseDetailView.this.errorPanel.reset();
                LicenseDetailView.this.parentPanel.getErrorPanel().reset();
                LicenseDetailView.this.showMainLicensePage();
            }
        });
        backButton.removeStyleName("gwt-Button");
        backButton.addStyleName("ebBtn");
        backButton.addStyleName("ebBtn_color_green");
        buttonsContainer.add((Widget)backButton);
    }

    private void addSaveButton(HorizontalContainer buttonsContainer) {
        boolean isCreating;
        boolean bl = isCreating = this.record.getKey() == null;
        if (isCreating && ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Create"}) || !isCreating && ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Modify"})) {
            ButtonWidget saveButton = new ButtonWidget(this.constants.saveButtonName(), new ClickHandler(){

                public void onClick(ClickEvent event) {
                    LicenseDetailView.this.parentPanel.getErrorPanel().reset();
                    LicenseDetailView.this.errorPanel.reset();
                    if (LicenseDetailView.this.validateTabs()) {
                        LicenseDetailView.this.commit();
                        LicenseDetailView.this.callback.save((DetailView)LicenseDetailView.this);
                    }
                }
            });
            saveButton.removeStyleName("gwt-Button");
            saveButton.addStyleName("ebBtn");
            saveButton.addStyleName("ebBtn_color_green");
            saveButton.addStyleName("save_button_icon");
            saveButton.ensureDebugId("license-save");
            buttonsContainer.add((Widget)saveButton);
        }
    }

    private void buildLicenseDetailsList() {
        if (this.record.getKey() == null) {
            this.createLicenseDetailsList();
        } else {
            this.updateLicenseDetailsList();
        }
    }

    private void updateLicenseDetailsList() {
        UiLicense uiLicense = this.record.getLicense();
        ArrayList<UiLicenseDetails> licenseDetailsListTemp = new ArrayList<UiLicenseDetails>();
        this.createMissingUserDefinedFieldValues(uiLicense, uiLicense.getDefaultLicenseDetails());
        UiLicenseDetails defaultLicenseDetails = uiLicense.getDefaultLicenseDetails();
        if (defaultLicenseDetails != null) {
            licenseDetailsListTemp.add(uiLicense.getDefaultLicenseDetails());
        } else {
            defaultLicenseDetails = this.createLicenseDetails(uiLicense, null, null, null);
            licenseDetailsListTemp.add(defaultLicenseDetails);
        }
        for (UiDeliveryLocation deliveryLocation : uiLicense.getDeliveryLocations()) {
            UiLicenseDetails licenseDetails = this.findLicenseDetails(uiLicense.getLicenseDetailsList(), deliveryLocation);
            if (licenseDetails != null) {
                this.createMissingUserDefinedFieldValues(uiLicense, licenseDetails);
                if (licenseDetails.getPlatform() == null && licenseDetails.getDevice() == null) {
                    licenseDetails.getChildren().clear();
                }
                licenseDetailsListTemp.add(licenseDetails);
            } else {
                UiLicenseDetails newLicenseDetails = this.createLicenseDetails(uiLicense, deliveryLocation, null, null);
                LicenseDetailsUtils.copy(defaultLicenseDetails, newLicenseDetails);
                licenseDetailsListTemp.add(newLicenseDetails);
            }
            for (UiPlatform platform : uiLicense.getPlatforms()) {
                licenseDetails = this.findLicenseDetails(uiLicense.getLicenseDetailsList(), deliveryLocation, platform);
                if (licenseDetails != null) {
                    platform.setDeliveryLocation(deliveryLocation);
                    this.createMissingUserDefinedFieldValues(uiLicense, licenseDetails);
                    licenseDetailsListTemp.add(licenseDetails);
                } else {
                    platform.setDeliveryLocation(deliveryLocation);
                    UiLicenseDetails newLicenseDetails = this.createLicenseDetails(uiLicense, deliveryLocation, platform, null);
                    LicenseDetailsUtils.copy(defaultLicenseDetails, newLicenseDetails);
                    licenseDetailsListTemp.add(newLicenseDetails);
                }
                for (UiDevice device : uiLicense.getDevices()) {
                    if (!device.getPlatform().getKey().equals(platform.getKey())) continue;
                    licenseDetails = this.findLicenseDetails(uiLicense.getLicenseDetailsList(), deliveryLocation, device);
                    if (licenseDetails != null) {
                        this.createMissingUserDefinedFieldValues(uiLicense, licenseDetails);
                        licenseDetailsListTemp.add(licenseDetails);
                        continue;
                    }
                    UiLicenseDetails newLicenseDetails = this.createLicenseDetails(uiLicense, deliveryLocation, platform, device);
                    LicenseDetailsUtils.copy(defaultLicenseDetails, newLicenseDetails);
                    licenseDetailsListTemp.add(newLicenseDetails);
                }
            }
        }
        uiLicense.getLicenseDetailsList().clear();
        uiLicense.getLicenseDetailsList().addAll(licenseDetailsListTemp);
    }

    private void createMissingUserDefinedFieldValues(UiLicense license, UiLicenseDetails licenseDetails) {
        for (UiUserDefinedField field : license.getUserDefinedFields()) {
            UiUserDefinedFieldValue uiUserDefinedFieldValue;
            if (field.getScreenName().equals("LICENSE") || (uiUserDefinedFieldValue = this.findUserDefinedFieldValue(licenseDetails, field.getIdUserDefinedField())) != null) continue;
            uiUserDefinedFieldValue = new UiUserDefinedFieldValue();
            uiUserDefinedFieldValue.setIdUserDefinedField(field.getIdUserDefinedField());
            uiUserDefinedFieldValue.setValue(field.getDefaultValue());
            licenseDetails.getUserDefinedFieldValues().add(uiUserDefinedFieldValue);
        }
    }

    private UiUserDefinedFieldValue findUserDefinedFieldValue(UiLicenseDetails licenseDetails, Long idUserDefinedField) {
        UiUserDefinedFieldValue uiUserDefinedFieldValue = null;
        for (UiUserDefinedFieldValue fieldValue : licenseDetails.getUserDefinedFieldValues()) {
            if (!fieldValue.getIdUserDefinedField().equals(idUserDefinedField)) continue;
            uiUserDefinedFieldValue = fieldValue;
            break;
        }
        return uiUserDefinedFieldValue;
    }

    private UiLicenseDetails findLicenseDetails(List<UiLicenseDetails> licenseDetailsList, UiDeliveryLocation deliveryLocation) {
        UiLicenseDetails licenseDetails = null;
        for (UiLicenseDetails ld : licenseDetailsList) {
            if (ld.getDeliveryLocation() == null || deliveryLocation == null || !ld.getDeliveryLocation().getName().equals(deliveryLocation.getName()) || ld.getPlatform() != null || ld.getDevice() != null) continue;
            licenseDetails = ld;
            break;
        }
        return licenseDetails;
    }

    private UiLicenseDetails findLicenseDetails(List<UiLicenseDetails> licenseDetailsList, UiDeliveryLocation deliveryLocation, UiPlatform platform) {
        UiLicenseDetails licenseDetails = null;
        for (UiLicenseDetails ld : licenseDetailsList) {
            if (ld.getDeliveryLocation() == null || ld.getPlatform() == null || !ld.getDeliveryLocation().getName().equals(deliveryLocation.getName()) || !ld.getPlatform().getKey().equals(platform.getKey()) || ld.getDevice() != null) continue;
            licenseDetails = ld;
            break;
        }
        return licenseDetails;
    }

    private UiLicenseDetails findLicenseDetails(List<UiLicenseDetails> licenseDetailsList, UiDeliveryLocation deliveryLocation, UiDevice device) {
        UiLicenseDetails licenseDetails = null;
        for (UiLicenseDetails ld : licenseDetailsList) {
            if (ld.getDeliveryLocation() == null || ld.getPlatform() == null || ld.getDevice() == null || !ld.getDeliveryLocation().getName().equals(deliveryLocation.getName()) || !ld.getPlatform().getKey().equals(device.getPlatform().getKey()) || !ld.getDevice().getKey().equals(device.getKey())) continue;
            licenseDetails = ld;
            break;
        }
        return licenseDetails;
    }

    private void createLicenseDetailsList() {
        UiLicense uiLicense = this.record.getLicense();
        uiLicense.getLicenseDetailsList().clear();
        UiLicenseDetails defaultLicenseDetails = new UiLicenseDetails(uiLicense);
        uiLicense.getLicenseDetailsList().add(defaultLicenseDetails);
        for (UiDeliveryLocation deliveryLocation : this.record.getLicense().getDeliveryLocations()) {
            UiLicenseDetails licenseDetails = this.createLicenseDetails(uiLicense, deliveryLocation, null, null);
            uiLicense.getLicenseDetailsList().add(licenseDetails);
            for (UiPlatform platform : this.record.getLicense().getPlatforms()) {
                platform.setDeliveryLocation(deliveryLocation);
                licenseDetails = this.createLicenseDetails(uiLicense, deliveryLocation, platform, null);
                uiLicense.getLicenseDetailsList().add(licenseDetails);
                for (UiDevice device : this.record.getLicense().getDevices()) {
                    if (!device.getPlatform().getKey().equals(platform.getKey())) continue;
                    licenseDetails = this.createLicenseDetails(uiLicense, deliveryLocation, platform, device);
                    uiLicense.getLicenseDetailsList().add(licenseDetails);
                }
            }
        }
    }

    private UiLicenseDetails createLicenseDetails(UiLicense license, UiDeliveryLocation deliveryLocation, UiPlatform platform, UiDevice device) {
        UiLicenseDetails licenseDetails = new UiLicenseDetails(license);
        licenseDetails.setDevice(device);
        licenseDetails.setPlatform(platform);
        licenseDetails.setDeliveryLocation(deliveryLocation);
        return licenseDetails;
    }

    private boolean validateTabs() {
        this.errorPanel.reset();
        boolean valid = true;
        boolean addErrorHeader = false;
        for (AbstractLicenseTab tab : this.tabs) {
            try {
                tab.validate();
                tab.commit();
            }
            catch (ValidationException validationException) {
                valid = false;
                if (!addErrorHeader) {
                    addErrorHeader = true;
                    this.errorPanel.addHeading1(this.messages.tabsValidationError());
                }
                this.errorPanel.addHeading2(tab.getDisplayName());
            }
        }
        return valid;
    }

    private void initTabs() {
        this.tabContainer = new TabContainer();
        this.tabContainer.addSelectionHandler((SelectionHandler)new SelectionHandler<Integer>(){

            public void onSelection(SelectionEvent<Integer> event) {
                int i = 0;
                while (i < LicenseDetailView.this.tabs.size()) {
                    ((AbstractLicenseTab)LicenseDetailView.this.tabs.get(i)).setSelected(i == (Integer)event.getSelectedItem());
                    ++i;
                }
            }
        });
        this.tabContainer.addStyleName(STYLE_TABCONTAINER);
        this.tabs.clear();
        this.addTabs();
        this.contentContainer.add((Widget)this.tabContainer);
    }

    private void addTabs() {
        StorageMetadataTab storageMetadataTab = new StorageMetadataTab(this.record.getLicense(), this);
        this.tabs.add(storageMetadataTab);
        this.tabContainer.add((Widget)storageMetadataTab, storageMetadataTab.getDisplayName());
        PricingTab pricingTab = new PricingTab(this.record.getLicense(), this);
        this.tabs.add(pricingTab);
        this.tabContainer.add((Widget)pricingTab, pricingTab.getDisplayName());
        DistributionTab distributionTab = new DistributionTab(this.record.getLicense(), this);
        this.tabs.add(distributionTab);
        this.tabContainer.add((Widget)distributionTab, distributionTab.getDisplayName());
        AssetEnhancementTab assetEnhancementTab = new AssetEnhancementTab(this.record.getLicense(), this);
        this.tabs.add(assetEnhancementTab);
        this.tabContainer.add((Widget)assetEnhancementTab, assetEnhancementTab.getDisplayName());
        this.tabContainer.selectTab(0);
    }

    public void commit() {
        this.licenseMainForm.commit();
    }

    public UiLicenseRecord getRecord() {
        return this.record;
    }

    public void revert() {
    }

    public String getStyleName() {
        return null;
    }

    public Widget getWidget() {
        return this;
    }

    public void release() {
    }

    public void saveFailed(Throwable throwable) {
        if (throwable instanceof ValidationException) {
            ValidationException ve = (ValidationException)throwable;
            for (String message : ve.getValidationMessages()) {
                this.parentPanel.getErrorPanel().addMessage(message);
            }
        } else {
            this.parentPanel.getErrorPanel().showMessage(throwable.getLocalizedMessage());
        }
    }

    protected void onUnload() {
        super.onUnload();
    }

    public ErrorPanel getErrorPanel() {
        return this.errorPanel;
    }

    static /* synthetic */ IContractManagerServiceAsync access$8(LicenseDetailView licenseDetailView) {
        return licenseDetailView.contractManagerService;
    }

    static /* synthetic */ LicenseMainForm access$9(LicenseDetailView licenseDetailView) {
        return licenseDetailView.licenseMainForm;
    }

    static /* synthetic */ void access$10(LicenseDetailView licenseDetailView) {
        licenseDetailView.buildLicenseDetailsList();
    }

    static /* synthetic */ void access$11(LicenseDetailView licenseDetailView) {
        licenseDetailView.createLicenceTabs();
    }
}

