/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.license;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.tab.ErrorPanel;
import com.ericsson.cms.contractmgmt.client.tab.SuccessPanel;
import com.ericsson.cms.contractmgmt.client.tab.license.LicenseAnchorChangeListener;
import com.ericsson.cms.contractmgmt.client.tab.license.LicenseDataProvider;
import com.ericsson.cms.contractmgmt.client.tab.license.LicenseDetailFeature;
import com.ericsson.cms.contractmgmt.client.tab.license.UiLicenseRecord;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableDetailViewEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableViewChangeHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableViewEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.BookmarkFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.BookmarkFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.PageFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class LicenseListPanel
extends Composite {
    private LicenseDataProvider dataProvider;
    private PageFeature pageFeature;
    private SortFeatureImpl<Long, UiLicenseRecord> sortFeature;
    private LicenseDetailFeature detailFeature;
    private BookmarkFeature bookmarkFeature;
    private WidgetMenuItem.AnchorChangeListener anchorChangeListener;
    private VerticalContainer mainContainer;
    private Table<Long, UiLicenseRecord> table;
    private BusyIndicator busyIndicator = new BusyIndicator();
    private HeaderPanel header;
    private final SuccessPanel successPanel = new SuccessPanel();
    private final ErrorPanel errorPanel = new ErrorPanel();
    private ContractComponentConstants constants = (ContractComponentConstants)GWT.create(ContractComponentConstants.class);
    private static final int SPACING = 2;
    private static final String STYLE_NAME = "content-ContractPanel";
    private String IMAGE_URL = "cms_contractmgmt_ui/images/ico_contracts.png";
    private String STYLE_HEADER_IMAGE = "nwt-HeaderPanel-image";

    public LicenseListPanel() {
        this.dataProvider = new LicenseDataProvider(this);
        this.dataProvider.setBusyNotifier(new LicenseDataProvider.IBusyNotifier(){

            @Override
            public void startingToBeBusy() {
                LicenseListPanel.this.busyIndicator.center();
            }

            @Override
            public void doneBeingBusy() {
                LicenseListPanel.this.busyIndicator.hide();
            }
        });
        this.init();
    }

    public SuccessPanel getSuccessPanel() {
        return this.successPanel;
    }

    public ErrorPanel getErrorPanel() {
        return this.errorPanel;
    }

    private void init() {
        this.initWidgets();
        this.setContainers();
    }

    private void setContainers() {
        this.mainContainer.add((Widget)this.header);
        this.mainContainer.add((Widget)this.successPanel);
        this.mainContainer.add((Widget)this.errorPanel);
        this.mainContainer.add(this.table);
    }

    private void initWidgets() {
        this.mainContainer = new VerticalContainer();
        this.mainContainer.setSpacing(2);
        this.mainContainer.setStylePrimaryName(STYLE_NAME);
        this.initWidget((Widget)this.mainContainer);
        this.header = new HeaderPanel("");
        final Image image = new Image(this.IMAGE_URL);
        image.setStyleName(this.STYLE_HEADER_IMAGE);
        this.table = new Table((DataProvider)this.dataProvider);
        this.table.addTableViewChangeHandler((TableViewChangeHandler)new TableViewChangeHandler<Long, UiLicenseRecord>(){

            public void onShowDetailView(TableDetailViewEvent<Long, UiLicenseRecord> event) {
                if (event.isCreateView()) {
                    LicenseListPanel.this.header.setLabel(LicenseListPanel.this.constants.licenseCreateHeading());
                } else {
                    LicenseListPanel.this.header.setLabel(String.valueOf(LicenseListPanel.this.constants.licenseViewEditHeading()) + " " + ((UiLicenseRecord)event.getRecord()).getLicense().getName());
                }
                LicenseListPanel.this.header.setImage(image);
            }

            public void onShowListView(TableViewEvent event) {
                LicenseListPanel.this.header.setLabel(LicenseListPanel.this.constants.licenseListHeading());
                LicenseListPanel.this.header.setImage(image);
            }
        });
        this.pageFeature = new PageFeatureImpl();
        this.dataProvider.setParentPageFeature(this.pageFeature);
        this.sortFeature = new SortFeatureImpl(this.dataProvider.getDefaultSortColumn(), SortOrder.ASCENDING);
        for (Column<?, UiLicenseRecord> col : this.dataProvider.getSortColumns()) {
            this.sortFeature.addSortableColumn(col);
        }
        this.dataProvider.setParentSortFeature(this.sortFeature);
        this.detailFeature = new LicenseDetailFeature(this);
        this.bookmarkFeature = new BookmarkFeatureImpl();
        this.table.addSortFeature(this.sortFeature);
        this.table.addPageFeature(this.pageFeature);
        this.table.addDetailFeature((DetailFeature)this.detailFeature);
        this.table.addBookmarkFeature(this.bookmarkFeature);
        this.table.initialize((AsyncCallback)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
            }

            public void onNeptuneSuccess(Void result) {
            }
        });
        this.anchorChangeListener = new LicenseAnchorChangeListener(this);
    }

    public Table<Long, UiLicenseRecord> getLicenseTable() {
        return this.table;
    }

    public WidgetMenuItem.AnchorChangeListener getAnchorChangeListener() {
        return this.anchorChangeListener;
    }

    public void setReverseAnchorChangeListener(WidgetMenuItem.AnchorChangeListener reverseAnchorChangeListener) {
        this.table.setAnchorChangeNotifier(reverseAnchorChangeListener);
    }

    public void clearMessages() {
        this.successPanel.reset();
        this.errorPanel.reset();
    }

    public void showBusyIndicator() {
        this.busyIndicator.center();
    }

    public void hideBusyIndicator() {
        this.busyIndicator.hide();
    }
}

