/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.license;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.ContractComponentMessages;
import com.ericsson.cms.contractmgmt.client.customfield.CustomFieldFactory;
import com.ericsson.cms.contractmgmt.client.customfield.CustomFieldValidator;
import com.ericsson.cms.contractmgmt.client.customfield.UiUserDefinedField;
import com.ericsson.cms.contractmgmt.client.customfield.UiUserDefinedFieldValue;
import com.ericsson.cms.contractmgmt.client.document.DocumentComponentFactory;
import com.ericsson.cms.contractmgmt.client.model.UiContentProvider;
import com.ericsson.cms.contractmgmt.client.model.UiContract;
import com.ericsson.cms.contractmgmt.client.model.UiCopyrightHolder;
import com.ericsson.cms.contractmgmt.client.model.UiDeal;
import com.ericsson.cms.contractmgmt.client.model.UiDeliveryLocation;
import com.ericsson.cms.contractmgmt.client.model.UiDevice;
import com.ericsson.cms.contractmgmt.client.model.UiDocument;
import com.ericsson.cms.contractmgmt.client.model.UiDocumentType;
import com.ericsson.cms.contractmgmt.client.model.UiKeyName;
import com.ericsson.cms.contractmgmt.client.model.UiKeyNames;
import com.ericsson.cms.contractmgmt.client.model.UiLicense;
import com.ericsson.cms.contractmgmt.client.model.UiPlatform;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownServiceAsync;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerServiceAsync;
import com.ericsson.cms.contractmgmt.client.tab.ContractFormContainer;
import com.ericsson.cms.contractmgmt.client.tab.ErrorPanel;
import com.ericsson.cms.contractmgmt.client.tab.config.configurablefield.ConfigurableFieldTypeEnum;
import com.ericsson.cms.contractmgmt.client.tab.license.AssetsTable;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.RoundedDisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.DataTypeWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedDateBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedTextAreaWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedTextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.DateConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IDateConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IValueConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IntegerConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.StringConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LicenseMainForm
extends ContractFormContainer {
    private static final int VISIBLE_LENGTH = 10;
    private static final String CONTENT_LISTBOX_WIDTH = "300px";
    private static final int NOTES_VISIBLE_COUNT = 5;
    private static final int NAME_MAX_LENGHT = 50;
    private static final int NOTES_CHAR_WIDTH = 30;
    private static final int EXTERNAL_ID_MAX_LENGTH = 100;
    private static final String DATE_BOX_WIDTH = "90px";
    private final ContractComponentConstants constants = (ContractComponentConstants)GWT.create(ContractComponentConstants.class);
    private final ContractComponentMessages messages = (ContractComponentMessages)GWT.create(ContractComponentMessages.class);
    private final IContractManagerServiceAsync contractManagerService = (IContractManagerServiceAsync)GWT.create(IContractManagerService.class);
    private final IContractManagerDropDownServiceAsync contractManagerDropDownService = (IContractManagerDropDownServiceAsync)GWT.create(IContractManagerDropDownService.class);
    private final Map<DataTypeWidget<?>, UiUserDefinedField> widgetCustomFieldMap = new HashMap();
    private TypedListBoxWidget<Long> copyrightHolderListBox;
    private TypedListBoxWidget<Long> contractListBox;
    private TypedListBoxWidget<Long> dealListBox;
    private TypedListBoxWidget<Long> typeListBox;
    private TypedListBoxWidget<String> contentProviderListBox;
    private final TypedTextBoxWidget<String> externalIdTextBox = new TypedTextBoxWidget((IValueConverter)new StringConverter());
    private final TypedTextBoxWidget<String> nameTextBox = new TypedTextBoxWidget((IValueConverter)new StringConverter());
    private final CheckBoxWidget activeCheckBox = new CheckBoxWidget();
    private final TypedDateBoxWidget creationDate = new TypedDateBoxWidget((IDateConverter)new DateConverter(this.constants.dateFormat(), this.constants.dateFormat()));
    private final TypedDateBoxWidget expiryDate = new TypedDateBoxWidget((IDateConverter)new DateConverter(this.constants.dateFormat(), this.constants.dateFormat()));
    private final TypedDateBoxWidget effectiveDate = new TypedDateBoxWidget((IDateConverter)new DateConverter(this.constants.dateFormat(), this.constants.dateFormat()));
    private final TypedTextAreaWidget<String> notesTextArea = new TypedTextAreaWidget((IValueConverter)new StringConverter());
    private ListBoxWidget<UiDeliveryLocation> locationListBox;
    private ListBoxWidget<UiPlatform> platformListBox;
    private ListBoxWidget<UiDevice> deviceListBox;
    private DocumentComponentFactory documentComponent;
    private List<UiDocument> documentsList = new ArrayList<UiDocument>();
    private final UiLicense uiLicense;
    private UiDeal uiDeal;
    private final ErrorPanel errorPanel;
    private final BusyIndicator busyIndicator = new BusyIndicator();
    private boolean copyrightHoldersLoaded = false;
    private boolean contractsLoaded = false;
    private boolean dealsLoaded = false;
    private boolean contentProvidersLoaded = false;
    private boolean locationsLoaded = false;
    private boolean platformsLoaded = false;
    private boolean devicesLoaded = false;
    private boolean typesLoaded = false;
    private boolean fieldsLoaded = false;
    private RoundedDisclosureContainer documentsContainer;
    private AssetsTable assetsTable;
    private final VerticalContainer bottomContainer;

    public LicenseMainForm(UiLicense uiLicense, ErrorPanel errorPanel, HasHorizontalAlignment.HorizontalAlignmentConstant buttonPanelHAlign, VerticalContainer bottomContainer) {
        super(buttonPanelHAlign);
        this.uiLicense = uiLicense;
        this.errorPanel = errorPanel;
        this.bottomContainer = bottomContainer;
        this.init();
    }

    public void validateWithMessages() throws ValidationException {
        ArrayList<String> validationMessages = new ArrayList<String>();
        if (super.validate() && this.uiDeal != null) {
            DateTimeFormat dateFormatter = DateTimeFormat.getFormat((String)this.constants.dateFormat());
            Date creationDateNoTime = dateFormatter.parse(this.creationDate.getTextValue());
            Date effectiveDateNoTime = dateFormatter.parse(this.effectiveDate.getTextValue());
            Date expiryDateNoTime = dateFormatter.parse(this.expiryDate.getTextValue());
            Date dealCreationDateNoTime = dateFormatter.parse(this.uiDeal.getCreationDate());
            Date dealEffectiveDateNoTime = dateFormatter.parse(this.uiDeal.getEffectiveDate());
            Date dealExpiryDateNoTime = dateFormatter.parse(this.uiDeal.getExpiryDate());
            if (this.notesTextArea.getText().length() > 250) {
                validationMessages.add(this.messages.maxFieldLength(this.constants.licenseNotesColumn(), 250));
            }
            if (creationDateNoTime.after(effectiveDateNoTime)) {
                validationMessages.add(this.messages.dateNotAfterError(this.constants.licenseCreationDateColumn(), this.constants.licenseEffectiveDateColumn(), dateFormatter.format(effectiveDateNoTime)));
            }
            if (creationDateNoTime.before(dealCreationDateNoTime)) {
                validationMessages.add(this.messages.dateNotBeforeError(this.constants.licenseCreationDateColumn(), String.valueOf(this.constants.licenseDealColumn()) + " " + this.constants.licenseCreationDateColumn(), dateFormatter.format(dealCreationDateNoTime)));
            }
            if (effectiveDateNoTime.before(dealEffectiveDateNoTime)) {
                validationMessages.add(this.messages.dateNotBeforeError(this.constants.licenseEffectiveDateColumn(), String.valueOf(this.constants.licenseDealColumn()) + " " + this.constants.licenseEffectiveDateColumn(), dateFormatter.format(dealEffectiveDateNoTime)));
            }
            if (!effectiveDateNoTime.before(dealExpiryDateNoTime)) {
                validationMessages.add(this.messages.dateBeforeError(this.constants.licenseEffectiveDateColumn(), String.valueOf(this.constants.licenseDealColumn()) + " " + this.constants.licenseExpiryDateColumn(), dateFormatter.format(dealExpiryDateNoTime)));
            }
            if (!expiryDateNoTime.after(effectiveDateNoTime)) {
                validationMessages.add(this.messages.dateAfterError(this.constants.licenseExpiryDateColumn(), this.constants.licenseEffectiveDateColumn(), dateFormatter.format(effectiveDateNoTime)));
            }
            if (!expiryDateNoTime.after(dealEffectiveDateNoTime)) {
                validationMessages.add(this.messages.dateAfterError(this.constants.licenseExpiryDateColumn(), String.valueOf(this.constants.licenseDealColumn()) + " " + this.constants.licenseEffectiveDateColumn(), dateFormatter.format(dealEffectiveDateNoTime)));
            }
            if (expiryDateNoTime.after(dealExpiryDateNoTime)) {
                validationMessages.add(this.messages.dateNotAfterError(this.constants.licenseExpiryDateColumn(), String.valueOf(this.constants.licenseDealColumn()) + " " + this.constants.licenseExpiryDateColumn(), dateFormatter.format(dealExpiryDateNoTime)));
            }
            this.validateCustomFields(validationMessages);
        } else {
            validationMessages.add(this.messages.formHasValidationErrors());
        }
        boolean locationSelected = false;
        int x = 0;
        while (x < this.locationListBox.getItemCount()) {
            if (this.locationListBox.isItemSelected(x)) {
                locationSelected = true;
                break;
            }
            ++x;
        }
        if (!locationSelected) {
            validationMessages.add(this.messages.deliveryLocationNotSelected());
        }
        if (!validationMessages.isEmpty()) {
            throw new ValidationException(validationMessages);
        }
    }

    private void init() {
        this.busyIndicator.center();
        UiDeal deal = this.uiLicense.getDeal();
        UiContract contract = deal.getContract();
        UiCopyrightHolder copyrightHolder = contract.getCopyrightHolder();
        this.documentComponent = new DocumentComponentFactory(this.uiLicense.getKey(), this.constants.licenseDocuments(), UiDocumentType.LICENSE, this.errorPanel);
        this.documentsContainer = this.documentComponent.getDocumentPanel();
        if (!this.isEditing()) {
            this.copyrightHolderListBox = new TypedListBoxWidget((IValueConverter)new IntegerConverter());
            this.copyrightHolderListBox.ensureDebugId("license-copyrightHolder");
            this.copyrightHolderListBox.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Long>(){

                public void onValueChange(ValueChangeEvent<Long> event) {
                    LicenseMainForm.this.contractsLoaded = false;
                    LicenseMainForm.this.busyIndicator.center();
                    LicenseMainForm.this.loadContractListBox((TypedListBoxWidget<Long>)LicenseMainForm.this.contractListBox, (Long)LicenseMainForm.this.copyrightHolderListBox.getSelectedItem(), null);
                    LicenseMainForm.this.dealListBox.clear();
                }
            });
            this.loadCopyrightHolderListBox(this.copyrightHolderListBox, copyrightHolder.getKey());
            this.addRow(this.constants.licenseCopyrightHolderColumn(), (Widget)this.copyrightHolderListBox, true);
            this.contractListBox = new TypedListBoxWidget((IValueConverter)new IntegerConverter());
            this.contractListBox.ensureDebugId("license-contract");
            this.contractListBox.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Long>(){

                public void onValueChange(ValueChangeEvent<Long> event) {
                    LicenseMainForm.this.dealsLoaded = false;
                    LicenseMainForm.this.busyIndicator.center();
                    LicenseMainForm.this.loadDealListBox((TypedListBoxWidget<Long>)LicenseMainForm.this.dealListBox, (Long)LicenseMainForm.this.contractListBox.getSelectedItem(), null);
                }
            });
            this.loadContractListBox(this.contractListBox, copyrightHolder.getKey(), contract.getKey());
            this.addRow(this.constants.licenseContractColumn(), (Widget)this.contractListBox, true);
            this.dealListBox = new TypedListBoxWidget((IValueConverter)new IntegerConverter());
            this.dealListBox.ensureDebugId("license-deal");
            this.dealListBox.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Long>(){

                public void onValueChange(ValueChangeEvent<Long> event) {
                    if (LicenseMainForm.this.uiLicense.getKey() == null && event.getValue() != null) {
                        LicenseMainForm.this.busyIndicator.center();
                        LicenseMainForm.this.contractManagerService.getDeal((Long)event.getValue(), (AsyncCallback<UiDeal>)new NeptuneAsyncCallback<UiDeal>(){

                            public void onNeptuneFailure(Throwable caught) {
                                LicenseMainForm.this.busyIndicator.hide();
                            }

                            public void onNeptuneSuccess(UiDeal result) {
                                LicenseMainForm.this.uiLicense.setDeal(result);
                                LicenseMainForm.this.busyIndicator.hide();
                            }
                        });
                    }
                }
            });
            this.loadDealListBox(this.dealListBox, contract.getKey(), deal.getKey());
            this.addRow(this.constants.licenseDealColumn(), (Widget)this.dealListBox, true);
        } else {
            TextBoxWidget copyrightHolderTextBox = new TextBoxWidget(copyrightHolder.getName());
            TextBoxWidget contractTextBox = new TextBoxWidget(contract.getName());
            TextBoxWidget dealTextBox = new TextBoxWidget(deal.getName());
            copyrightHolderTextBox.setEnabled(false);
            contractTextBox.setEnabled(false);
            dealTextBox.setEnabled(false);
            this.addRow(this.constants.licenseCopyrightHolderColumn(), (Widget)copyrightHolderTextBox);
            this.addRow(this.constants.licenseContractColumn(), (Widget)contractTextBox);
            this.addRow(this.constants.licenseDealColumn(), (Widget)dealTextBox);
            this.copyrightHoldersLoaded = true;
            this.contractsLoaded = true;
            this.dealsLoaded = true;
            this.documentsList = this.uiLicense.getDocumentsList();
            this.documentComponent.setDocumentsList(this.documentsList);
        }
        this.externalIdTextBox.setValue((Object)this.uiLicense.getExternalId());
        this.externalIdTextBox.setMaxLength(100);
        this.addRow(this.constants.externalID(), (Widget)this.externalIdTextBox);
        this.nameTextBox.setText(this.uiLicense.getName());
        this.nameTextBox.setMaxLength(50);
        this.nameTextBox.ensureDebugId("license-name");
        this.addRow(this.constants.licenseNameColumn(), (Widget)this.nameTextBox, true);
        this.activeCheckBox.setValue(Boolean.valueOf(this.uiLicense.isActive()));
        this.activeCheckBox.ensureDebugId("license-active");
        this.addRow(this.constants.licenseActiveColumn(), (Widget)this.activeCheckBox, true);
        this.typeListBox = new TypedListBoxWidget((IValueConverter)new IntegerConverter());
        this.typeListBox.ensureDebugId("license-type");
        this.loadTypeListBox(this.typeListBox, this.uiLicense.getType().getKey());
        this.addRow(this.constants.licenseTypeColumn(), (Widget)this.typeListBox, true);
        this.configureDateBoxWidget(this.creationDate, this.uiLicense.getCreationDate());
        this.creationDate.ensureDebugId("license-creationDate");
        this.addRow(this.constants.licenseCreationDateColumn(), (Widget)this.creationDate, true);
        this.configureDateBoxWidget(this.effectiveDate, this.uiLicense.getEffectiveDate());
        this.effectiveDate.ensureDebugId("license-effectiveDate");
        this.addRow(this.constants.licenseEffectiveDateColumn(), (Widget)this.effectiveDate, true);
        this.configureDateBoxWidget(this.expiryDate, this.uiLicense.getExpiryDate());
        this.expiryDate.ensureDebugId("license-expiryDate");
        this.addRow(this.constants.licenseExpiryDateColumn(), (Widget)this.expiryDate, true);
        this.notesTextArea.setCharacterWidth(30);
        this.notesTextArea.setVisibleLines(5);
        this.notesTextArea.setValue((Object)this.uiLicense.getNotes());
        this.addRow(this.constants.licenseNotesColumn(), (Widget)this.notesTextArea, false);
        this.contentProviderListBox = new TypedListBoxWidget((IValueConverter)new StringConverter());
        this.loadContentProviderListBox(this.contentProviderListBox, this.uiLicense.getContentProvider().getProviderId());
        this.addRow(this.constants.licenseContentProvider(), (Widget)this.contentProviderListBox, false);
        if (this.isEditing()) {
            this.contentProviderListBox.setEnabled(false);
        }
        this.locationListBox = new ListBoxWidget(true);
        this.locationListBox.setWidth(CONTENT_LISTBOX_WIDTH);
        this.locationListBox.ensureDebugId("license-site");
        this.loadLocationListBox(this.locationListBox, this.uiLicense.getDeliveryLocations());
        this.addRow(this.constants.licenseLocation(), (Widget)this.locationListBox, true);
        this.platformListBox = new ListBoxWidget(true);
        this.platformListBox.setWidth(CONTENT_LISTBOX_WIDTH);
        this.platformListBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                ArrayList<UiPlatform> selectedPlatforms = new ArrayList<UiPlatform>();
                int x = 0;
                while (x < LicenseMainForm.this.platformListBox.getItemCount()) {
                    if (LicenseMainForm.this.platformListBox.isItemSelected(x)) {
                        selectedPlatforms.add((UiPlatform)LicenseMainForm.this.platformListBox.getItem(x));
                    }
                    ++x;
                }
                LicenseMainForm.this.devicesLoaded = false;
                LicenseMainForm.this.busyIndicator.center();
                ArrayList<UiDevice> selectedDevices = new ArrayList<UiDevice>();
                int x2 = 0;
                while (x2 < LicenseMainForm.this.deviceListBox.getItemCount()) {
                    if (LicenseMainForm.this.deviceListBox.isItemSelected(x2)) {
                        selectedDevices.add((UiDevice)LicenseMainForm.this.deviceListBox.getItem(x2));
                    }
                    ++x2;
                }
                LicenseMainForm.this.loadDeviceListBox((ListBoxWidget<UiDevice>)LicenseMainForm.this.deviceListBox, selectedPlatforms, selectedDevices);
            }
        });
        this.loadPlatformListBox(this.platformListBox, this.uiLicense.getPlatforms());
        this.addRow(this.constants.licensePlatform(), (Widget)this.platformListBox, false);
        this.deviceListBox = new ListBoxWidget(true);
        this.deviceListBox.setWidth(CONTENT_LISTBOX_WIDTH);
        this.loadDeviceListBox(this.deviceListBox, this.uiLicense.getPlatforms(), this.uiLicense.getDevices());
        this.addRow(this.constants.licenseDevice(), (Widget)this.deviceListBox, false);
        this.contractManagerService.getLicenseUserDefinedFields((AsyncCallback<List<UiUserDefinedField>>)new NeptuneAsyncCallback<List<UiUserDefinedField>>(){

            public void onNeptuneFailure(Throwable caught) {
                LicenseMainForm.this.errorPanel.showMessage(caught.getLocalizedMessage());
                LicenseMainForm.this.fieldsLoaded = true;
                LicenseMainForm.this.stopBusyIndicator();
            }

            public void onNeptuneSuccess(List<UiUserDefinedField> result) {
                LicenseMainForm.this.uiLicense.getUserDefinedFields().clear();
                LicenseMainForm.this.uiLicense.getUserDefinedFields().addAll(result);
                CustomFieldFactory factory = new CustomFieldFactory(null);
                ContractFormContainer userDefinedFieldsForm = new ContractFormContainer(HasHorizontalAlignment.ALIGN_LEFT);
                factory.addFieldsToForm(userDefinedFieldsForm, LicenseMainForm.this.uiLicense.getUserDefinedFields("LICENSE"), LicenseMainForm.this.widgetCustomFieldMap);
                RoundedDisclosureContainer userDefinedFieldsContainer = new RoundedDisclosureContainer(LicenseMainForm.this.constants.userDefinedFields());
                userDefinedFieldsContainer.add((Widget)userDefinedFieldsForm);
                userDefinedFieldsContainer.setOpen(false);
                LicenseMainForm.this.createUpdateUserDefinedFieldValues();
                LicenseMainForm.this.updateFormFromUserDefinedFieldValues(LicenseMainForm.this.uiLicense.getUserDefinedFieldsValues());
                LicenseMainForm.this.fieldsLoaded = true;
                LicenseMainForm.this.addRow("", (Widget)userDefinedFieldsContainer);
                LicenseMainForm.this.bottomContainer.add((Widget)LicenseMainForm.this.documentsContainer);
                LicenseMainForm.this.documentsList = LicenseMainForm.this.uiLicense.getDocumentsList();
                for (UiDocument doc : LicenseMainForm.this.documentsList) {
                    LicenseMainForm.this.documentComponent.addRow(doc);
                }
                Label space = new Label();
                space.setHeight("20px");
                LicenseMainForm.this.bottomContainer.add((Widget)space);
                LicenseMainForm.this.assetsTable = new AssetsTable(LicenseMainForm.this.uiLicense);
                LicenseMainForm.this.assetsTable.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_LEFT);
                HorizontalContainer assetsContainer = new HorizontalContainer();
                Label assetsLabel = new Label(LicenseMainForm.this.constants.storageAssetsInLicenseColumn());
                assetsLabel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_JUSTIFY);
                assetsContainer.add((Widget)assetsLabel);
                assetsContainer.add((Widget)LicenseMainForm.this.assetsTable);
                assetsContainer.setCellWidth((Widget)LicenseMainForm.this.assetsTable, "80%");
                LicenseMainForm.this.bottomContainer.add((Widget)assetsContainer);
                LicenseMainForm.this.stopBusyIndicator();
            }
        });
    }

    private boolean isEditing() {
        return this.uiLicense.getKey() != null;
    }

    private void createUpdateUserDefinedFieldValues() {
        for (UiUserDefinedField uiUserDefinedField : this.widgetCustomFieldMap.values()) {
            UiUserDefinedFieldValue uiUserDefinedFieldValue = this.findUiUserDefinedFieldValue(uiUserDefinedField.getIdUserDefinedField(), this.uiLicense.getUserDefinedFieldsValues());
            if (uiUserDefinedFieldValue != null) continue;
            uiUserDefinedFieldValue = new UiUserDefinedFieldValue();
            uiUserDefinedFieldValue.setIdUserDefinedField(uiUserDefinedField.getIdUserDefinedField());
            uiUserDefinedFieldValue.setValue(uiUserDefinedField.getDefaultValue());
            this.uiLicense.getUserDefinedFieldsValues().add(uiUserDefinedFieldValue);
        }
    }

    private UiUserDefinedFieldValue findUiUserDefinedFieldValue(Long idUserDefinedField, List<UiUserDefinedFieldValue> userDefinedFieldsValues) {
        UiUserDefinedFieldValue uiUserDefinedFieldValue = null;
        for (UiUserDefinedFieldValue fieldValue : userDefinedFieldsValues) {
            if (fieldValue.getIdUserDefinedField() == null || !fieldValue.getIdUserDefinedField().equals(idUserDefinedField)) continue;
            uiUserDefinedFieldValue = fieldValue;
            break;
        }
        return uiUserDefinedFieldValue;
    }

    private TypedListBoxWidget<Long> loadCopyrightHolderListBox(final TypedListBoxWidget<Long> lbCopyrightHolder, final Long selected) {
        this.contractManagerDropDownService.getCopyrightHolderKeyNameList((AsyncCallback<List<UiKeyName>>)new NeptuneAsyncCallback<List<UiKeyName>>(){

            public void onNeptuneFailure(Throwable caught) {
                LicenseMainForm.this.errorPanel.addMessage(LicenseMainForm.this.constants.failureGettingCopyrightHolders());
                LicenseMainForm.this.copyrightHoldersLoaded = true;
                LicenseMainForm.this.stopBusyIndicator();
            }

            public void onNeptuneSuccess(List<UiKeyName> result) {
                LicenseMainForm.this.fillListBox((TypedListBoxWidget<Long>)lbCopyrightHolder, selected, result);
                LicenseMainForm.this.copyrightHoldersLoaded = true;
                LicenseMainForm.this.stopBusyIndicator();
            }
        });
        return lbCopyrightHolder;
    }

    private void loadContractListBox(final TypedListBoxWidget<Long> lbContract, Long copyrightHolderKey, final Long selected) {
        lbContract.clear();
        this.contractManagerDropDownService.getContractKeyNameList(copyrightHolderKey, (AsyncCallback<List<UiKeyName>>)new NeptuneAsyncCallback<List<UiKeyName>>(){

            public void onNeptuneFailure(Throwable caught) {
                LicenseMainForm.this.errorPanel.addMessage(LicenseMainForm.this.constants.failureGettingContracts());
                LicenseMainForm.this.contractsLoaded = true;
                LicenseMainForm.this.stopBusyIndicator();
            }

            public void onNeptuneSuccess(List<UiKeyName> result) {
                LicenseMainForm.this.fillListBox((TypedListBoxWidget<Long>)lbContract, selected, result);
                LicenseMainForm.this.contractsLoaded = true;
                LicenseMainForm.this.stopBusyIndicator();
            }
        });
    }

    private void loadDealListBox(final TypedListBoxWidget<Long> lbDeal, Long contractKey, final Long selected) {
        lbDeal.clear();
        this.contractManagerDropDownService.getDealKeyNameList(contractKey, (AsyncCallback<List<UiKeyName>>)new NeptuneAsyncCallback<List<UiKeyName>>(){

            public void onNeptuneFailure(Throwable caught) {
                LicenseMainForm.this.errorPanel.addMessage(LicenseMainForm.this.constants.failureGettingDeals());
                LicenseMainForm.this.dealsLoaded = true;
                LicenseMainForm.this.stopBusyIndicator();
            }

            public void onNeptuneSuccess(List<UiKeyName> result) {
                LicenseMainForm.this.fillListBox((TypedListBoxWidget<Long>)lbDeal, selected, result);
                LicenseMainForm.this.dealsLoaded = true;
                LicenseMainForm.this.stopBusyIndicator();
            }
        });
    }

    private void loadTypeListBox(final TypedListBoxWidget<Long> lbType, final Long selected) {
        lbType.clear();
        this.contractManagerDropDownService.getGenericDropDownKeyNameList(0, 0, "", true, ConfigurableFieldTypeEnum.LicenseType, (AsyncCallback<UiKeyNames>)new NeptuneAsyncCallback<UiKeyNames>(){

            public void onNeptuneFailure(Throwable caught) {
                LicenseMainForm.this.errorPanel.addMessage(LicenseMainForm.this.constants.failureGettingTypes());
                LicenseMainForm.this.typesLoaded = true;
                LicenseMainForm.this.stopBusyIndicator();
            }

            public void onNeptuneSuccess(UiKeyNames result) {
                LicenseMainForm.this.fillListBox((TypedListBoxWidget<Long>)lbType, selected, result.getRecords());
                LicenseMainForm.this.typesLoaded = true;
                LicenseMainForm.this.stopBusyIndicator();
            }
        });
    }

    private void loadContentProviderListBox(final TypedListBoxWidget<String> lbContentProvider, final String selected) {
        lbContentProvider.clear();
        this.contractManagerDropDownService.getContentProvidersList((AsyncCallback<List<UiContentProvider>>)new NeptuneAsyncCallback<List<UiContentProvider>>(){

            public void onNeptuneFailure(Throwable caught) {
                LicenseMainForm.this.errorPanel.addMessage(LicenseMainForm.this.constants.failureGettingContentProviders());
                LicenseMainForm.this.contentProvidersLoaded = true;
                LicenseMainForm.this.stopBusyIndicator();
            }

            public void onNeptuneSuccess(List<UiContentProvider> result) {
                lbContentProvider.addItem("", null);
                Collections.sort(result);
                for (UiContentProvider contentProvider : result) {
                    lbContentProvider.addItem(contentProvider.getName(), (Object)contentProvider.getProviderId());
                }
                lbContentProvider.setSelectedItem((Object)selected);
                int x = 0;
                while (x < lbContentProvider.getItemCount()) {
                    if (selected != null && selected.equals(lbContentProvider.getItem(x))) {
                        lbContentProvider.setItemSelected(x, true);
                        break;
                    }
                    ++x;
                }
                LicenseMainForm.this.contentProvidersLoaded = true;
                LicenseMainForm.this.stopBusyIndicator();
            }
        });
    }

    private void loadLocationListBox(final ListBoxWidget<UiDeliveryLocation> lbLocation, final List<UiDeliveryLocation> selectedLocations) {
        lbLocation.clear();
        this.contractManagerDropDownService.getDeliveryLocationList((AsyncCallback<List<UiDeliveryLocation>>)new NeptuneAsyncCallback<List<UiDeliveryLocation>>(){

            public void onNeptuneFailure(Throwable caught) {
                LicenseMainForm.this.errorPanel.addMessage(LicenseMainForm.this.constants.failureGettingDeliveryLocations());
                LicenseMainForm.this.locationsLoaded = true;
                LicenseMainForm.this.stopBusyIndicator();
            }

            public void onNeptuneSuccess(List<UiDeliveryLocation> result) {
                Collections.sort(result, new Comparator<UiDeliveryLocation>(){

                    @Override
                    public int compare(UiDeliveryLocation location1, UiDeliveryLocation location2) {
                        return location1.getName().toUpperCase().compareTo(location2.getName().toUpperCase());
                    }
                });
                block0: for (UiDeliveryLocation location : result) {
                    lbLocation.addItem(location.getName(), (Object)location);
                    for (UiDeliveryLocation selectedLocation : selectedLocations) {
                        if (!selectedLocation.getName().equals(location.getName())) continue;
                        lbLocation.setItemSelected(lbLocation.getIndex((Object)location), true);
                        continue block0;
                    }
                }
                LicenseMainForm.this.locationsLoaded = true;
                LicenseMainForm.this.stopBusyIndicator();
            }
        });
    }

    private void loadPlatformListBox(final ListBoxWidget<UiPlatform> lbPlatform, final List<UiPlatform> selectedPlatforms) {
        lbPlatform.clear();
        this.contractManagerDropDownService.getPlatformList((AsyncCallback<List<UiPlatform>>)new NeptuneAsyncCallback<List<UiPlatform>>(){

            public void onNeptuneFailure(Throwable caught) {
                LicenseMainForm.this.errorPanel.addMessage(LicenseMainForm.this.constants.failureGettingPlatforms());
                LicenseMainForm.this.platformsLoaded = true;
                LicenseMainForm.this.stopBusyIndicator();
            }

            public void onNeptuneSuccess(List<UiPlatform> result) {
                Collections.sort(result, new Comparator<UiPlatform>(){

                    @Override
                    public int compare(UiPlatform platform1, UiPlatform platform2) {
                        return platform1.getName().toUpperCase().compareTo(platform2.getName().toUpperCase());
                    }
                });
                for (UiPlatform platform : result) {
                    lbPlatform.addItem(platform.getName(), (Object)platform);
                }
                block1: for (UiPlatform platform : result) {
                    for (UiPlatform selectedPlatform : selectedPlatforms) {
                        if (!selectedPlatform.getKey().equals(platform.getKey())) continue;
                        lbPlatform.setItemSelected(lbPlatform.getIndex((Object)platform), true);
                        continue block1;
                    }
                }
                LicenseMainForm.this.platformsLoaded = true;
                LicenseMainForm.this.stopBusyIndicator();
            }
        });
    }

    private void loadDeviceListBox(final ListBoxWidget<UiDevice> lbDevice, List<UiPlatform> selectedPlatforms, final List<UiDevice> selectedDevices) {
        this.contractManagerDropDownService.getDeviceList(selectedPlatforms, (AsyncCallback<List<UiDevice>>)new NeptuneAsyncCallback<List<UiDevice>>(){

            public void onNeptuneFailure(Throwable caught) {
                LicenseMainForm.this.errorPanel.addMessage(LicenseMainForm.this.constants.failureGettingDevices());
                LicenseMainForm.this.devicesLoaded = true;
                LicenseMainForm.this.stopBusyIndicator();
            }

            public void onNeptuneSuccess(List<UiDevice> result) {
                Collections.sort(result, new Comparator<UiDevice>(){

                    @Override
                    public int compare(UiDevice device1, UiDevice device2) {
                        int compareResult = device1.getPlatform().getName().toUpperCase().compareTo(device2.getPlatform().getName().toUpperCase());
                        if (compareResult == 0) {
                            compareResult = device1.getName().toUpperCase().compareTo(device2.getName().toUpperCase());
                        }
                        return compareResult;
                    }
                });
                lbDevice.clear();
                block0: for (UiDevice device : result) {
                    lbDevice.addItem(String.valueOf(device.getName()) + " (" + device.getPlatform().getName() + ")", (Object)device);
                    for (UiDevice selectedDevice : selectedDevices) {
                        if (!selectedDevice.getKey().equals(device.getKey())) continue;
                        lbDevice.setItemSelected(lbDevice.getIndex((Object)device), true);
                        continue block0;
                    }
                }
                LicenseMainForm.this.devicesLoaded = true;
                LicenseMainForm.this.stopBusyIndicator();
            }
        });
    }

    private void fillListBox(TypedListBoxWidget<Long> listBox, Long selected, List<UiKeyName> result) {
        listBox.addItem("", null);
        for (UiKeyName keyName : result) {
            listBox.addItem(keyName.getName(), (Object)keyName.getKey());
        }
        listBox.setSelectedItem((Object)selected);
    }

    private void configureDateBoxWidget(TypedDateBoxWidget dateBox, String date) {
        dateBox.setTextValue(date);
        dateBox.getTextBox().setMaxLength(10);
        dateBox.getTextBox().setVisibleLength(10);
        dateBox.setWidth(DATE_BOX_WIDTH);
        dateBox.setToolTip(String.valueOf(this.constants.validDateTitle()) + " " + this.constants.dateFormat());
        dateBox.setErrorToolTip(String.valueOf(this.constants.validDateTitle()) + " " + this.constants.dateFormat());
    }

    public void setDeal(UiDeal deal) {
        this.uiDeal = deal;
    }

    public void commit() {
        UiContentProvider uiContentProvider = new UiContentProvider((String)this.contentProviderListBox.getSelectedItem());
        uiContentProvider.setName(this.contentProviderListBox.getItemText(this.contentProviderListBox.getSelectedIndex()));
        this.uiLicense.setContentProvider(uiContentProvider);
        this.uiLicense.setAllAssets(this.assetsTable.allAssetsSelected());
        this.uiLicense.setCreationDate(this.creationDate.getTextValue());
        this.uiLicense.setEffectiveDate(this.effectiveDate.getTextValue());
        this.uiLicense.setExpiryDate(this.expiryDate.getTextValue());
        this.uiLicense.setName((String)this.nameTextBox.getValue());
        this.uiLicense.setNotes((String)this.notesTextArea.getValue());
        this.uiLicense.setType(new UiKeyName((Long)this.typeListBox.getSelectedItem()));
        this.uiLicense.setDocumentsList(this.documentsList);
        this.uiLicense.setActive(this.activeCheckBox.getValue());
        this.uiLicense.setExternalId(this.externalIdTextBox.getText() != null ? this.externalIdTextBox.getText().trim() : null);
        this.uiLicense.getDeliveryLocations().clear();
        int x = 0;
        while (x < this.locationListBox.getItemCount()) {
            UiDeliveryLocation deliveryLocation;
            if (this.locationListBox.isItemSelected(x) && (deliveryLocation = (UiDeliveryLocation)this.locationListBox.getItem(x)) != null) {
                this.uiLicense.getDeliveryLocations().add(deliveryLocation);
            }
            ++x;
        }
        this.uiLicense.getPlatforms().clear();
        x = 0;
        while (x < this.platformListBox.getItemCount()) {
            UiPlatform platform;
            if (this.platformListBox.isItemSelected(x) && (platform = (UiPlatform)this.platformListBox.getItem(x)) != null) {
                this.uiLicense.getPlatforms().add(platform);
            }
            ++x;
        }
        this.uiLicense.getDevices().clear();
        x = 0;
        while (x < this.deviceListBox.getItemCount()) {
            UiDevice device;
            if (this.deviceListBox.isItemSelected(x) && (device = (UiDevice)this.deviceListBox.getItem(x)) != null) {
                this.uiLicense.getDevices().add(device);
            }
            ++x;
        }
        this.updateUserDefinedFieldsValuesFromForm(this.uiLicense.getUserDefinedFieldsValues());
    }

    private void updateUserDefinedFieldsValuesFromForm(Collection<UiUserDefinedFieldValue> oldValuesList) {
        Set<Map.Entry<DataTypeWidget<?>, UiUserDefinedField>> entrySet = this.widgetCustomFieldMap.entrySet();
        for (Map.Entry<DataTypeWidget<?>, UiUserDefinedField> entry : entrySet) {
            DataTypeWidget<?> dataTypeWidget = entry.getKey();
            UiUserDefinedField userDefinedField = entry.getValue();
            UiUserDefinedFieldValue userDefinedFieldValue = this.getValueForFieldType(oldValuesList, userDefinedField.getIdUserDefinedField());
            if (userDefinedFieldValue == null) continue;
            userDefinedFieldValue.setValue(dataTypeWidget.getTextValue());
        }
    }

    private void updateFormFromUserDefinedFieldValues(Collection<UiUserDefinedFieldValue> newValuesList) {
        Set<Map.Entry<DataTypeWidget<?>, UiUserDefinedField>> entrySet = this.widgetCustomFieldMap.entrySet();
        for (Map.Entry<DataTypeWidget<?>, UiUserDefinedField> entry : entrySet) {
            DataTypeWidget<?> dataTypeWidget = entry.getKey();
            UiUserDefinedField userDefinedField = entry.getValue();
            UiUserDefinedFieldValue userDefinedFieldValue = this.getValueForFieldType(newValuesList, userDefinedField.getIdUserDefinedField());
            if (userDefinedFieldValue == null) continue;
            dataTypeWidget.setTextValue(userDefinedFieldValue.getValue());
        }
    }

    private UiUserDefinedFieldValue getValueForFieldType(Collection<UiUserDefinedFieldValue> newValuesList, Long idUserDefinedField) {
        UiUserDefinedFieldValue userDefinedFieldValue = null;
        for (UiUserDefinedFieldValue newUserDefinedFieldValue : newValuesList) {
            Long newIdUserDefinedField = newUserDefinedFieldValue.getIdUserDefinedField();
            if (!newIdUserDefinedField.equals(idUserDefinedField)) continue;
            userDefinedFieldValue = newUserDefinedFieldValue;
            break;
        }
        return userDefinedFieldValue;
    }

    private void stopBusyIndicator() {
        if (this.copyrightHoldersLoaded && this.contractsLoaded && this.dealsLoaded && this.contentProvidersLoaded && this.locationsLoaded && this.platformsLoaded && this.devicesLoaded && this.typesLoaded && this.fieldsLoaded) {
            this.busyIndicator.hide();
        }
    }

    private void validateCustomFields(List<String> validationMessages) {
        Set<Map.Entry<DataTypeWidget<?>, UiUserDefinedField>> entrySet = this.widgetCustomFieldMap.entrySet();
        for (Map.Entry<DataTypeWidget<?>, UiUserDefinedField> entry : entrySet) {
            DataTypeWidget<?> dataTypeWidget = entry.getKey();
            UiUserDefinedField field = entry.getValue();
            CustomFieldValidator.validate(dataTypeWidget, field);
            if (dataTypeWidget.isValidValue() && !dataTypeWidget.hasValidationError()) continue;
            String tooltip = dataTypeWidget.getToolTip();
            if (tooltip == null) {
                tooltip = "";
            }
            validationMessages.add(String.valueOf(this.messages.invalidFieldValue(field.getLabel())) + tooltip);
        }
    }
}

