/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.license.tab;

import com.ericsson.cms.contractmgmt.client.customfield.CustomFieldFactory;
import com.ericsson.cms.contractmgmt.client.customfield.UiUserDefinedField;
import com.ericsson.cms.contractmgmt.client.model.UiLicense;
import com.ericsson.cms.contractmgmt.client.model.UiLicenseDetails;
import com.ericsson.cms.contractmgmt.client.tab.ContractFormContainer;
import com.ericsson.cms.contractmgmt.client.tab.license.AbstractLicenseTab;
import com.ericsson.cms.contractmgmt.client.tab.license.LicenseDetailView;
import com.ericsson.cms.contractmgmt.client.tab.license.tab.LicenseDetailsUtils;
import com.ericsson.cms.contractmgmt.client.tab.license.tab.TabValueChangeHandler;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.RadioButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.RoundedDisclosureContainer;
import java.util.ArrayList;
import java.util.List;

public class AssetEnhancementTab
extends AbstractLicenseTab {
    private final ContractFormContainer formContainer = new ContractFormContainer(HasHorizontalAlignment.ALIGN_LEFT);
    private final ContractFormContainer formUserDefinedFields = new ContractFormContainer(HasHorizontalAlignment.ALIGN_LEFT);
    private RadioButtonWidget watermarkingRequiredYes;
    private RadioButtonWidget watermarkingRequiredNo;
    private RadioButtonWidget fingerprintingRequiredYes;
    private RadioButtonWidget fingerprintingRequiredNo;
    private RadioButtonWidget transcodingRequiredYes;
    private RadioButtonWidget transcodingRequiredNo;
    private RadioButtonWidget adRemovalAllowedYes;
    private RadioButtonWidget adRemovalAllowedNo;
    private RadioButtonWidget contentEditAllowedYes;
    private RadioButtonWidget contentEditAllowedNo;
    private RadioButtonWidget qualityCheckRequiredYes;
    private RadioButtonWidget qualityCheckRequiredNo;
    private RadioButtonWidget contentSecurityRequiredYes;
    private RadioButtonWidget contentSecurityRequiredNo;

    public AssetEnhancementTab(UiLicense license, LicenseDetailView detailView) {
        super(license, detailView);
        this.initForm();
        this.fillForm();
    }

    private void initForm() {
        this.watermarkingRequiredYes = new RadioButtonWidget("watermarking", this.constants.yes());
        this.watermarkingRequiredYes.addValueChangeHandler(new TabValueChangeHandler(this));
        this.watermarkingRequiredNo = new RadioButtonWidget("watermarking", this.constants.no());
        this.watermarkingRequiredNo.addValueChangeHandler(new TabValueChangeHandler(this));
        HorizontalContainer watermarkingRequired = this.createRadioContainer(this.watermarkingRequiredYes, this.watermarkingRequiredNo);
        this.formContainer.addRow(this.constants.assetWatermarkingColumn(), (Widget)watermarkingRequired);
        this.fingerprintingRequiredYes = new RadioButtonWidget("fingerprinting", this.constants.yes());
        this.fingerprintingRequiredYes.addValueChangeHandler(new TabValueChangeHandler(this));
        this.fingerprintingRequiredNo = new RadioButtonWidget("fingerprinting", this.constants.no());
        this.fingerprintingRequiredNo.addValueChangeHandler(new TabValueChangeHandler(this));
        HorizontalContainer fingerprintingRequired = this.createRadioContainer(this.fingerprintingRequiredYes, this.fingerprintingRequiredNo);
        this.formContainer.addRow(this.constants.assetFingerprintingColumn(), (Widget)fingerprintingRequired);
        this.transcodingRequiredYes = new RadioButtonWidget("transcoding", this.constants.yes());
        this.transcodingRequiredYes.addValueChangeHandler(new TabValueChangeHandler(this));
        this.transcodingRequiredNo = new RadioButtonWidget("transcoding", this.constants.no());
        this.transcodingRequiredNo.addValueChangeHandler(new TabValueChangeHandler(this));
        HorizontalContainer transcodingRequired = this.createRadioContainer(this.transcodingRequiredYes, this.transcodingRequiredNo);
        this.formContainer.addRow(this.constants.assetTranscodingColumn(), (Widget)transcodingRequired);
        this.adRemovalAllowedYes = new RadioButtonWidget("adRemoval", this.constants.yes());
        this.adRemovalAllowedYes.addValueChangeHandler(new TabValueChangeHandler(this));
        this.adRemovalAllowedNo = new RadioButtonWidget("adRemoval", this.constants.no());
        this.adRemovalAllowedNo.addValueChangeHandler(new TabValueChangeHandler(this));
        HorizontalContainer adRemovalAllowed = this.createRadioContainer(this.adRemovalAllowedYes, this.adRemovalAllowedNo);
        this.formContainer.addRow(this.constants.assetAdRemovalColumn(), (Widget)adRemovalAllowed);
        this.contentEditAllowedYes = new RadioButtonWidget("contentEdit", this.constants.yes());
        this.contentEditAllowedYes.addValueChangeHandler(new TabValueChangeHandler(this));
        this.contentEditAllowedNo = new RadioButtonWidget("contentEdit", this.constants.no());
        this.contentEditAllowedNo.addValueChangeHandler(new TabValueChangeHandler(this));
        HorizontalContainer contentEditAllowed = this.createRadioContainer(this.contentEditAllowedYes, this.contentEditAllowedNo);
        this.formContainer.addRow(this.constants.assetContentEditColumn(), (Widget)contentEditAllowed);
        this.qualityCheckRequiredYes = new RadioButtonWidget("qualityCheck", this.constants.yes());
        this.qualityCheckRequiredYes.addValueChangeHandler(new TabValueChangeHandler(this));
        this.qualityCheckRequiredNo = new RadioButtonWidget("qualityCheck", this.constants.no());
        this.qualityCheckRequiredNo.addValueChangeHandler(new TabValueChangeHandler(this));
        HorizontalContainer qualityCheckAllowed = this.createRadioContainer(this.qualityCheckRequiredYes, this.qualityCheckRequiredNo);
        this.formContainer.addRow(this.constants.assetQualityCheckColumn(), (Widget)qualityCheckAllowed);
        this.contentSecurityRequiredYes = new RadioButtonWidget("contentSecurity", this.constants.yes());
        this.contentSecurityRequiredYes.addValueChangeHandler(new TabValueChangeHandler(this));
        this.contentSecurityRequiredNo = new RadioButtonWidget("contentSecurity", this.constants.no());
        this.contentSecurityRequiredNo.addValueChangeHandler(new TabValueChangeHandler(this));
        HorizontalContainer contentSecurityAllowed = this.createRadioContainer(this.contentSecurityRequiredYes, this.contentSecurityRequiredNo);
        this.formContainer.addRow(this.constants.assetContentSecurityColumn(), (Widget)contentSecurityAllowed);
        this.contentPanel.add((Widget)this.formContainer);
        CustomFieldFactory factory = new CustomFieldFactory(this);
        List<UiUserDefinedField> userDefinedFields = this.getLicense().getUserDefinedFields("ASSET_ENHANCEMENT");
        factory.addFieldsToForm(this.formUserDefinedFields, userDefinedFields, this.widgetCustomFieldMap);
        RoundedDisclosureContainer userDefinedFieldsContainer = new RoundedDisclosureContainer(this.constants.userDefinedFields());
        userDefinedFieldsContainer.add((Widget)this.formUserDefinedFields);
        userDefinedFieldsContainer.setOpen(false);
        this.contentPanel.add((Widget)userDefinedFieldsContainer);
    }

    private HorizontalContainer createRadioContainer(RadioButtonWidget radio1, RadioButtonWidget radio2) {
        HorizontalContainer container = new HorizontalContainer();
        container.add((Widget)radio1);
        HorizontalPanel space = new HorizontalPanel();
        LabelWidget label = new LabelWidget();
        space.add((Widget)label);
        space.setCellWidth((Widget)label, "10");
        container.add((Widget)space);
        radio2.setValue(Boolean.valueOf(true));
        container.add((Widget)radio2);
        return container;
    }

    @Override
    public String getName() {
        return "ASSET_ENHANCEMENT";
    }

    @Override
    public String getDisplayName() {
        return this.constants.assetTabDisplayName();
    }

    @Override
    public void fillForm() {
        this.formContainer.clearAllValidationErrors();
        this.fillRadioValues(this.watermarkingRequiredYes, this.watermarkingRequiredNo, this.currentTreeObject.getAeWaterMarking());
        this.fillRadioValues(this.fingerprintingRequiredYes, this.fingerprintingRequiredNo, this.currentTreeObject.getAeFingerPrinting());
        this.fillRadioValues(this.transcodingRequiredYes, this.transcodingRequiredNo, this.currentTreeObject.getAeTranscoding());
        this.fillRadioValues(this.adRemovalAllowedYes, this.adRemovalAllowedNo, this.currentTreeObject.getAeAdRemoval());
        this.fillRadioValues(this.contentEditAllowedYes, this.contentEditAllowedNo, this.currentTreeObject.getAeContentEdit());
        this.fillRadioValues(this.qualityCheckRequiredYes, this.qualityCheckRequiredNo, this.currentTreeObject.getAeQualityCheck());
        this.fillRadioValues(this.contentSecurityRequiredYes, this.contentSecurityRequiredNo, this.currentTreeObject.getAeContentSecurity());
        this.updateFormFromUserDefinedFieldValues(this.currentTreeObject.getUserDefinedFieldValues());
    }

    private void fillRadioValues(RadioButtonWidget radio1, RadioButtonWidget radio2, Boolean value) {
        if (value != null && value.booleanValue()) {
            radio1.setValue(Boolean.valueOf(true));
            radio2.setValue(Boolean.valueOf(false));
        } else {
            radio1.setValue(Boolean.valueOf(false));
            radio2.setValue(Boolean.valueOf(true));
        }
    }

    @Override
    public void validate() throws ValidationException {
        this.formContainer.clearAllValidationErrors();
        ArrayList<String> validationMessages = new ArrayList<String>();
        if (!this.formContainer.validate()) {
            validationMessages.add(this.messages.formHasValidationErrors());
        }
        if (!this.formUserDefinedFields.validate()) {
            validationMessages.add(this.messages.formHasValidationErrors());
        }
        this.validateCustomFields(validationMessages);
        if (!validationMessages.isEmpty()) {
            throw new ValidationException(validationMessages);
        }
    }

    @Override
    public void commit() throws ValidationException {
        this.currentTreeObject.setModified(true);
        this.currentTreeObject.setAeAdRemoval(this.adRemovalAllowedYes.getValue());
        this.currentTreeObject.setAeContentEdit(this.contentEditAllowedYes.getValue());
        this.currentTreeObject.setAeContentSecurity(this.contentSecurityRequiredYes.getValue());
        this.currentTreeObject.setAeFingerPrinting(this.fingerprintingRequiredYes.getValue());
        this.currentTreeObject.setAeQualityCheck(this.qualityCheckRequiredYes.getValue());
        this.currentTreeObject.setAeTranscoding(this.transcodingRequiredYes.getValue());
        this.currentTreeObject.setAeWaterMarking(this.watermarkingRequiredYes.getValue());
        this.updateUserDefinedFieldsValuesFromForm(this.currentTreeObject.getUserDefinedFieldValues());
        this.overrideChildrenValues();
    }

    private void overrideChildrenValues() {
        if (this.currentTreeObject != null) {
            for (UiLicenseDetails licenseDetails : this.currentTreeObject.getAllChildren()) {
                licenseDetails.setModified(true);
                LicenseDetailsUtils.copyAssetEnhancementValues(this.currentTreeObject, licenseDetails);
                this.copyUserDefinedFieldValues(licenseDetails.getUserDefinedFieldValues());
            }
        }
    }
}

