/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.license.tab;

import com.ericsson.cms.contractmgmt.client.customfield.CustomFieldFactory;
import com.ericsson.cms.contractmgmt.client.customfield.UiUserDefinedField;
import com.ericsson.cms.contractmgmt.client.model.UiDistributionListValues;
import com.ericsson.cms.contractmgmt.client.model.UiDistributionManagement;
import com.ericsson.cms.contractmgmt.client.model.UiLicense;
import com.ericsson.cms.contractmgmt.client.model.UiLicenseDetails;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownServiceAsync;
import com.ericsson.cms.contractmgmt.client.tab.ContractFormContainer;
import com.ericsson.cms.contractmgmt.client.tab.license.AbstractLicenseTab;
import com.ericsson.cms.contractmgmt.client.tab.license.LicenseDetailView;
import com.ericsson.cms.contractmgmt.client.tab.license.tab.DistributionTable;
import com.ericsson.cms.contractmgmt.client.tab.license.tab.LicenseDetailsUtils;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.RoundedDisclosureContainer;
import java.util.ArrayList;
import java.util.List;

public class DistributionTab
extends AbstractLicenseTab {
    private final IContractManagerDropDownServiceAsync contractManagerDropDownService = (IContractManagerDropDownServiceAsync)GWT.create(IContractManagerDropDownService.class);
    private final ContractFormContainer formContainer = new ContractFormContainer(HasHorizontalAlignment.ALIGN_LEFT);
    private UiDistributionListValues distributionListValues;
    private HorizontalContainer distributionTableContainer;
    private DistributionTable distributionTable;

    public DistributionTab(UiLicense license, final LicenseDetailView detailView) {
        super(license, detailView);
        this.busyIndicator.center();
        this.contractManagerDropDownService.getDistributionListValues((AsyncCallback<UiDistributionListValues>)new NeptuneAsyncCallback<UiDistributionListValues>(){

            public void onNeptuneFailure(Throwable caught) {
                detailView.getErrorPanel().showMessage(caught.getLocalizedMessage());
                DistributionTab.this.busyIndicator.hide();
            }

            public void onNeptuneSuccess(UiDistributionListValues result) {
                DistributionTab.this.distributionListValues = result;
                DistributionTab.this.initForm();
                DistributionTab.this.fillForm();
                DistributionTab.this.busyIndicator.hide();
            }
        });
    }

    private void initForm() {
        LabelWidget spaceLabel = new LabelWidget();
        this.contentPanel.add((Widget)spaceLabel);
        this.contentPanel.setCellHeight((Widget)spaceLabel, "10");
        this.distributionTableContainer = new HorizontalContainer();
        this.distributionTable = this.createDistributionTable();
        this.distributionTableContainer.add((Widget)this.distributionTable);
        this.contentPanel.add((Widget)this.distributionTableContainer);
        CustomFieldFactory factory = new CustomFieldFactory(this);
        List<UiUserDefinedField> userDefinedFields = this.getLicense().getUserDefinedFields("DISTRIBUTION");
        factory.addFieldsToForm(this.formContainer, userDefinedFields, this.widgetCustomFieldMap);
        RoundedDisclosureContainer userDefinedFieldsContainer = new RoundedDisclosureContainer(this.constants.userDefinedFields());
        userDefinedFieldsContainer.add((Widget)this.formContainer);
        userDefinedFieldsContainer.setOpen(false);
        this.contentPanel.add((Widget)userDefinedFieldsContainer);
    }

    private DistributionTable createDistributionTable() {
        boolean isEditing = this.getLicense().getKey() != null;
        DistributionTable distribution = new DistributionTable(this.distributionListValues, this, isEditing);
        List<UiDistributionManagement> distributionMgmtList = this.currentTreeObject.getDistributionManagementList();
        if (distributionMgmtList != null && !distributionMgmtList.isEmpty()) {
            for (UiDistributionManagement distributionPlatform : distributionMgmtList) {
                distribution.addRow(distributionPlatform);
            }
        } else {
            distribution.addRow();
        }
        return distribution;
    }

    @Override
    public String getName() {
        return "DISTRIBUTION";
    }

    @Override
    public String getDisplayName() {
        return this.constants.distributionTabDisplayName();
    }

    @Override
    public void validate() throws ValidationException {
        this.formContainer.clearAllValidationErrors();
        this.validateUnique();
        ArrayList<String> validationMessages = new ArrayList<String>();
        if (!this.formContainer.validate()) {
            validationMessages.add(this.messages.formHasValidationErrors());
        }
        String licenseEffectiveDate = this.getLicense().getEffectiveDate();
        String licenseExpiryDate = this.getLicense().getExpiryDate();
        List<UiDistributionManagement> dmList = this.distributionTable.getDistributionManagementList();
        int x = 0;
        while (x < dmList.size()) {
            UiDistributionManagement dm = dmList.get(x);
            String deliveryDate = dm.getDeliveryDate();
            String dueDate = dm.getDueDate();
            String returnDate = dm.getReturnDate();
            if (returnDate != null) {
                if (deliveryDate == null) {
                    validationMessages.add(this.messages.deliveryDateRequired());
                } else if (deliveryDate.compareTo(returnDate) >= 0) {
                    validationMessages.add(this.messages.deliveryDateNotBeforeReturn());
                }
            }
            if (dueDate != null && deliveryDate != null && deliveryDate.compareTo(dueDate) < 0) {
                validationMessages.add(this.messages.deliveryDateBeforeDue());
            }
            this.validateDatesWithin(deliveryDate, this.constants.platformDeliveryDateColumn(), licenseEffectiveDate, licenseExpiryDate, x, validationMessages);
            this.validateDatesWithin(dueDate, this.constants.platformDueDateColumn(), licenseEffectiveDate, licenseExpiryDate, x, validationMessages);
            this.validateDatesWithin(returnDate, this.constants.platformReturnDateColumn(), licenseEffectiveDate, licenseExpiryDate, x, validationMessages);
            ++x;
        }
        this.validateCustomFields(validationMessages);
        if (!validationMessages.isEmpty()) {
            throw new ValidationException(validationMessages);
        }
    }

    private void validateDatesWithin(String date, String field, String d1, String d2, int row, List<String> validationMessages) {
        if (date != null && (date.compareTo(d1) < 0 || date.compareTo(d2) > 0)) {
            validationMessages.add(this.messages.dateNotWithinError(row + 1, field, d1, d2));
        }
    }

    private void validateUnique() throws ValidationException {
        List<UiDistributionManagement> distributionManagementList = this.distributionTable.getDistributionManagementList();
        int x = 0;
        while (x < distributionManagementList.size()) {
            UiDistributionManagement dm1 = distributionManagementList.get(x);
            Long methodKey1 = dm1.getDeliveryMethod().getKey();
            Long mediaKey1 = dm1.getMediaType().getKey();
            String formatKey1 = dm1.getMetaFormat().getName();
            int y = x + 1;
            while (y < distributionManagementList.size()) {
                UiDistributionManagement dm2 = distributionManagementList.get(y);
                Long methodKey2 = dm2.getDeliveryMethod().getKey();
                Long mediaKey2 = dm2.getMediaType().getKey();
                String formatKey2 = dm2.getMetaFormat().getName();
                if (this.compareLongs(methodKey1, methodKey2) && this.compareLongs(mediaKey1, mediaKey2) && this.compareStrings(formatKey1, formatKey2)) {
                    ArrayList<String> validationMessages = new ArrayList<String>();
                    validationMessages.add(this.messages.distributionManagementUniqueViolation());
                    throw new ValidationException(validationMessages);
                }
                ++y;
            }
            ++x;
        }
    }

    private boolean compareLongs(Long value1, Long value2) {
        boolean isEqual;
        boolean bl = isEqual = value1 == value2;
        if (!isEqual && value1 != null && value1.equals(value2)) {
            isEqual = true;
        }
        return isEqual;
    }

    private boolean compareStrings(String value1, String value2) {
        boolean isEqual;
        boolean bl = isEqual = value1 == value2;
        if (!isEqual && value1 != null && value1.equals(value2)) {
            isEqual = true;
        }
        return isEqual;
    }

    @Override
    public void fillForm() {
        this.formContainer.clearAllValidationErrors();
        this.distributionTableContainer.clear();
        this.distributionTable = this.createDistributionTable();
        this.distributionTableContainer.add((Widget)this.distributionTable);
        this.updateFormFromUserDefinedFieldValues(this.currentTreeObject.getUserDefinedFieldValues());
    }

    @Override
    public void commit() throws ValidationException {
        this.currentTreeObject.setModified(true);
        this.currentTreeObject.getDistributionManagementList().clear();
        this.currentTreeObject.getDistributionManagementList().addAll(this.distributionTable.getDistributionManagementList());
        this.updateUserDefinedFieldsValuesFromForm(this.currentTreeObject.getUserDefinedFieldValues());
        this.overrideChildrenValues();
    }

    private void overrideChildrenValues() {
        if (this.currentTreeObject != null) {
            for (UiLicenseDetails licenseDetails : this.currentTreeObject.getAllChildren()) {
                licenseDetails.setModified(true);
                LicenseDetailsUtils.copyDistributionValues(this.currentTreeObject, licenseDetails);
                this.copyUserDefinedFieldValues(licenseDetails.getUserDefinedFieldValues());
            }
        }
    }
}

