/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.license.tab;

import com.ericsson.cms.contractmgmt.client.Changeable;
import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.ContractComponentMessages;
import com.ericsson.cms.contractmgmt.client.model.UiDeliveryMethod;
import com.ericsson.cms.contractmgmt.client.model.UiDistributionListValues;
import com.ericsson.cms.contractmgmt.client.model.UiDistributionManagement;
import com.ericsson.cms.contractmgmt.client.model.UiKeyName;
import com.ericsson.cms.contractmgmt.client.model.UiMediaType;
import com.ericsson.cms.contractmgmt.client.model.UiMetaFormat;
import com.ericsson.cms.contractmgmt.client.model.UiOwnership;
import com.ericsson.cms.contractmgmt.client.tab.license.tab.TabValueChangeHandler;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedDateBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedTextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.DateConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.FloatConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IDateConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IValueConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IntegerConverter;
import java.util.ArrayList;
import java.util.List;

public class DistributionTable
extends Composite {
    private final VerticalContainer mainContainer;
    private final FlexTableContainer table;
    private String name;
    private static final String TABLE_STYLE = "contract-table";
    private static final String ROW_STYLE = "contract-table-row";
    private static final String ROW_HEADER_STYLE = "contract-table-row-header";
    private static final String ROW_BODY_STYLE = "contract-table-row-body";
    private static final String CELL_STYLE = "contract-table-cell";
    private static final String CELL_HEADER_STYLE = "contract-table-cell-header";
    private static final String CELL_BODY_STYLE = "contract-table-cell-body";
    private static final String DELETE_IMAGE = "cms_contractmgmt_ui/images/delete.png";
    private static final String DELETE_CELL_STYLE = "contract-table-cell-body-delete";
    private static final int VISIBLE_LENGTH = 10;
    private final ContractComponentConstants constants = (ContractComponentConstants)GWT.create(ContractComponentConstants.class);
    private final ContractComponentMessages messages = (ContractComponentMessages)GWT.create(ContractComponentMessages.class);
    private final UiDistributionListValues distributionPlatformListValues;
    private final Changeable changeable;
    private final boolean isEditing;

    public DistributionTable(UiDistributionListValues distributionPlatformListValues, Changeable changeable, boolean isEditing) {
        this.changeable = changeable;
        this.distributionPlatformListValues = distributionPlatformListValues;
        this.isEditing = isEditing;
        this.mainContainer = new VerticalContainer();
        this.table = new FlexTableContainer();
        this.table.addStyleName(TABLE_STYLE);
        this.table.insertRow(0);
        this.table.getRowFormatter().addStyleName(0, "table-header-row");
        this.table.getRowFormatter().addStyleName(0, ROW_HEADER_STYLE);
        this.initTable();
        this.mainContainer.add((Widget)this.table);
        if (this.changeEnabled()) {
            this.addButtons();
        }
        this.initWidget((Widget)this.mainContainer);
    }

    private boolean changeEnabled() {
        return !this.isEditing && ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Create"}) || this.isEditing && ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Modify"});
    }

    public String getName() {
        return this.name;
    }

    private void addButtons() {
        HorizontalContainer buttonsContainer = new HorizontalContainer();
        ButtonWidget addButton = new ButtonWidget(this.constants.addButtonName(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                DistributionTable.this.addRow(null);
            }
        });
        addButton.removeStyleName("gwt-Button");
        addButton.addStyleName("ebBtn");
        addButton.addStyleName("addgreen_button_icon");
        buttonsContainer.add((Widget)addButton);
        this.mainContainer.add((Widget)buttonsContainer);
    }

    private void initTable() {
        this.addHeading(this.constants.platformMediaTypeColumn());
        this.addHeading(this.constants.platformMetaFormatColumn());
        this.addHeading(this.constants.platformDeliveryMethodColumn());
        this.addHeading(this.constants.platformDueDateColumn());
        this.addHeading(this.constants.platformDeliveryDateColumn());
        this.addHeading(this.constants.platformReturnDateColumn());
        this.addHeading(this.constants.platformOwnershipColumn());
        this.addHeading(this.constants.platformCostColumn());
    }

    public void addRow() {
        this.addRow(null);
    }

    public void addRow(UiDistributionManagement distributionManagement) {
        int rowIndex = this.addRow(this.getRowCount());
        TypedListBoxWidget mediaTypeListBox = new TypedListBoxWidget((IValueConverter)new IntegerConverter());
        mediaTypeListBox.addValueChangeHandler(new TabValueChangeHandler(this.changeable));
        this.fillListBox((TypedListBoxWidget<Long>)mediaTypeListBox, null, this.distributionPlatformListValues.getMediaTypeValues(), true);
        this.addCell(rowIndex, (Widget)mediaTypeListBox);
        TypedListBoxWidget metaFormatListBox = new TypedListBoxWidget((IValueConverter)new IntegerConverter());
        metaFormatListBox.addValueChangeHandler(new TabValueChangeHandler(this.changeable));
        this.fillListBox((TypedListBoxWidget<Long>)metaFormatListBox, null, this.distributionPlatformListValues.getMetaFormatValues(), true);
        this.addCell(rowIndex, (Widget)metaFormatListBox);
        TypedListBoxWidget deliveryMethodListBox = new TypedListBoxWidget((IValueConverter)new IntegerConverter());
        deliveryMethodListBox.addValueChangeHandler(new TabValueChangeHandler(this.changeable));
        this.fillListBox((TypedListBoxWidget<Long>)deliveryMethodListBox, null, this.distributionPlatformListValues.getDeliveryMethodValues(), true);
        this.addCell(rowIndex, (Widget)deliveryMethodListBox);
        TypedDateBoxWidget dueDate = new TypedDateBoxWidget((IDateConverter)new DateConverter(this.constants.dateFormat(), this.constants.dateFormat()));
        dueDate.addValueChangeHandler(new TabValueChangeHandler(this.changeable));
        this.configureDateBox(dueDate);
        this.addCell(rowIndex, (Widget)dueDate);
        TypedDateBoxWidget deliveryDate = new TypedDateBoxWidget((IDateConverter)new DateConverter(this.constants.dateFormat(), this.constants.dateFormat()));
        deliveryDate.addValueChangeHandler(new TabValueChangeHandler(this.changeable));
        this.configureDateBox(deliveryDate);
        this.addCell(rowIndex, (Widget)deliveryDate);
        TypedDateBoxWidget returnDate = new TypedDateBoxWidget((IDateConverter)new DateConverter(this.constants.dateFormat(), this.constants.dateFormat()));
        returnDate.addValueChangeHandler(new TabValueChangeHandler(this.changeable));
        this.configureDateBox(returnDate);
        this.addCell(rowIndex, (Widget)returnDate);
        TypedListBoxWidget ownershipListBox = new TypedListBoxWidget((IValueConverter)new IntegerConverter());
        ownershipListBox.addValueChangeHandler(new TabValueChangeHandler(this.changeable));
        this.fillListBox((TypedListBoxWidget<Long>)ownershipListBox, null, this.distributionPlatformListValues.getOwnershipValues(), true);
        this.addCell(rowIndex, (Widget)ownershipListBox);
        TypedTextBoxWidget costTextBox = new TypedTextBoxWidget((IValueConverter)new FloatConverter());
        costTextBox.addValueChangeHandler(new TabValueChangeHandler(this.changeable));
        costTextBox.setVisibleLength(10);
        costTextBox.setErrorToolTip(this.messages.floatValidationErrorTooltip());
        this.addCell(rowIndex, (Widget)costTextBox);
        if (this.changeEnabled()) {
            Image removeButton = new Image(DELETE_IMAGE);
            removeButton.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    if (Window.confirm((String)DistributionTable.this.messages.deleteRecordConfirmation())) {
                        int rowIndex = DistributionTable.this.table.getCellForEvent(event).getRowIndex();
                        DistributionTable.this.table.removeRow(rowIndex);
                        if (DistributionTable.this.changeable != null) {
                            DistributionTable.this.changeable.setChanged(true);
                        }
                    }
                }
            });
            this.addCell(rowIndex, (Widget)removeButton);
            this.table.getCellFormatter().addStyleName(rowIndex + 1, this.getCellCount(rowIndex), DELETE_CELL_STYLE);
        }
        if (distributionManagement != null) {
            if (distributionManagement.getCost() != null) {
                costTextBox.setValue((Object)String.valueOf(distributionManagement.getCost()));
            }
            if (distributionManagement.getMediaType() != null) {
                mediaTypeListBox.setValue((Object)distributionManagement.getMediaType().getKey());
            }
            if (distributionManagement.getDeliveryMethod() != null) {
                deliveryMethodListBox.setValue((Object)distributionManagement.getDeliveryMethod().getKey());
            }
            if (distributionManagement.getOwnership() != null) {
                ownershipListBox.setValue((Object)distributionManagement.getOwnership().getKey());
            }
            if (distributionManagement.getMetaFormat() != null) {
                int x = 0;
                while (x < metaFormatListBox.getItemCount()) {
                    if (metaFormatListBox.getItemText(x).equals(distributionManagement.getMetaFormat().getName())) {
                        metaFormatListBox.setItemSelected(x, true);
                        break;
                    }
                    ++x;
                }
            }
            if (distributionManagement.getDeliveryDate() != null) {
                deliveryDate.setValue(distributionManagement.getDeliveryDate());
            }
            if (distributionManagement.getDueDate() != null) {
                dueDate.setValue(distributionManagement.getDueDate());
            }
            if (distributionManagement.getReturnDate() != null) {
                returnDate.setValue(distributionManagement.getReturnDate());
            }
        }
    }

    public List<UiDistributionManagement> getDistributionManagementList() {
        ArrayList<UiDistributionManagement> distributionPlatforms = new ArrayList<UiDistributionManagement>();
        int x = 1;
        while (x < this.table.getRowCount()) {
            TypedListBoxWidget mediaTypeListBox = (TypedListBoxWidget)this.table.getWidget(x, 0);
            TypedListBoxWidget metaFormatListBox = (TypedListBoxWidget)this.table.getWidget(x, 1);
            TypedListBoxWidget deliveryMethodListBox = (TypedListBoxWidget)this.table.getWidget(x, 2);
            TypedDateBoxWidget dueDate = (TypedDateBoxWidget)this.table.getWidget(x, 3);
            TypedDateBoxWidget deliveryDate = (TypedDateBoxWidget)this.table.getWidget(x, 4);
            TypedDateBoxWidget returnDate = (TypedDateBoxWidget)this.table.getWidget(x, 5);
            TypedListBoxWidget ownershipListBox = (TypedListBoxWidget)this.table.getWidget(x, 6);
            TypedTextBoxWidget costTextBox = (TypedTextBoxWidget)this.table.getWidget(x, 7);
            UiDistributionManagement distributionMgmt = new UiDistributionManagement();
            if (deliveryDate.getTextValue() != null && !deliveryDate.getTextValue().trim().isEmpty()) {
                distributionMgmt.setDeliveryDate(deliveryDate.getTextValue());
            } else {
                distributionMgmt.setDeliveryDate(null);
            }
            if (dueDate.getTextValue() != null && !dueDate.getTextValue().trim().isEmpty()) {
                distributionMgmt.setDueDate(dueDate.getTextValue());
            } else {
                distributionMgmt.setDueDate(null);
            }
            if (returnDate.getTextValue() != null && !returnDate.getTextValue().trim().isEmpty()) {
                distributionMgmt.setReturnDate(returnDate.getTextValue());
            } else {
                distributionMgmt.setReturnDate(null);
            }
            if (costTextBox.getValue() != null && !((String)costTextBox.getValue()).trim().equals("")) {
                distributionMgmt.setCost((String)costTextBox.getValue());
            } else {
                distributionMgmt.setCost(null);
            }
            distributionMgmt.setMediaType(new UiMediaType((Long)mediaTypeListBox.getSelectedItem()));
            distributionMgmt.setDeliveryMethod(new UiDeliveryMethod((Long)deliveryMethodListBox.getSelectedItem()));
            distributionMgmt.setOwnership(new UiOwnership((Long)ownershipListBox.getSelectedItem()));
            UiMetaFormat uiMetaFormat = new UiMetaFormat((Long)metaFormatListBox.getSelectedItem());
            uiMetaFormat.setName(metaFormatListBox.getItemText(metaFormatListBox.getSelectedIndex()));
            distributionMgmt.setMetaFormat(uiMetaFormat);
            distributionPlatforms.add(distributionMgmt);
            ++x;
        }
        return distributionPlatforms;
    }

    private void configureDateBox(TypedDateBoxWidget dateBox) {
        dateBox.getTextBox().setMaxLength(10);
        dateBox.getTextBox().setVisibleLength(10);
        dateBox.setToolTip(String.valueOf(this.constants.validDateTitle()) + " " + this.constants.dateFormat());
        dateBox.setErrorToolTip(String.valueOf(this.constants.validDateTitle()) + " " + this.constants.dateFormat());
    }

    private void addHeading(String heading) {
        int column = this.table.getCellCount(0);
        this.table.insertCell(0, column);
        this.table.getCellFormatter().addStyleName(0, column, CELL_STYLE);
        this.table.getCellFormatter().addStyleName(0, column, CELL_HEADER_STYLE);
        this.updateHeading(heading, column);
    }

    private void updateHeading(String heading, int column) {
        LabelWidget label = this.getHeadingWidget(column);
        if (label == null) {
            label = new LabelWidget(heading);
            label.addStyleName("table-header-nonSortable-text");
            this.table.setWidget(0, column, (Widget)label);
        } else {
            label.setText(heading);
        }
    }

    private LabelWidget getHeadingWidget(int column) {
        Widget widget = this.table.getWidget(0, column);
        return widget instanceof LabelWidget ? (LabelWidget)widget : null;
    }

    private void addCell(int row, Widget widget) {
        this.addCell(row, this.getCellCount(row), widget);
    }

    private void addCell(int row, int column, Widget widget) {
        int tableRow = row + 1;
        this.table.insertCell(tableRow, column);
        this.table.getCellFormatter().addStyleName(tableRow, column, CELL_STYLE);
        this.table.getCellFormatter().addStyleName(tableRow, column, CELL_BODY_STYLE);
        this.updateCell(row, column, widget);
    }

    private void updateCell(int row, int column, Widget widget) {
        int tableRow = row + 1;
        this.table.clearCell(tableRow, column);
        this.table.setWidget(tableRow, column, widget);
    }

    private int getCellCount(int row) {
        return this.table.getCellCount(row + 1);
    }

    private int addRow(int row) {
        this.validateBodyRow(row);
        int tableRow = row + 1;
        this.table.insertRow(tableRow);
        this.table.getRowFormatter().addStyleName(tableRow, ROW_STYLE);
        this.table.getRowFormatter().addStyleName(tableRow, ROW_BODY_STYLE);
        return row;
    }

    private void validateBodyRow(int row) {
        if (row < 0) {
            throw new IllegalArgumentException("The row index cannot be less than 0.");
        }
    }

    private int getRowCount() {
        return this.table.getRowCount() - 1;
    }

    private void fillListBox(TypedListBoxWidget<Long> listBox, Long selected, List<UiKeyName> result, boolean blankValue) {
        if (blankValue) {
            listBox.addItem("", null);
        }
        for (UiKeyName keyName : result) {
            listBox.addItem(keyName.getName(), (Object)keyName.getKey());
        }
        listBox.setSelectedItem((Object)selected);
    }
}

