/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.license.tab;

import com.ericsson.cms.contractmgmt.client.model.UiCurrency;
import com.ericsson.cms.contractmgmt.client.model.UiLicense;
import com.ericsson.cms.contractmgmt.client.model.UiLicenseDetails;
import com.ericsson.cms.contractmgmt.client.model.UiRevenuePricing;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownServiceAsync;
import com.ericsson.cms.contractmgmt.client.tab.ContractFormContainer;
import com.ericsson.cms.contractmgmt.client.tab.config.PercentageConverter;
import com.ericsson.cms.contractmgmt.client.tab.config.PositiveFloatConverter;
import com.ericsson.cms.contractmgmt.client.tab.config.PositiveIntegerConverter;
import com.ericsson.cms.contractmgmt.client.tab.license.AbstractLicenseTab;
import com.ericsson.cms.contractmgmt.client.tab.license.LicenseDetailView;
import com.ericsson.cms.contractmgmt.client.tab.license.tab.LicenseDetailsUtils;
import com.ericsson.cms.contractmgmt.client.tab.license.tab.TabValueChangeHandler;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.RadioButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.DisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.RoundedDisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.ScrollContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedDateBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedTextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.DateConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IDateConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IValueConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IntegerConverter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class PricingTab
extends AbstractLicenseTab {
    private static final String TEXTBOXWIDGET_WIDTH = "100px";
    private static final String OVERAGE_LABELWIDGET = "200px";
    private static final String CONTENT_LISTBOX_WIDTH = "235px";
    private static final int VISIBLE_LENGTH = 10;
    private static final long DATE_OPTION = 1L;
    private static final long THRESHOLD_OPTION = 2L;
    private final IContractManagerDropDownServiceAsync contractManagerDropDownService = (IContractManagerDropDownServiceAsync)GWT.create(IContractManagerDropDownService.class);
    private static final String STYLE_DISCLOSURE_CONTAINER = "content-FileView-disclosureContainer";
    private static final String STYLE_DISCLOSURE_CONTENTS = "content-FileView-disclosureContents";
    private static final String STYLE_SCROLL_CONTENTS = "content-FileView-scrollContents";
    private static final String TABLE_STYLE = "contract-table";
    private static final String ROW_STYLE = "contract-table-row";
    private static final String ROW_HEADER_STYLE = "contract-table-row-header";
    private static final String ROW_BODY_STYLE = "contract-table-row-body";
    private static final String CELL_STYLE = "contract-table-cell";
    private static final String CELL_HEADER_STYLE = "contract-table-cell-header";
    private static final String DELETE_IMAGE = "cms_contractmgmt_ui/images/delete.png";
    private static final String DELETE_CELL_STYLE = "contract-table-cell-body-delete";
    private final FlexTableContainer tablePricing;
    private final FlexTableContainer tableShare;
    private final ContractFormContainer formContainer;
    private final ContractFormContainer licenseFormContainer;
    private final ContractFormContainer paymentFormContainer;
    private final ContractFormContainer tieredPricingContainer;
    private final ContractFormContainer revenueShareFormContainer;
    private DisclosureContainer licenseDisclosureContainer;
    private DisclosureContainer paymentDisclosureContainer;
    private DisclosureContainer revenueShareDisclosureContainer;
    private DisclosureContainer tieredPricingDisclosureContainer;
    private RadioButtonWidget upfrontPaymentRequiredYes;
    private RadioButtonWidget upfrontPaymentRequiredNo;
    private RadioButtonWidget paymentScheduleRequiredYes;
    private RadioButtonWidget paymentScheduleRequiredNo;
    private RadioButtonWidget installmentPlanYes;
    private RadioButtonWidget installmentPlanNo;
    private RadioButtonWidget tieredPricingRequiredYes;
    private RadioButtonWidget tieredPricingRequiredNo;
    private RadioButtonWidget revenueShareRequiredYes;
    private RadioButtonWidget revenueShareRequiredNo;
    private TypedTextBoxWidget<Integer> subscribers;
    private TypedTextBoxWidget<String> buyRate;
    private TypedTextBoxWidget<String> deemedRetailPrice;
    private TypedTextBoxWidget<String> actualRetailPrice;
    private TypedTextBoxWidget<String> lostBuys;
    private TypedTextBoxWidget<String> revenueShare;
    private TypedTextBoxWidget<String> actualLicenseFee;
    private TypedTextBoxWidget<String> minimumLicenseFee;
    private TypedTextBoxWidget<String> upfrontPaymentRequired;
    private TypedTextBoxWidget<String> overageRequired;
    private TypedTextBoxWidget<String> installmentPlanText;
    private TypedListBoxWidget<Long> paymentCurrency;
    private final List<UiCurrency> currencyList;
    private final List<UiRevenuePricing> revenueList = new ArrayList<UiRevenuePricing>();
    private final List<UiRevenuePricing> tieredPricingList = new ArrayList<UiRevenuePricing>();
    private ButtonWidget addButtonPricing;
    private ButtonWidget addButtonShare;

    public PricingTab(UiLicense license, final LicenseDetailView detailView) {
        super(license, detailView);
        this.busyIndicator.center();
        this.currencyList = new ArrayList<UiCurrency>();
        this.tablePricing = new FlexTableContainer();
        this.tableShare = new FlexTableContainer();
        this.formContainer = new ContractFormContainer(HasHorizontalAlignment.ALIGN_LEFT);
        this.licenseFormContainer = new ContractFormContainer(HasHorizontalAlignment.ALIGN_LEFT);
        this.paymentFormContainer = new ContractFormContainer(HasHorizontalAlignment.ALIGN_LEFT);
        this.tieredPricingContainer = new ContractFormContainer(HasHorizontalAlignment.ALIGN_LEFT);
        this.revenueShareFormContainer = new ContractFormContainer(HasHorizontalAlignment.ALIGN_LEFT);
        this.contractManagerDropDownService.getCurrencies((AsyncCallback<List<UiCurrency>>)new NeptuneAsyncCallback<List<UiCurrency>>(){

            public void onNeptuneFailure(Throwable caught) {
                detailView.getErrorPanel().showMessage(caught.getLocalizedMessage());
                PricingTab.this.busyIndicator.hide();
            }

            public void onNeptuneSuccess(List<UiCurrency> result) {
                PricingTab.this.currencyList.clear();
                PricingTab.this.currencyList.addAll(result);
                PricingTab.this.init();
                PricingTab.this.contentPanel.add((Widget)PricingTab.this.formContainer);
                PricingTab.this.contentPanel.add((Widget)PricingTab.this.licenseDisclosureContainer);
                PricingTab.this.contentPanel.add((Widget)PricingTab.this.paymentDisclosureContainer);
                PricingTab.this.contentPanel.add((Widget)PricingTab.this.tieredPricingDisclosureContainer);
                PricingTab.this.contentPanel.add((Widget)PricingTab.this.revenueShareDisclosureContainer);
                PricingTab.this.fillForm();
                PricingTab.this.busyIndicator.hide();
            }
        });
    }

    private void init() {
        this.subscribers = new TypedTextBoxWidget((IValueConverter)new PositiveIntegerConverter());
        this.subscribers.addValueChangeHandler(new TabValueChangeHandler(this));
        this.configureNumberTextBox(this.subscribers, this.messages.positiveNumberValidationErrorTooltip());
        this.buyRate = new TypedTextBoxWidget((IValueConverter)new PercentageConverter());
        this.buyRate.addValueChangeHandler(new TabValueChangeHandler(this));
        this.configureNumberTextBox(this.buyRate, this.messages.pricingTabBuyRate());
        this.deemedRetailPrice = new TypedTextBoxWidget((IValueConverter)new PositiveFloatConverter());
        this.deemedRetailPrice.addValueChangeHandler(new TabValueChangeHandler(this));
        this.configureNumberTextBox(this.deemedRetailPrice, this.messages.positiveFloatValidationErrorTooltip());
        this.actualRetailPrice = new TypedTextBoxWidget((IValueConverter)new PositiveFloatConverter());
        this.actualRetailPrice.addValueChangeHandler(new TabValueChangeHandler(this));
        this.configureNumberTextBox(this.actualRetailPrice, this.messages.positiveFloatValidationErrorTooltip());
        this.lostBuys = new TypedTextBoxWidget((IValueConverter)new PercentageConverter());
        this.lostBuys.addValueChangeHandler(new TabValueChangeHandler(this));
        this.configureNumberTextBox(this.lostBuys, this.messages.pricingTabLostBuys());
        this.revenueShare = new TypedTextBoxWidget((IValueConverter)new PercentageConverter());
        this.revenueShare.addValueChangeHandler(new TabValueChangeHandler(this));
        this.configureNumberTextBox(this.revenueShare, this.messages.pricingTabRevenueShare());
        this.buildLicenseDisclosure();
        this.buildPaymentDisclosure();
        this.buildTieredPricingDisclosure();
        this.buildRevenueShareDisclosure();
        this.formContainer.addRow(this.constants.pricingGuaranteedSubscribers(), (Widget)this.subscribers);
        this.formContainer.addRow(this.constants.pricingGuaranteedBuyRate(), (Widget)this.buyRate);
        this.formContainer.addRow(this.constants.pricingDeemedRetailPrice(), (Widget)this.deemedRetailPrice);
        this.formContainer.addRow(this.constants.pricingActualRetailPrice(), (Widget)this.actualRetailPrice);
        this.formContainer.addRow(this.constants.pricingLostBuys(), (Widget)this.lostBuys);
        this.formContainer.addRow(this.constants.pricingRevenueShare(), (Widget)this.revenueShare);
    }

    private void buildLicenseDisclosure() {
        this.licenseDisclosureContainer = new RoundedDisclosureContainer(this.constants.pricingLicenseSectionHeading(), true);
        this.licenseDisclosureContainer.addStyleName(STYLE_DISCLOSURE_CONTAINER);
        this.licenseFormContainer.addStyleName(STYLE_SCROLL_CONTENTS);
        this.actualLicenseFee = new TypedTextBoxWidget((IValueConverter)new PositiveFloatConverter());
        this.actualLicenseFee.addValueChangeHandler(new TabValueChangeHandler(this));
        this.configureNumberTextBox(this.actualLicenseFee, this.messages.positiveFloatValidationErrorTooltip());
        this.minimumLicenseFee = new TypedTextBoxWidget((IValueConverter)new PositiveFloatConverter());
        this.minimumLicenseFee.addValueChangeHandler(new TabValueChangeHandler(this));
        this.configureNumberTextBox(this.minimumLicenseFee, this.messages.positiveFloatValidationErrorTooltip());
        this.licenseFormContainer.addRow(this.constants.pricingActualLicenseFee(), (Widget)this.actualLicenseFee);
        this.licenseFormContainer.addRow(this.constants.pricingMinimumLicenseFee(), (Widget)this.minimumLicenseFee);
        ScrollContainer licenseDisclosureContents = new ScrollContainer((Widget)this.licenseFormContainer);
        licenseDisclosureContents.addStyleName(STYLE_DISCLOSURE_CONTENTS);
        this.licenseDisclosureContainer.setContent((Widget)licenseDisclosureContents);
    }

    private void buildPaymentDisclosure() {
        this.paymentDisclosureContainer = new RoundedDisclosureContainer(this.constants.pricingPaymentCurrency(), true);
        this.paymentDisclosureContainer.addStyleName(STYLE_DISCLOSURE_CONTAINER);
        this.paymentFormContainer.addStyleName(STYLE_SCROLL_CONTENTS);
        this.upfrontPaymentRequired = new TypedTextBoxWidget((IValueConverter)new PositiveFloatConverter());
        this.upfrontPaymentRequired.addValueChangeHandler(new TabValueChangeHandler(this));
        this.upfrontPaymentRequired.setEnabled(false);
        this.upfrontPaymentRequired.setVisible(false);
        this.configureNumberTextBox(this.upfrontPaymentRequired, this.messages.positiveFloatValidationErrorTooltip());
        this.upfrontPaymentRequiredYes = new RadioButtonWidget("upfrontPayment", this.constants.yes());
        this.upfrontPaymentRequiredYes.addValueChangeHandler(new TabValueChangeHandler(this));
        this.upfrontPaymentRequiredYes.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                PricingTab.this.upfrontPaymentRequired.setText("");
                PricingTab.this.upfrontPaymentRequired.setEnabled(true);
                PricingTab.this.upfrontPaymentRequired.setVisible(true);
            }
        });
        this.upfrontPaymentRequiredNo = new RadioButtonWidget("upfrontPayment", this.constants.no());
        this.upfrontPaymentRequiredNo.addValueChangeHandler(new TabValueChangeHandler(this));
        this.upfrontPaymentRequiredNo.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                PricingTab.this.upfrontPaymentRequired.setText("");
                PricingTab.this.upfrontPaymentRequired.setEnabled(false);
                PricingTab.this.upfrontPaymentRequired.setVisible(false);
            }
        });
        HorizontalContainer upfrontPayment = this.createRadioContainer(this.upfrontPaymentRequiredYes, this.upfrontPaymentRequiredNo);
        this.addSpace(upfrontPayment);
        upfrontPayment.add(this.upfrontPaymentRequired);
        this.overageRequired = new TypedTextBoxWidget((IValueConverter)new PositiveFloatConverter());
        this.overageRequired.addValueChangeHandler(new TabValueChangeHandler(this));
        this.overageRequired.setEnabled(false);
        this.overageRequired.setVisible(false);
        this.configureNumberTextBox(this.overageRequired, this.messages.positiveFloatValidationErrorTooltip());
        this.paymentScheduleRequiredYes = new RadioButtonWidget("overage", this.constants.yes());
        this.paymentScheduleRequiredYes.addValueChangeHandler(new TabValueChangeHandler(this));
        this.paymentScheduleRequiredYes.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                PricingTab.this.overageRequired.setText("");
                PricingTab.this.overageRequired.setEnabled(true);
                PricingTab.this.overageRequired.setVisible(true);
            }
        });
        this.paymentScheduleRequiredNo = new RadioButtonWidget("overage", this.constants.no());
        this.paymentScheduleRequiredNo.addValueChangeHandler(new TabValueChangeHandler(this));
        this.paymentScheduleRequiredNo.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                PricingTab.this.overageRequired.setText("");
                PricingTab.this.overageRequired.setEnabled(false);
                PricingTab.this.overageRequired.setVisible(false);
            }
        });
        HorizontalContainer overagePayment = this.createRadioContainer(this.paymentScheduleRequiredYes, this.paymentScheduleRequiredNo);
        this.addSpace(overagePayment);
        overagePayment.add(this.overageRequired);
        this.paymentCurrency = new TypedListBoxWidget((IValueConverter)new IntegerConverter());
        this.paymentCurrency.addValueChangeHandler(new TabValueChangeHandler(this));
        this.paymentCurrency.setWidth(CONTENT_LISTBOX_WIDTH);
        this.installmentPlanText = new TypedTextBoxWidget((IValueConverter)new PositiveFloatConverter());
        this.installmentPlanText.addValueChangeHandler(new TabValueChangeHandler(this));
        this.installmentPlanText.setEnabled(false);
        this.installmentPlanText.setVisible(false);
        this.configureNumberTextBox(this.installmentPlanText, this.messages.positiveFloatValidationErrorTooltip());
        this.installmentPlanYes = new RadioButtonWidget("installment", this.constants.yes());
        this.installmentPlanYes.addValueChangeHandler(new TabValueChangeHandler(this));
        this.installmentPlanYes.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                PricingTab.this.installmentPlanText.setText("");
                PricingTab.this.installmentPlanText.setEnabled(true);
                PricingTab.this.installmentPlanText.setVisible(true);
            }
        });
        this.installmentPlanNo = new RadioButtonWidget("installment", this.constants.no());
        this.installmentPlanNo.addValueChangeHandler(new TabValueChangeHandler(this));
        this.installmentPlanNo.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                PricingTab.this.installmentPlanText.setText("");
                PricingTab.this.installmentPlanText.setEnabled(false);
                PricingTab.this.installmentPlanText.setVisible(false);
            }
        });
        HorizontalContainer installmentPlan = this.createRadioContainer(this.installmentPlanYes, this.installmentPlanNo);
        this.addSpace(installmentPlan);
        installmentPlan.add(this.installmentPlanText);
        this.paymentFormContainer.addRow(this.constants.pricingUpfrontPaymentRequired(), (Widget)upfrontPayment, true);
        LabelWidget overageLabel = new LabelWidget(this.constants.pricingOveragePaymentRequired());
        overageLabel.setWidth(OVERAGE_LABELWIDGET);
        overageLabel.setWordWrap(true);
        this.paymentFormContainer.addRow(overageLabel, (Widget)overagePayment, true);
        this.paymentFormContainer.addRow(this.constants.pricingPaymentCurrency(), (Widget)this.paymentCurrency);
        this.paymentFormContainer.addRow(this.constants.pricingInstallmentPlan(), (Widget)installmentPlan, true);
        ScrollContainer paymentDisclosureContents = new ScrollContainer((Widget)this.paymentFormContainer);
        paymentDisclosureContents.addStyleName(STYLE_DISCLOSURE_CONTENTS);
        this.paymentDisclosureContainer.setContent((Widget)paymentDisclosureContents);
    }

    private void buildTieredPricingDisclosure() {
        this.tieredPricingDisclosureContainer = new RoundedDisclosureContainer(this.constants.pricingTieredPricingSectionHeading(), true);
        this.tieredPricingDisclosureContainer.addStyleName(STYLE_DISCLOSURE_CONTAINER);
        this.tieredPricingContainer.addStyleName(STYLE_SCROLL_CONTENTS);
        this.tieredPricingRequiredYes = new RadioButtonWidget("tiered", this.constants.yes());
        this.tieredPricingRequiredYes.addValueChangeHandler(new TabValueChangeHandler(this));
        this.tieredPricingRequiredYes.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                PricingTab.this.enableTieredPricingTable();
            }
        });
        this.tieredPricingRequiredNo = new RadioButtonWidget("tiered", this.constants.no());
        this.tieredPricingRequiredNo.addValueChangeHandler(new TabValueChangeHandler(this));
        this.tieredPricingRequiredNo.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                PricingTab.this.disableTieredPricingTable();
            }
        });
        this.tieredPricingContainer.addRow(this.constants.pricingTieredPricingRequired(), (Widget)this.createRadioContainer(this.tieredPricingRequiredYes, this.tieredPricingRequiredNo));
        ScrollContainer tieredPricingDisclosureContents = new ScrollContainer((Widget)this.tieredPricingContainer);
        tieredPricingDisclosureContents.addStyleName(STYLE_DISCLOSURE_CONTENTS);
        this.tablePricing.addStyleName(TABLE_STYLE);
        this.tablePricing.insertRow(0);
        this.tablePricing.getRowFormatter().addStyleName(0, "table-header-row");
        this.tablePricing.getRowFormatter().addStyleName(0, ROW_HEADER_STYLE);
        this.tieredPricingContainer.addRow("", (Widget)this.tablePricing);
        this.initTable(this.tablePricing, true);
        if (this.changeEnabled()) {
            this.addButtonsPricing();
        }
        this.tieredPricingDisclosureContainer.setContent((Widget)tieredPricingDisclosureContents);
    }

    private void enableTieredPricingTable() {
        if (this.changeEnabled()) {
            this.addButtonPricing.setEnabled(true);
        }
    }

    private void disableTieredPricingTable() {
        if (this.changeEnabled()) {
            this.addButtonPricing.setEnabled(false);
        }
        this.removeAllRows(this.tablePricing, this.tieredPricingList);
    }

    private void buildRevenueShareDisclosure() {
        this.revenueShareDisclosureContainer = new RoundedDisclosureContainer(this.constants.pricingRevenueShare(), true);
        this.revenueShareDisclosureContainer.addStyleName(STYLE_DISCLOSURE_CONTAINER);
        this.revenueShareFormContainer.addStyleName(STYLE_SCROLL_CONTENTS);
        this.revenueShareRequiredYes = new RadioButtonWidget("revenue", this.constants.yes());
        this.revenueShareRequiredYes.addValueChangeHandler(new TabValueChangeHandler(this));
        this.revenueShareRequiredYes.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                PricingTab.this.enableRevenueShareTable();
            }
        });
        this.revenueShareRequiredNo = new RadioButtonWidget("revenue", this.constants.no());
        this.revenueShareRequiredNo.addValueChangeHandler(new TabValueChangeHandler(this));
        this.revenueShareRequiredNo.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                PricingTab.this.disableRevenueShareTable();
            }
        });
        this.revenueShareFormContainer.addRow(this.constants.pricingRevenueShareRequired(), (Widget)this.createRadioContainer(this.revenueShareRequiredYes, this.revenueShareRequiredNo));
        ScrollContainer revenueShareDisclosureContents = new ScrollContainer((Widget)this.revenueShareFormContainer);
        revenueShareDisclosureContents.addStyleName(STYLE_DISCLOSURE_CONTENTS);
        this.tableShare.addStyleName(TABLE_STYLE);
        this.tableShare.insertRow(0);
        this.tableShare.getRowFormatter().addStyleName(0, "table-header-row");
        this.tableShare.getRowFormatter().addStyleName(0, ROW_HEADER_STYLE);
        this.revenueShareFormContainer.addRow("", (Widget)this.tableShare);
        this.initTable(this.tableShare, false);
        if (this.changeEnabled()) {
            this.addButtonsShare();
        }
        this.revenueShareDisclosureContainer.setContent((Widget)revenueShareDisclosureContents);
    }

    private void enableRevenueShareTable() {
        if (this.changeEnabled()) {
            this.addButtonShare.setEnabled(true);
        }
    }

    private void disableRevenueShareTable() {
        if (this.changeEnabled()) {
            this.addButtonShare.setEnabled(false);
        }
        this.removeAllRows(this.tableShare, this.revenueList);
    }

    private void addButtonsPricing() {
        HorizontalContainer buttonsContainer = new HorizontalContainer();
        buttonsContainer.setSpacing(5);
        this.addButtonPricing = new ButtonWidget(this.constants.addButtonName(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                PricingTab.this.addRow(PricingTab.this.tablePricing, null, true, PricingTab.this.tieredPricingList);
            }
        });
        this.addButtonPricing.removeStyleName("gwt-Button");
        this.addButtonPricing.addStyleName("ebBtn");
        this.addButtonPricing.addStyleName("addgreen_button_icon");
        this.addButtonPricing.setEnabled(false);
        buttonsContainer.add((Widget)this.addButtonPricing);
        this.tieredPricingContainer.addRow("", (Widget)buttonsContainer);
    }

    private void addButtonsShare() {
        HorizontalContainer buttonsContainer = new HorizontalContainer();
        buttonsContainer.setSpacing(5);
        this.addButtonShare = new ButtonWidget(this.constants.addButtonName(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                PricingTab.this.addRow(PricingTab.this.tableShare, null, false, PricingTab.this.revenueList);
            }
        });
        this.addButtonShare.removeStyleName("gwt-Button");
        this.addButtonShare.addStyleName("ebBtn");
        this.addButtonShare.addStyleName("ebBtn_color_green");
        this.addButtonShare.addStyleName("create_button_icon");
        this.addButtonShare.setEnabled(false);
        buttonsContainer.add((Widget)this.addButtonShare);
        this.revenueShareFormContainer.addRow("", (Widget)buttonsContainer);
    }

    private HorizontalContainer createRadioContainer(RadioButtonWidget radio1, RadioButtonWidget radio2) {
        HorizontalContainer container = new HorizontalContainer();
        container.add((Widget)radio1);
        this.addSpace(container);
        radio2.setValue(Boolean.valueOf(true));
        container.add((Widget)radio2);
        return container;
    }

    private void addSpace(HorizontalContainer container) {
        if (container != null) {
            HorizontalPanel space = new HorizontalPanel();
            LabelWidget label = new LabelWidget();
            space.add((Widget)label);
            space.setCellWidth((Widget)label, "10");
            container.add((Widget)space);
        }
    }

    private void addHeading(String heading, FlexTableContainer table) {
        int column = table.getCellCount(0);
        table.insertCell(0, column);
        table.getCellFormatter().addStyleName(0, column, CELL_STYLE);
        table.getCellFormatter().addStyleName(0, column, CELL_HEADER_STYLE);
        this.updateHeading(table, heading, column);
    }

    private void updateHeading(FlexTableContainer table, String heading, int column) {
        LabelWidget label = this.getHeadingWidget(table, column);
        if (label == null) {
            label = new LabelWidget(heading);
            label.addStyleName("table-header-nonSortable-text");
            table.setWidget(0, column, (Widget)label);
        } else {
            label.setText(heading);
        }
    }

    private LabelWidget getHeadingWidget(FlexTableContainer table, int column) {
        Widget widget = table.getWidget(0, column);
        return widget instanceof LabelWidget ? (LabelWidget)widget : null;
    }

    private void initTable(FlexTableContainer table, boolean priceHeader) {
        this.addHeading("", table);
        if (priceHeader) {
            this.addHeading(this.constants.pricingTypeHeader(), table);
        }
        this.addHeading(priceHeader ? this.constants.pricingFromHeader() : String.valueOf(this.constants.pricingFromHeader()) + "*", table);
        this.addHeading(priceHeader ? this.constants.pricingToHeader() : String.valueOf(this.constants.pricingToHeader()) + "*", table);
        this.addHeading(this.constants.pricingThresholdHeader(), table);
        this.addHeading(priceHeader ? String.valueOf(this.constants.pricingPriceHeader()) + "*" : String.valueOf(this.constants.pricingPercentageHeader()) + "*", table);
        this.addHeading(this.constants.pricingCurrencyHeader(), table);
        this.addHeading(this.constants.pricingPenaltyHeader(), table);
    }

    private boolean changeEnabled() {
        boolean isCreating;
        boolean bl = isCreating = this.getLicense().getKey() == null;
        return isCreating && ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Create"}) || !isCreating && ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Modify"});
    }

    private void addRow(final FlexTableContainer table, UiRevenuePricing uiRevenuePricing, final boolean hasType, final List<UiRevenuePricing> uiRevenuePricingList) {
        int rowIndex = this.addRow(table);
        int colIndex = 1;
        TypedListBoxWidget typeListBox = new TypedListBoxWidget((IValueConverter)new IntegerConverter());
        if (hasType) {
            typeListBox.addValueChangeHandler(new TabValueChangeHandler(this));
            typeListBox.setWidth(TEXTBOXWIDGET_WIDTH);
            typeListBox.addItem(this.constants.date(), (Object)1L);
            typeListBox.addItem(this.constants.threshold(), (Object)2L);
            table.setWidget(rowIndex, colIndex++, (Widget)typeListBox);
        }
        final TypedDateBoxWidget fromDate = new TypedDateBoxWidget((IDateConverter)new DateConverter(this.constants.dateFormat(), this.constants.dateFormat()));
        fromDate.addValueChangeHandler(new TabValueChangeHandler(this));
        this.configureDateBox(fromDate);
        table.setWidget(rowIndex, colIndex++, (Widget)fromDate);
        final TypedDateBoxWidget toDate = new TypedDateBoxWidget((IDateConverter)new DateConverter(this.constants.dateFormat(), this.constants.dateFormat()));
        toDate.addValueChangeHandler(new TabValueChangeHandler(this));
        this.configureDateBox(toDate);
        table.setWidget(rowIndex, colIndex++, (Widget)toDate);
        final TypedTextBoxWidget thresholdTextBox = new TypedTextBoxWidget((IValueConverter)new PositiveFloatConverter());
        thresholdTextBox.addValueChangeHandler(new TabValueChangeHandler(this));
        table.setWidget(rowIndex, colIndex++, (Widget)thresholdTextBox);
        thresholdTextBox.setErrorToolTip(this.messages.positiveFloatValidationErrorTooltip());
        thresholdTextBox.setVisibleLength(10);
        if (hasType) {
            thresholdTextBox.setEnabled(false);
        }
        if (hasType) {
            typeListBox.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Long>(){

                public void onValueChange(ValueChangeEvent<Long> event) {
                    if (((Long)event.getValue()).equals(1L)) {
                        fromDate.setEnabled(true);
                        toDate.setEnabled(true);
                        thresholdTextBox.setEnabled(false);
                        thresholdTextBox.setValue(null);
                    } else if (((Long)event.getValue()).equals(2L)) {
                        fromDate.setEnabled(false);
                        toDate.setEnabled(false);
                        thresholdTextBox.setEnabled(true);
                        fromDate.setValue(null);
                        toDate.setValue(null);
                    }
                }
            });
        }
        TypedTextBoxWidget price = new TypedTextBoxWidget((IValueConverter)new PositiveFloatConverter());
        price.setErrorToolTip(this.messages.positiveFloatValidationErrorTooltip());
        price.addValueChangeHandler(new TabValueChangeHandler(this));
        table.setWidget(rowIndex, colIndex++, (Widget)price);
        price.setVisibleLength(10);
        TypedListBoxWidget currencyMethodListBox = new TypedListBoxWidget((IValueConverter)new IntegerConverter());
        currencyMethodListBox.addValueChangeHandler(new TabValueChangeHandler(this));
        currencyMethodListBox.setWidth(TEXTBOXWIDGET_WIDTH);
        table.setWidget(rowIndex, colIndex++, (Widget)currencyMethodListBox);
        this.fillTypedList((TypedListBoxWidget<Long>)currencyMethodListBox);
        TypedTextBoxWidget penalty = new TypedTextBoxWidget((IValueConverter)new PositiveFloatConverter());
        penalty.setErrorToolTip(this.messages.positiveFloatValidationErrorTooltip());
        penalty.addValueChangeHandler(new TabValueChangeHandler(this));
        table.setWidget(rowIndex, colIndex++, (Widget)penalty);
        penalty.setVisibleLength(10);
        if (this.changeEnabled()) {
            Image removeButton = new Image(DELETE_IMAGE);
            removeButton.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    if (Window.confirm((String)PricingTab.this.messages.deleteRecordConfirmation())) {
                        int rowIndex = table.getCellForEvent(event).getRowIndex();
                        table.removeRow(rowIndex);
                        PricingTab.this.removeRow(table, uiRevenuePricingList, hasType);
                    }
                }
            });
            table.setWidget(rowIndex, colIndex++, (Widget)removeButton);
            table.getCellFormatter().setStyleName(rowIndex, colIndex, DELETE_CELL_STYLE);
        }
        if (uiRevenuePricing != null) {
            if (hasType) {
                if (uiRevenuePricing.getFromDate() != null && uiRevenuePricing.getToDate() != null) {
                    fromDate.setValue(uiRevenuePricing.getFromDate());
                    fromDate.setEnabled(true);
                    toDate.setValue(uiRevenuePricing.getToDate());
                    toDate.setEnabled(true);
                    thresholdTextBox.setEnabled(false);
                    typeListBox.setSelectedItem((Object)1L);
                } else if (uiRevenuePricing.getThreshold() != null) {
                    thresholdTextBox.setTextValue(uiRevenuePricing.getThreshold());
                    thresholdTextBox.setEnabled(true);
                    toDate.setEnabled(false);
                    fromDate.setEnabled(false);
                    typeListBox.setSelectedItem((Object)2L);
                }
            } else {
                if (uiRevenuePricing.getFromDate() != null && uiRevenuePricing.getToDate() != null) {
                    fromDate.setValue(uiRevenuePricing.getFromDate());
                    toDate.setValue(uiRevenuePricing.getToDate());
                }
                if (uiRevenuePricing.getThreshold() != null) {
                    thresholdTextBox.setTextValue(uiRevenuePricing.getThreshold());
                }
            }
            if (uiRevenuePricing.getPrice() != null) {
                price.setTextValue(uiRevenuePricing.getPrice());
            }
            if (uiRevenuePricing.getCurrency() != null) {
                currencyMethodListBox.setValue((Object)uiRevenuePricing.getCurrency().getKey());
            }
            if (uiRevenuePricing.getPenalty() != null) {
                penalty.setTextValue(uiRevenuePricing.getPenalty());
            }
        }
    }

    private void removeRow(FlexTableContainer table, List<UiRevenuePricing> uiRevenuePricingList, boolean hasType) {
        this.updateRevenuePricingList(uiRevenuePricingList, table, hasType);
        this.setChanged(true);
    }

    private int addRow(FlexTableContainer table) {
        table.insertRow(table.getRowCount());
        table.getRowFormatter().addStyleName(this.getRowIndex(table), ROW_STYLE);
        table.getRowFormatter().addStyleName(this.getRowIndex(table), ROW_BODY_STYLE);
        return this.getRowIndex(table);
    }

    private int getRowIndex(FlexTableContainer table) {
        return table.getRowCount() - 1;
    }

    private void updateRevenuePricingList(List<UiRevenuePricing> uiRevenuePrincingList, FlexTableContainer table, boolean hasType) {
        uiRevenuePrincingList.clear();
        if (table.getRowCount() > 1) {
            int i = 1;
            while (i < table.getRowCount()) {
                UiRevenuePricing uiRevenuePricing = new UiRevenuePricing();
                uiRevenuePricing.setCurrency(this.getCurrency((Long)((TypedListBoxWidget)table.getWidget(i, hasType ? 6 : 5)).getSelectedItem()));
                String fromDateText = ((TypedDateBoxWidget)table.getWidget(i, hasType ? 2 : 1)).getTextValue();
                if (fromDateText != null && !fromDateText.trim().isEmpty()) {
                    uiRevenuePricing.setFromDate(fromDateText);
                } else {
                    uiRevenuePricing.setFromDate(null);
                }
                String toDateText = ((TypedDateBoxWidget)table.getWidget(i, hasType ? 3 : 2)).getTextValue();
                if (toDateText != null && !toDateText.trim().isEmpty()) {
                    uiRevenuePricing.setToDate(toDateText);
                } else {
                    uiRevenuePricing.setToDate(null);
                }
                uiRevenuePricing.setPenalty((String)((TypedTextBoxWidget)table.getWidget(i, hasType ? 7 : 6)).getValue());
                uiRevenuePricing.setPrice((String)((TypedTextBoxWidget)table.getWidget(i, hasType ? 5 : 4)).getValue());
                uiRevenuePricing.setThreshold((String)((TypedTextBoxWidget)table.getWidget(i, hasType ? 4 : 3)).getValue());
                uiRevenuePrincingList.add(uiRevenuePricing);
                ++i;
            }
        }
    }

    private void removeAllRows(FlexTableContainer table, List<UiRevenuePricing> uiRevenuePricingList) {
        int i = 1;
        while (i < table.getRowCount()) {
            table.removeRow(i);
            --i;
            ++i;
        }
        uiRevenuePricingList.clear();
    }

    private void configureDateBox(TypedDateBoxWidget dateBox) {
        dateBox.getTextBox().setMaxLength(10);
        dateBox.getTextBox().setVisibleLength(10);
        dateBox.setToolTip(String.valueOf(this.constants.validDateTitle()) + " " + this.constants.dateFormat());
        dateBox.setErrorToolTip(String.valueOf(this.constants.validDateTitle()) + " " + this.constants.dateFormat());
    }

    private void configureNumberTextBox(TypedTextBoxWidget<?> textBox, String errorTooltip) {
        textBox.setWidth(TEXTBOXWIDGET_WIDTH);
        textBox.setErrorToolTip(errorTooltip);
    }

    private void fillRadioValues(RadioButtonWidget radio1, RadioButtonWidget radio2, Boolean value) {
        if (value != null && value.booleanValue()) {
            radio1.setValue(Boolean.valueOf(true));
            radio2.setValue(Boolean.valueOf(false));
        } else {
            radio1.setValue(Boolean.valueOf(false));
            radio2.setValue(Boolean.valueOf(true));
        }
    }

    @Override
    public String getName() {
        return "PRICING";
    }

    @Override
    public String getDisplayName() {
        return this.constants.pricingTabDisplayName();
    }

    @Override
    public void validate() throws ValidationException {
        Float revenue;
        Float lost;
        Float buyrate;
        ArrayList<String> validationMessages = new ArrayList<String>();
        if (!this.formContainer.validate()) {
            validationMessages.add(this.messages.formHasValidationErrors());
        }
        if (!this.licenseFormContainer.validate()) {
            validationMessages.add(this.messages.licenseFormHasValidationErrors());
        }
        if (!this.paymentFormContainer.validate()) {
            validationMessages.add(this.messages.paymentFormHasValidationErrors());
        }
        if (!this.tieredPricingContainer.validate()) {
            validationMessages.add(this.messages.tieredPricingFormHasValidationErrors());
        }
        if (!this.revenueShareFormContainer.validate()) {
            validationMessages.add(this.messages.revenueShareFormHasValidationErrors());
        }
        if (this.buyRate.getValue() != null && ((buyrate = new Float((String)this.buyRate.getValue())).floatValue() < 0.0f || buyrate.floatValue() > 100.0f)) {
            validationMessages.add(this.messages.pricingTabBuyRate());
        }
        if (this.lostBuys.getValue() != null && ((lost = new Float((String)this.lostBuys.getValue())).floatValue() < 0.0f || lost.floatValue() > 100.0f)) {
            validationMessages.add(this.messages.pricingTabLostBuys());
        }
        if (this.revenueShare.getValue() != null && ((revenue = new Float((String)this.revenueShare.getValue())).floatValue() < 0.0f || revenue.floatValue() > 100.0f)) {
            validationMessages.add(this.messages.pricingTabRevenueShare());
        }
        this.updateRevenuePricingList(this.tieredPricingList, this.tablePricing, true);
        this.validateRows(this.tieredPricingList, validationMessages, this.constants.pricingTieredPricingSectionHeading());
        this.updateRevenuePricingList(this.revenueList, this.tableShare, false);
        this.validateRows(this.revenueList, validationMessages, this.constants.pricingRevenueShare());
        if (!validationMessages.isEmpty()) {
            throw new ValidationException(validationMessages);
        }
    }

    private void validateRows(List<UiRevenuePricing> rows, List<String> validationMessages, String type) {
        DateTimeFormat dateFormatter = DateTimeFormat.getFormat((String)this.constants.dateFormat());
        boolean overlap = false;
        HashSet<UiRevenuePricing> rpTempSet = new HashSet<UiRevenuePricing>();
        int i = 0;
        while (i < rows.size()) {
            UiRevenuePricing rp1 = rows.get(i);
            rpTempSet.add(rp1);
            if (rp1.getPrice() == null) {
                validationMessages.add(this.messages.pricingTabPriceRequired(type, i + 1, type.equals(this.constants.pricingRevenueShare()) ? this.constants.percentage() : this.constants.pricingPriceHeader()));
            }
            if (rp1.getThreshold() == null || type.equals(this.constants.pricingRevenueShare())) {
                if (rp1.getToDate() != null && rp1.getFromDate() != null) {
                    this.validateRevenuePricingDate(validationMessages, type, dateFormatter, i, rp1);
                    if (!overlap) {
                        for (UiRevenuePricing rp2 : rows) {
                            if (rpTempSet.contains(rp2) || rp2.getFromDate() == null || rp2.getToDate() == null || (rp2.getFromDate().compareTo(rp1.getFromDate()) < 0 || rp2.getFromDate().compareTo(rp1.getToDate()) > 0) && (rp2.getToDate().compareTo(rp1.getFromDate()) < 0 || rp2.getToDate().compareTo(rp1.getToDate()) > 0)) continue;
                            if (type.equals(this.constants.pricingRevenueShare()) && rp1.getThreshold() != null && rp2.getThreshold() != null) {
                                Float rp1FloatVal = Float.valueOf(Float.parseFloat(rp1.getThreshold()));
                                Float rp2FloatVal = Float.valueOf(Float.parseFloat(rp2.getThreshold()));
                                if (rp1FloatVal.floatValue() != rp2FloatVal.floatValue()) continue;
                                validationMessages.add(this.messages.pricingTabDatesThresholdOverlap(type));
                                overlap = true;
                            } else {
                                validationMessages.add(this.messages.pricingTabDatesOverlap(type));
                                overlap = true;
                            }
                            break;
                        }
                    }
                } else {
                    validationMessages.add(this.messages.pricingTabThresholdOrDateRangeRequired(type, i + 1));
                }
            }
            ++i;
        }
    }

    private void validateRevenuePricingDate(List<String> validationMessages, String type, DateTimeFormat dateFormatter, int i, UiRevenuePricing rp1) {
        if (rp1.getToDate().compareTo(rp1.getFromDate()) < 0) {
            validationMessages.add(this.messages.pricingTabToDateBeforeFrom(type, i + 1));
        }
        if (this.getLicense().getEffectiveDate() != null && this.getLicense().getExpiryDate() != null && rp1.getToDate() != null && rp1.getFromDate() != null) {
            if (this.getLicense().getEffectiveDate().compareTo(rp1.getFromDate()) > 0) {
                validationMessages.add(this.messages.pricingTabLicenseEffectiveAfterFromDate(type, i + 1, this.getLicense().getEffectiveDate()));
            }
            if (this.getLicense().getExpiryDate().compareTo(rp1.getToDate()) < 0) {
                validationMessages.add(this.messages.pricingTabLicenseExpiryBeforeToDate(type, i + 1, this.getLicense().getExpiryDate()));
            }
        }
    }

    @Override
    public void fillForm() {
        this.formContainer.clearAllValidationErrors();
        this.licenseFormContainer.clearAllValidationErrors();
        this.paymentFormContainer.clearAllValidationErrors();
        this.tieredPricingContainer.clearAllValidationErrors();
        this.revenueShareFormContainer.clearAllValidationErrors();
        this.removeAllRows(this.tablePricing, this.tieredPricingList);
        this.removeAllRows(this.tableShare, this.revenueList);
        this.installmentPlanText.setEnabled(false);
        this.fillRadioValues(this.installmentPlanYes, this.installmentPlanNo, this.currentTreeObject.getPrInstallmentPlanRequired());
        if (this.currentTreeObject.getPrInstallmentPlanRequired().booleanValue()) {
            this.installmentPlanText.setEnabled(true);
        }
        this.overageRequired.setEnabled(false);
        this.fillRadioValues(this.paymentScheduleRequiredYes, this.paymentScheduleRequiredNo, this.currentTreeObject.getPrOverageRequired());
        if (this.currentTreeObject.getPrOverageRequired().booleanValue()) {
            this.overageRequired.setEnabled(true);
        }
        this.fillRadioValues(this.revenueShareRequiredYes, this.revenueShareRequiredNo, this.currentTreeObject.getPrRevenueShareRequired());
        if (this.currentTreeObject.getPrRevenueShareRequired() != null && this.currentTreeObject.getPrRevenueShareRequired().booleanValue()) {
            this.enableRevenueShareTable();
        } else {
            this.disableRevenueShareTable();
        }
        this.fillRadioValues(this.tieredPricingRequiredYes, this.tieredPricingRequiredNo, this.currentTreeObject.getPrTieredPricingRequired());
        if (this.currentTreeObject.getPrTieredPricingRequired() != null && this.currentTreeObject.getPrTieredPricingRequired().booleanValue()) {
            this.enableTieredPricingTable();
        } else {
            this.disableTieredPricingTable();
        }
        this.upfrontPaymentRequired.setEnabled(false);
        this.fillRadioValues(this.upfrontPaymentRequiredYes, this.upfrontPaymentRequiredNo, this.currentTreeObject.getPrUpfrontPaymentRequired());
        if (this.currentTreeObject.getPrUpfrontPaymentRequired() != null && this.currentTreeObject.getPrUpfrontPaymentRequired().booleanValue()) {
            this.upfrontPaymentRequired.setEnabled(true);
        }
        this.actualLicenseFee.setTextValue(this.currentTreeObject.getPrActualLicenseFee());
        this.actualRetailPrice.setTextValue(this.currentTreeObject.getPrActualRetailPrice());
        this.deemedRetailPrice.setTextValue(this.currentTreeObject.getPrDeemedRetailPrice());
        this.buyRate.setTextValue(this.currentTreeObject.getPrGuaranteedBuyRate());
        if (this.currentTreeObject.getPrGuaranteedSubscribers() != null) {
            this.subscribers.setValue((Object)this.currentTreeObject.getPrGuaranteedSubscribers().intValue());
        } else {
            this.subscribers.setValue(null);
        }
        this.installmentPlanText.setTextValue(this.currentTreeObject.getPrInstallmentPlan());
        this.lostBuys.setTextValue(this.currentTreeObject.getPrLostBuys());
        this.minimumLicenseFee.setTextValue(this.currentTreeObject.getPrMinimumLicenseFee());
        this.overageRequired.setTextValue(this.currentTreeObject.getPrOverage());
        this.revenueShare.setTextValue(this.currentTreeObject.getPrRevenueShare());
        this.upfrontPaymentRequired.setTextValue(this.currentTreeObject.getPrUpfrontPayment());
        this.fillTypedList(this.paymentCurrency);
        if (this.currentTreeObject.getPrCurrency() != null) {
            this.paymentCurrency.setSelectedItem((Object)this.currentTreeObject.getPrCurrency().getKey());
        } else {
            this.paymentCurrency.setSelectedItem(null);
        }
        if (this.currentTreeObject.getRevenueSharedList() != null) {
            this.revenueList.clear();
            this.revenueList.addAll(this.currentTreeObject.getRevenueSharedList());
            for (UiRevenuePricing revenue : this.revenueList) {
                this.addRow(this.tableShare, revenue, false, this.revenueList);
            }
        }
        if (this.currentTreeObject.getTieredPricingList() != null) {
            this.tieredPricingList.clear();
            this.tieredPricingList.addAll(this.currentTreeObject.getTieredPricingList());
            for (UiRevenuePricing revenue : this.tieredPricingList) {
                this.addRow(this.tablePricing, revenue, true, this.tieredPricingList);
            }
        }
        this.updateFormFromUserDefinedFieldValues(this.currentTreeObject.getUserDefinedFieldValues());
    }

    private void fillTypedList(TypedListBoxWidget<Long> widget) {
        widget.clear();
        widget.addItem("", null);
        if (this.currencyList != null) {
            for (UiCurrency cur : this.currencyList) {
                widget.addItem(String.valueOf(cur.getName()) + " (" + cur.getSymbol() + ")", (Object)cur.getKey());
            }
        }
    }

    @Override
    public void commit() {
        this.currentTreeObject.setModified(true);
        this.currentTreeObject.setPrActualLicenseFee((String)this.actualLicenseFee.getValue());
        this.currentTreeObject.setPrActualRetailPrice((String)this.actualRetailPrice.getValue());
        this.currentTreeObject.setPrCurrency(this.getCurrency((Long)this.paymentCurrency.getSelectedItem()));
        this.currentTreeObject.setPrDeemedRetailPrice((String)this.deemedRetailPrice.getValue());
        this.currentTreeObject.setPrGuaranteedBuyRate((String)this.buyRate.getValue());
        if (this.subscribers.getValue() != null) {
            this.currentTreeObject.setPrGuaranteedSubscribers(((Integer)this.subscribers.getValue()).longValue());
        } else {
            this.currentTreeObject.setPrGuaranteedSubscribers(null);
        }
        this.currentTreeObject.setPrInstallmentPlan((String)this.installmentPlanText.getValue());
        if (this.installmentPlanNo.getValue().booleanValue()) {
            this.currentTreeObject.setPrInstallmentPlan(null);
        }
        this.currentTreeObject.setPrInstallmentPlanRequired(this.installmentPlanYes.getValue());
        this.currentTreeObject.setPrLostBuys((String)this.lostBuys.getValue());
        this.currentTreeObject.setPrMinimumLicenseFee((String)this.minimumLicenseFee.getValue());
        this.currentTreeObject.setPrOverage((String)this.overageRequired.getValue());
        if (this.paymentScheduleRequiredNo.getValue().booleanValue()) {
            this.currentTreeObject.setPrOverage(null);
        }
        this.currentTreeObject.setPrOverageRequired(this.paymentScheduleRequiredYes.getValue());
        this.currentTreeObject.setPrRevenueShare((String)this.revenueShare.getValue());
        this.currentTreeObject.setPrRevenueShareRequired(this.revenueShareRequiredYes.getValue());
        this.currentTreeObject.setPrTieredPricingRequired(this.tieredPricingRequiredYes.getValue());
        this.currentTreeObject.setPrUpfrontPayment((String)this.upfrontPaymentRequired.getValue());
        if (this.upfrontPaymentRequiredNo.getValue().booleanValue()) {
            this.currentTreeObject.setPrUpfrontPayment(null);
        }
        this.currentTreeObject.setPrUpfrontPaymentRequired(this.upfrontPaymentRequiredYes.getValue());
        this.updateUserDefinedFieldsValuesFromForm(this.currentTreeObject.getUserDefinedFieldValues());
        this.currentTreeObject.getTieredPricingList().clear();
        this.currentTreeObject.getTieredPricingList().addAll(this.tieredPricingList);
        this.currentTreeObject.getRevenueSharedList().clear();
        this.currentTreeObject.getRevenueSharedList().addAll(this.revenueList);
        this.overrideChildrenValues();
    }

    private UiCurrency getCurrency(Long key) {
        if (key != null) {
            for (UiCurrency currency : this.currencyList) {
                if (!currency.getKey().equals(key)) continue;
                return currency;
            }
        }
        return null;
    }

    private void overrideChildrenValues() {
        if (this.currentTreeObject != null) {
            for (UiLicenseDetails licenseDetails : this.currentTreeObject.getAllChildren()) {
                licenseDetails.setModified(true);
                LicenseDetailsUtils.copyPricingValues(this.currentTreeObject, licenseDetails);
                this.copyUserDefinedFieldValues(licenseDetails.getUserDefinedFieldValues());
            }
        }
    }
}

