/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.license.tab;

import com.ericsson.cms.contractmgmt.client.customfield.CustomFieldFactory;
import com.ericsson.cms.contractmgmt.client.customfield.UiUserDefinedField;
import com.ericsson.cms.contractmgmt.client.model.UiKeyName;
import com.ericsson.cms.contractmgmt.client.model.UiKeyNames;
import com.ericsson.cms.contractmgmt.client.model.UiLanguage;
import com.ericsson.cms.contractmgmt.client.model.UiLicense;
import com.ericsson.cms.contractmgmt.client.model.UiLicenseDetails;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownServiceAsync;
import com.ericsson.cms.contractmgmt.client.tab.ContractFormContainer;
import com.ericsson.cms.contractmgmt.client.tab.config.configurablefield.ConfigurableFieldTypeEnum;
import com.ericsson.cms.contractmgmt.client.tab.license.AbstractLicenseTab;
import com.ericsson.cms.contractmgmt.client.tab.license.LicenseDetailView;
import com.ericsson.cms.contractmgmt.client.tab.license.tab.LicenseDetailsUtils;
import com.ericsson.cms.contractmgmt.client.tab.license.tab.TabValueChangeHandler;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.RadioButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.RoundedDisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedDateBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.DateConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IDateConverter;
import java.util.ArrayList;
import java.util.List;

public class StorageMetadataTab
extends AbstractLicenseTab {
    private final IContractManagerDropDownServiceAsync contractManagerDropDownService = (IContractManagerDropDownServiceAsync)GWT.create(IContractManagerDropDownService.class);
    private static final int VISIBLE_LENGTH = 10;
    private ListBoxWidget<Long> language;
    private final ContractFormContainer formContainer = new ContractFormContainer(HasHorizontalAlignment.ALIGN_LEFT);
    private final ContractFormContainer formUserDefinedFields = new ContractFormContainer(HasHorizontalAlignment.ALIGN_LEFT);
    private RadioButtonWidget posterArtRequiredYes;
    private RadioButtonWidget posterArtRequiredNo;
    private RadioButtonWidget previewRequiredYes;
    private RadioButtonWidget previewRequiredNo;
    private RadioButtonWidget inheritFromDeal1;
    private RadioButtonWidget specify1;
    private RadioButtonWidget inheritFromDeal2;
    private RadioButtonWidget specify2;
    private final TypedDateBoxWidget contentEffectiveDate = new TypedDateBoxWidget((IDateConverter)new DateConverter(this.constants.dateFormat(), this.constants.dateFormat()));
    private final TypedDateBoxWidget contentExpiryDate = new TypedDateBoxWidget((IDateConverter)new DateConverter(this.constants.dateFormat(), this.constants.dateFormat()));

    public StorageMetadataTab(UiLicense license, final LicenseDetailView detailView) {
        super(license, detailView);
        this.busyIndicator.center();
        this.init();
        this.contractManagerDropDownService.getGenericDropDownKeyNameList(0, 0, "", true, ConfigurableFieldTypeEnum.Language, (AsyncCallback<UiKeyNames>)new NeptuneAsyncCallback<UiKeyNames>(){

            public void onNeptuneFailure(Throwable caught) {
                detailView.getErrorPanel().showMessage(caught.getLocalizedMessage());
                StorageMetadataTab.this.busyIndicator.hide();
            }

            public void onNeptuneSuccess(UiKeyNames result) {
                for (UiKeyName ui : result.getRecords()) {
                    StorageMetadataTab.this.language.addItem(ui.getName(), (Object)ui.getKey());
                }
                StorageMetadataTab.this.fillForm();
                StorageMetadataTab.this.busyIndicator.hide();
            }
        });
    }

    private void init() {
        DateTimeFormat.getFormat((String)this.constants.dateFormat());
        this.language = new ListBoxWidget(true);
        this.language.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                StorageMetadataTab.this.setChanged(true);
            }
        });
        this.language.setWidth("190px");
        this.language.ensureDebugId("license-language");
        this.posterArtRequiredYes = new RadioButtonWidget("posterArt", this.constants.yes());
        this.posterArtRequiredYes.addValueChangeHandler(new TabValueChangeHandler(this));
        this.posterArtRequiredYes.ensureDebugId("license-posterArtRequiredYes");
        this.posterArtRequiredNo = new RadioButtonWidget("posterArt", this.constants.no());
        this.posterArtRequiredNo.addValueChangeHandler(new TabValueChangeHandler(this));
        this.posterArtRequiredNo.ensureDebugId("license-posterArtRequiredNo");
        HorizontalContainer posterArtRequired = this.createRadioContainer(this.posterArtRequiredYes, this.posterArtRequiredNo);
        this.previewRequiredYes = new RadioButtonWidget("preview", this.constants.yes());
        this.previewRequiredYes.addValueChangeHandler(new TabValueChangeHandler(this));
        this.previewRequiredYes.ensureDebugId("license-previewRequiredYes");
        this.previewRequiredNo = new RadioButtonWidget("preview", this.constants.no());
        this.previewRequiredNo.addValueChangeHandler(new TabValueChangeHandler(this));
        this.previewRequiredNo.ensureDebugId("license-previewRequiredNo");
        HorizontalContainer previewRequired = this.createRadioContainer(this.previewRequiredYes, this.previewRequiredNo);
        this.contentEffectiveDate.addValueChangeHandler(new TabValueChangeHandler(this));
        this.configureDateBox(this.contentEffectiveDate);
        this.contentEffectiveDate.setEnabled(false);
        this.contentEffectiveDate.ensureDebugId("license-contentEffectiveDate");
        if (this.getLicense().getEffectiveDate() != null) {
            this.contentEffectiveDate.setValue(this.getLicense().getEffectiveDate());
        }
        this.inheritFromDeal1 = new RadioButtonWidget("effective", this.constants.storageInheritLicense());
        this.inheritFromDeal1.addValueChangeHandler(new TabValueChangeHandler(this));
        this.inheritFromDeal1.setValue(Boolean.valueOf(true));
        this.inheritFromDeal1.ensureDebugId("license-inheritFromLicense1");
        this.inheritFromDeal1.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                StorageMetadataTab.this.contentEffectiveDate.setValue(StorageMetadataTab.this.getLicense().getEffectiveDate());
                StorageMetadataTab.this.contentEffectiveDate.setEnabled(false);
            }
        });
        this.specify1 = new RadioButtonWidget("effective", this.constants.specify());
        this.specify1.ensureDebugId("license-specify1");
        this.specify1.addValueChangeHandler(new TabValueChangeHandler(this));
        this.specify1.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                StorageMetadataTab.this.contentEffectiveDate.setEnabled(true);
                StorageMetadataTab.this.contentEffectiveDate.setFocus(true);
            }
        });
        HorizontalContainer effective = this.createRadioContainer(this.inheritFromDeal1, this.specify1);
        this.specify1.setValue(Boolean.valueOf(false));
        this.addSpace(effective);
        effective.add((Widget)this.contentEffectiveDate);
        this.contentExpiryDate.addValueChangeHandler(new TabValueChangeHandler(this));
        this.configureDateBox(this.contentExpiryDate);
        this.contentExpiryDate.setEnabled(false);
        this.contentExpiryDate.ensureDebugId("license-contentExpiryDate");
        if (this.getLicense().getExpiryDate() != null) {
            this.contentExpiryDate.setValue(this.getLicense().getExpiryDate());
        }
        this.inheritFromDeal2 = new RadioButtonWidget("expiry", this.constants.storageInheritLicense());
        this.inheritFromDeal2.addValueChangeHandler(new TabValueChangeHandler(this));
        this.inheritFromDeal2.setValue(Boolean.valueOf(true));
        this.inheritFromDeal2.ensureDebugId("license-inheritFromLicense2");
        this.inheritFromDeal2.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                StorageMetadataTab.this.contentExpiryDate.setValue(StorageMetadataTab.this.getLicense().getExpiryDate());
                StorageMetadataTab.this.contentExpiryDate.setEnabled(false);
            }
        });
        this.specify2 = new RadioButtonWidget("expiry", this.constants.specify());
        this.specify2.ensureDebugId("license-specify2");
        this.specify2.addValueChangeHandler(new TabValueChangeHandler(this));
        this.specify2.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                StorageMetadataTab.this.contentExpiryDate.setEnabled(true);
                StorageMetadataTab.this.contentExpiryDate.setFocus(true);
            }
        });
        HorizontalContainer expiry = this.createRadioContainer(this.inheritFromDeal2, this.specify2);
        this.specify2.setValue(Boolean.valueOf(false));
        this.addSpace(expiry);
        expiry.add((Widget)this.contentExpiryDate);
        this.formContainer.addRow(this.constants.storageLanguageColumn(), (Widget)this.language, true);
        this.formContainer.addRow(this.constants.storagePosterArtRequiredColumn(), (Widget)posterArtRequired, true);
        this.formContainer.addRow(this.constants.storagePreviewRequiredColumn(), (Widget)previewRequired, true);
        this.formContainer.addRow(this.constants.storageEffectiveDateColumn(), (Widget)effective, true);
        this.formContainer.addRow(this.constants.storageExpiryDateColumn(), (Widget)expiry, true);
        this.contentPanel.add((Widget)this.formContainer);
        CustomFieldFactory factory = new CustomFieldFactory(this);
        List<UiUserDefinedField> userDefinedFields = this.getLicense().getUserDefinedFields("STORAGE_METADATA");
        factory.addFieldsToForm(this.formUserDefinedFields, userDefinedFields, this.widgetCustomFieldMap);
        RoundedDisclosureContainer userDefinedFieldsContainer = new RoundedDisclosureContainer(this.constants.userDefinedFields());
        userDefinedFieldsContainer.add((Widget)this.formUserDefinedFields);
        userDefinedFieldsContainer.setOpen(false);
        this.contentPanel.add((Widget)userDefinedFieldsContainer);
    }

    private void configureDateBox(TypedDateBoxWidget dateBox) {
        dateBox.getTextBox().setMaxLength(10);
        dateBox.getTextBox().setVisibleLength(10);
        dateBox.setToolTip(String.valueOf(this.constants.validDateTitle()) + " " + this.constants.dateFormat());
        dateBox.setErrorToolTip(String.valueOf(this.constants.validDateTitle()) + " " + this.constants.dateFormat());
    }

    private HorizontalContainer createRadioContainer(RadioButtonWidget radio1, RadioButtonWidget radio2) {
        HorizontalContainer container = new HorizontalContainer();
        container.add((Widget)radio1);
        this.addSpace(container);
        radio2.setValue(Boolean.valueOf(true));
        container.add((Widget)radio2);
        return container;
    }

    private void addSpace(HorizontalContainer container) {
        if (container != null) {
            HorizontalPanel space = new HorizontalPanel();
            LabelWidget label = new LabelWidget();
            space.add((Widget)label);
            space.setCellWidth((Widget)label, "10");
            container.add((Widget)space);
        }
    }

    private void fillRadioValues(RadioButtonWidget radio1, RadioButtonWidget radio2, Boolean value) {
        if (value != null && value.booleanValue()) {
            radio1.setValue(Boolean.valueOf(true));
            radio2.setValue(Boolean.valueOf(false));
        } else {
            radio1.setValue(Boolean.valueOf(false));
            radio2.setValue(Boolean.valueOf(true));
        }
    }

    @Override
    public String getName() {
        return "STORAGE_METADATA";
    }

    @Override
    public String getDisplayName() {
        return this.constants.storageTabDisplayName();
    }

    @Override
    public void commit() {
        this.currentTreeObject.setModified(true);
        if (this.specify1.getValue().booleanValue()) {
            this.currentTreeObject.setSmEffectiveDate(this.contentEffectiveDate.getTextValue());
        } else {
            this.currentTreeObject.setSmEffectiveDate(this.getLicense().getEffectiveDate());
        }
        if (this.specify2.getValue().booleanValue()) {
            this.currentTreeObject.setSmExpiryDate(this.contentExpiryDate.getTextValue());
        } else {
            this.currentTreeObject.setSmExpiryDate(this.getLicense().getExpiryDate());
        }
        this.currentTreeObject.getLanguageList().clear();
        this.currentTreeObject.getLanguageList().addAll(this.createSelectedLanguageList());
        this.currentTreeObject.setSmPosterArtRequired(this.posterArtRequiredYes.getValue());
        this.currentTreeObject.setSmPreviewRequired(this.previewRequiredYes.getValue());
        this.updateUserDefinedFieldsValuesFromForm(this.currentTreeObject.getUserDefinedFieldValues());
        this.overrideChildrenValues();
    }

    private List<UiLanguage> createSelectedLanguageList() {
        ArrayList<UiLanguage> languageList = new ArrayList<UiLanguage>();
        int i = 0;
        while (i < this.language.getItemCount()) {
            if (this.language.isItemSelected(i)) {
                UiLanguage uiLanguage = new UiLanguage();
                uiLanguage.setKey((Long)this.language.getItem(i));
                uiLanguage.setName(this.language.getItemText(i));
                languageList.add(uiLanguage);
            }
            ++i;
        }
        return languageList;
    }

    @Override
    public void fillForm() {
        this.formContainer.clearAllValidationErrors();
        this.fillRadioValues(this.posterArtRequiredYes, this.posterArtRequiredNo, this.currentTreeObject.getSmPosterArtRequired());
        this.fillRadioValues(this.previewRequiredYes, this.previewRequiredNo, this.currentTreeObject.getSmPreviewRequired());
        int i = 0;
        while (i < this.language.getItemCount()) {
            this.language.setItemSelected(i, false);
            ++i;
        }
        for (UiLanguage ui : this.currentTreeObject.getLanguageList()) {
            this.language.setItemSelected(this.language.getIndex((Object)ui.getKey()), true);
        }
        if (this.currentTreeObject.getSmEffectiveDate() != null) {
            if (this.currentTreeObject.getSmEffectiveDate().equals(this.getLicense().getEffectiveDate())) {
                this.inheritFromDeal1.setValue(Boolean.valueOf(true));
                this.contentEffectiveDate.setValue(this.getLicense().getEffectiveDate());
                this.contentEffectiveDate.setEnabled(false);
            } else {
                this.specify1.setValue(Boolean.valueOf(true));
                this.contentEffectiveDate.setEnabled(true);
                this.contentEffectiveDate.setValue(this.currentTreeObject.getSmEffectiveDate());
            }
        } else {
            this.contentEffectiveDate.setValue(this.getLicense().getEffectiveDate());
            this.contentEffectiveDate.setEnabled(false);
        }
        if (this.currentTreeObject.getSmExpiryDate() != null) {
            if (this.currentTreeObject.getSmExpiryDate().equals(this.getLicense().getExpiryDate())) {
                this.inheritFromDeal2.setValue(Boolean.valueOf(true));
                this.contentExpiryDate.setValue(this.getLicense().getExpiryDate());
                this.contentExpiryDate.setEnabled(false);
            } else {
                this.specify2.setValue(Boolean.valueOf(true));
                this.contentExpiryDate.setEnabled(true);
                this.contentExpiryDate.setValue(this.currentTreeObject.getSmExpiryDate());
            }
        } else {
            this.contentExpiryDate.setValue(this.getLicense().getExpiryDate());
            this.contentExpiryDate.setEnabled(false);
        }
        this.updateFormFromUserDefinedFieldValues(this.currentTreeObject.getUserDefinedFieldValues());
    }

    @Override
    public void validate() throws ValidationException {
        String expiry;
        String effective;
        ArrayList<String> validationMessages = new ArrayList<String>();
        if (!this.formContainer.validate()) {
            validationMessages.add(this.messages.formHasValidationErrors());
        }
        if (!this.formUserDefinedFields.validate()) {
            validationMessages.add(this.messages.formHasValidationErrors());
        }
        if (this.specify1.getValue().booleanValue() && this.contentEffectiveDate.getTextValue() != null && !this.contentEffectiveDate.getTextValue().isEmpty() && !(effective = this.contentEffectiveDate.getTextValue()).equals(this.getLicense().getEffectiveDate()) && effective.compareTo(this.getLicense().getEffectiveDate()) < 0) {
            validationMessages.add(this.messages.storageDateMessage(this.constants.storageEffectiveDateColumn()));
        }
        if (this.specify2.getValue().booleanValue() && this.contentExpiryDate.getTextValue() != null && !this.contentExpiryDate.getTextValue().isEmpty() && !(expiry = this.contentExpiryDate.getTextValue()).equals(this.getLicense().getExpiryDate()) && expiry.compareTo(this.getLicense().getExpiryDate()) > 0) {
            validationMessages.add(this.messages.storageDateMessage(this.constants.storageExpiryDateColumn()));
        }
        this.validateCustomFields(validationMessages);
        if (!validationMessages.isEmpty()) {
            throw new ValidationException(validationMessages);
        }
    }

    private void overrideChildrenValues() {
        if (this.currentTreeObject != null) {
            for (UiLicenseDetails licenseDetails : this.currentTreeObject.getAllChildren()) {
                licenseDetails.setModified(true);
                LicenseDetailsUtils.copyStorageMetadataValues(this.currentTreeObject, licenseDetails);
                this.copyUserDefinedFieldValues(licenseDetails.getUserDefinedFieldValues());
            }
        }
    }
}

