/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.license.tree;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.ContractComponentMessages;
import com.ericsson.cms.contractmgmt.client.model.UiLicenseDetails;
import com.ericsson.cms.contractmgmt.client.tab.license.tree.TreeListener;
import com.ericsson.cms.contractmgmt.client.tab.license.tree.TreeResource;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TreeWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DeviceTree
extends TreeWidget {
    private static final String STYLE_NAME = "contract-DeviceTree";
    private static final String STYLE_ITEM = "contract-DeviceTree-item";
    private static final String STYLE_ITEM_DISABLED = "contract-DeviceTree-item-disabled";
    private final Map<String, TreeItem> deliveryLocationMap = new HashMap<String, TreeItem>();
    private final Map<String, TreeItem> platformMap = new HashMap<String, TreeItem>();
    private final Map<String, TreeItem> deviceMap = new HashMap<String, TreeItem>();
    private TreeItem currentSelectedTreeItem;
    protected ContractComponentConstants constants = (ContractComponentConstants)GWT.create(ContractComponentConstants.class);
    protected ContractComponentMessages messages = (ContractComponentMessages)GWT.create(ContractComponentMessages.class);

    public DeviceTree(List<UiLicenseDetails> licenseDetailsList, UiLicenseDetails defaultLicenseDetails, final TreeListener treeListener) {
        super((Tree.Resources)new TreeResource());
        this.addStyleName(STYLE_NAME);
        this.addSelectionHandler((SelectionHandler)new SelectionHandler<TreeItem>(){

            public void onSelection(SelectionEvent<TreeItem> event) {
                if (treeListener != null) {
                    Object userObject = ((TreeItem)event.getSelectedItem()).getUserObject();
                    if (userObject != null) {
                        treeListener.nodeSelected((UiLicenseDetails)userObject);
                        DeviceTree.this.currentSelectedTreeItem = (TreeItem)event.getSelectedItem();
                    } else if (DeviceTree.this.currentSelectedTreeItem != null) {
                        DeviceTree.this.setSelectedItem(DeviceTree.this.currentSelectedTreeItem);
                    }
                }
            }
        });
        this.addTreeItems(licenseDetailsList, defaultLicenseDetails);
        Iterator iterator = this.treeItemIterator();
        while (iterator.hasNext()) {
            TreeItem item = (TreeItem)iterator.next();
            item.setState(true);
        }
    }

    private void addTreeItems(List<UiLicenseDetails> licenseDetails, UiLicenseDetails defaultLicenseDetails) {
        TreeItem platformTreeItem;
        UiLicenseDetails parent;
        TreeItem locationTreeItem;
        for (UiLicenseDetails ld : licenseDetails) {
            if (ld.getDeliveryLocation() == null || ld.getPlatform() != null || ld.getDevice() != null) continue;
            locationTreeItem = this.createDeliveryLocationNode(ld);
            this.deliveryLocationMap.put(ld.getDeliveryLocation().getName(), locationTreeItem);
            defaultLicenseDetails.addChild(ld);
        }
        for (UiLicenseDetails ld : licenseDetails) {
            if (ld.getDeliveryLocation() == null || ld.getPlatform() == null || ld.getDevice() != null || (locationTreeItem = this.deliveryLocationMap.get(ld.getDeliveryLocation().getName())) == null) continue;
            TreeItem platformTreeItem2 = this.createPlatformNode(locationTreeItem, ld);
            this.platformMap.put(String.valueOf(ld.getDeliveryLocation().getName()) + "-" + ld.getPlatform().getKey(), platformTreeItem2);
            parent = (UiLicenseDetails)locationTreeItem.getUserObject();
            parent.addChild(ld);
        }
        for (UiLicenseDetails ld : licenseDetails) {
            if (ld.getDeliveryLocation() == null || ld.getPlatform() == null || ld.getDevice() == null || (platformTreeItem = this.platformMap.get(String.valueOf(ld.getDeliveryLocation().getName()) + "-" + ld.getPlatform().getKey())) == null) continue;
            TreeItem deviceTreeItem = this.createDeviceNode(platformTreeItem, ld);
            this.deviceMap.put(String.valueOf(ld.getDeliveryLocation().getName()) + "-" + ld.getPlatform().getKey() + "-" + ld.getDevice().getKey(), deviceTreeItem);
            parent = (UiLicenseDetails)platformTreeItem.getUserObject();
            parent.addChild(ld);
        }
        for (UiLicenseDetails ld : licenseDetails) {
            if (ld.getDeliveryLocation() == null || ld.getPlatform() != null || ld.getDevice() != null || (locationTreeItem = this.deliveryLocationMap.get(ld.getDeliveryLocation().getName())) == null || !ld.getAllChildren().isEmpty()) continue;
            this.addAllNode(locationTreeItem, this.constants.allPlatform());
            this.addAllNode(locationTreeItem.getChild(locationTreeItem.getChildCount() - 1), this.constants.allDevices());
        }
        for (UiLicenseDetails ld : licenseDetails) {
            if (ld.getDeliveryLocation() == null || ld.getPlatform() == null || ld.getDevice() != null || (platformTreeItem = this.platformMap.get(String.valueOf(ld.getDeliveryLocation().getName()) + "-" + ld.getPlatform().getKey())) == null || !ld.getAllChildren().isEmpty()) continue;
            this.addAllNode(platformTreeItem);
        }
    }

    private void addAllNode(TreeItem platformTreeItem) {
        TreeItem allNode = new TreeItem(this.buildTreeItemWidget(this.constants.allDevices(), true));
        allNode.setText(this.constants.allDevices());
        platformTreeItem.addItem(allNode);
    }

    private void addAllNode(TreeItem treeItem, String label) {
        TreeItem allNode = new TreeItem(this.buildTreeItemWidget(label, true));
        allNode.setText(label);
        treeItem.addItem(allNode);
    }

    public TreeItem createDeliveryLocationNode(UiLicenseDetails licenseDetails) {
        TreeItem locationTreeItem = new TreeItem(this.buildTreeItemWidget(licenseDetails.getDeliveryLocation().getName(), false));
        locationTreeItem.setText(licenseDetails.getDeliveryLocation().getName());
        locationTreeItem.setUserObject((Object)licenseDetails);
        this.addItem(locationTreeItem);
        return locationTreeItem;
    }

    private TreeItem createPlatformNode(TreeItem locationTreeItem, UiLicenseDetails licenseDetails) {
        TreeItem platformTreeItem = new TreeItem(this.buildTreeItemWidget(licenseDetails.getPlatform().getName(), false));
        platformTreeItem.setText(licenseDetails.getPlatform().getName());
        platformTreeItem.setUserObject((Object)licenseDetails);
        locationTreeItem.addItem(platformTreeItem);
        return platformTreeItem;
    }

    private TreeItem createDeviceNode(TreeItem platformTreeItem, UiLicenseDetails licenseDetails) {
        TreeItem deviceTreeItem = new TreeItem(this.buildTreeItemWidget(licenseDetails.getDevice().getName(), false));
        deviceTreeItem.setText(licenseDetails.getDevice().getName());
        deviceTreeItem.setUserObject((Object)licenseDetails);
        platformTreeItem.addItem(deviceTreeItem);
        return deviceTreeItem;
    }

    public Widget buildTreeItemWidget(String name, boolean disabled) {
        HorizontalContainer container = new HorizontalContainer();
        if (!disabled) {
            container.addStyleName(STYLE_ITEM);
        } else {
            container.addStyleName(STYLE_ITEM_DISABLED);
        }
        container.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        LabelWidget label = new LabelWidget(name);
        container.add((Widget)label);
        return container;
    }

    public void selectNone() {
        TreeItem selectedItem = this.getSelectedItem();
        if (selectedItem != null) {
            selectedItem.setSelected(false);
        }
    }
}

