/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.tab.license.tree;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.ContractComponentMessages;
import com.ericsson.cms.contractmgmt.client.HelpWidget;
import com.ericsson.cms.contractmgmt.client.model.UiLicense;
import com.ericsson.cms.contractmgmt.client.model.UiLicenseDetails;
import com.ericsson.cms.contractmgmt.client.tab.license.tree.DeviceTree;
import com.ericsson.cms.contractmgmt.client.tab.license.tree.TreeListener;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.Iterator;

public class DeviceTreePanel
extends VerticalContainer {
    private final LabelWidget defaultLabel;
    private final HorizontalContainer defaultContainer;
    private DeviceTree deviceTree;
    private final UiLicense license;
    protected ContractComponentConstants constants = (ContractComponentConstants)GWT.create(ContractComponentConstants.class);
    protected ContractComponentMessages messages = (ContractComponentMessages)GWT.create(ContractComponentMessages.class);

    public DeviceTreePanel(final UiLicense license, final TreeListener treeListener) {
        this.license = license;
        this.deviceTree = this.createDeviceTree(license, treeListener);
        this.defaultLabel = new LabelWidget(this.constants.treeDefaultNode());
        this.defaultContainer = new HorizontalContainer();
        this.defaultContainer.add((Widget)this.defaultLabel);
        this.defaultContainer.setCellWidth((Widget)this.defaultLabel, "5%");
        this.defaultLabel.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                treeListener.nodeSelected(license.getDefaultLicenseDetails());
                DeviceTreePanel.this.deviceTree.selectNone();
                DeviceTreePanel.this.setDefaultSelected(true);
            }
        });
        LabelWidget spaceLabel = new LabelWidget("");
        this.defaultContainer.add((Widget)spaceLabel);
        this.defaultContainer.setCellWidth((Widget)spaceLabel, "5px");
        this.defaultContainer.add((Widget)new HelpWidget(this.messages.treeDefaultNodeWarning()));
        this.add((Widget)this.defaultContainer);
        ScrollPanel sp = new ScrollPanel();
        sp.setAlwaysShowScrollBars(false);
        sp.add((Widget)this.deviceTree);
        this.add((Widget)sp);
        this.setDefaultSelected(true);
    }

    private DeviceTree createDeviceTree(UiLicense license, TreeListener treeListener) {
        DeviceTree device = new DeviceTree(license.getLicenseDetailsList(), license.getDefaultLicenseDetails(), treeListener);
        device.addSelectionHandler((SelectionHandler)new SelectionHandler<TreeItem>(){

            public void onSelection(SelectionEvent<TreeItem> event) {
                DeviceTreePanel.this.setDefaultSelected(false);
            }
        });
        return device;
    }

    public void updateModifiedItems() {
        if (this.license.getDefaultLicenseDetails().isModified().booleanValue()) {
            this.defaultLabel.setText(String.valueOf(this.constants.treeDefaultNode()) + "*");
        } else {
            this.defaultLabel.setText(this.constants.treeDefaultNode());
        }
        Iterator iterator = this.deviceTree.treeItemIterator();
        while (iterator.hasNext()) {
            TreeItem treeItem = (TreeItem)iterator.next();
            String name = treeItem.getText();
            boolean disabled = false;
            UiLicenseDetails licenseDetails = (UiLicenseDetails)treeItem.getUserObject();
            if (licenseDetails != null) {
                if (licenseDetails.isModified().booleanValue() && name.lastIndexOf("*") != name.length() - 1) {
                    name = String.valueOf(name) + "*";
                }
            } else {
                disabled = true;
            }
            treeItem.setWidget(this.deviceTree.buildTreeItemWidget(name, disabled));
        }
    }

    public void setDefaultSelected(boolean selected) {
        if (selected) {
            this.defaultContainer.setStyleName("contract-DeviceTree-item-default-selected");
        } else {
            this.defaultContainer.setStyleName("contract-DeviceTree-item-default");
        }
    }
}

