/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.table;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.ContractComponentMessages;
import com.ericsson.cms.contractmgmt.client.table.EditableTablePager;
import com.ericsson.cms.contractmgmt.client.table.EditableTableResources;
import com.google.gwt.cell.client.ButtonCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.cellview.client.AbstractHeaderOrFooterBuilder;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListDataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.DisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractEditableTable<T>
extends Composite {
    private static final String STYLE_NAME = "content-EditableTable";
    private static final String DELETE_STYLE_NAME = "editable-table-cell-body-delete";
    private static final String TITLE_STYLE_NAME = "editable-table-title";
    private static final String BUTTON_ROW_STYLE_NAME = "editable-table-button-row";
    private static final String DELETE_IMG_URL = "cms_contractmgmt_ui/images/delete.png";
    private static final int DEFAULT_PAGE_SIZE = 5;
    private static final String DEFAULT_RECORD_DISPLAY_NAME = "Value";
    private String recordDisplayName = "Value";
    protected ListDataProvider<T> dataProvider;
    protected CellTable<T> cellTable;
    private HorizontalContainer buttonRow;
    protected EditableTablePager<T> pager;
    private VerticalContainer mainContainer;
    private HeaderPanel headerContainer;
    private VerticalContainer tableContainer = new VerticalContainer();
    private DisclosureContainer discContainer;
    private String headerText = null;
    protected List<T> recordList = new ArrayList<T>();
    private boolean dirty;
    private ClearMessagesCallback clearMessagesCallback;
    protected final ContractComponentConstants constants = (ContractComponentConstants)GWT.create(ContractComponentConstants.class);
    private final ContractComponentMessages messages = (ContractComponentMessages)GWT.create(ContractComponentMessages.class);
    private static final int SPACING = 2;

    public AbstractEditableTable(String title, String recordDisplayName) {
        this(title, recordDisplayName, false);
    }

    public AbstractEditableTable(String title, String recordDisplayName, boolean subField) {
        this.recordList = new ArrayList<T>();
        this.headerText = title;
        this.recordDisplayName = recordDisplayName;
        if (subField) {
            this.discContainer = new DisclosureContainer(title);
        }
        this.initWidgets();
    }

    public AbstractEditableTable(List<T> recordList, String title, String recordDisplayName, boolean subField) {
        this.recordList = recordList;
        this.headerText = title;
        this.recordDisplayName = recordDisplayName;
        if (subField) {
            this.discContainer = new DisclosureContainer(title);
        }
        this.initWidgets();
    }

    public AbstractEditableTable(List<T> recordList) {
        this.recordList = recordList;
        this.initWidgets();
    }

    public AbstractEditableTable(List<T> recordList, ClearMessagesCallback clearMessagesCallback) {
        this.recordList = recordList;
        this.clearMessagesCallback = clearMessagesCallback;
        this.initWidgets();
    }

    public AbstractEditableTable(List<T> recordList, ClearMessagesCallback clearMessagesCallback, String title) {
        this.recordList = recordList;
        this.headerText = title;
        this.clearMessagesCallback = clearMessagesCallback;
        this.initWidgets();
    }

    protected void initWidgets() {
        this.mainContainer = new VerticalContainer();
        this.mainContainer.setSpacing(2);
        this.mainContainer.setStylePrimaryName(STYLE_NAME);
        this.headerContainer = new HeaderPanel(this.headerText);
        if (this.headerText != null && !this.headerText.isEmpty()) {
            this.mainContainer.add((Widget)this.headerContainer);
        }
        if (this.discContainer != null) {
            this.headerContainer.setVisible(false);
            this.discContainer.getHeader().addStyleName(TITLE_STYLE_NAME);
            this.discContainer.setOpen(true);
            this.discContainer.add((Widget)this.tableContainer);
            this.mainContainer.add((Widget)this.discContainer);
        } else {
            this.mainContainer.add((Widget)this.tableContainer);
        }
        this.initWidget((Widget)this.mainContainer);
    }

    public void createTable() {
        this.cellTable = new CellTable(5, (CellTable.Resources)GWT.create(EditableTableResources.class));
        this.initTable(this.cellTable);
        this.pager = new EditableTablePager<T>(this.cellTable);
        this.buttonRow = new HorizontalContainer();
        ButtonWidget addButton = this.createAddButton();
        if (addButton != null) {
            this.buttonRow.add((Widget)this.createAddButton());
        }
        this.buttonRow.addStyleName(BUTTON_ROW_STYLE_NAME);
        this.tableContainer.add(this.cellTable);
        this.tableContainer.add((Widget)this.buttonRow);
        this.tableContainer.add(this.pager);
    }

    protected ButtonWidget createAddButton() {
        ButtonWidget addBtn = new ButtonWidget(String.valueOf(this.constants.addRecordButtonName()) + this.getRecordDisplayName());
        addBtn.removeStyleName("gwt-Button");
        addBtn.addStyleName("ebBtn");
        addBtn.addStyleName("addgreen_button_icon");
        addBtn.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                AbstractEditableTable.this.addNewRecord();
                AbstractEditableTable.this.dataProvider.refresh();
                AbstractEditableTable.this.pager.lastPage();
            }
        });
        return addBtn;
    }

    public List<T> getRecords() {
        return this.dataProvider.getList();
    }

    public void setRecordList(List<T> recordList) {
        if (this.recordList != null) {
            this.recordList.clear();
            this.recordList.addAll(recordList);
        } else {
            this.recordList = recordList;
            this.dataProvider.setList(this.recordList);
        }
        if (this.dataProvider != null) {
            this.dataProvider.refresh();
            this.dataProvider.flush();
            this.cellTable.flush();
        }
    }

    protected void setDirty() {
        this.dirty = true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    protected void initTable(CellTable<T> table) {
        AbstractHeaderOrFooterBuilder ahofb = (AbstractHeaderOrFooterBuilder)table.getHeaderBuilder();
        ahofb.setSortIconStartOfLine(false);
        this.dataProvider = new ListDataProvider();
        this.dataProvider.addDataDisplay(table);
        this.dataProvider.setList(this.recordList);
        this.createTable(table);
        Column<T, String> deleteColumn = this.createDeleteColumn();
        if (deleteColumn != null) {
            table.addColumn(this.createDeleteColumn());
        }
    }

    protected Column<T, String> createDeleteColumn() {
        ButtonImageCell imageCell = new ButtonImageCell();
        Column deleteColumn = new Column<T, String>((Cell)imageCell){

            public String getValue(T record) {
                return AbstractEditableTable.DELETE_IMG_URL;
            }
        };
        deleteColumn.setFieldUpdater(new FieldUpdater<T, String>(){

            public void update(int index, T record, String value) {
                if (Window.confirm((String)AbstractEditableTable.this.messages.deleteGenericConfirmation(AbstractEditableTable.this.getRecordDisplayName()))) {
                    AbstractEditableTable.this.clearParentMessages();
                    AbstractEditableTable.this.deleteRecord(record);
                    AbstractEditableTable.this.setDirty();
                }
            }
        });
        deleteColumn.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_LEFT);
        deleteColumn.setCellStyleNames(DELETE_STYLE_NAME);
        return deleteColumn;
    }

    private void deleteRecord(T record) {
        this.dataProvider.getList().remove(record);
        this.dataProvider.refresh();
    }

    protected void clearParentMessages() {
        try {
            if (this.clearMessagesCallback != null) {
                this.clearMessagesCallback.clearMessages();
            }
        }
        catch (Exception exception) {}
    }

    protected void redrawRow(int i) {
        if (this.cellTable != null) {
            this.cellTable.redrawRow(i);
        }
    }

    public String getRecordDisplayName() {
        return this.recordDisplayName;
    }

    public abstract List<T> getCollapsedRecordList();

    protected abstract void addNewRecord();

    protected abstract void createTable(CellTable<T> var1);

    public void setRecordDisplayName(String recordDisplayName) {
        this.recordDisplayName = recordDisplayName;
    }

    public void setClearMessagesCallback(ClearMessagesCallback cmCallback) {
        this.clearMessagesCallback = cmCallback;
    }

    private class ButtonImageCell
    extends ButtonCell {
        private ButtonImageCell() {
        }

        public void render(Cell.Context context, String value, SafeHtmlBuilder sb) {
            SafeHtml html = SafeHtmlUtils.fromTrustedString((String)new Image(value).toString());
            sb.append(html);
        }
    }

    public static interface ClearMessagesCallback {
        public void clearMessages();
    }
}

