/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.client.table;

import com.ericsson.cms.contractmgmt.client.table.EditableTableConstants;
import com.ericsson.cms.contractmgmt.client.table.EditableTablePagerResources;
import com.ericsson.cms.contractmgmt.client.table.EditableTableSimplePager;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.SimplePager;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasRows;

public class EditableTablePager<T>
extends Composite {
    private static final String STYLE_NAME = "editableTable-Pager";
    private CellTable<T> cellTable;
    private EditableTableSimplePager pager;
    private HorizontalPanel pagerPanel = new HorizontalPanel();
    private int[] pageSizes = new int[]{5, 10, 25, 50, 100};
    private final EditableTableConstants constants = (EditableTableConstants)GWT.create(EditableTableConstants.class);

    public EditableTablePager(CellTable<T> cellTable) {
        this.cellTable = cellTable;
        this.initPagerPanel();
        this.initWidget((Widget)this.pagerPanel);
    }

    private Widget initPagerPanel() {
        this.pagerPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        this.pagerPanel.addStyleName("editableTable-Pager-Panel");
        HorizontalPanel pagerButtons = new HorizontalPanel();
        pagerButtons.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
        this.pager = this.initPager(this.cellTable);
        this.pager.setWidth("0px");
        this.pager.addStyleName(STYLE_NAME);
        pagerButtons.add((Widget)this.pager);
        this.pagerPanel.add((Widget)pagerButtons);
        HorizontalPanel rowsPerPanel = new HorizontalPanel();
        rowsPerPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        Label rowsPerPageLabel = new Label(this.constants.rowsPerPage());
        rowsPerPanel.add((Widget)rowsPerPageLabel);
        rowsPerPanel.setCellHorizontalAlignment((Widget)rowsPerPageLabel, HasHorizontalAlignment.ALIGN_RIGHT);
        ListBox pageSizeBox = new ListBox();
        int i = 0;
        while (i < this.pageSizes.length) {
            pageSizeBox.addItem(String.valueOf(this.pageSizes[i]));
            ++i;
        }
        pageSizeBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                try {
                    ListBox box = (ListBox)event.getSource();
                    EditableTablePager.this.setPageSize(Integer.parseInt(box.getValue(box.getSelectedIndex())));
                }
                catch (NumberFormatException numberFormatException) {
                    Window.alert((String)EditableTablePager.this.constants.invalidPageSize());
                }
            }
        });
        rowsPerPanel.add((Widget)pageSizeBox);
        rowsPerPanel.setCellHorizontalAlignment((Widget)pageSizeBox, HasHorizontalAlignment.ALIGN_LEFT);
        this.pagerPanel.add((Widget)rowsPerPanel);
        HorizontalPanel goToPanel = new HorizontalPanel();
        goToPanel.addStyleName("contact-Pager-GoToPage");
        goToPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        Label goToPageLabel = new Label(this.constants.goToPage());
        goToPanel.add((Widget)goToPageLabel);
        goToPanel.setCellHorizontalAlignment((Widget)goToPageLabel, HasHorizontalAlignment.ALIGN_RIGHT);
        TextBox gotoPageBox = new TextBox();
        gotoPageBox.setValue((Object)"1");
        gotoPageBox.setWidth("2em");
        gotoPageBox.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                try {
                    EditableTablePager.this.goToPage(Integer.parseInt((String)event.getValue()));
                }
                catch (NumberFormatException numberFormatException) {
                    Window.alert((String)EditableTablePager.this.constants.invalidPageNumber());
                }
            }
        });
        goToPanel.add((Widget)gotoPageBox);
        goToPanel.setCellHorizontalAlignment((Widget)gotoPageBox, HasHorizontalAlignment.ALIGN_LEFT);
        this.pagerPanel.add((Widget)goToPanel);
        this.pagerPanel.setCellWidth((Widget)pagerButtons, "50%");
        this.pagerPanel.setCellHorizontalAlignment((Widget)pagerButtons, HasHorizontalAlignment.ALIGN_RIGHT);
        this.pagerPanel.setCellVerticalAlignment((Widget)rowsPerPanel, HasVerticalAlignment.ALIGN_MIDDLE);
        this.pagerPanel.setCellVerticalAlignment((Widget)goToPanel, HasVerticalAlignment.ALIGN_MIDDLE);
        return this.pagerPanel;
    }

    private EditableTableSimplePager initPager(CellTable<T> cellTable) {
        SimplePager.Resources pagerResources = (SimplePager.Resources)GWT.create(EditableTablePagerResources.class);
        EditableTableSimplePager simplePager = new EditableTableSimplePager(SimplePager.TextLocation.CENTER, pagerResources, false, 0, true);
        simplePager.setDisplay((HasRows)cellTable);
        simplePager.setVisible(true);
        return simplePager;
    }

    public void setPageSize(int pageSize) {
        this.cellTable.setPageSize(pageSize);
    }

    public void goToPage(int pageNum) {
        if (this.pager.hasPage(pageNum - 1)) {
            this.pager.setPage(pageNum - 1);
        }
    }

    public void lastPageStart() {
        this.pager.lastPageStart();
    }

    public void lastPage() {
        this.pager.lastPage();
    }
}

