/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.server;

import com.ericsson.cms.contractmgmt.client.customfield.FieldTypeEnum;
import com.ericsson.cms.contractmgmt.client.model.UiContentProvider;
import com.ericsson.cms.contractmgmt.client.model.UiCurrency;
import com.ericsson.cms.contractmgmt.client.model.UiDeliveryLocation;
import com.ericsson.cms.contractmgmt.client.model.UiDevice;
import com.ericsson.cms.contractmgmt.client.model.UiDevices;
import com.ericsson.cms.contractmgmt.client.model.UiDistributionListValues;
import com.ericsson.cms.contractmgmt.client.model.UiKeyName;
import com.ericsson.cms.contractmgmt.client.model.UiKeyNames;
import com.ericsson.cms.contractmgmt.client.model.UiPlatform;
import com.ericsson.cms.contractmgmt.client.model.UiPlatforms;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownService;
import com.ericsson.cms.contractmgmt.client.tab.config.configurablefield.ConfigurableFieldTypeEnum;
import com.ericsson.cms.contractmgmt.server.ObjectsConverter;
import com.ericsson.cms.sites.core.ISiteManager;
import com.ericsson.cms.sites.core.entities.DistributionSite;
import com.ericsson.ejb.Contract;
import com.ericsson.ejb.ContractType;
import com.ericsson.ejb.CopyrightHolder;
import com.ericsson.ejb.Currency;
import com.ericsson.ejb.Deal;
import com.ericsson.ejb.DealType;
import com.ericsson.ejb.DeliveryMethod;
import com.ericsson.ejb.Device;
import com.ericsson.ejb.Field;
import com.ericsson.ejb.FieldDropdown;
import com.ericsson.ejb.Frequency;
import com.ericsson.ejb.Language;
import com.ericsson.ejb.LicenseType;
import com.ericsson.ejb.Media;
import com.ericsson.ejb.Ownership;
import com.ericsson.ejb.Platform;
import com.ericsson.service.ContractManagerValidationException;
import com.ericsson.service.IContractManager;
import com.ericsson.service.IContractTypeManager;
import com.ericsson.service.ICopyrightHolderManager;
import com.ericsson.service.ICurrencyManager;
import com.ericsson.service.IDealManager;
import com.ericsson.service.IDealTypeManager;
import com.ericsson.service.IDeliveryMethodManager;
import com.ericsson.service.IDeviceManager;
import com.ericsson.service.IFieldDropdownManager;
import com.ericsson.service.IFieldManager;
import com.ericsson.service.IFrequencyManager;
import com.ericsson.service.ILanguageManager;
import com.ericsson.service.ILicenseTypeManager;
import com.ericsson.service.IMediaManager;
import com.ericsson.service.IOwnershipManager;
import com.ericsson.service.IPlatformManager;
import com.tandbergtv.cms.contentmgmt.service.specification.IAssetSpecificationManager;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.entities.PartnerType;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerManagement;
import com.tandbergtv.watchpoint.pmm.title.conf.Specification;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.aspectj.runtime.internal.AroundClosure;

public class ContractManagerDropDownServiceImpl
implements IContractManagerDropDownService,
NeptuneRemoteService {
    private IFrequencyManager frequencyManager = (IFrequencyManager)InjectionUtil.injectInstance((String)"cms/FrequencyManager/local", IFrequencyManager.class);
    private ICopyrightHolderManager copyrightHolderManager = (ICopyrightHolderManager)InjectionUtil.injectInstance((String)"cms/CopyrightHolderManager/local", ICopyrightHolderManager.class);
    private IContractManager contractManager = (IContractManager)InjectionUtil.injectInstance((String)"cms/ContractManager/local", IContractManager.class);
    private IDealManager dealManager = (IDealManager)InjectionUtil.injectInstance((String)"cms/DealManager/local", IDealManager.class);
    private IPlatformManager platformManager = (IPlatformManager)InjectionUtil.injectInstance((String)"cms/PlatformManager/local", IPlatformManager.class);
    private IDeviceManager deviceManager = (IDeviceManager)InjectionUtil.injectInstance((String)"cms/DeviceManager/local", IDeviceManager.class);
    private ICurrencyManager currencyManager = (ICurrencyManager)InjectionUtil.injectInstance((String)"cms/CurrencyManager/local", ICurrencyManager.class);
    private IContractTypeManager contractTypeManager = (IContractTypeManager)InjectionUtil.injectInstance((String)"cms/ContractTypeManager/local", IContractTypeManager.class);
    private ILicenseTypeManager licenseTypeManager = (ILicenseTypeManager)InjectionUtil.injectInstance((String)"cms/LicenseTypeManager/local", ILicenseTypeManager.class);
    private IDealTypeManager dealTypeManager = (IDealTypeManager)InjectionUtil.injectInstance((String)"cms/DealTypeManager/local", IDealTypeManager.class);
    private ILanguageManager languageManager = (ILanguageManager)InjectionUtil.injectInstance((String)"cms/LanguageManager/local", ILanguageManager.class);
    private IDeliveryMethodManager deliveryMethodManager = (IDeliveryMethodManager)InjectionUtil.injectInstance((String)"cms/DeliveryMethodManager/local", IDeliveryMethodManager.class);
    private IOwnershipManager ownershipManager = (IOwnershipManager)InjectionUtil.injectInstance((String)"cms/OwnershipManager/local", IOwnershipManager.class);
    private IMediaManager mediaManager = (IMediaManager)InjectionUtil.injectInstance((String)"cms/MediaManager/local", IMediaManager.class);
    private IAssetSpecificationManager assetSpecificationManager = (IAssetSpecificationManager)InjectionUtil.injectInstance((String)"cms/AssetSpecificationManager/local", IAssetSpecificationManager.class);
    private IPartnerManagement partnerManagement = (IPartnerManagement)ServiceRegistry.getDefault().lookup(IPartnerManagement.class);
    private ISiteManager siteManager = (ISiteManager)InjectionUtil.injectInstance((String)"cms/SiteManager/local", ISiteManager.class);
    private IFieldDropdownManager fieldDropDownManager = (IFieldDropdownManager)InjectionUtil.injectInstance((String)"cms/FieldDropdownManager/local", IFieldDropdownManager.class);
    private IFieldManager fieldManager = (IFieldManager)InjectionUtil.injectInstance((String)"cms/FieldManager/local", IFieldManager.class);
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ Annotation ajc$anno$1;
    private static /* synthetic */ Annotation ajc$anno$2;
    private static /* synthetic */ Annotation ajc$anno$3;
    private static /* synthetic */ Annotation ajc$anno$4;
    private static /* synthetic */ Annotation ajc$anno$5;
    private static /* synthetic */ Annotation ajc$anno$6;
    private static /* synthetic */ Annotation ajc$anno$7;
    private static /* synthetic */ Annotation ajc$anno$8;
    private static /* synthetic */ Annotation ajc$anno$9;
    private static /* synthetic */ Annotation ajc$anno$10;
    private static /* synthetic */ Annotation ajc$anno$11;
    private static /* synthetic */ Annotation ajc$anno$12;
    private static /* synthetic */ Annotation ajc$anno$13;
    private static /* synthetic */ Annotation ajc$anno$14;
    private static /* synthetic */ Annotation ajc$anno$15;
    private static /* synthetic */ Annotation ajc$anno$16;
    private static /* synthetic */ Annotation ajc$anno$17;
    private static /* synthetic */ Annotation ajc$anno$18;
    private static /* synthetic */ Annotation ajc$anno$19;
    private static /* synthetic */ Annotation ajc$anno$20;

    public String getRelativePath() {
        return "service/contract/contractManagerDropDownService";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }

    @Override
    public List<UiKeyName> getCopyrightHolderKeyNameList() throws NeptuneException {
        ArrayList<UiKeyName> copyrightHoldersList = new ArrayList<UiKeyName>();
        List copyrightHolders = this.copyrightHolderManager.getAllCopyrightHolders();
        for (CopyrightHolder copyrightHolder : copyrightHolders) {
            copyrightHoldersList.add(this.createKeyName(copyrightHolder.getIdCopyrightHolder(), copyrightHolder.getName()));
        }
        return copyrightHoldersList;
    }

    @Override
    public List<UiKeyName> getContractKeyNameList(Long copyrightHolderKey) throws NeptuneException {
        ArrayList<UiKeyName> contractsList = new ArrayList<UiKeyName>();
        if (copyrightHolderKey != null) {
            List contracts = this.contractManager.findByCopyrightHolder(copyrightHolderKey.longValue());
            for (Contract contract : contracts) {
                contractsList.add(this.createKeyName(contract.getIdContract(), contract.getName()));
            }
        }
        return contractsList;
    }

    @Override
    public List<UiKeyName> getDealKeyNameList(Long contractKey) throws NeptuneException {
        ArrayList<UiKeyName> dealsList = new ArrayList<UiKeyName>();
        if (contractKey != null) {
            List deals = this.dealManager.findByContract(contractKey.longValue());
            for (Deal deal : deals) {
                dealsList.add(this.createKeyName(deal.getIdDeal(), deal.getName()));
            }
        }
        return dealsList;
    }

    @Override
    public UiDistributionListValues getDistributionListValues() throws NeptuneException {
        UiDistributionListValues values = new UiDistributionListValues();
        values.getDeliveryMethodValues().addAll(this.getDeliveryMethodKeyNameList());
        values.getMediaTypeValues().addAll(this.getMediaTypeKeyNameList());
        values.getMetaFormatValues().addAll(this.getMetaFormatKeyNameList());
        values.getOwnershipValues().addAll(this.getOwnershipKeyNameList());
        return values;
    }

    @Override
    public List<UiKeyName> getFieldTypeKeyNameList() throws NeptuneException {
        ArrayList<UiKeyName> types = new ArrayList<UiKeyName>();
        types.add(this.createKeyName(Long.valueOf(FieldTypeEnum.Alphanumeric.ordinal()), "Alphanumeric"));
        types.add(this.createKeyName(Long.valueOf(FieldTypeEnum.Currency.ordinal()), "Currency"));
        types.add(this.createKeyName(Long.valueOf(FieldTypeEnum.Date.ordinal()), "Date"));
        types.add(this.createKeyName(Long.valueOf(FieldTypeEnum.Frequency.ordinal()), "Frequency"));
        types.add(this.createKeyName(Long.valueOf(FieldTypeEnum.Number.ordinal()), "Number"));
        types.add(this.createKeyName(Long.valueOf(FieldTypeEnum.Percentage.ordinal()), "Percentage"));
        types.add(this.createKeyName(Long.valueOf(FieldTypeEnum.Text.ordinal()), "Text"));
        return types;
    }

    @Override
    public List<UiKeyName> getDropDownKeyNameList(Long uiUserDefinedField) throws NeptuneException {
        ArrayList<UiKeyName> values = new ArrayList<UiKeyName>();
        if (uiUserDefinedField != null) {
            List dbValues = this.fieldDropDownManager.findByFieldId(uiUserDefinedField.longValue());
            for (FieldDropdown dbValue : dbValues) {
                values.add(this.createKeyName(dbValue.getIdFieldDropdown(), dbValue.getValue()));
            }
        }
        return values;
    }

    @Override
    public void saveCustomDropDownKeyList(List<UiKeyName> keyList, Long userDefinedFieldId) throws NeptuneException {
        ArrayList<String> validationErrors = new ArrayList<String>();
        List<UiKeyName> existingCustomKeys = this.getDropDownKeyNameList(userDefinedFieldId);
        for (UiKeyName curKey : existingCustomKeys) {
            if (this.containsCustomKey(curKey, keyList)) continue;
            this.deleteCustomDropDown(curKey);
        }
        for (UiKeyName name : keyList) {
            try {
                this.saveCustomDropDownKeyName(name, userDefinedFieldId);
            }
            catch (ValidationException ve) {
                validationErrors.add(ve.getLocalizedMessage());
            }
        }
        if (!validationErrors.isEmpty()) {
            throw new ValidationException(validationErrors);
        }
    }

    private boolean containsCustomKey(UiKeyName key, List<UiKeyName> existingKeyList) {
        if (key != null) {
            for (UiKeyName curExistingKey : existingKeyList) {
                if (key.getKey() == null || curExistingKey == null || curExistingKey.getKey() == null || !key.getKey().equals(curExistingKey.getKey())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @Transactional
    public void saveCustomDropDownKeyName(UiKeyName name, Long userDefinedFieldId) throws NeptuneException {
        UiKeyName uiKeyName = name;
        Long l = userDefinedFieldId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = ContractManagerDropDownServiceImpl.class.getDeclaredMethod("saveCustomDropDownKeyName", UiKeyName.class, Long.class).getAnnotation(Transactional.class);
        }
        ContractManagerDropDownServiceImpl.saveCustomDropDownKeyName_aroundBody1$advice(this, uiKeyName, l, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    public void deleteCustomDropDownKeyNames(List<UiKeyName> keyNames) throws NeptuneException {
        for (UiKeyName dropDown : keyNames) {
            this.deleteCustomDropDown(dropDown);
        }
    }

    @Transactional
    private void deleteCustomDropDown(UiKeyName dropDown) throws NeptuneException {
        UiKeyName uiKeyName = dropDown;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = ContractManagerDropDownServiceImpl.class.getDeclaredMethod("deleteCustomDropDown", UiKeyName.class).getAnnotation(Transactional.class);
        }
        ContractManagerDropDownServiceImpl.deleteCustomDropDown_aroundBody3$advice(this, uiKeyName, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    public List<UiDeliveryLocation> getDeliveryLocationList() throws NeptuneException {
        ArrayList<UiDeliveryLocation> deliveryLocations = new ArrayList<UiDeliveryLocation>();
        List sitesList = this.siteManager.getAllDistributionSites();
        for (DistributionSite site : sitesList) {
            UiDeliveryLocation uiDeliveryLocation = new UiDeliveryLocation();
            uiDeliveryLocation.setName(site.getName());
            uiDeliveryLocation.setKey(site.getId().longValue());
            deliveryLocations.add(uiDeliveryLocation);
        }
        return deliveryLocations;
    }

    @Override
    public UiPlatforms getPlatforms(int start, int length, String sortProperty, boolean isAscending) throws NeptuneException {
        UiPlatforms uiPlatforms = new UiPlatforms(null, this.platformManager.count());
        List platforms = this.platformManager.getPlatforms(start, length, sortProperty, isAscending);
        for (Platform platform : platforms) {
            uiPlatforms.getPlatforms().add(ObjectsConverter.createUiPlatform(platform));
        }
        return uiPlatforms;
    }

    @Override
    @Transactional
    public UiDevices getDevices(int start, int length, String sortProperty, boolean isAscending) throws NeptuneException {
        int n = start;
        int n2 = length;
        String string = sortProperty;
        boolean bl = isAscending;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$2;
        if (annotation == null) {
            annotation = ajc$anno$2 = ContractManagerDropDownServiceImpl.class.getDeclaredMethod("getDevices", Integer.TYPE, Integer.TYPE, String.class, Boolean.TYPE).getAnnotation(Transactional.class);
        }
        return (UiDevices)ContractManagerDropDownServiceImpl.getDevices_aroundBody5$advice(this, n, n2, string, bl, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public void saveDevice(UiDevice device) throws NeptuneException {
        UiDevice uiDevice = device;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$3;
        if (annotation == null) {
            annotation = ajc$anno$3 = ContractManagerDropDownServiceImpl.class.getDeclaredMethod("saveDevice", UiDevice.class).getAnnotation(Transactional.class);
        }
        ContractManagerDropDownServiceImpl.saveDevice_aroundBody7$advice(this, uiDevice, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    public void saveDeviceList(List<UiDevice> devices) throws NeptuneException {
        ArrayList<String> validationErrors = new ArrayList<String>();
        UiDevices existingDevices = this.getDevices(0, 0, "name", true);
        for (UiDevice existingDevice : existingDevices.getDevices()) {
            if (this.containsDevice(devices, existingDevice)) continue;
            this.deleteDevice(existingDevice, validationErrors);
            if (validationErrors == null || validationErrors.isEmpty()) continue;
            throw new ValidationException(validationErrors);
        }
        for (UiDevice device : devices) {
            this.saveDevice(device);
        }
    }

    private boolean containsDevice(List<UiDevice> devices, UiDevice device) {
        if (devices != null && device != null) {
            for (UiDevice curDevice : devices) {
                if (curDevice.getKey() != device.getKey()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void deleteDevices(List<UiDevice> devices) throws NeptuneException {
        ArrayList<String> validationErrors = new ArrayList<String>();
        for (UiDevice device : devices) {
            this.deleteDevice(device, validationErrors);
        }
        if (!validationErrors.isEmpty()) {
            throw new ValidationException(validationErrors);
        }
    }

    @Transactional
    private void deleteDevice(UiDevice device, List<String> validationErrors) throws NeptuneException {
        UiDevice uiDevice = device;
        List<String> list = validationErrors;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$4;
        if (annotation == null) {
            annotation = ajc$anno$4 = ContractManagerDropDownServiceImpl.class.getDeclaredMethod("deleteDevice", UiDevice.class, List.class).getAnnotation(Transactional.class);
        }
        ContractManagerDropDownServiceImpl.deleteDevice_aroundBody9$advice(this, uiDevice, list, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    public List<UiPlatform> getPlatformList() throws NeptuneException {
        ArrayList<UiPlatform> uiPlatforms = new ArrayList<UiPlatform>();
        List platforms = this.platformManager.getAllPlatforms();
        for (Platform platform : platforms) {
            uiPlatforms.add(ObjectsConverter.createUiPlatform(platform));
        }
        return uiPlatforms;
    }

    @Override
    @Transactional
    public List<UiDevice> getDeviceList(List<UiPlatform> selectedPlatforms) throws NeptuneException {
        List<UiPlatform> list = selectedPlatforms;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$5;
        if (annotation == null) {
            annotation = ajc$anno$5 = ContractManagerDropDownServiceImpl.class.getDeclaredMethod("getDeviceList", List.class).getAnnotation(Transactional.class);
        }
        return (List)ContractManagerDropDownServiceImpl.getDeviceList_aroundBody11$advice(this, list, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    public List<UiCurrency> getCurrencies() throws NeptuneException {
        ArrayList<UiCurrency> uiCurrencies = new ArrayList<UiCurrency>();
        List currencies = this.currencyManager.getAllCurrencies();
        for (Currency currency : currencies) {
            uiCurrencies.add(ObjectsConverter.createUiCurrency(currency));
        }
        return uiCurrencies;
    }

    @Override
    public void saveCurrency(UiCurrency currency) throws NeptuneException {
        try {
            Currency dbCurrency = new Currency(currency.getName(), currency.getSymbol());
            if (currency.getKey() == null) {
                this.currencyManager.persist(dbCurrency);
            } else {
                dbCurrency.setIdCurrency(currency.getKey());
                this.currencyManager.merge(dbCurrency);
            }
        }
        catch (Exception e) {
            if (e instanceof ContractManagerValidationException) {
                throw new ValidationException(((ContractManagerValidationException)((Object)e)).getValidationMessages());
            }
            throw new NeptuneException(e.getLocalizedMessage());
        }
    }

    @Override
    public void saveCurrencyList(List<UiCurrency> currencyList) throws NeptuneException {
        ArrayList<String> validationErrors = new ArrayList<String>();
        List existingCurrencies = this.currencyManager.getAllCurrencies();
        for (Currency currency : existingCurrencies) {
            if (this.containsCurrency(currency, currencyList)) continue;
            this.deleteCurrency(currency.getIdCurrency(), validationErrors);
        }
        if (currencyList != null) {
            for (UiCurrency uicurrency : currencyList) {
                this.saveCurrency(uicurrency);
            }
        }
    }

    private boolean containsCurrency(Currency currency, List<UiCurrency> currencyList) {
        for (UiCurrency uiCurrency : currencyList) {
            if (currency.getIdCurrency() != uiCurrency.getKey()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void deleteCurrencies(List<UiCurrency> currencies) throws NeptuneException {
        ArrayList<String> validationErrors = new ArrayList<String>();
        for (UiCurrency currency : currencies) {
            this.deleteCurrency(currency, validationErrors);
        }
        if (!validationErrors.isEmpty()) {
            throw new ValidationException(validationErrors);
        }
    }

    @Transactional
    private void deleteCurrency(UiCurrency currency, List<String> validationErrors) throws NeptuneException {
        UiCurrency uiCurrency = currency;
        List<String> list = validationErrors;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$6;
        if (annotation == null) {
            annotation = ajc$anno$6 = ContractManagerDropDownServiceImpl.class.getDeclaredMethod("deleteCurrency", UiCurrency.class, List.class).getAnnotation(Transactional.class);
        }
        ContractManagerDropDownServiceImpl.deleteCurrency_aroundBody13$advice(this, uiCurrency, list, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    private void deleteCurrency(Long currencyId, List<String> validationErrors) {
        Long l = currencyId;
        List<String> list = validationErrors;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$7;
        if (annotation == null) {
            annotation = ajc$anno$7 = ContractManagerDropDownServiceImpl.class.getDeclaredMethod("deleteCurrency", Long.class, List.class).getAnnotation(Transactional.class);
        }
        ContractManagerDropDownServiceImpl.deleteCurrency_aroundBody15$advice(this, l, list, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    public UiKeyNames getGenericDropDownKeyNameList(int start, int length, String sortProperty, boolean isAscending, ConfigurableFieldTypeEnum fieldType) throws NeptuneException {
        UiKeyNames keyNames = new UiKeyNames();
        switch (fieldType) {
            case LicenseType: {
                List licenseTypes = this.licenseTypeManager.getAllLicenseTypes();
                for (LicenseType licenseType : licenseTypes) {
                    keyNames.getRecords().add(this.createKeyName(licenseType.getIdType(), licenseType.getType()));
                }
                break;
            }
            case ContractType: {
                List contractTypes = this.contractTypeManager.getAllContractTypes();
                for (ContractType contractType : contractTypes) {
                    keyNames.getRecords().add(this.createKeyName(contractType.getIdType(), contractType.getType()));
                }
                break;
            }
            case DealType: {
                List dealTypes = this.dealTypeManager.getAllDealTypes();
                for (DealType dealType : dealTypes) {
                    keyNames.getRecords().add(this.createKeyName(dealType.getIdType(), dealType.getType()));
                }
                break;
            }
            case DeliveryMethod: {
                keyNames.getRecords().addAll(this.getDeliveryMethodKeyNameList());
                break;
            }
            case MediaType: {
                keyNames.getRecords().addAll(this.getMediaTypeKeyNameList());
                break;
            }
            case MetaFormat: {
                keyNames.getRecords().addAll(this.getMetaFormatKeyNameList());
                break;
            }
            case Ownership: {
                keyNames.getRecords().addAll(this.getOwnershipKeyNameList());
                break;
            }
            case Frequency: {
                List frequenciesList = this.frequencyManager.getAllFrequencies();
                for (Frequency frequency : frequenciesList) {
                    keyNames.getRecords().add(this.createKeyName(frequency.getIdFrequency(), frequency.getDescription()));
                }
                break;
            }
            case Language: {
                List languages = this.languageManager.getAllLanguages();
                for (Language language : languages) {
                    keyNames.getRecords().add(this.createKeyName(language.getIdLanguage(), language.getLanguage()));
                }
                break;
            }
            case Platform: {
                UiPlatforms platforms = this.getPlatforms(start, length, sortProperty, isAscending);
                for (UiPlatform platform : platforms.getPlatforms()) {
                    keyNames.getRecords().add(this.createKeyName(platform.getKey(), platform.getName()));
                }
                keyNames.setTotalCount(platforms.getTotalCount());
            }
        }
        return keyNames;
    }

    private boolean containsGenericDropDownKey(UiKeyName key, List<UiKeyName> existingKeyList) {
        if (key != null) {
            for (UiKeyName curExistingKey : existingKeyList) {
                if (key.getKey() == null || curExistingKey == null || curExistingKey.getKey() == null || !key.getKey().equals(curExistingKey.getKey())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void saveGenericDropDownKeyList(List<UiKeyName> keyList, ConfigurableFieldTypeEnum fieldType) throws NeptuneException {
        UiKeyNames existingKeyNames = this.getGenericDropDownKeyNameList(0, 0, null, true, fieldType);
        List<UiKeyName> existingKeyNameList = existingKeyNames.getRecords();
        if (existingKeyNameList != null) {
            for (UiKeyName curExistingKey : existingKeyNameList) {
                if (this.containsGenericDropDownKey(curExistingKey, keyList)) continue;
                this.deleteGenericDropDownKeyName(curExistingKey, fieldType);
            }
        }
        if (keyList != null) {
            for (UiKeyName curKey : keyList) {
                this.saveGenericDropDownKeyName(curKey, fieldType);
            }
        }
    }

    @Override
    @Transactional
    public void saveGenericDropDownKeyName(UiKeyName name, ConfigurableFieldTypeEnum fieldType) throws NeptuneException {
        UiKeyName uiKeyName = name;
        ConfigurableFieldTypeEnum configurableFieldTypeEnum = fieldType;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$8;
        if (annotation == null) {
            annotation = ajc$anno$8 = ContractManagerDropDownServiceImpl.class.getDeclaredMethod("saveGenericDropDownKeyName", UiKeyName.class, ConfigurableFieldTypeEnum.class).getAnnotation(Transactional.class);
        }
        ContractManagerDropDownServiceImpl.saveGenericDropDownKeyName_aroundBody17$advice(this, uiKeyName, configurableFieldTypeEnum, transactionEnforcer, (Transactional)annotation, null);
    }

    public void deleteGenericDropDownKeyName(UiKeyName keyName, ConfigurableFieldTypeEnum fieldType) throws NeptuneException {
        ArrayList<String> validationErrors = new ArrayList<String>();
        try {
            switch (fieldType) {
                case LicenseType: {
                    this.deleteLicenseType(keyName, validationErrors);
                    break;
                }
                case ContractType: {
                    this.deleteContractType(keyName, validationErrors);
                    break;
                }
                case DealType: {
                    this.deleteDealType(keyName, validationErrors);
                    break;
                }
                case DeliveryMethod: {
                    this.deleteDeliveryMethod(keyName, validationErrors);
                    break;
                }
                case MediaType: {
                    this.deleteMediaType(keyName, validationErrors);
                    break;
                }
                case Ownership: {
                    this.deleteOwnership(keyName, validationErrors);
                    break;
                }
                case Frequency: {
                    this.deleteFrequency(keyName, validationErrors);
                    break;
                }
                case Language: {
                    this.deleteLanguage(keyName, validationErrors);
                    break;
                }
                case Platform: {
                    this.deletePlatform(keyName, validationErrors);
                }
            }
        }
        catch (Exception e) {
            throw new NeptuneException(e.getLocalizedMessage());
        }
        if (validationErrors != null && !validationErrors.isEmpty()) {
            throw new ValidationException(validationErrors);
        }
    }

    @Override
    public void deleteGenericDropDownKeyNames(List<UiKeyName> keyNames, ConfigurableFieldTypeEnum fieldType) throws NeptuneException {
        ArrayList<String> validationErrors = new ArrayList<String>();
        try {
            for (UiKeyName keyName : keyNames) {
                switch (fieldType) {
                    case LicenseType: {
                        this.deleteLicenseType(keyName, validationErrors);
                        break;
                    }
                    case ContractType: {
                        this.deleteContractType(keyName, validationErrors);
                        break;
                    }
                    case DealType: {
                        this.deleteDealType(keyName, validationErrors);
                        break;
                    }
                    case DeliveryMethod: {
                        this.deleteDeliveryMethod(keyName, validationErrors);
                        break;
                    }
                    case MediaType: {
                        this.deleteMediaType(keyName, validationErrors);
                        break;
                    }
                    case Ownership: {
                        this.deleteOwnership(keyName, validationErrors);
                        break;
                    }
                    case Frequency: {
                        this.deleteFrequency(keyName, validationErrors);
                        break;
                    }
                    case Language: {
                        this.deleteLanguage(keyName, validationErrors);
                        break;
                    }
                    case Platform: {
                        this.deletePlatform(keyName, validationErrors);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new NeptuneException(e.getLocalizedMessage());
        }
        if (!validationErrors.isEmpty()) {
            throw new ValidationException(validationErrors);
        }
    }

    @Override
    @Transactional
    public List<UiKeyName> getContractTypeKeyNameList() {
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$9;
        if (annotation == null) {
            annotation = ajc$anno$9 = ContractManagerDropDownServiceImpl.class.getDeclaredMethod("getContractTypeKeyNameList", new Class[0]).getAnnotation(Transactional.class);
        }
        return (List)ContractManagerDropDownServiceImpl.getContractTypeKeyNameList_aroundBody19$advice(this, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public List<UiKeyName> getDealTypeKeyNameList() {
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$10;
        if (annotation == null) {
            annotation = ajc$anno$10 = ContractManagerDropDownServiceImpl.class.getDeclaredMethod("getDealTypeKeyNameList", new Class[0]).getAnnotation(Transactional.class);
        }
        return (List)ContractManagerDropDownServiceImpl.getDealTypeKeyNameList_aroundBody21$advice(this, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    private void deleteLicenseType(UiKeyName keyName, List<String> validationErrors) {
        UiKeyName uiKeyName = keyName;
        List<String> list = validationErrors;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$11;
        if (annotation == null) {
            annotation = ajc$anno$11 = ContractManagerDropDownServiceImpl.class.getDeclaredMethod("deleteLicenseType", UiKeyName.class, List.class).getAnnotation(Transactional.class);
        }
        ContractManagerDropDownServiceImpl.deleteLicenseType_aroundBody23$advice(this, uiKeyName, list, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    private void deleteContractType(UiKeyName keyName, List<String> validationErrors) {
        UiKeyName uiKeyName = keyName;
        List<String> list = validationErrors;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$12;
        if (annotation == null) {
            annotation = ajc$anno$12 = ContractManagerDropDownServiceImpl.class.getDeclaredMethod("deleteContractType", UiKeyName.class, List.class).getAnnotation(Transactional.class);
        }
        ContractManagerDropDownServiceImpl.deleteContractType_aroundBody25$advice(this, uiKeyName, list, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    private void deleteDealType(UiKeyName keyName, List<String> validationErrors) {
        UiKeyName uiKeyName = keyName;
        List<String> list = validationErrors;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$13;
        if (annotation == null) {
            annotation = ajc$anno$13 = ContractManagerDropDownServiceImpl.class.getDeclaredMethod("deleteDealType", UiKeyName.class, List.class).getAnnotation(Transactional.class);
        }
        ContractManagerDropDownServiceImpl.deleteDealType_aroundBody27$advice(this, uiKeyName, list, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    private void deleteDeliveryMethod(UiKeyName keyName, List<String> validationErrors) {
        UiKeyName uiKeyName = keyName;
        List<String> list = validationErrors;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$14;
        if (annotation == null) {
            annotation = ajc$anno$14 = ContractManagerDropDownServiceImpl.class.getDeclaredMethod("deleteDeliveryMethod", UiKeyName.class, List.class).getAnnotation(Transactional.class);
        }
        ContractManagerDropDownServiceImpl.deleteDeliveryMethod_aroundBody29$advice(this, uiKeyName, list, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    private void deleteMediaType(UiKeyName keyName, List<String> validationErrors) {
        UiKeyName uiKeyName = keyName;
        List<String> list = validationErrors;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$15;
        if (annotation == null) {
            annotation = ajc$anno$15 = ContractManagerDropDownServiceImpl.class.getDeclaredMethod("deleteMediaType", UiKeyName.class, List.class).getAnnotation(Transactional.class);
        }
        ContractManagerDropDownServiceImpl.deleteMediaType_aroundBody31$advice(this, uiKeyName, list, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    private void deleteOwnership(UiKeyName keyName, List<String> validationErrors) {
        UiKeyName uiKeyName = keyName;
        List<String> list = validationErrors;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$16;
        if (annotation == null) {
            annotation = ajc$anno$16 = ContractManagerDropDownServiceImpl.class.getDeclaredMethod("deleteOwnership", UiKeyName.class, List.class).getAnnotation(Transactional.class);
        }
        ContractManagerDropDownServiceImpl.deleteOwnership_aroundBody33$advice(this, uiKeyName, list, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    private void deleteFrequency(UiKeyName keyName, List<String> validationErrors) throws ContractManagerValidationException {
        UiKeyName uiKeyName = keyName;
        List<String> list = validationErrors;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$17;
        if (annotation == null) {
            annotation = ajc$anno$17 = ContractManagerDropDownServiceImpl.class.getDeclaredMethod("deleteFrequency", UiKeyName.class, List.class).getAnnotation(Transactional.class);
        }
        ContractManagerDropDownServiceImpl.deleteFrequency_aroundBody35$advice(this, uiKeyName, list, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    private void deleteLanguage(UiKeyName keyName, List<String> validationErrors) {
        UiKeyName uiKeyName = keyName;
        List<String> list = validationErrors;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$18;
        if (annotation == null) {
            annotation = ajc$anno$18 = ContractManagerDropDownServiceImpl.class.getDeclaredMethod("deleteLanguage", UiKeyName.class, List.class).getAnnotation(Transactional.class);
        }
        ContractManagerDropDownServiceImpl.deleteLanguage_aroundBody37$advice(this, uiKeyName, list, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    private void deletePlatform(UiKeyName keyName, List<String> validationErrors) {
        UiKeyName uiKeyName = keyName;
        List<String> list = validationErrors;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$19;
        if (annotation == null) {
            annotation = ajc$anno$19 = ContractManagerDropDownServiceImpl.class.getDeclaredMethod("deletePlatform", UiKeyName.class, List.class).getAnnotation(Transactional.class);
        }
        ContractManagerDropDownServiceImpl.deletePlatform_aroundBody39$advice(this, uiKeyName, list, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public List<UiContentProvider> getContentProvidersList() {
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$20;
        if (annotation == null) {
            annotation = ajc$anno$20 = ContractManagerDropDownServiceImpl.class.getDeclaredMethod("getContentProvidersList", new Class[0]).getAnnotation(Transactional.class);
        }
        return (List)ContractManagerDropDownServiceImpl.getContentProvidersList_aroundBody41$advice(this, transactionEnforcer, (Transactional)annotation, null);
    }

    private List<UiKeyName> getDeliveryMethodKeyNameList() {
        ArrayList<UiKeyName> values = new ArrayList<UiKeyName>();
        List deliveryMethods = this.deliveryMethodManager.getAllDeliveryMethods();
        for (DeliveryMethod deliveryMethod : deliveryMethods) {
            values.add(this.createKeyName(deliveryMethod.getIdDeliveryMethod(), deliveryMethod.getDeliveryMethod()));
        }
        return values;
    }

    private List<UiKeyName> getMediaTypeKeyNameList() {
        ArrayList<UiKeyName> values = new ArrayList<UiKeyName>();
        List medias = this.mediaManager.getAllMedias();
        for (Media media : medias) {
            values.add(this.createKeyName(media.getIdMedia(), media.getMediaType()));
        }
        return values;
    }

    private List<UiKeyName> getOwnershipKeyNameList() {
        ArrayList<UiKeyName> values = new ArrayList<UiKeyName>();
        List ownerships = this.ownershipManager.getAllOwnerships();
        for (Ownership ownership : ownerships) {
            values.add(this.createKeyName(ownership.getIdOwnership(), ownership.getOwnership()));
        }
        return values;
    }

    private List<UiKeyName> getMetaFormatKeyNameList() {
        ArrayList<UiKeyName> values = new ArrayList<UiKeyName>();
        Collection specificationsList = this.assetSpecificationManager.getSpecsWithFromTTVTranslator();
        for (Specification specification : specificationsList) {
            values.add(this.createKeyName(null, specification.getName()));
        }
        return values;
    }

    private UiKeyName createKeyName(Long key, String name) {
        UiKeyName keyName = new UiKeyName();
        keyName.setKey(key);
        keyName.setName(name);
        return keyName;
    }

    private static final /* synthetic */ void saveCustomDropDownKeyName_aroundBody0(ContractManagerDropDownServiceImpl ajc$this, UiKeyName name, Long userDefinedFieldId) {
        try {
            if (userDefinedFieldId != null) {
                Field field = ajc$this.fieldManager.findById(userDefinedFieldId.longValue());
                FieldDropdown fieldDropDown = new FieldDropdown(field, name.getName());
                if (name.getKey() == null) {
                    ajc$this.fieldDropDownManager.persist(fieldDropDown);
                } else {
                    fieldDropDown.setIdFieldDropdown(name.getKey());
                    ajc$this.fieldDropDownManager.merge(fieldDropDown);
                }
            }
        }
        catch (Exception e) {
            if (e instanceof ContractManagerValidationException) {
                throw new ValidationException(((ContractManagerValidationException)e).getValidationMessages());
            }
            throw new NeptuneException(e.getLocalizedMessage());
        }
    }

    private static final /* synthetic */ Object saveCustomDropDownKeyName_aroundBody1$advice(ContractManagerDropDownServiceImpl ajc$this, UiKeyName name, Long userDefinedFieldId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            ContractManagerDropDownServiceImpl.saveCustomDropDownKeyName_aroundBody0(ajc$this, name, userDefinedFieldId);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContractManagerDropDownServiceImpl.saveCustomDropDownKeyName_aroundBody0(ajc$this, name, userDefinedFieldId);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void deleteCustomDropDown_aroundBody2(ContractManagerDropDownServiceImpl ajc$this, UiKeyName dropDown) {
        try {
            FieldDropdown dbDropDown;
            if (dropDown.getKey() != null && (dbDropDown = ajc$this.fieldDropDownManager.findById(dropDown.getKey().longValue())) != null) {
                ajc$this.fieldDropDownManager.remove(dbDropDown);
            }
        }
        catch (Exception e) {
            if (e instanceof ContractManagerValidationException) {
                throw new ValidationException(((ContractManagerValidationException)e).getValidationMessages());
            }
            throw new NeptuneException(e.getLocalizedMessage());
        }
    }

    private static final /* synthetic */ Object deleteCustomDropDown_aroundBody3$advice(ContractManagerDropDownServiceImpl ajc$this, UiKeyName dropDown, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            ContractManagerDropDownServiceImpl.deleteCustomDropDown_aroundBody2(ajc$this, dropDown);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContractManagerDropDownServiceImpl.deleteCustomDropDown_aroundBody2(ajc$this, dropDown);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ UiDevices getDevices_aroundBody4(ContractManagerDropDownServiceImpl ajc$this, int start, int length, String sortProperty, boolean isAscending) {
        UiDevices uiDevices = new UiDevices(null, ajc$this.deviceManager.count());
        List devices = ajc$this.deviceManager.getDevices(start, length, sortProperty, isAscending);
        for (Device device : devices) {
            uiDevices.getDevices().add(ObjectsConverter.createUiDevice(device));
        }
        return uiDevices;
    }

    private static final /* synthetic */ Object getDevices_aroundBody5$advice(ContractManagerDropDownServiceImpl ajc$this, int start, int length, String sortProperty, boolean isAscending, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContractManagerDropDownServiceImpl.getDevices_aroundBody4(ajc$this, start, length, sortProperty, isAscending);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            UiDevices object = ContractManagerDropDownServiceImpl.getDevices_aroundBody4(ajc$this, start, length, sortProperty, isAscending);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void saveDevice_aroundBody6(ContractManagerDropDownServiceImpl ajc$this, UiDevice device) {
        try {
            Platform dbPlatform = ajc$this.platformManager.findById(device.getPlatform().getKey().longValue());
            Device dbDevice = new Device(dbPlatform, device.getName());
            if (device.getKey() == null) {
                ajc$this.deviceManager.persist(dbDevice);
            } else {
                dbDevice.setIdDevice(device.getKey());
                ajc$this.deviceManager.merge(dbDevice);
            }
        }
        catch (Exception e) {
            if (e instanceof ContractManagerValidationException) {
                throw new ValidationException(((ContractManagerValidationException)e).getValidationMessages());
            }
            throw new NeptuneException(e.getLocalizedMessage());
        }
    }

    private static final /* synthetic */ Object saveDevice_aroundBody7$advice(ContractManagerDropDownServiceImpl ajc$this, UiDevice device, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            ContractManagerDropDownServiceImpl.saveDevice_aroundBody6(ajc$this, device);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContractManagerDropDownServiceImpl.saveDevice_aroundBody6(ajc$this, device);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void deleteDevice_aroundBody8(ContractManagerDropDownServiceImpl ajc$this, UiDevice device, List validationErrors) {
        try {
            Device dbDevice;
            if (device.getKey() != null && (dbDevice = ajc$this.deviceManager.findById(device.getKey().longValue())) != null) {
                if (dbDevice.getLicenseDetails().isEmpty()) {
                    ajc$this.deviceManager.remove(dbDevice);
                } else {
                    validationErrors.add("Device (" + dbDevice.getDeviceName() + ") is associated with a License!");
                }
            }
        }
        catch (RuntimeException e) {
            throw new NeptuneException(e.getLocalizedMessage());
        }
    }

    private static final /* synthetic */ Object deleteDevice_aroundBody9$advice(ContractManagerDropDownServiceImpl ajc$this, UiDevice device, List validationErrors, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            ContractManagerDropDownServiceImpl.deleteDevice_aroundBody8(ajc$this, device, validationErrors);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContractManagerDropDownServiceImpl.deleteDevice_aroundBody8(ajc$this, device, validationErrors);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List getDeviceList_aroundBody10(ContractManagerDropDownServiceImpl ajc$this, List selectedPlatforms) {
        HashSet<UiDevice> uiDevices = new HashSet<UiDevice>();
        for (UiPlatform uiPlatform : selectedPlatforms) {
            List devicesByPlatform = ajc$this.deviceManager.findByPlatform(uiPlatform.getKey().longValue());
            for (Device device : devicesByPlatform) {
                uiDevices.add(ObjectsConverter.createUiDevice(device));
            }
        }
        return new ArrayList(uiDevices);
    }

    private static final /* synthetic */ Object getDeviceList_aroundBody11$advice(ContractManagerDropDownServiceImpl ajc$this, List selectedPlatforms, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContractManagerDropDownServiceImpl.getDeviceList_aroundBody10(ajc$this, selectedPlatforms);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = ContractManagerDropDownServiceImpl.getDeviceList_aroundBody10(ajc$this, selectedPlatforms);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void deleteCurrency_aroundBody12(ContractManagerDropDownServiceImpl ajc$this, UiCurrency currency, List validationErrors) {
        block6: {
            try {
                Currency dbCurrency;
                if (currency.getKey() == null || (dbCurrency = ajc$this.currencyManager.findById(currency.getKey().longValue())) == null) break block6;
                if (dbCurrency.getRevenuePricings().isEmpty() && dbCurrency.getLicenseDetails().isEmpty()) {
                    try {
                        ajc$this.currencyManager.remove(dbCurrency);
                        break block6;
                    }
                    catch (Exception e) {
                        if (e instanceof ContractManagerValidationException) {
                            validationErrors.addAll(((ContractManagerValidationException)e).getValidationMessages());
                            break block6;
                        }
                        throw new NeptuneException(e.getLocalizedMessage());
                    }
                }
                validationErrors.add("Currency (" + dbCurrency.getNameAndSymbol() + ") is associated with a License!");
            }
            catch (RuntimeException e) {
                throw new NeptuneException(e.getLocalizedMessage());
            }
        }
    }

    private static final /* synthetic */ Object deleteCurrency_aroundBody13$advice(ContractManagerDropDownServiceImpl ajc$this, UiCurrency currency, List validationErrors, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            ContractManagerDropDownServiceImpl.deleteCurrency_aroundBody12(ajc$this, currency, validationErrors);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContractManagerDropDownServiceImpl.deleteCurrency_aroundBody12(ajc$this, currency, validationErrors);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void deleteCurrency_aroundBody14(ContractManagerDropDownServiceImpl ajc$this, Long currencyId, List validationErrors) {
        try {
            Currency currency = ajc$this.currencyManager.findById(currencyId.longValue());
            ajc$this.currencyManager.remove(currency);
        }
        catch (ContractManagerValidationException cmve) {
            validationErrors.add(cmve.getMessage());
        }
    }

    private static final /* synthetic */ Object deleteCurrency_aroundBody15$advice(ContractManagerDropDownServiceImpl ajc$this, Long currencyId, List validationErrors, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            ContractManagerDropDownServiceImpl.deleteCurrency_aroundBody14(ajc$this, currencyId, validationErrors);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContractManagerDropDownServiceImpl.deleteCurrency_aroundBody14(ajc$this, currencyId, validationErrors);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void saveGenericDropDownKeyName_aroundBody16(ContractManagerDropDownServiceImpl ajc$this, UiKeyName name, ConfigurableFieldTypeEnum fieldType) {
        try {
            switch (fieldType) {
                case LicenseType: {
                    LicenseType dbLicenseType = new LicenseType(name.getName());
                    if (name.getKey() == null) {
                        ajc$this.licenseTypeManager.persist(dbLicenseType);
                        break;
                    }
                    dbLicenseType.setIdType(name.getKey());
                    ajc$this.licenseTypeManager.merge(dbLicenseType);
                    break;
                }
                case ContractType: {
                    ContractType dbContractType = new ContractType(name.getName());
                    if (name.getKey() == null) {
                        ajc$this.contractTypeManager.persist(dbContractType);
                        break;
                    }
                    dbContractType.setIdType(name.getKey());
                    ajc$this.contractTypeManager.merge(dbContractType);
                    break;
                }
                case DealType: {
                    DealType dbDealType = new DealType(name.getName());
                    if (name.getKey() == null) {
                        ajc$this.dealTypeManager.persist(dbDealType);
                        break;
                    }
                    dbDealType.setIdType(name.getKey());
                    ajc$this.dealTypeManager.merge(dbDealType);
                    break;
                }
                case DeliveryMethod: {
                    DeliveryMethod dbDeliveryMethod = new DeliveryMethod(name.getName());
                    if (name.getKey() == null) {
                        ajc$this.deliveryMethodManager.persist(dbDeliveryMethod);
                        break;
                    }
                    dbDeliveryMethod.setIdDeliveryMethod(name.getKey());
                    ajc$this.deliveryMethodManager.merge(dbDeliveryMethod);
                    break;
                }
                case MediaType: {
                    Media dbMedia = new Media(name.getName());
                    if (name.getKey() == null) {
                        ajc$this.mediaManager.persist(dbMedia);
                        break;
                    }
                    dbMedia.setIdMedia(name.getKey());
                    ajc$this.mediaManager.merge(dbMedia);
                    break;
                }
                case Ownership: {
                    Ownership dbOwner = new Ownership(name.getName());
                    if (name.getKey() == null) {
                        ajc$this.ownershipManager.persist(dbOwner);
                        break;
                    }
                    dbOwner.setIdOwnership(name.getKey());
                    ajc$this.ownershipManager.merge(dbOwner);
                    break;
                }
                case Frequency: {
                    Frequency dbFrequency = new Frequency(name.getName());
                    if (name.getKey() == null) {
                        ajc$this.frequencyManager.persist(dbFrequency);
                        break;
                    }
                    dbFrequency.setIdFrequency(name.getKey());
                    ajc$this.frequencyManager.merge(dbFrequency);
                    break;
                }
                case Language: {
                    Language dbLanguage = new Language(name.getName());
                    if (name.getKey() == null) {
                        ajc$this.languageManager.persist(dbLanguage);
                        break;
                    }
                    dbLanguage.setIdLanguage(name.getKey());
                    ajc$this.languageManager.merge(dbLanguage);
                    break;
                }
                case Platform: {
                    Platform dbPlatform = new Platform(name.getName());
                    if (name.getKey() == null) {
                        ajc$this.platformManager.persist(dbPlatform);
                        break;
                    }
                    dbPlatform.setIdPlatform(name.getKey());
                    ajc$this.platformManager.merge(dbPlatform);
                }
            }
        }
        catch (Exception e) {
            if (e instanceof ContractManagerValidationException) {
                throw new ValidationException(((ContractManagerValidationException)((Object)e)).getValidationMessages());
            }
            throw new NeptuneException(e.getLocalizedMessage());
        }
    }

    private static final /* synthetic */ Object saveGenericDropDownKeyName_aroundBody17$advice(ContractManagerDropDownServiceImpl ajc$this, UiKeyName name, ConfigurableFieldTypeEnum fieldType, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            ContractManagerDropDownServiceImpl.saveGenericDropDownKeyName_aroundBody16(ajc$this, name, fieldType);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContractManagerDropDownServiceImpl.saveGenericDropDownKeyName_aroundBody16(ajc$this, name, fieldType);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List getContractTypeKeyNameList_aroundBody18(ContractManagerDropDownServiceImpl ajc$this) {
        ArrayList<UiKeyName> types = new ArrayList<UiKeyName>();
        List contractTypeList = ajc$this.contractTypeManager.getAllContractTypes();
        for (ContractType contractType : contractTypeList) {
            UiKeyName keyName = new UiKeyName();
            keyName.setKey(contractType.getIdType());
            keyName.setName(contractType.getType());
            types.add(keyName);
        }
        return types;
    }

    private static final /* synthetic */ Object getContractTypeKeyNameList_aroundBody19$advice(ContractManagerDropDownServiceImpl ajc$this, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContractManagerDropDownServiceImpl.getContractTypeKeyNameList_aroundBody18(ajc$this);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = ContractManagerDropDownServiceImpl.getContractTypeKeyNameList_aroundBody18(ajc$this);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List getDealTypeKeyNameList_aroundBody20(ContractManagerDropDownServiceImpl ajc$this) {
        ArrayList<UiKeyName> types = new ArrayList<UiKeyName>();
        List contractTypeList = ajc$this.dealTypeManager.getAllDealTypes();
        for (DealType dealType : contractTypeList) {
            UiKeyName keyName = new UiKeyName();
            keyName.setKey(dealType.getIdType());
            keyName.setName(dealType.getType());
            types.add(keyName);
        }
        return types;
    }

    private static final /* synthetic */ Object getDealTypeKeyNameList_aroundBody21$advice(ContractManagerDropDownServiceImpl ajc$this, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContractManagerDropDownServiceImpl.getDealTypeKeyNameList_aroundBody20(ajc$this);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = ContractManagerDropDownServiceImpl.getDealTypeKeyNameList_aroundBody20(ajc$this);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void deleteLicenseType_aroundBody22(ContractManagerDropDownServiceImpl ajc$this, UiKeyName keyName, List validationErrors) {
        LicenseType dbLicenseType;
        if (keyName.getKey() != null && (dbLicenseType = ajc$this.licenseTypeManager.findById(keyName.getKey().longValue())) != null) {
            if (dbLicenseType.getLicenses().isEmpty()) {
                ajc$this.licenseTypeManager.remove(dbLicenseType);
            } else {
                validationErrors.add("LicenseType (" + dbLicenseType.getType() + ") is associated with a License!");
            }
        }
    }

    private static final /* synthetic */ Object deleteLicenseType_aroundBody23$advice(ContractManagerDropDownServiceImpl ajc$this, UiKeyName keyName, List validationErrors, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            ContractManagerDropDownServiceImpl.deleteLicenseType_aroundBody22(ajc$this, keyName, validationErrors);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContractManagerDropDownServiceImpl.deleteLicenseType_aroundBody22(ajc$this, keyName, validationErrors);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void deleteContractType_aroundBody24(ContractManagerDropDownServiceImpl ajc$this, UiKeyName keyName, List validationErrors) {
        ContractType dbContractType;
        if (keyName.getKey() != null && (dbContractType = ajc$this.contractTypeManager.findById(keyName.getKey().longValue())) != null) {
            if (dbContractType.getContracts().isEmpty()) {
                ajc$this.contractTypeManager.remove(dbContractType);
            } else {
                validationErrors.add("ContractType (" + dbContractType.getType() + ") is associated with a Contract!");
            }
        }
    }

    private static final /* synthetic */ Object deleteContractType_aroundBody25$advice(ContractManagerDropDownServiceImpl ajc$this, UiKeyName keyName, List validationErrors, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            ContractManagerDropDownServiceImpl.deleteContractType_aroundBody24(ajc$this, keyName, validationErrors);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContractManagerDropDownServiceImpl.deleteContractType_aroundBody24(ajc$this, keyName, validationErrors);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void deleteDealType_aroundBody26(ContractManagerDropDownServiceImpl ajc$this, UiKeyName keyName, List validationErrors) {
        DealType dbDealType;
        if (keyName.getKey() != null && (dbDealType = ajc$this.dealTypeManager.findById(keyName.getKey().longValue())) != null) {
            if (dbDealType.getDeals().isEmpty()) {
                ajc$this.dealTypeManager.remove(dbDealType);
            } else {
                validationErrors.add("DealType (" + dbDealType.getType() + ") is associated with a Deal!");
            }
        }
    }

    private static final /* synthetic */ Object deleteDealType_aroundBody27$advice(ContractManagerDropDownServiceImpl ajc$this, UiKeyName keyName, List validationErrors, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            ContractManagerDropDownServiceImpl.deleteDealType_aroundBody26(ajc$this, keyName, validationErrors);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContractManagerDropDownServiceImpl.deleteDealType_aroundBody26(ajc$this, keyName, validationErrors);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void deleteDeliveryMethod_aroundBody28(ContractManagerDropDownServiceImpl ajc$this, UiKeyName keyName, List validationErrors) {
        DeliveryMethod deliveryMethod;
        if (keyName.getKey() != null && (deliveryMethod = ajc$this.deliveryMethodManager.findById(keyName.getKey().longValue())) != null) {
            if (deliveryMethod.getDistributionManagements().isEmpty()) {
                ajc$this.deliveryMethodManager.remove(deliveryMethod);
            } else {
                validationErrors.add("Delivery Method (" + deliveryMethod.getDeliveryMethod() + ") is associated with a License!");
            }
        }
    }

    private static final /* synthetic */ Object deleteDeliveryMethod_aroundBody29$advice(ContractManagerDropDownServiceImpl ajc$this, UiKeyName keyName, List validationErrors, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            ContractManagerDropDownServiceImpl.deleteDeliveryMethod_aroundBody28(ajc$this, keyName, validationErrors);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContractManagerDropDownServiceImpl.deleteDeliveryMethod_aroundBody28(ajc$this, keyName, validationErrors);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void deleteMediaType_aroundBody30(ContractManagerDropDownServiceImpl ajc$this, UiKeyName keyName, List validationErrors) {
        Media mediaType;
        if (keyName.getKey() != null && (mediaType = ajc$this.mediaManager.findById(keyName.getKey().longValue())) != null) {
            if (mediaType.getDistributionManagements().isEmpty()) {
                ajc$this.mediaManager.remove(mediaType);
            } else {
                validationErrors.add("Media Type (" + mediaType.getMediaType() + ") is associated with a License!");
            }
        }
    }

    private static final /* synthetic */ Object deleteMediaType_aroundBody31$advice(ContractManagerDropDownServiceImpl ajc$this, UiKeyName keyName, List validationErrors, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            ContractManagerDropDownServiceImpl.deleteMediaType_aroundBody30(ajc$this, keyName, validationErrors);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContractManagerDropDownServiceImpl.deleteMediaType_aroundBody30(ajc$this, keyName, validationErrors);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void deleteOwnership_aroundBody32(ContractManagerDropDownServiceImpl ajc$this, UiKeyName keyName, List validationErrors) {
        Ownership owner;
        if (keyName.getKey() != null && (owner = ajc$this.ownershipManager.findById(keyName.getKey().longValue())) != null) {
            if (owner.getDistributionManagements().isEmpty()) {
                ajc$this.ownershipManager.remove(owner);
            } else {
                validationErrors.add("Ownership (" + owner.getOwnership() + ") is associated with a License!");
            }
        }
    }

    private static final /* synthetic */ Object deleteOwnership_aroundBody33$advice(ContractManagerDropDownServiceImpl ajc$this, UiKeyName keyName, List validationErrors, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            ContractManagerDropDownServiceImpl.deleteOwnership_aroundBody32(ajc$this, keyName, validationErrors);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContractManagerDropDownServiceImpl.deleteOwnership_aroundBody32(ajc$this, keyName, validationErrors);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void deleteFrequency_aroundBody34(ContractManagerDropDownServiceImpl ajc$this, UiKeyName keyName, List validationErrors) {
        Frequency frequency;
        if (keyName.getKey() != null && (frequency = ajc$this.frequencyManager.findById(keyName.getKey().longValue())) != null) {
            try {
                ajc$this.frequencyManager.remove(frequency);
            }
            catch (Exception e) {
                if (e instanceof ContractManagerValidationException) {
                    validationErrors.addAll(((ContractManagerValidationException)((Object)e)).getValidationMessages());
                }
                throw new ContractManagerValidationException(e.getMessage());
            }
        }
    }

    private static final /* synthetic */ Object deleteFrequency_aroundBody35$advice(ContractManagerDropDownServiceImpl ajc$this, UiKeyName keyName, List validationErrors, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            ContractManagerDropDownServiceImpl.deleteFrequency_aroundBody34(ajc$this, keyName, validationErrors);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContractManagerDropDownServiceImpl.deleteFrequency_aroundBody34(ajc$this, keyName, validationErrors);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void deleteLanguage_aroundBody36(ContractManagerDropDownServiceImpl ajc$this, UiKeyName keyName, List validationErrors) {
        Language language;
        if (keyName.getKey() != null && (language = ajc$this.languageManager.findById(keyName.getKey().longValue())) != null) {
            if (language.getLicenseDetails().isEmpty()) {
                ajc$this.languageManager.remove(language);
            } else {
                validationErrors.add("Language (" + language.getLanguage() + ") is associated with a License!");
            }
        }
    }

    private static final /* synthetic */ Object deleteLanguage_aroundBody37$advice(ContractManagerDropDownServiceImpl ajc$this, UiKeyName keyName, List validationErrors, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            ContractManagerDropDownServiceImpl.deleteLanguage_aroundBody36(ajc$this, keyName, validationErrors);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContractManagerDropDownServiceImpl.deleteLanguage_aroundBody36(ajc$this, keyName, validationErrors);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void deletePlatform_aroundBody38(ContractManagerDropDownServiceImpl ajc$this, UiKeyName keyName, List validationErrors) {
        Platform platform;
        if (keyName.getKey() != null && (platform = ajc$this.platformManager.findById(keyName.getKey().longValue())) != null) {
            if (platform.getLicenseDetails().isEmpty()) {
                ajc$this.platformManager.remove(platform);
            } else {
                validationErrors.add("Platform (" + platform.getDescription() + ") is associated with a License!");
            }
        }
    }

    private static final /* synthetic */ Object deletePlatform_aroundBody39$advice(ContractManagerDropDownServiceImpl ajc$this, UiKeyName keyName, List validationErrors, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            ContractManagerDropDownServiceImpl.deletePlatform_aroundBody38(ajc$this, keyName, validationErrors);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContractManagerDropDownServiceImpl.deletePlatform_aroundBody38(ajc$this, keyName, validationErrors);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List getContentProvidersList_aroundBody40(ContractManagerDropDownServiceImpl ajc$this) {
        ArrayList<UiContentProvider> uiContentProviderList = new ArrayList<UiContentProvider>();
        List partnersList = ajc$this.partnerManagement.getAllActivePartnerDTOsForCurrentUser();
        for (Partner partner : partnersList) {
            if (partner.getType() != PartnerType.SOURCE) continue;
            UiContentProvider uiContentProvider = new UiContentProvider(partner.getProviderId());
            uiContentProvider.setName(partner.getName());
            uiContentProviderList.add(uiContentProvider);
        }
        return uiContentProviderList;
    }

    private static final /* synthetic */ Object getContentProvidersList_aroundBody41$advice(ContractManagerDropDownServiceImpl ajc$this, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContractManagerDropDownServiceImpl.getContentProvidersList_aroundBody40(ajc$this);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = ContractManagerDropDownServiceImpl.getContentProvidersList_aroundBody40(ajc$this);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

