/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.server;

import com.ericsson.cms.contractmgmt.client.customfield.UiUserDefinedField;
import com.ericsson.cms.contractmgmt.client.model.AuditReportResult;
import com.ericsson.cms.contractmgmt.client.model.ContactSearchResult;
import com.ericsson.cms.contractmgmt.client.model.ContractSearchResult;
import com.ericsson.cms.contractmgmt.client.model.CopyrightHolderSearchResult;
import com.ericsson.cms.contractmgmt.client.model.DealSearchResult;
import com.ericsson.cms.contractmgmt.client.model.LicenseSearchResult;
import com.ericsson.cms.contractmgmt.client.model.UiAsset;
import com.ericsson.cms.contractmgmt.client.model.UiAudit;
import com.ericsson.cms.contractmgmt.client.model.UiContact;
import com.ericsson.cms.contractmgmt.client.model.UiContactType;
import com.ericsson.cms.contractmgmt.client.model.UiContract;
import com.ericsson.cms.contractmgmt.client.model.UiCopyrightHolder;
import com.ericsson.cms.contractmgmt.client.model.UiCurrency;
import com.ericsson.cms.contractmgmt.client.model.UiDeal;
import com.ericsson.cms.contractmgmt.client.model.UiKeyName;
import com.ericsson.cms.contractmgmt.client.model.UiKeyNames;
import com.ericsson.cms.contractmgmt.client.model.UiLicense;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerService;
import com.ericsson.cms.contractmgmt.client.tab.config.configurablefield.ConfigurableFieldTypeEnum;
import com.ericsson.cms.contractmgmt.client.tab.license.UiLicenseRecord;
import com.ericsson.cms.contractmgmt.server.ContractManagerDropDownServiceImpl;
import com.ericsson.cms.contractmgmt.server.ContractManagerServiceMessages;
import com.ericsson.cms.contractmgmt.server.ObjectsConverter;
import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.SearchColumn;
import com.ericsson.cms.scheduler.entities.ScheduleRule;
import com.ericsson.cms.scheduling.ui.client.data.ScheduleInfo;
import com.ericsson.cms.scheduling.ui.server.ScheduleConvertor;
import com.ericsson.cms.search.TitleSearchResult;
import com.ericsson.ejb.Audit;
import com.ericsson.ejb.Contract;
import com.ericsson.ejb.ContractContacts;
import com.ericsson.ejb.CopyHolderContacts;
import com.ericsson.ejb.CopyrightHolder;
import com.ericsson.ejb.CustomLicFieldValue;
import com.ericsson.ejb.Deal;
import com.ericsson.ejb.DealContacts;
import com.ericsson.ejb.Field;
import com.ericsson.ejb.License;
import com.ericsson.ejb.SmAssets;
import com.ericsson.ejb.SmAssetsId;
import com.ericsson.enumeration.ScreenName;
import com.ericsson.service.ContractManagerValidationException;
import com.ericsson.service.IAuditManager;
import com.ericsson.service.ICMLicenseManager;
import com.ericsson.service.IContractContactsManager;
import com.ericsson.service.IContractDocumentsManager;
import com.ericsson.service.IContractManager;
import com.ericsson.service.IContractManagerExpiryTimer;
import com.ericsson.service.ICopyHolderContactsManager;
import com.ericsson.service.ICopyrightHolderManager;
import com.ericsson.service.ICustomLicFieldValueManager;
import com.ericsson.service.IDealContactsManager;
import com.ericsson.service.IDealDocumentsManager;
import com.ericsson.service.IDealManager;
import com.ericsson.service.IFieldManager;
import com.ericsson.service.ILicenseDocumentsManager;
import com.ericsson.service.ISmAssetsManager;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.cms.title.search.ITitleSearchService;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException;
import com.tandbergtv.neptune.widgettoolkit.server.NeptuneAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerManagement;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.InitialContext;
import javax.servlet.http.HttpSession;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.runtime.internal.AroundClosure;

public class ContractManagerServiceImpl
implements IContractManagerService,
NeptuneRemoteService {
    private static final Log log = LogFactory.getLog(ContractManagerServiceImpl.class);
    private static final String ASSETS_ALREADY_ADDED = "licenseAssetsAlreadyAdded";
    private static final String INVALID_ASSETS = "licenseInvalidAssets";
    private static final String ASSETS_ASSOCIATED_WITH_LICENSES = "licenseAssetsAssociated";
    private final ICopyrightHolderManager chManager = (ICopyrightHolderManager)InjectionUtil.injectInstance((String)"cms/CopyrightHolderManager/local", ICopyrightHolderManager.class);
    private final IContractManager contractManager = (IContractManager)InjectionUtil.injectInstance((String)"cms/ContractManager/local", IContractManager.class);
    private final IDealManager dealManager = (IDealManager)InjectionUtil.injectInstance((String)"cms/DealManager/local", IDealManager.class);
    private final ICopyHolderContactsManager chContactsManager = (ICopyHolderContactsManager)InjectionUtil.injectInstance((String)"cms/CopyHolderContactsManager/local", ICopyHolderContactsManager.class);
    private final IDealContactsManager dealContactManager = (IDealContactsManager)InjectionUtil.injectInstance((String)"cms/DealContactsManager/local", IDealContactsManager.class);
    private final IContractContactsManager contractContactManager = (IContractContactsManager)InjectionUtil.injectInstance((String)"cms/ContractContactsManager/local", IContractContactsManager.class);
    private final ICMLicenseManager cmLicenseManager = (ICMLicenseManager)InjectionUtil.injectInstance((String)"cms/CMLicenseManager/local", ICMLicenseManager.class);
    private final ISmAssetsManager smAssetsManager = (ISmAssetsManager)InjectionUtil.injectInstance((String)"cms/SmAssetsManager/local", ISmAssetsManager.class);
    private final IPartnerManagement partnerManager = (IPartnerManagement)ServiceRegistry.getDefault().lookup(IPartnerManagement.class);
    private final IFieldManager fieldManager = (IFieldManager)InjectionUtil.injectInstance((String)"cms/FieldManager/local", IFieldManager.class);
    private final ITitleSearchService searchService = (ITitleSearchService)InjectionUtil.injectInstance((String)"cms/TitleSearchServiceProxy/local", ITitleSearchService.class);
    private final ICMLicenseManager licenseManager = (ICMLicenseManager)InjectionUtil.injectInstance((String)"cms/CMLicenseManager/local", ICMLicenseManager.class);
    private final IContractDocumentsManager contractDocManager = (IContractDocumentsManager)InjectionUtil.injectInstance((String)"cms/ContractDocumentsManager/local", IContractDocumentsManager.class);
    private final ILicenseDocumentsManager licenseDocManager = (ILicenseDocumentsManager)InjectionUtil.injectInstance((String)"cms/LicenseDocumentsManager/local", ILicenseDocumentsManager.class);
    private final IDealDocumentsManager dealDocManager = (IDealDocumentsManager)InjectionUtil.injectInstance((String)"cms/DealDocumentsManager/local", IDealDocumentsManager.class);
    private final ICustomLicFieldValueManager fieldValueManager = (ICustomLicFieldValueManager)InjectionUtil.injectInstance((String)"cms/CustomLicFieldValueManager/local", ICustomLicFieldValueManager.class);
    private final IAuditManager auditManager = (IAuditManager)InjectionUtil.injectInstance((String)"cms/AuditManager/local", IAuditManager.class);
    private final IContractManagerExpiryTimer expiryTimerManager = (IContractManagerExpiryTimer)InjectionUtil.injectInstance((String)"cms/EmailNotificationManager/local", IContractManagerExpiryTimer.class);
    private HttpSession httpSession;
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ Annotation ajc$anno$1;
    private static /* synthetic */ Annotation ajc$anno$2;
    private static /* synthetic */ Annotation ajc$anno$3;
    private static /* synthetic */ Annotation ajc$anno$4;
    private static /* synthetic */ Annotation ajc$anno$5;
    private static /* synthetic */ Annotation ajc$anno$6;
    private static /* synthetic */ Annotation ajc$anno$7;
    private static /* synthetic */ Annotation ajc$anno$8;
    private static /* synthetic */ Annotation ajc$anno$9;
    private static /* synthetic */ Annotation ajc$anno$10;
    private static /* synthetic */ Annotation ajc$anno$11;
    private static /* synthetic */ Annotation ajc$anno$12;
    private static /* synthetic */ Annotation ajc$anno$13;
    private static /* synthetic */ Annotation ajc$anno$14;
    private static /* synthetic */ Annotation ajc$anno$15;
    private static /* synthetic */ Annotation ajc$anno$16;
    private static /* synthetic */ Annotation ajc$anno$17;
    private static /* synthetic */ Annotation ajc$anno$18;
    private static /* synthetic */ Annotation ajc$anno$19;
    private static /* synthetic */ Annotation ajc$anno$20;
    private static /* synthetic */ Annotation ajc$anno$21;
    private static /* synthetic */ Annotation ajc$anno$22;
    private static /* synthetic */ Annotation ajc$anno$23;
    private static /* synthetic */ Annotation ajc$anno$24;

    public String getRelativePath() {
        return "service/contract/contractManagerService";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }

    @Override
    public List<UiUserDefinedField> getUserDefinedFields(String screen) throws NeptuneException {
        return this.getUserDefinedFields("fieldOrder", true, screen);
    }

    @Override
    public List<UiUserDefinedField> getLicenseUserDefinedFields() throws NeptuneException {
        ArrayList<UiUserDefinedField> userDefinedFields = new ArrayList<UiUserDefinedField>();
        userDefinedFields.addAll(this.getUserDefinedFields("fieldOrder", true, "LICENSE"));
        userDefinedFields.addAll(this.getUserDefinedFields("fieldOrder", true, "ASSET_ENHANCEMENT"));
        userDefinedFields.addAll(this.getUserDefinedFields("fieldOrder", true, "DISTRIBUTION"));
        userDefinedFields.addAll(this.getUserDefinedFields("fieldOrder", true, "STORAGE_METADATA"));
        return userDefinedFields;
    }

    private boolean containsCustomKey(UiKeyName key, Set<UiKeyName> existingKeyList) {
        if (key != null) {
            for (UiKeyName curExistingKey : existingKeyList) {
                if (key.getKey() == null || curExistingKey == null || curExistingKey.getKey() == null || !key.getKey().equals(curExistingKey.getKey())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void saveUserDefinedField(UiUserDefinedField userDefinedField) throws NeptuneException {
        ContractManagerDropDownServiceImpl dropDownService = new ContractManagerDropDownServiceImpl();
        Set<UiKeyName> keySet = userDefinedField.getKeyNames();
        List<UiKeyName> existingKeyList = dropDownService.getDropDownKeyNameList(userDefinedField.getIdUserDefinedField());
        ArrayList<UiKeyName> obsoleteKeys = new ArrayList<UiKeyName>();
        for (UiKeyName curKey : existingKeyList) {
            if (this.containsCustomKey(curKey, keySet)) continue;
            obsoleteKeys.add(curKey);
        }
        dropDownService.deleteCustomDropDownKeyNames(obsoleteKeys);
        Field dbField = ObjectsConverter.createField(userDefinedField);
        try {
            if (dbField.getIdField() == null) {
                this.fieldManager.persist(dbField);
            } else {
                this.fieldManager.merge(dbField);
            }
        }
        catch (Exception e) {
            if (e instanceof ContractManagerValidationException) {
                throw new ValidationException(((ContractManagerValidationException)((Object)e)).getValidationMessages());
            }
            throw new NeptuneException(e.getLocalizedMessage());
        }
    }

    @Override
    public void deleteUserDefinedFields(List<UiUserDefinedField> userDefinedFields) throws NeptuneException {
        ArrayList<String> validationErrors = new ArrayList<String>();
        for (UiUserDefinedField userDefinedField : userDefinedFields) {
            this.deleteUserDefinedField(userDefinedField, validationErrors);
        }
        if (!validationErrors.isEmpty()) {
            throw new ValidationException(validationErrors);
        }
    }

    @Transactional
    private void deleteUserDefinedField(UiUserDefinedField userDefinedField, List<String> validationErrors) throws NeptuneException {
        UiUserDefinedField uiUserDefinedField = userDefinedField;
        List<String> list = validationErrors;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = ContractManagerServiceImpl.class.getDeclaredMethod("deleteUserDefinedField", UiUserDefinedField.class, List.class).getAnnotation(Transactional.class);
        }
        ContractManagerServiceImpl.deleteUserDefinedField_aroundBody1$advice(this, uiUserDefinedField, list, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public List<UiUserDefinedField> getUserDefinedFields(String sortByProperty, boolean isAscending, String screen) throws NeptuneException {
        String string = sortByProperty;
        boolean bl = isAscending;
        String string2 = screen;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = ContractManagerServiceImpl.class.getDeclaredMethod("getUserDefinedFields", String.class, Boolean.TYPE, String.class).getAnnotation(Transactional.class);
        }
        return (List)ContractManagerServiceImpl.getUserDefinedFields_aroundBody3$advice(this, string, bl, string2, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public LicenseSearchResult getLicenseList(int start, int length, String sortProperty, boolean isAscending) throws NeptuneException {
        int n = start;
        int n2 = length;
        String string = sortProperty;
        boolean bl = isAscending;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$2;
        if (annotation == null) {
            annotation = ajc$anno$2 = ContractManagerServiceImpl.class.getDeclaredMethod("getLicenseList", Integer.TYPE, Integer.TYPE, String.class, Boolean.TYPE).getAnnotation(Transactional.class);
        }
        return (LicenseSearchResult)ContractManagerServiceImpl.getLicenseList_aroundBody5$advice(this, n, n2, string, bl, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public UiLicense getLicense(Long key) throws NeptuneException {
        Long l = key;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$3;
        if (annotation == null) {
            annotation = ajc$anno$3 = ContractManagerServiceImpl.class.getDeclaredMethod("getLicense", Long.class).getAnnotation(Transactional.class);
        }
        return (UiLicense)ContractManagerServiceImpl.getLicense_aroundBody7$advice(this, l, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public UiLicense getFullLicense(Long key) throws NeptuneException {
        Long l = key;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$4;
        if (annotation == null) {
            annotation = ajc$anno$4 = ContractManagerServiceImpl.class.getDeclaredMethod("getFullLicense", Long.class).getAnnotation(Transactional.class);
        }
        return (UiLicense)ContractManagerServiceImpl.getFullLicense_aroundBody9$advice(this, l, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public void saveLicense(UiLicenseRecord uiLicenseRecord) throws NeptuneException {
        UiLicenseRecord uiLicenseRecord2 = uiLicenseRecord;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$5;
        if (annotation == null) {
            annotation = ajc$anno$5 = ContractManagerServiceImpl.class.getDeclaredMethod("saveLicense", UiLicenseRecord.class).getAnnotation(Transactional.class);
        }
        ContractManagerServiceImpl.saveLicense_aroundBody11$advice(this, uiLicenseRecord2, transactionEnforcer, (Transactional)annotation, null);
    }

    private ContractManagerValidationException findContractManagerValidationException(Exception e) {
        ContractManagerValidationException result = null;
        if (e instanceof ContractManagerValidationException) {
            result = (ContractManagerValidationException)((Object)e);
        } else {
            Throwable current = e;
            while (current.getCause() != null) {
                if (!((current = current.getCause()) instanceof ContractManagerValidationException)) continue;
                result = (ContractManagerValidationException)current;
                break;
            }
        }
        return result;
    }

    private ValidationException findValidationException(Exception e) {
        ValidationException result = null;
        if (e instanceof ValidationException) {
            result = (ValidationException)((Object)e);
        } else {
            Throwable current = e;
            while (current.getCause() != null) {
                if (!((current = current.getCause()) instanceof ValidationException)) continue;
                result = (ValidationException)current;
                break;
            }
        }
        return result;
    }

    @Override
    @Transactional
    public void deleteLicense(Long licenseId) throws NeptuneException {
        Long l = licenseId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$6;
        if (annotation == null) {
            annotation = ajc$anno$6 = ContractManagerServiceImpl.class.getDeclaredMethod("deleteLicense", Long.class).getAnnotation(Transactional.class);
        }
        ContractManagerServiceImpl.deleteLicense_aroundBody13$advice(this, l, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    public void deleteLicenses(List<UiLicenseRecord> records) throws NeptuneException {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Delete"});
        ArrayList validationErrors = new ArrayList();
        for (UiLicenseRecord uiLicenseRecord : records) {
            try {
                this.deleteLicense(uiLicenseRecord.getLicense().getKey());
            }
            catch (Exception e) {
                ContractManagerValidationException cmve = this.findContractManagerValidationException(e);
                if (cmve != null) {
                    validationErrors.addAll(cmve.getValidationMessages());
                    continue;
                }
                ValidationException ve = this.findValidationException(e);
                if (ve != null) {
                    validationErrors.addAll(ve.getValidationMessages());
                    continue;
                }
                throw new NeptuneException(e.getLocalizedMessage());
            }
        }
        if (!validationErrors.isEmpty()) {
            throw new ValidationException(validationErrors);
        }
    }

    @Override
    public Boolean saveContact(UiContact contact, UiContactType contactType, Long parentId) throws NeptuneException {
        if (contactType.equals((Object)UiContactType.COPYRIGHT_HOLDER)) {
            CopyrightHolder copyrightHolder = this.chManager.findById(parentId.longValue());
            CopyHolderContacts copyContact = (CopyHolderContacts)ObjectsConverter.createContact(contact, copyrightHolder, ObjectsConverter.ContactType.COPYRIGHT_HOLDER);
            if (copyContact.getIdContact() == null) {
                try {
                    this.chContactsManager.persist(copyContact);
                }
                catch (ContractManagerValidationException e) {
                    throw new NeptuneException(e.getMessage());
                }
            } else {
                try {
                    this.chContactsManager.merge(copyContact);
                }
                catch (ContractManagerValidationException e) {
                    throw new NeptuneException(e.getMessage());
                }
            }
        } else if (contactType.equals((Object)UiContactType.CONTRACT)) {
            Contract contract = this.contractManager.findById(parentId.longValue());
            ContractContacts contractContact = (ContractContacts)ObjectsConverter.createContact(contact, contract, ObjectsConverter.ContactType.CONTRACT);
            if (contractContact.getIdContact() == null) {
                try {
                    this.contractContactManager.persist(contractContact);
                }
                catch (ContractManagerValidationException e) {
                    throw new NeptuneException(e.getMessage());
                }
            } else {
                try {
                    this.contractContactManager.merge(contractContact);
                }
                catch (ContractManagerValidationException e) {
                    throw new NeptuneException(e.getMessage());
                }
            }
        } else if (contactType.equals((Object)UiContactType.DEAL)) {
            Deal contract = this.dealManager.findById(parentId.longValue());
            DealContacts dealContact = (DealContacts)ObjectsConverter.createContact(contact, contract, ObjectsConverter.ContactType.DEAL);
            if (dealContact.getIdContact() == null) {
                try {
                    this.dealContactManager.persist(dealContact);
                }
                catch (ContractManagerValidationException e) {
                    throw new NeptuneException(e.getMessage());
                }
            }
            try {
                this.dealContactManager.merge(dealContact);
            }
            catch (ContractManagerValidationException e) {
                throw new NeptuneException(e.getMessage());
            }
        }
        return Boolean.TRUE;
    }

    @Override
    public ContactSearchResult getCopyrightHolderContactList(Long copyrightHolderKey, String sortProperty, boolean isAscending) throws NeptuneException {
        List copyHolderContactList = this.chContactsManager.getCopyrightHoldersContacts(copyrightHolderKey, sortProperty, isAscending);
        List<UiContact> contactList = ObjectsConverter.createUiCopyHolderContactList(copyHolderContactList);
        return new ContactSearchResult(contactList, 0);
    }

    @Override
    public Boolean saveContract(UiContract uiContract) throws NeptuneException {
        CopyrightHolder copy = this.chManager.findById(uiContract.getCopyrightHolder().getKey().longValue());
        try {
            Contract contract = ObjectsConverter.createContract(uiContract, copy);
            List<Long> obsoleteContacts = null;
            if (contract.getIdContract() != null) {
                obsoleteContacts = this.findObsoleteContacts(contract);
            }
            if (uiContract.getKey() == null) {
                this.contractManager.persist(contract);
            } else {
                List docsList = this.contractDocManager.findByContract(contract.getIdContract().longValue());
                contract.setContractDocuments(new HashSet(docsList));
                List dealList = this.dealManager.findByContract(contract.getIdContract().longValue());
                contract.setDeals(new HashSet(dealList));
                this.contractManager.merge(contract);
            }
            if (obsoleteContacts != null) {
                for (Long curContact : obsoleteContacts) {
                    this.deleteContractContact(curContact);
                }
            }
        }
        catch (ContractManagerValidationException e) {
            throw new NeptuneException(e.getMessage());
        }
        catch (Exception exception) {
            throw new NeptuneException("The save operation failed. Please verify if Copyright Holder name is unique.");
        }
        return true;
    }

    @Transactional
    private void deleteContractContact(Long key) {
        Long l = key;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$7;
        if (annotation == null) {
            annotation = ajc$anno$7 = ContractManagerServiceImpl.class.getDeclaredMethod("deleteContractContact", Long.class).getAnnotation(Transactional.class);
        }
        ContractManagerServiceImpl.deleteContractContact_aroundBody15$advice(this, l, transactionEnforcer, (Transactional)annotation, null);
    }

    private List<Long> findObsoleteContacts(Contract contract) {
        ArrayList<Long> contactList = new ArrayList<Long>();
        Set newContacts = contract.getContractContacts();
        List origContacts = this.contractContactManager.findByContract(contract.getIdContract().longValue());
        for (ContractContacts origContact : origContacts) {
            if (ContractManagerServiceImpl.containsContact(newContacts, origContact)) continue;
            contactList.add(origContact.getIdContact());
        }
        return contactList;
    }

    private static boolean containsContact(Set<ContractContacts> newContacts, ContractContacts origContact) {
        for (ContractContacts newContact : newContacts) {
            if (newContact.getIdContact() == null || !newContact.getIdContact().equals(origContact.getIdContact())) continue;
            return true;
        }
        return false;
    }

    @Transactional
    private void deleteCopyrightContact(Long key) {
        Long l = key;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$8;
        if (annotation == null) {
            annotation = ajc$anno$8 = ContractManagerServiceImpl.class.getDeclaredMethod("deleteCopyrightContact", Long.class).getAnnotation(Transactional.class);
        }
        ContractManagerServiceImpl.deleteCopyrightContact_aroundBody17$advice(this, l, transactionEnforcer, (Transactional)annotation, null);
    }

    private List<Long> findObsoleteContacts(CopyrightHolder cp) {
        ArrayList<Long> contactList = new ArrayList<Long>();
        Set newContacts = cp.getCopyHolderContacts();
        List origContacts = this.chContactsManager.findByCopyrightHolder(cp.getIdCopyrightHolder().longValue());
        for (CopyHolderContacts origContact : origContacts) {
            if (ContractManagerServiceImpl.containsContact(newContacts, origContact)) continue;
            contactList.add(origContact.getIdContact());
        }
        return contactList;
    }

    private static boolean containsContact(Set<CopyHolderContacts> newContacts, CopyHolderContacts origContact) {
        for (CopyHolderContacts newContact : newContacts) {
            if (newContact.getIdContact() == null || !newContact.getIdContact().equals(origContact.getIdContact())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean saveCopyrightHolder(UiCopyrightHolder copyrightHolder) throws NeptuneException {
        try {
            CopyrightHolder cp = ObjectsConverter.createCopyrightHolder(copyrightHolder);
            List<Long> obsoleteContacts = null;
            if (cp.getIdCopyrightHolder() != null) {
                obsoleteContacts = this.findObsoleteContacts(cp);
            }
            if (copyrightHolder.getKey() == null) {
                this.chManager.persist(cp);
            } else {
                this.chManager.merge(cp);
            }
            if (obsoleteContacts != null) {
                for (Long curContact : obsoleteContacts) {
                    this.deleteCopyrightContact(curContact);
                }
            }
        }
        catch (ContractManagerValidationException e) {
            throw new NeptuneException(e.getMessage());
        }
        catch (Exception e) {
            log.warn((Object)"fail to save the deal, ", (Throwable)e);
            throw new NeptuneException("The save operation failed. Please verify the input.");
        }
        return Boolean.TRUE;
    }

    @Override
    @Transactional
    public Boolean deleteCopyrightHolders(List<UiCopyrightHolder> list) {
        List<UiCopyrightHolder> list2 = list;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$9;
        if (annotation == null) {
            annotation = ajc$anno$9 = ContractManagerServiceImpl.class.getDeclaredMethod("deleteCopyrightHolders", List.class).getAnnotation(Transactional.class);
        }
        return (Boolean)ContractManagerServiceImpl.deleteCopyrightHolders_aroundBody19$advice(this, list2, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public CopyrightHolderSearchResult getCopyrightHolderList(int start, int length, String sortProperty, boolean isAscending) throws NeptuneException {
        int n = start;
        int n2 = length;
        String string = sortProperty;
        boolean bl = isAscending;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$10;
        if (annotation == null) {
            annotation = ajc$anno$10 = ContractManagerServiceImpl.class.getDeclaredMethod("getCopyrightHolderList", Integer.TYPE, Integer.TYPE, String.class, Boolean.TYPE).getAnnotation(Transactional.class);
        }
        return (CopyrightHolderSearchResult)ContractManagerServiceImpl.getCopyrightHolderList_aroundBody21$advice(this, n, n2, string, bl, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public ContractSearchResult getContractList(int start, int length, String sortProperty, boolean isAscending) {
        int n = start;
        int n2 = length;
        String string = sortProperty;
        boolean bl = isAscending;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$11;
        if (annotation == null) {
            annotation = ajc$anno$11 = ContractManagerServiceImpl.class.getDeclaredMethod("getContractList", Integer.TYPE, Integer.TYPE, String.class, Boolean.TYPE).getAnnotation(Transactional.class);
        }
        return (ContractSearchResult)ContractManagerServiceImpl.getContractList_aroundBody23$advice(this, n, n2, string, bl, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public List<UiContract> getCopyrightHolderContractList(Long copyrightHolderId) {
        Long l = copyrightHolderId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$12;
        if (annotation == null) {
            annotation = ajc$anno$12 = ContractManagerServiceImpl.class.getDeclaredMethod("getCopyrightHolderContractList", Long.class).getAnnotation(Transactional.class);
        }
        return (List)ContractManagerServiceImpl.getCopyrightHolderContractList_aroundBody25$advice(this, l, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public Boolean deleteContracts(List<UiContract> list) {
        List<UiContract> list2 = list;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$13;
        if (annotation == null) {
            annotation = ajc$anno$13 = ContractManagerServiceImpl.class.getDeclaredMethod("deleteContracts", List.class).getAnnotation(Transactional.class);
        }
        return (Boolean)ContractManagerServiceImpl.deleteContracts_aroundBody27$advice(this, list2, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public Boolean deleteDeals(List<UiDeal> list) {
        List<UiDeal> list2 = list;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$14;
        if (annotation == null) {
            annotation = ajc$anno$14 = ContractManagerServiceImpl.class.getDeclaredMethod("deleteDeals", List.class).getAnnotation(Transactional.class);
        }
        return (Boolean)ContractManagerServiceImpl.deleteDeals_aroundBody29$advice(this, list2, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public List<UiDeal> getContractDealsList(Long key) {
        Long l = key;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$15;
        if (annotation == null) {
            annotation = ajc$anno$15 = ContractManagerServiceImpl.class.getDeclaredMethod("getContractDealsList", Long.class).getAnnotation(Transactional.class);
        }
        return (List)ContractManagerServiceImpl.getContractDealsList_aroundBody31$advice(this, l, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public List<UiLicense> getDealsLicenseList(Long key) {
        Long l = key;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$16;
        if (annotation == null) {
            annotation = ajc$anno$16 = ContractManagerServiceImpl.class.getDeclaredMethod("getDealsLicenseList", Long.class).getAnnotation(Transactional.class);
        }
        return (List)ContractManagerServiceImpl.getDealsLicenseList_aroundBody33$advice(this, l, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public UiContract getContract(Long key) {
        Long l = key;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$17;
        if (annotation == null) {
            annotation = ajc$anno$17 = ContractManagerServiceImpl.class.getDeclaredMethod("getContract", Long.class).getAnnotation(Transactional.class);
        }
        return (UiContract)ContractManagerServiceImpl.getContract_aroundBody35$advice(this, l, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public DealSearchResult getDealsList(int start, int length, String sortProperty, boolean isAscending) {
        int n = start;
        int n2 = length;
        String string = sortProperty;
        boolean bl = isAscending;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$18;
        if (annotation == null) {
            annotation = ajc$anno$18 = ContractManagerServiceImpl.class.getDeclaredMethod("getDealsList", Integer.TYPE, Integer.TYPE, String.class, Boolean.TYPE).getAnnotation(Transactional.class);
        }
        return (DealSearchResult)ContractManagerServiceImpl.getDealsList_aroundBody37$advice(this, n, n2, string, bl, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    public Boolean saveDeal(UiDeal uiDeal) throws NeptuneException {
        Contract contract = this.contractManager.findById(uiDeal.getContract().getKey().longValue());
        try {
            Deal detached = ObjectsConverter.createDeal(uiDeal, contract);
            List<Long> obsoleteContacts = null;
            if (detached.getIdDeal() != null) {
                obsoleteContacts = this.findObsoleteContacts(detached);
            }
            if (uiDeal.getKey() == null) {
                this.dealManager.persist(detached);
            } else {
                List docsList = this.dealDocManager.findByDeal(detached.getIdDeal().longValue());
                detached.setDealDocuments(new HashSet(docsList));
                List dealList = this.licenseManager.findByDealId(detached.getIdDeal());
                detached.setLicenses(new HashSet(dealList));
                this.dealManager.merge(detached);
            }
            if (obsoleteContacts != null) {
                for (Long curContact : obsoleteContacts) {
                    this.deleteDealContact(curContact);
                }
            }
        }
        catch (ContractManagerValidationException e) {
            throw new NeptuneException(e.getMessage());
        }
        catch (Exception e) {
            log.warn((Object)"fail to save the deal, ", (Throwable)e);
            throw new NeptuneException("The save operation failed. Please verify the input.");
        }
        return true;
    }

    @Override
    @Transactional
    public UiDeal getDeal(Long key) {
        Long l = key;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$19;
        if (annotation == null) {
            annotation = ajc$anno$19 = ContractManagerServiceImpl.class.getDeclaredMethod("getDeal", Long.class).getAnnotation(Transactional.class);
        }
        return (UiDeal)ContractManagerServiceImpl.getDeal_aroundBody39$advice(this, l, transactionEnforcer, (Transactional)annotation, null);
    }

    @Transactional
    private void deleteDealContact(Long key) {
        Long l = key;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$20;
        if (annotation == null) {
            annotation = ajc$anno$20 = ContractManagerServiceImpl.class.getDeclaredMethod("deleteDealContact", Long.class).getAnnotation(Transactional.class);
        }
        ContractManagerServiceImpl.deleteDealContact_aroundBody41$advice(this, l, transactionEnforcer, (Transactional)annotation, null);
    }

    private List<Long> findObsoleteContacts(Deal deal) {
        ArrayList<Long> contactList = new ArrayList<Long>();
        Set newContacts = deal.getDealContacts();
        List origContacts = this.dealContactManager.findByDeal(deal.getIdDeal().longValue());
        for (DealContacts origContact : origContacts) {
            if (ContractManagerServiceImpl.containsContact(newContacts, origContact)) continue;
            contactList.add(origContact.getIdContact());
        }
        return contactList;
    }

    private static boolean containsContact(Set<DealContacts> newContacts, DealContacts origContact) {
        for (DealContacts newContact : newContacts) {
            if (newContact.getIdContact() == null || !newContact.getIdContact().equals(origContact.getIdContact())) continue;
            return true;
        }
        return false;
    }

    @Override
    @Transactional
    public Boolean deleteContacts(List<UiContact> contactList, UiContactType contactType, Long parentId) {
        List<UiContact> list = contactList;
        UiContactType uiContactType = contactType;
        Long l = parentId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$21;
        if (annotation == null) {
            annotation = ajc$anno$21 = ContractManagerServiceImpl.class.getDeclaredMethod("deleteContacts", List.class, UiContactType.class, Long.class).getAnnotation(Transactional.class);
        }
        return (Boolean)ContractManagerServiceImpl.deleteContacts_aroundBody43$advice(this, list, uiContactType, l, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    public UiContact getContact(long contactKey) {
        return null;
    }

    @Override
    @Transactional
    public UiCopyrightHolder getCopyrightHolder(long copyrightHolderKey) {
        long l = copyrightHolderKey;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$22;
        if (annotation == null) {
            annotation = ajc$anno$22 = ContractManagerServiceImpl.class.getDeclaredMethod("getCopyrightHolder", Long.TYPE).getAnnotation(Transactional.class);
        }
        return (UiCopyrightHolder)ContractManagerServiceImpl.getCopyrightHolder_aroundBody45$advice(this, l, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    public ContactSearchResult getContractContactList(Long contractKey, String sortProperty, boolean isAscending) throws NeptuneException {
        List contractContactList = this.contractContactManager.getContractContacts(contractKey, sortProperty, isAscending);
        List<UiContact> contactList = ObjectsConverter.createUiContractContactList(contractContactList);
        return new ContactSearchResult(contactList, 0);
    }

    @Override
    public ContactSearchResult getDealContactList(Long dealKey, String sortProperty, boolean isAscending) {
        List list = this.dealContactManager.getDealContacts(dealKey, sortProperty, isAscending);
        List<UiContact> deallist = ObjectsConverter.createUiDealContactList(list);
        return new ContactSearchResult(deallist, 0);
    }

    @Override
    @Transactional
    public void addAssetsToLicense(long licenseId, List<Long> titleIds) throws NeptuneException {
        long l = licenseId;
        List<Long> list = titleIds;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$23;
        if (annotation == null) {
            annotation = ajc$anno$23 = ContractManagerServiceImpl.class.getDeclaredMethod("addAssetsToLicense", Long.TYPE, List.class).getAnnotation(Transactional.class);
        }
        ContractManagerServiceImpl.addAssetsToLicense_aroundBody47$advice(this, l, list, transactionEnforcer, (Transactional)annotation, null);
    }

    private void throwNeptuneException(Exception e) throws NeptuneException {
        String[] message = e.getLocalizedMessage().split("Exception: ");
        if (message.length > 1 && message[message.length - 2].contains(ContractManagerValidationException.class.getName().replace("Exception", ""))) {
            StringBuffer sb = new StringBuffer();
            String text = message[message.length - 1];
            if (text.startsWith("[") && text.split(" ,").length > 1) {
                text = text.replace("[", "");
                text = text.replace("]", "");
                String[] stringArray = text.split(" ,");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    sb.append(String.format("%n%s", s.trim()));
                    ++n2;
                }
                sb.append(String.format("%n", new Object[0]));
            } else {
                sb.append(String.valueOf(text) + " - ");
            }
            text = MessageFormat.format(ContractManagerServiceMessages.getString("contract.manager.licence.validation.err"), sb.toString());
            throw new NeptuneException(text);
        }
        throw new NeptuneException(e.getLocalizedMessage());
    }

    @Override
    @Transactional
    public void removeAssetsFromLicense(long licenseId, List<Long> titleIds) throws NeptuneException {
        long l = licenseId;
        List<Long> list = titleIds;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$24;
        if (annotation == null) {
            annotation = ajc$anno$24 = ContractManagerServiceImpl.class.getDeclaredMethod("removeAssetsFromLicense", Long.TYPE, List.class).getAnnotation(Transactional.class);
        }
        ContractManagerServiceImpl.removeAssetsFromLicense_aroundBody49$advice(this, l, list, transactionEnforcer, (Transactional)annotation, null);
    }

    private UiAsset getUiAssetById(List<UiAsset> uiAssetsList, Long titleId) {
        UiAsset uiAsset = null;
        for (UiAsset asset : uiAssetsList) {
            if (!asset.getKey().equals(titleId)) continue;
            uiAsset = asset;
            break;
        }
        return uiAsset;
    }

    private boolean assetAlreadyAdded(License license, Long id) {
        boolean alreadyAdded = false;
        for (SmAssets smAssets : license.getSmAssets()) {
            if (!smAssets.getId().getIdAsset().equals(id.toString())) continue;
            alreadyAdded = true;
            break;
        }
        return alreadyAdded;
    }

    @Override
    public List<UiAsset> getAssets(List<Long> assetIds) throws NeptuneException {
        ArrayList<SearchColumn> sc = new ArrayList<SearchColumn>();
        sc.add(new SearchColumn("Package", "/Fields/Identifier/Id", FieldType.ASSET, "string", false));
        sc.add(new SearchColumn("Package/Title", "/Fields/Title/ShortTitle/Value", FieldType.ASSET, "string", false));
        sc.add(new SearchColumn("Package/Title", "/Fields/ProviderInfo/Identifier/Id", FieldType.ASSET, "string", false));
        ArrayList<UiAsset> uiAssets = new ArrayList<UiAsset>();
        TitleSearchResult result = this.searchService.getMasterTitleSearchResults(assetIds, sc);
        List searchResults = result.getRows();
        for (TitleSearchResult.SearchRow searchRow : searchResults) {
            uiAssets.add(this.convertRowToAsset(searchRow));
        }
        return uiAssets;
    }

    private UiAsset convertRowToAsset(TitleSearchResult.SearchRow searchRow) {
        UiAsset uiAsset = new UiAsset(searchRow.getId());
        uiAsset.setPackageAssetId(searchRow.getFirstValueAsString(0));
        uiAsset.setName(searchRow.getFirstValueAsString(1));
        uiAsset.setProviderId(searchRow.getFirstValueAsString(2));
        return uiAsset;
    }

    @Override
    public Map<String, Object> getLicenseErrorsFromHttpSession(long licenseId) throws NeptuneException {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_View"});
        HashMap<String, Object> errorsMap = new HashMap<String, Object>();
        Integer assetsAlreadyAdded = this.getValueFromSession(ASSETS_ALREADY_ADDED + licenseId);
        errorsMap.put(ASSETS_ALREADY_ADDED + licenseId, assetsAlreadyAdded);
        Integer invalidAssets = this.getValueFromSession(INVALID_ASSETS + licenseId);
        errorsMap.put(INVALID_ASSETS + licenseId, invalidAssets);
        List assetsIdsLicIdsAssociatedList = (List)this.httpSession.getAttribute(ASSETS_ASSOCIATED_WITH_LICENSES + licenseId);
        this.httpSession.removeAttribute(ASSETS_ASSOCIATED_WITH_LICENSES + licenseId);
        errorsMap.put(ASSETS_ASSOCIATED_WITH_LICENSES + licenseId, assetsIdsLicIdsAssociatedList);
        return errorsMap;
    }

    private Integer getValueFromSession(String attributeName) {
        Integer value = (Integer)this.httpSession.getAttribute(attributeName);
        this.httpSession.removeAttribute(attributeName);
        return value;
    }

    public void setHttpSession(HttpSession httpSession) {
        this.httpSession = httpSession;
    }

    @Override
    public AuditReportResult findAuditsByFilter(int start, int length, String sortProperty, boolean isAscending, UiAudit uiAudit) throws NeptuneException {
        ArrayList<UiAudit> uiAuditList = new ArrayList<UiAudit>();
        List auditResult = this.auditManager.findAuditsByFilter(start, length, sortProperty, isAscending, uiAudit.getUserName(), uiAudit.getStartDate(), uiAudit.getEndDate(), uiAudit.getAuditType());
        for (Audit audit : auditResult) {
            uiAuditList.add(ObjectsConverter.createBasicUiAudit(audit));
        }
        int totalCount = this.auditManager.count(uiAudit.getUserName(), uiAudit.getStartDate(), uiAudit.getEndDate(), uiAudit.getAuditType());
        return new AuditReportResult(uiAuditList, totalCount);
    }

    @Override
    public void saveSchedule(ScheduleInfo scheduleInfo) throws NeptuneException {
        try {
            ScheduleRule rule = null;
            if (scheduleInfo != null) {
                ScheduleConvertor scheduleConvertor = new ScheduleConvertor();
                rule = scheduleConvertor.convertScheduleInfo(scheduleInfo);
            }
            this.expiryTimerManager.createUpdateTimer(rule);
        }
        catch (Exception e) {
            ContractManagerValidationException cmve = this.findContractManagerValidationException(e);
            if (cmve != null) {
                throw new ValidationException(cmve.getValidationMessages());
            }
            throw new NeptuneException(e.getLocalizedMessage());
        }
    }

    @Override
    public ScheduleInfo getSchedule() throws NeptuneException {
        try {
            ScheduleInfo info = null;
            ScheduleRule rule = this.expiryTimerManager.getTimerSchedule();
            if (rule != null) {
                ScheduleConvertor scheduleConvertor = new ScheduleConvertor();
                info = scheduleConvertor.convertScheduleRule(rule);
            }
            return info;
        }
        catch (Exception e) {
            ContractManagerValidationException cmve = this.findContractManagerValidationException(e);
            if (cmve != null) {
                throw new ValidationException(cmve.getValidationMessages());
            }
            throw new NeptuneException(e.getLocalizedMessage());
        }
    }

    private static final /* synthetic */ void deleteUserDefinedField_aroundBody0(ContractManagerServiceImpl ajc$this, UiUserDefinedField userDefinedField, List validationErrors) {
        try {
            Field dbField;
            if (userDefinedField.getIdUserDefinedField() != null && (dbField = ajc$this.fieldManager.findById(userDefinedField.getIdUserDefinedField().longValue())) != null) {
                boolean canDelete = true;
                if (!dbField.getCustomLicFieldValues().isEmpty()) {
                    for (CustomLicFieldValue value : dbField.getCustomLicFieldValues()) {
                        if (value.getValue() == null || value.getValue().isEmpty()) {
                            ajc$this.fieldValueManager.remove(value);
                            continue;
                        }
                        canDelete = false;
                        validationErrors.add("Field (" + dbField.getName() + ") has values associated with " + dbField.getScreenName() + "!");
                        break;
                    }
                }
                if (canDelete) {
                    ajc$this.fieldManager.remove(dbField);
                }
            }
        }
        catch (Exception e) {
            throw new NeptuneException(e.getLocalizedMessage());
        }
    }

    private static final /* synthetic */ Object deleteUserDefinedField_aroundBody1$advice(ContractManagerServiceImpl ajc$this, UiUserDefinedField userDefinedField, List validationErrors, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            ContractManagerServiceImpl.deleteUserDefinedField_aroundBody0(ajc$this, userDefinedField, validationErrors);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContractManagerServiceImpl.deleteUserDefinedField_aroundBody0(ajc$this, userDefinedField, validationErrors);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List getUserDefinedFields_aroundBody2(ContractManagerServiceImpl ajc$this, String sortByProperty, boolean isAscending, String screen) {
        ArrayList<UiUserDefinedField> userDefinedFields = new ArrayList<UiUserDefinedField>();
        List fields = ajc$this.fieldManager.findByScreenName(ScreenName.valueOf((String)screen), sortByProperty, isAscending);
        ContractManagerDropDownServiceImpl dropDownService = new ContractManagerDropDownServiceImpl();
        UiKeyNames frequencies = dropDownService.getGenericDropDownKeyNameList(0, 0, null, true, ConfigurableFieldTypeEnum.Frequency);
        List<UiCurrency> currencies = dropDownService.getCurrencies();
        for (Field field : fields) {
            userDefinedFields.add(ObjectsConverter.createUiUserDefinedField(field, frequencies.getRecords(), currencies));
        }
        return userDefinedFields;
    }

    private static final /* synthetic */ Object getUserDefinedFields_aroundBody3$advice(ContractManagerServiceImpl ajc$this, String sortByProperty, boolean isAscending, String screen, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContractManagerServiceImpl.getUserDefinedFields_aroundBody2(ajc$this, sortByProperty, isAscending, screen);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = ContractManagerServiceImpl.getUserDefinedFields_aroundBody2(ajc$this, sortByProperty, isAscending, screen);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ LicenseSearchResult getLicenseList_aroundBody4(ContractManagerServiceImpl ajc$this, int start, int length, String sortProperty, boolean isAscending) {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_View"});
        ArrayList<UiLicense> uiLicensesList = new ArrayList<UiLicense>();
        List licensesList = ajc$this.cmLicenseManager.getLicenses(start, length, sortProperty, isAscending);
        for (License license : licensesList) {
            uiLicensesList.add(ObjectsConverter.createBasicUiLicense(license));
        }
        int totalCount = ajc$this.cmLicenseManager.count();
        return new LicenseSearchResult(uiLicensesList, totalCount);
    }

    private static final /* synthetic */ Object getLicenseList_aroundBody5$advice(ContractManagerServiceImpl ajc$this, int start, int length, String sortProperty, boolean isAscending, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContractManagerServiceImpl.getLicenseList_aroundBody4(ajc$this, start, length, sortProperty, isAscending);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            LicenseSearchResult object = ContractManagerServiceImpl.getLicenseList_aroundBody4(ajc$this, start, length, sortProperty, isAscending);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ UiLicense getLicense_aroundBody6(ContractManagerServiceImpl ajc$this, Long key) {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_View"});
        License license = ajc$this.cmLicenseManager.findById(key);
        return ObjectsConverter.createUiLicense(license);
    }

    private static final /* synthetic */ Object getLicense_aroundBody7$advice(ContractManagerServiceImpl ajc$this, Long key, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContractManagerServiceImpl.getLicense_aroundBody6(ajc$this, key);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            UiLicense object = ContractManagerServiceImpl.getLicense_aroundBody6(ajc$this, key);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ UiLicense getFullLicense_aroundBody8(ContractManagerServiceImpl ajc$this, Long key) {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_View"});
        License license = ajc$this.cmLicenseManager.getFullLicense(key);
        String providerId = license.getContentProvider();
        if (providerId != null && providerId.trim().length() > 0) {
            boolean associatedPartner = false;
            List partners = ajc$this.partnerManager.getAllActivePartnerDTOsForCurrentUser();
            if (partners != null) {
                for (Partner partner : partners) {
                    if (!providerId.equals(partner.getProviderId())) continue;
                    associatedPartner = true;
                    break;
                }
                if (!associatedPartner) {
                    throw new NeptuneException("Access denied - User is not associated with the content provider for the selected license (" + license.getName() + ").  Press the back button to return to the license list.");
                }
            }
        }
        return ObjectsConverter.createFullUiLicense(license);
    }

    private static final /* synthetic */ Object getFullLicense_aroundBody9$advice(ContractManagerServiceImpl ajc$this, Long key, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContractManagerServiceImpl.getFullLicense_aroundBody8(ajc$this, key);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            UiLicense object = ContractManagerServiceImpl.getFullLicense_aroundBody8(ajc$this, key);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void saveLicense_aroundBody10(ContractManagerServiceImpl ajc$this, UiLicenseRecord uiLicenseRecord) {
        block7: {
            UiLicense uiLicense = uiLicenseRecord.getLicense();
            uiLicense.setName(uiLicense.getName().trim());
            boolean isEdit = uiLicense.getKey() != null;
            String permission = isEdit ? "ContractManager_Modify" : "ContractManager_Create";
            NeptuneAuthorizationManager.isAuthorized((String[])new String[]{permission});
            try {
                License license = ObjectsConverter.createLicense(uiLicense);
                License licenseDB = ajc$this.cmLicenseManager.findByName(license.getName());
                if (license.getIdLicense() != null) {
                    boolean alreadyExists = false;
                    if (licenseDB != null && !licenseDB.getIdLicense().equals(license.getIdLicense())) {
                        alreadyExists = true;
                    }
                    if (!alreadyExists) {
                        List licenseDocs = ajc$this.licenseDocManager.findByLicense(license.getIdLicense().longValue());
                        license.setLicenseDocuments(new HashSet(licenseDocs));
                        ajc$this.cmLicenseManager.merge(license);
                        break block7;
                    }
                    ContractManagerValidationException cmve = new ContractManagerValidationException();
                    cmve.addValidationMessage("The save operation failed. Please verify if License name is unique.");
                    throw cmve;
                }
                if (licenseDB == null) {
                    ajc$this.cmLicenseManager.persist(license);
                    break block7;
                }
                ContractManagerValidationException cmve = new ContractManagerValidationException();
                cmve.addValidationMessage("The save operation failed. Please verify if License name is unique.");
                throw cmve;
            }
            catch (ContractManagerValidationException e) {
                throw new ValidationException(e.getValidationMessages());
            }
            catch (Exception e) {
                throw new NeptuneException(e.getLocalizedMessage());
            }
        }
    }

    private static final /* synthetic */ Object saveLicense_aroundBody11$advice(ContractManagerServiceImpl ajc$this, UiLicenseRecord uiLicenseRecord, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            ContractManagerServiceImpl.saveLicense_aroundBody10(ajc$this, uiLicenseRecord);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContractManagerServiceImpl.saveLicense_aroundBody10(ajc$this, uiLicenseRecord);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void deleteLicense_aroundBody12(ContractManagerServiceImpl ajc$this, Long licenseId) {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Delete"});
        License license = ajc$this.cmLicenseManager.findById(licenseId);
        if (license != null) {
            try {
                ajc$this.cmLicenseManager.remove(license);
            }
            catch (Exception e) {
                ContractManagerValidationException cmve = ajc$this.findContractManagerValidationException(e);
                if (cmve != null) {
                    throw new ValidationException(cmve.getValidationMessages());
                }
                throw new NeptuneException(e.getLocalizedMessage());
            }
        }
    }

    private static final /* synthetic */ Object deleteLicense_aroundBody13$advice(ContractManagerServiceImpl ajc$this, Long licenseId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            ContractManagerServiceImpl.deleteLicense_aroundBody12(ajc$this, licenseId);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContractManagerServiceImpl.deleteLicense_aroundBody12(ajc$this, licenseId);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void deleteContractContact_aroundBody14(ContractManagerServiceImpl ajc$this, Long key) {
        ContractContacts contact = ajc$this.contractContactManager.findById(key.longValue());
        ajc$this.contractContactManager.remove(contact);
    }

    private static final /* synthetic */ Object deleteContractContact_aroundBody15$advice(ContractManagerServiceImpl ajc$this, Long key, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            ContractManagerServiceImpl.deleteContractContact_aroundBody14(ajc$this, key);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContractManagerServiceImpl.deleteContractContact_aroundBody14(ajc$this, key);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void deleteCopyrightContact_aroundBody16(ContractManagerServiceImpl ajc$this, Long key) {
        CopyHolderContacts contact = ajc$this.chContactsManager.findById(key.longValue());
        ajc$this.chContactsManager.remove(contact);
    }

    private static final /* synthetic */ Object deleteCopyrightContact_aroundBody17$advice(ContractManagerServiceImpl ajc$this, Long key, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            ContractManagerServiceImpl.deleteCopyrightContact_aroundBody16(ajc$this, key);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContractManagerServiceImpl.deleteCopyrightContact_aroundBody16(ajc$this, key);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Boolean deleteCopyrightHolders_aroundBody18(ContractManagerServiceImpl ajc$this, List list) {
        for (UiCopyrightHolder uiCopyrightHolder : list) {
            CopyrightHolder delete = ajc$this.chManager.findById(uiCopyrightHolder.getKey().longValue());
            ajc$this.chManager.remove(delete);
        }
        return Boolean.TRUE;
    }

    private static final /* synthetic */ Object deleteCopyrightHolders_aroundBody19$advice(ContractManagerServiceImpl ajc$this, List list, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContractManagerServiceImpl.deleteCopyrightHolders_aroundBody18(ajc$this, list);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Boolean object = ContractManagerServiceImpl.deleteCopyrightHolders_aroundBody18(ajc$this, list);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ CopyrightHolderSearchResult getCopyrightHolderList_aroundBody20(ContractManagerServiceImpl ajc$this, int start, int length, String sortProperty, boolean isAscending) {
        ArrayList<UiCopyrightHolder> copyrightHolderList = new ArrayList<UiCopyrightHolder>();
        List list = ajc$this.chManager.getCopyrightHolders(start, length, sortProperty, isAscending);
        for (CopyrightHolder cp : list) {
            copyrightHolderList.add(ObjectsConverter.createUiCopyrightHolder(cp));
        }
        int totalCount = ajc$this.chManager.count();
        return new CopyrightHolderSearchResult(copyrightHolderList, totalCount);
    }

    private static final /* synthetic */ Object getCopyrightHolderList_aroundBody21$advice(ContractManagerServiceImpl ajc$this, int start, int length, String sortProperty, boolean isAscending, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContractManagerServiceImpl.getCopyrightHolderList_aroundBody20(ajc$this, start, length, sortProperty, isAscending);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            CopyrightHolderSearchResult object = ContractManagerServiceImpl.getCopyrightHolderList_aroundBody20(ajc$this, start, length, sortProperty, isAscending);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ ContractSearchResult getContractList_aroundBody22(ContractManagerServiceImpl ajc$this, int start, int length, String sortProperty, boolean isAscending) {
        List contractList = ajc$this.contractManager.getContracts(start, length, sortProperty, isAscending);
        List<UiContract> uiContracts = ObjectsConverter.createUiContractList(contractList);
        int totalCount = ajc$this.contractManager.count();
        return new ContractSearchResult(uiContracts, totalCount);
    }

    private static final /* synthetic */ Object getContractList_aroundBody23$advice(ContractManagerServiceImpl ajc$this, int start, int length, String sortProperty, boolean isAscending, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContractManagerServiceImpl.getContractList_aroundBody22(ajc$this, start, length, sortProperty, isAscending);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContractSearchResult object = ContractManagerServiceImpl.getContractList_aroundBody22(ajc$this, start, length, sortProperty, isAscending);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List getCopyrightHolderContractList_aroundBody24(ContractManagerServiceImpl ajc$this, Long copyrightHolderId) {
        List contractList = ajc$this.contractManager.findByCopyrightHolder(copyrightHolderId.longValue());
        return ObjectsConverter.createUiContractList(contractList);
    }

    private static final /* synthetic */ Object getCopyrightHolderContractList_aroundBody25$advice(ContractManagerServiceImpl ajc$this, Long copyrightHolderId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContractManagerServiceImpl.getCopyrightHolderContractList_aroundBody24(ajc$this, copyrightHolderId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = ContractManagerServiceImpl.getCopyrightHolderContractList_aroundBody24(ajc$this, copyrightHolderId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Boolean deleteContracts_aroundBody26(ContractManagerServiceImpl ajc$this, List list) {
        for (UiContract uiContract : list) {
            Contract contract = ajc$this.contractManager.findById(uiContract.getKey().longValue());
            ajc$this.contractManager.remove(contract);
        }
        return Boolean.TRUE;
    }

    private static final /* synthetic */ Object deleteContracts_aroundBody27$advice(ContractManagerServiceImpl ajc$this, List list, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContractManagerServiceImpl.deleteContracts_aroundBody26(ajc$this, list);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Boolean object = ContractManagerServiceImpl.deleteContracts_aroundBody26(ajc$this, list);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Boolean deleteDeals_aroundBody28(ContractManagerServiceImpl ajc$this, List list) {
        for (UiDeal uiDeal : list) {
            Deal persistentInstance = ajc$this.dealManager.findById(uiDeal.getKey().longValue());
            ajc$this.dealManager.remove(persistentInstance);
        }
        return Boolean.TRUE;
    }

    private static final /* synthetic */ Object deleteDeals_aroundBody29$advice(ContractManagerServiceImpl ajc$this, List list, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContractManagerServiceImpl.deleteDeals_aroundBody28(ajc$this, list);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Boolean object = ContractManagerServiceImpl.deleteDeals_aroundBody28(ajc$this, list);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List getContractDealsList_aroundBody30(ContractManagerServiceImpl ajc$this, Long key) {
        List dealList = ajc$this.dealManager.findByContract(key.longValue());
        return ObjectsConverter.createUiDealList(dealList);
    }

    private static final /* synthetic */ Object getContractDealsList_aroundBody31$advice(ContractManagerServiceImpl ajc$this, Long key, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContractManagerServiceImpl.getContractDealsList_aroundBody30(ajc$this, key);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = ContractManagerServiceImpl.getContractDealsList_aroundBody30(ajc$this, key);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ List getDealsLicenseList_aroundBody32(ContractManagerServiceImpl ajc$this, Long key) {
        List licenseList = ajc$this.licenseManager.findByDealId(key);
        return ObjectsConverter.createUiLicenseList(licenseList);
    }

    private static final /* synthetic */ Object getDealsLicenseList_aroundBody33$advice(ContractManagerServiceImpl ajc$this, Long key, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContractManagerServiceImpl.getDealsLicenseList_aroundBody32(ajc$this, key);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = ContractManagerServiceImpl.getDealsLicenseList_aroundBody32(ajc$this, key);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ UiContract getContract_aroundBody34(ContractManagerServiceImpl ajc$this, Long key) {
        Contract contract = ajc$this.contractManager.findById(key.longValue());
        UiContract uiContract = ObjectsConverter.createUiContract(contract);
        return uiContract;
    }

    private static final /* synthetic */ Object getContract_aroundBody35$advice(ContractManagerServiceImpl ajc$this, Long key, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContractManagerServiceImpl.getContract_aroundBody34(ajc$this, key);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            UiContract object = ContractManagerServiceImpl.getContract_aroundBody34(ajc$this, key);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ DealSearchResult getDealsList_aroundBody36(ContractManagerServiceImpl ajc$this, int start, int length, String sortProperty, boolean isAscending) {
        List dealList = ajc$this.dealManager.getDeals(start, length, sortProperty, isAscending);
        List<UiDeal> uiDealList = ObjectsConverter.createUiDealList(dealList);
        int totalCount = ajc$this.dealManager.count();
        return new DealSearchResult(uiDealList, totalCount);
    }

    private static final /* synthetic */ Object getDealsList_aroundBody37$advice(ContractManagerServiceImpl ajc$this, int start, int length, String sortProperty, boolean isAscending, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContractManagerServiceImpl.getDealsList_aroundBody36(ajc$this, start, length, sortProperty, isAscending);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            DealSearchResult object = ContractManagerServiceImpl.getDealsList_aroundBody36(ajc$this, start, length, sortProperty, isAscending);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ UiDeal getDeal_aroundBody38(ContractManagerServiceImpl ajc$this, Long key) {
        return ObjectsConverter.createUiDeal(ajc$this.dealManager.findById(key.longValue()));
    }

    private static final /* synthetic */ Object getDeal_aroundBody39$advice(ContractManagerServiceImpl ajc$this, Long key, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContractManagerServiceImpl.getDeal_aroundBody38(ajc$this, key);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            UiDeal object = ContractManagerServiceImpl.getDeal_aroundBody38(ajc$this, key);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void deleteDealContact_aroundBody40(ContractManagerServiceImpl ajc$this, Long key) {
        DealContacts contact = ajc$this.dealContactManager.findById(key.longValue());
        ajc$this.dealContactManager.remove(contact);
    }

    private static final /* synthetic */ Object deleteDealContact_aroundBody41$advice(ContractManagerServiceImpl ajc$this, Long key, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            ContractManagerServiceImpl.deleteDealContact_aroundBody40(ajc$this, key);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContractManagerServiceImpl.deleteDealContact_aroundBody40(ajc$this, key);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Boolean deleteContacts_aroundBody42(ContractManagerServiceImpl ajc$this, List contactList, UiContactType contactType, Long parentId) {
        block4: {
            block5: {
                block3: {
                    if (!contactType.equals((Object)UiContactType.COPYRIGHT_HOLDER)) break block3;
                    for (UiContact contact : contactList) {
                        CopyHolderContacts copyContact = ajc$this.chContactsManager.findById(contact.getKey().longValue());
                        ajc$this.chContactsManager.remove(copyContact);
                    }
                    break block4;
                }
                if (!contactType.equals((Object)UiContactType.CONTRACT)) break block5;
                for (UiContact contact : contactList) {
                    ContractContacts contractContacts = ajc$this.contractContactManager.findById(contact.getKey().longValue());
                    ajc$this.contractContactManager.remove(contractContacts);
                }
                break block4;
            }
            if (!contactType.equals((Object)UiContactType.DEAL)) break block4;
            for (UiContact contact : contactList) {
                DealContacts dealContact = ajc$this.dealContactManager.findById(contact.getKey().longValue());
                ajc$this.dealContactManager.remove(dealContact);
            }
        }
        return Boolean.TRUE;
    }

    private static final /* synthetic */ Object deleteContacts_aroundBody43$advice(ContractManagerServiceImpl ajc$this, List contactList, UiContactType contactType, Long parentId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContractManagerServiceImpl.deleteContacts_aroundBody42(ajc$this, contactList, contactType, parentId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Boolean object = ContractManagerServiceImpl.deleteContacts_aroundBody42(ajc$this, contactList, contactType, parentId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ UiCopyrightHolder getCopyrightHolder_aroundBody44(ContractManagerServiceImpl ajc$this, long copyrightHolderKey) {
        return ObjectsConverter.createUiCopyrightHolder(ajc$this.chManager.findById(copyrightHolderKey));
    }

    private static final /* synthetic */ Object getCopyrightHolder_aroundBody45$advice(ContractManagerServiceImpl ajc$this, long copyrightHolderKey, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return ContractManagerServiceImpl.getCopyrightHolder_aroundBody44(ajc$this, copyrightHolderKey);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            UiCopyrightHolder object = ContractManagerServiceImpl.getCopyrightHolder_aroundBody44(ajc$this, copyrightHolderKey);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void addAssetsToLicense_aroundBody46(ContractManagerServiceImpl ajc$this, long licenseId, List titleIds) {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Modify"});
        if (!titleIds.isEmpty()) {
            License license = ajc$this.cmLicenseManager.findById(Long.valueOf(licenseId));
            List<UiAsset> uiAssetsList = ajc$this.getAssets(titleIds);
            ArrayList<String> titleIdsLicIdsAssociated = new ArrayList<String>(0);
            ArrayList<Long> titleIdsToAdd = new ArrayList<Long>();
            int alreadyAdded = 0;
            int invalid = 0;
            if (license != null) {
                for (Long titleId : titleIds) {
                    UiAsset uiAsset = ajc$this.getUiAssetById(uiAssetsList, titleId);
                    if (uiAsset == null) continue;
                    if (license.getContentProvider() == null || uiAsset.getProviderId().equals(license.getContentProvider())) {
                        if (!ajc$this.assetAlreadyAdded(license, titleId)) {
                            List associatedAssets = ajc$this.smAssetsManager.getAssociatedAssetsList(titleId.longValue());
                            if (associatedAssets != null) {
                                boolean found = false;
                                for (SmAssets smAsset : associatedAssets) {
                                    if (new Long(smAsset.getId().getIdAsset()).longValue() != titleId.longValue()) continue;
                                    found = true;
                                    titleIdsLicIdsAssociated.add("Title with tileId: " + titleId + " is associated with License " + smAsset.getId().getIdLicense());
                                }
                                if (found) continue;
                                titleIdsToAdd.add(titleId);
                                continue;
                            }
                            titleIdsToAdd.add(titleId);
                            continue;
                        }
                        ++alreadyAdded;
                        continue;
                    }
                    ++invalid;
                }
            }
            ajc$this.httpSession.setAttribute(ASSETS_ASSOCIATED_WITH_LICENSES + licenseId, titleIdsLicIdsAssociated);
            ajc$this.httpSession.setAttribute(ASSETS_ALREADY_ADDED + licenseId, (Object)alreadyAdded);
            ajc$this.httpSession.setAttribute(INVALID_ASSETS + licenseId, (Object)invalid);
            try {
                ajc$this.cmLicenseManager.addAssets(licenseId, titleIdsToAdd);
            }
            catch (Exception e) {
                ajc$this.throwNeptuneException(e);
            }
        }
    }

    private static final /* synthetic */ Object addAssetsToLicense_aroundBody47$advice(ContractManagerServiceImpl ajc$this, long licenseId, List titleIds, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            ContractManagerServiceImpl.addAssetsToLicense_aroundBody46(ajc$this, licenseId, titleIds);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContractManagerServiceImpl.addAssetsToLicense_aroundBody46(ajc$this, licenseId, titleIds);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ void removeAssetsFromLicense_aroundBody48(ContractManagerServiceImpl ajc$this, long licenseId, List titleIds) {
        NeptuneAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_Modify"});
        for (Long titleId : titleIds) {
            SmAssetsId smAssetsId = new SmAssetsId(titleId.toString(), Long.valueOf(licenseId));
            SmAssets smAssets = ajc$this.smAssetsManager.findById(smAssetsId);
            if (smAssets == null) continue;
            ajc$this.smAssetsManager.remove(smAssets);
        }
    }

    private static final /* synthetic */ Object removeAssetsFromLicense_aroundBody49$advice(ContractManagerServiceImpl ajc$this, long licenseId, List titleIds, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            ContractManagerServiceImpl.removeAssetsFromLicense_aroundBody48(ajc$this, licenseId, titleIds);
            return null;
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            ContractManagerServiceImpl.removeAssetsFromLicense_aroundBody48(ajc$this, licenseId, titleIds);
            Object object = null;
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

