/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.server;

import com.ericsson.ejb.ContractDocuments;
import com.ericsson.ejb.CopyHolderDocuments;
import com.ericsson.ejb.DealDocuments;
import com.ericsson.ejb.LicenseDocuments;
import com.ericsson.service.IContractDocumentsManager;
import com.ericsson.service.ICopyHolderDocumentsManager;
import com.ericsson.service.IDealDocumentsManager;
import com.ericsson.service.ILicenseDocumentsManager;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FileDownloadServiceServlet
extends HttpServlet {
    private final ICopyHolderDocumentsManager copyDocManager = (ICopyHolderDocumentsManager)InjectionUtil.injectInstance((String)"cms/CopyHolderDocumentsManager/local", ICopyHolderDocumentsManager.class);
    private final IContractDocumentsManager contractDocManager = (IContractDocumentsManager)InjectionUtil.injectInstance((String)"cms/ContractDocumentsManager/local", IContractDocumentsManager.class);
    private final IDealDocumentsManager dealDocManager = (IDealDocumentsManager)InjectionUtil.injectInstance((String)"cms/DealDocumentsManager/local", IDealDocumentsManager.class);
    private final ILicenseDocumentsManager licenseDocManager = (ILicenseDocumentsManager)InjectionUtil.injectInstance((String)"cms/LicenseDocumentsManager/local", ILicenseDocumentsManager.class);
    private static final long serialVersionUID = 5285227188842560658L;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try (ServletOutputStream op = null;){
            try {
                Long docId = new Long(req.getParameter("docId"));
                Integer ordinal = Integer.valueOf(req.getParameter("docType"));
                op = resp.getOutputStream();
                resp.setContentType("application/octet-stream");
                switch (ordinal) {
                    case 0: {
                        CopyHolderDocuments document = this.copyDocManager.findById(docId.longValue());
                        this.writeFile(resp, op, document.getFileName(), document.getFileBytes());
                        break;
                    }
                    case 1: {
                        ContractDocuments document = this.contractDocManager.findById(docId.longValue());
                        this.writeFile(resp, op, document.getFileName(), document.getFileBytes());
                        break;
                    }
                    case 2: {
                        DealDocuments document = this.dealDocManager.findById(docId.longValue());
                        this.writeFile(resp, op, document.getFileName(), document.getFileBytes());
                        break;
                    }
                    case 3: {
                        LicenseDocuments document = this.licenseDocManager.findById(docId.longValue());
                        this.writeFile(resp, op, document.getFileName(), document.getFileBytes());
                    }
                }
            }
            catch (Exception exception) {
                resp.setStatus(400);
                if (op != null) {
                    op.close();
                }
            }
        }
    }

    private void writeFile(HttpServletResponse resp, ServletOutputStream op, String fileName, byte[] fileBytes) throws IOException {
        File tmpFile = Files.createTempFile("", "", new FileAttribute[0]).toFile();
        FileOutputStream os = null;
        FilterInputStream in = null;
        try {
            try {
                os = new FileOutputStream(tmpFile);
                resp.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
                os.write(fileBytes);
                byte[] size = new byte[100];
                in = new DataInputStream(new FileInputStream(tmpFile));
                int length = 0;
                while (in != null && (length = ((DataInputStream)in).read(size)) != -1) {
                    op.write(size, 0, length);
                }
                op.flush();
            }
            catch (Exception exception) {
                if (os != null) {
                    os.close();
                }
                if (in != null) {
                    in.close();
                }
            }
        }
        finally {
            if (os != null) {
                os.close();
            }
            if (in != null) {
                in.close();
            }
        }
    }
}

