/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.server;

import com.ericsson.cms.contractmgmt.client.model.UiDocument;
import com.ericsson.cms.contractmgmt.client.model.UiDocumentType;
import com.ericsson.cms.contractmgmt.client.rpc.IFileService;
import com.ericsson.cms.contractmgmt.server.ObjectsConverter;
import com.ericsson.ejb.ContractDocuments;
import com.ericsson.ejb.CopyHolderDocuments;
import com.ericsson.ejb.DealDocuments;
import com.ericsson.ejb.LicenseDocuments;
import com.ericsson.service.ICMLicenseManager;
import com.ericsson.service.IContractDocumentsManager;
import com.ericsson.service.IContractManager;
import com.ericsson.service.ICopyHolderDocumentsManager;
import com.ericsson.service.ICopyrightHolderManager;
import com.ericsson.service.IDealDocumentsManager;
import com.ericsson.service.IDealManager;
import com.ericsson.service.ILicenseDocumentsManager;
import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.transaction.TransactionManager;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.runtime.internal.AroundClosure;

public class FileServiceImpl
extends RemoteServiceServlet
implements IFileService {
    private static final String ERR_LARGE_FILE = "File size is larger than 50MB.";
    private static final Log log = LogFactory.getLog(FileServiceImpl.class);
    private FileItem uploadedFileItem;
    private String fileName;
    private static final long MAX_FILE_SIZE = 0x3200000L;
    private final ICopyHolderDocumentsManager copyDocManager = (ICopyHolderDocumentsManager)InjectionUtil.injectInstance((String)"cms/CopyHolderDocumentsManager/local", ICopyHolderDocumentsManager.class);
    private final IContractDocumentsManager contractDocManager = (IContractDocumentsManager)InjectionUtil.injectInstance((String)"cms/ContractDocumentsManager/local", IContractDocumentsManager.class);
    private final IDealDocumentsManager dealDocManager = (IDealDocumentsManager)InjectionUtil.injectInstance((String)"cms/DealDocumentsManager/local", IDealDocumentsManager.class);
    private final ILicenseDocumentsManager licenseDocManager = (ILicenseDocumentsManager)InjectionUtil.injectInstance((String)"cms/LicenseDocumentsManager/local", ILicenseDocumentsManager.class);
    private final ICopyrightHolderManager copyrightHolderManager = (ICopyrightHolderManager)InjectionUtil.injectInstance((String)"cms/CopyrightHolderManager/local", ICopyrightHolderManager.class);
    private final IContractManager contractManager = (IContractManager)InjectionUtil.injectInstance((String)"cms/ContractManager/local", IContractManager.class);
    private final IDealManager dealManager = (IDealManager)InjectionUtil.injectInstance((String)"cms/DealManager/local", IDealManager.class);
    private final ICMLicenseManager licenseManager = (ICMLicenseManager)InjectionUtil.injectInstance((String)"cms/CMLicenseManager/local", ICMLicenseManager.class);
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ Annotation ajc$anno$1;

    @Override
    @Transactional
    public UiDocument uploadAttachment(String filePath, UiDocument uiDocument) throws NeptuneException {
        String string = filePath;
        UiDocument uiDocument2 = uiDocument;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = FileServiceImpl.class.getDeclaredMethod("uploadAttachment", String.class, UiDocument.class).getAnnotation(Transactional.class);
        }
        return (UiDocument)FileServiceImpl.uploadAttachment_aroundBody1$advice(this, string, uiDocument2, transactionEnforcer, (Transactional)annotation, null);
    }

    @Override
    @Transactional
    public Boolean deleteAttachment(Long uiDocumentId, UiDocumentType documentType) {
        Long l = uiDocumentId;
        UiDocumentType uiDocumentType = documentType;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = FileServiceImpl.class.getDeclaredMethod("deleteAttachment", Long.class, UiDocumentType.class).getAnnotation(Transactional.class);
        }
        return (Boolean)FileServiceImpl.deleteAttachment_aroundBody3$advice(this, l, uiDocumentType, transactionEnforcer, (Transactional)annotation, null);
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean isMultiPart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
        if (isMultiPart) {
            DiskFileItemFactory factory = new DiskFileItemFactory();
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            try {
                List items = upload.parseRequest(request);
                this.uploadedFileItem = (FileItem)items.get(0);
                if (this.uploadedFileItem.getSize() > 0x3200000L) {
                    throw new ServletException(ERR_LARGE_FILE);
                }
                if (this.uploadedFileItem == null) {
                    super.service(request, response);
                    return;
                }
                if (this.uploadedFileItem.getFieldName().equalsIgnoreCase("uploadFormElement")) {
                    this.fileName = this.uploadedFileItem.getName();
                    int i = -1;
                    i = this.fileName.lastIndexOf("\\");
                    if (i != -1) {
                        this.fileName = this.fileName.substring(i + 1);
                    }
                    log.debug((Object)this.fileName);
                    response.setStatus(201);
                    response.getWriter().print("OK");
                    response.flushBuffer();
                }
            }
            catch (Exception e) {
                if (!(e instanceof ServletException)) {
                    throw new IOException(e);
                }
                response.setStatus(413);
                response.getWriter().print(ERR_LARGE_FILE);
                response.flushBuffer();
                log.error((Object)("Error in uploading the file: " + e.getLocalizedMessage()), (Throwable)e);
            }
        } else {
            super.service(request, response);
            return;
        }
    }

    private static final /* synthetic */ UiDocument uploadAttachment_aroundBody0(FileServiceImpl ajc$this, String filePath, UiDocument uiDocument) {
        File f = new File(String.valueOf(filePath) + ajc$this.fileName);
        try {
            ajc$this.uploadedFileItem.write(f);
            if (ajc$this.uploadedFileItem.getSize() > 0x3200000L) {
                throw new Exception(ERR_LARGE_FILE);
            }
            if (uiDocument.getDocumentType().equals((Object)UiDocumentType.COPYRIGHT_HOLDER)) {
                CopyHolderDocuments cpDocuments = ObjectsConverter.createCopyRightHolderDocuments(uiDocument, f);
                cpDocuments.setCopyrightHolder(ajc$this.copyrightHolderManager.findById(uiDocument.getParentId().longValue()));
                ajc$this.copyDocManager.persist(cpDocuments);
                uiDocument.setFileName(f.getName());
                uiDocument.setKey(cpDocuments.getIdDocument());
            }
            if (uiDocument.getDocumentType().equals((Object)UiDocumentType.CONTRACT)) {
                ContractDocuments contractDocuments = ObjectsConverter.createContractDocuments(uiDocument, f);
                contractDocuments.setContract(ajc$this.contractManager.findById(uiDocument.getParentId().longValue()));
                ajc$this.contractDocManager.persist(contractDocuments);
                uiDocument.setFileName(f.getName());
                uiDocument.setKey(contractDocuments.getIdDocument());
            } else if (uiDocument.getDocumentType().equals((Object)UiDocumentType.DEAL)) {
                DealDocuments dealDocuments = ObjectsConverter.createDealDocuments(uiDocument, f);
                dealDocuments.setDeal(ajc$this.dealManager.findById(uiDocument.getParentId().longValue()));
                ajc$this.dealDocManager.persist(dealDocuments);
                uiDocument.setFileName(f.getName());
                uiDocument.setKey(dealDocuments.getIdDocument());
            } else if (uiDocument.getDocumentType().equals((Object)UiDocumentType.LICENSE)) {
                LicenseDocuments licenseDocuments = ObjectsConverter.createLicenseDocuments(uiDocument, f);
                licenseDocuments.setLicense(ajc$this.licenseManager.findById(uiDocument.getParentId()));
                ajc$this.licenseDocManager.persist(licenseDocuments);
                uiDocument.setFileName(f.getName());
                uiDocument.setKey(licenseDocuments.getIdDocument());
            }
            f.delete();
        }
        catch (Exception e) {
            log.error((Object)("Error in attaching the file: " + e.getLocalizedMessage()), (Throwable)e);
            throw new NeptuneException(e.getLocalizedMessage());
        }
        return uiDocument;
    }

    private static final /* synthetic */ Object uploadAttachment_aroundBody1$advice(FileServiceImpl ajc$this, String filePath, UiDocument uiDocument, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return FileServiceImpl.uploadAttachment_aroundBody0(ajc$this, filePath, uiDocument);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            UiDocument object = FileServiceImpl.uploadAttachment_aroundBody0(ajc$this, filePath, uiDocument);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ Boolean deleteAttachment_aroundBody2(FileServiceImpl ajc$this, Long uiDocumentId, UiDocumentType documentType) {
        if (documentType.equals((Object)UiDocumentType.COPYRIGHT_HOLDER)) {
            CopyHolderDocuments persistentInstance = ajc$this.copyDocManager.findById(uiDocumentId.longValue());
            ajc$this.copyDocManager.remove(persistentInstance);
        } else if (documentType.equals((Object)UiDocumentType.CONTRACT)) {
            ContractDocuments persistentInstance = ajc$this.contractDocManager.findById(uiDocumentId.longValue());
            ajc$this.contractDocManager.remove(persistentInstance);
        } else if (documentType.equals((Object)UiDocumentType.DEAL)) {
            DealDocuments persistentInstance = ajc$this.dealDocManager.findById(uiDocumentId.longValue());
            ajc$this.dealDocManager.remove(persistentInstance);
        } else if (documentType.equals((Object)UiDocumentType.LICENSE)) {
            LicenseDocuments persistentInstance = ajc$this.licenseDocManager.findById(uiDocumentId.longValue());
            ajc$this.licenseDocManager.remove(persistentInstance);
        }
        return true;
    }

    private static final /* synthetic */ Object deleteAttachment_aroundBody3$advice(FileServiceImpl ajc$this, Long uiDocumentId, UiDocumentType documentType, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return FileServiceImpl.deleteAttachment_aroundBody2(ajc$this, uiDocumentId, documentType);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            Boolean object = FileServiceImpl.deleteAttachment_aroundBody2(ajc$this, uiDocumentId, documentType);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

