/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.contractmgmt.server;

import com.ericsson.cms.contractmgmt.client.customfield.FieldTypeEnum;
import com.ericsson.cms.contractmgmt.client.customfield.UiUserDefinedField;
import com.ericsson.cms.contractmgmt.client.customfield.UiUserDefinedFieldValue;
import com.ericsson.cms.contractmgmt.client.model.UiAsset;
import com.ericsson.cms.contractmgmt.client.model.UiAudit;
import com.ericsson.cms.contractmgmt.client.model.UiContact;
import com.ericsson.cms.contractmgmt.client.model.UiContentProvider;
import com.ericsson.cms.contractmgmt.client.model.UiContract;
import com.ericsson.cms.contractmgmt.client.model.UiContractType;
import com.ericsson.cms.contractmgmt.client.model.UiCopyrightHolder;
import com.ericsson.cms.contractmgmt.client.model.UiCurrency;
import com.ericsson.cms.contractmgmt.client.model.UiDeal;
import com.ericsson.cms.contractmgmt.client.model.UiDealType;
import com.ericsson.cms.contractmgmt.client.model.UiDeliveryLocation;
import com.ericsson.cms.contractmgmt.client.model.UiDeliveryMethod;
import com.ericsson.cms.contractmgmt.client.model.UiDevice;
import com.ericsson.cms.contractmgmt.client.model.UiDistributionManagement;
import com.ericsson.cms.contractmgmt.client.model.UiDocument;
import com.ericsson.cms.contractmgmt.client.model.UiDocumentType;
import com.ericsson.cms.contractmgmt.client.model.UiKeyName;
import com.ericsson.cms.contractmgmt.client.model.UiLanguage;
import com.ericsson.cms.contractmgmt.client.model.UiLicense;
import com.ericsson.cms.contractmgmt.client.model.UiLicenseDetails;
import com.ericsson.cms.contractmgmt.client.model.UiMediaType;
import com.ericsson.cms.contractmgmt.client.model.UiMetaFormat;
import com.ericsson.cms.contractmgmt.client.model.UiOwnership;
import com.ericsson.cms.contractmgmt.client.model.UiPlatform;
import com.ericsson.cms.contractmgmt.client.model.UiRevenuePricing;
import com.ericsson.cms.sites.core.ISiteManager;
import com.ericsson.cms.sites.core.entities.Site;
import com.ericsson.ejb.Audit;
import com.ericsson.ejb.Contact;
import com.ericsson.ejb.Contract;
import com.ericsson.ejb.ContractContacts;
import com.ericsson.ejb.ContractDocuments;
import com.ericsson.ejb.ContractType;
import com.ericsson.ejb.CopyHolderContacts;
import com.ericsson.ejb.CopyHolderDocuments;
import com.ericsson.ejb.CopyrightHolder;
import com.ericsson.ejb.Currency;
import com.ericsson.ejb.CustomLicFieldValue;
import com.ericsson.ejb.Deal;
import com.ericsson.ejb.DealContacts;
import com.ericsson.ejb.DealDocuments;
import com.ericsson.ejb.DealType;
import com.ericsson.ejb.DeliveryMethod;
import com.ericsson.ejb.Device;
import com.ericsson.ejb.DistributionManagement;
import com.ericsson.ejb.Document;
import com.ericsson.ejb.Field;
import com.ericsson.ejb.FieldDropdown;
import com.ericsson.ejb.Language;
import com.ericsson.ejb.License;
import com.ericsson.ejb.LicenseDetails;
import com.ericsson.ejb.LicenseDocuments;
import com.ericsson.ejb.LicenseType;
import com.ericsson.ejb.Media;
import com.ericsson.ejb.Ownership;
import com.ericsson.ejb.Platform;
import com.ericsson.ejb.RevenuePricing;
import com.ericsson.ejb.SmAssets;
import com.ericsson.ejb.SmAssetsId;
import com.ericsson.enumeration.FieldType;
import com.ericsson.enumeration.RevenuePricingType;
import com.ericsson.enumeration.ScreenName;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObjectsConverter {
    private static final ISiteManager siteManager = (ISiteManager)InjectionUtil.injectInstance((String)"cms/SiteManager/local", ISiteManager.class);
    private static SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static final Log logger = LogFactory.getLog(ObjectsConverter.class);

    public static License createLicense(UiLicense uiLicense) throws ParseException {
        License license = new License();
        license.setIdLicense(uiLicense.getKey());
        license.setExternalId(uiLicense.getExternalId());
        license.setActive(Boolean.valueOf(uiLicense.isActive()));
        UiContentProvider uiContentProvider = uiLicense.getContentProvider();
        if (uiContentProvider != null) {
            license.setContentProvider(uiContentProvider.getProviderId());
        }
        license.setCreationDate(ObjectsConverter.dateFromString(uiLicense.getCreationDate()));
        license.setDeal(ObjectsConverter.createDeal(uiLicense.getDeal(), null));
        license.setEffectiveDate(ObjectsConverter.dateFromString(uiLicense.getEffectiveDate()));
        license.setExpiryDate(ObjectsConverter.dateFromString(uiLicense.getExpiryDate()));
        if (uiLicense.getType() != null) {
            license.setLicenseType(new LicenseType(uiLicense.getType().getKey()));
        }
        license.setName(uiLicense.getName());
        license.setNotes(uiLicense.getNotes());
        license.setAllAssets(uiLicense.getAllAssets());
        HashSet<CustomLicFieldValue> customLicFieldValues = new HashSet<CustomLicFieldValue>();
        for (UiUserDefinedFieldValue uiUserDefinedFieldValue : uiLicense.getUserDefinedFieldsValues()) {
            customLicFieldValues.add(ObjectsConverter.createCustomLicFieldValue(uiUserDefinedFieldValue));
        }
        license.setLicenseCustomLicFieldValues(customLicFieldValues);
        HashSet<LicenseDetails> licenseDetails = new HashSet<LicenseDetails>();
        for (UiLicenseDetails uiLicenseDetails : uiLicense.getLicenseDetailsList()) {
            licenseDetails.add(ObjectsConverter.createLicenseDetails(uiLicenseDetails));
        }
        license.setLicenseDetails(licenseDetails);
        HashSet<LicenseDocuments> licenseDocuments = new HashSet<LicenseDocuments>();
        for (UiDocument document : uiLicense.getDocumentsList()) {
            licenseDocuments.add(ObjectsConverter.createLicenseDocuments(document));
        }
        license.setLicenseDocuments(licenseDocuments);
        if (uiLicense.getAllAssets() != null && !uiLicense.getAllAssets().booleanValue()) {
            HashSet<SmAssets> smAssetsList = new HashSet<SmAssets>();
            for (UiAsset uiAsset : uiLicense.getAssetList()) {
                smAssetsList.add(ObjectsConverter.createSmAssets(uiAsset, license));
            }
            license.setSmAssets(smAssetsList);
        }
        return license;
    }

    public static LicenseDetails createLicenseDetails(UiLicenseDetails uiLicenseDetails) throws ParseException {
        LicenseDetails licenseDetails = new LicenseDetails();
        licenseDetails.setIdLicensedetails(uiLicenseDetails.getKey());
        licenseDetails.setAeAdRemoval(uiLicenseDetails.getAeAdRemoval());
        licenseDetails.setAeContentEdit(uiLicenseDetails.getAeContentEdit());
        licenseDetails.setAeContentSecurity(uiLicenseDetails.getAeContentSecurity());
        licenseDetails.setAeFingerprinting(uiLicenseDetails.getAeFingerPrinting());
        licenseDetails.setAeQualityCheck(uiLicenseDetails.getAeQualityCheck());
        licenseDetails.setAeTranscoding(uiLicenseDetails.getAeTranscoding());
        licenseDetails.setAeWatermarking(uiLicenseDetails.getAeWaterMarking());
        if (uiLicenseDetails.getPrCurrency() != null) {
            licenseDetails.setCurrency(new Currency(uiLicenseDetails.getPrCurrency().getKey()));
        }
        if (uiLicenseDetails.getDeliveryLocation() != null) {
            licenseDetails.setDeliveryLocation(uiLicenseDetails.getDeliveryLocation().getName());
            if (uiLicenseDetails.getDeliveryLocation().getKey() != null) {
                licenseDetails.setDeliveryLocationId(uiLicenseDetails.getDeliveryLocation().getKey());
            }
        }
        if (uiLicenseDetails.getDevice() != null) {
            Device device = new Device(uiLicenseDetails.getDevice().getKey());
            device.setDeviceName(uiLicenseDetails.getDevice().getName());
            licenseDetails.setDevice(device);
        }
        if (uiLicenseDetails.getPlatform() != null) {
            Platform platform = new Platform(uiLicenseDetails.getPlatform().getKey());
            platform.setDescription(uiLicenseDetails.getPlatform().getName());
            licenseDetails.setPlatform(platform);
        }
        licenseDetails.setPrActualLicenseFee(uiLicenseDetails.getPrActualLicenseFee() != null ? new BigDecimal(uiLicenseDetails.getPrActualLicenseFee()) : null);
        licenseDetails.setPrActualRetailPrice(uiLicenseDetails.getPrActualRetailPrice() != null ? new BigDecimal(uiLicenseDetails.getPrActualRetailPrice()) : null);
        licenseDetails.setPrDeemedRetailPrice(uiLicenseDetails.getPrDeemedRetailPrice() != null ? new BigDecimal(uiLicenseDetails.getPrDeemedRetailPrice()) : null);
        licenseDetails.setPrGuaranteedBuyRate(uiLicenseDetails.getPrGuaranteedBuyRate() != null ? new BigDecimal(uiLicenseDetails.getPrGuaranteedBuyRate()) : null);
        licenseDetails.setPrGuaranteedSubscribers(uiLicenseDetails.getPrGuaranteedSubscribers());
        licenseDetails.setPrInstallmentPlan(uiLicenseDetails.getPrInstallmentPlan() != null ? new BigDecimal(uiLicenseDetails.getPrInstallmentPlan()) : null);
        licenseDetails.setPrInstallmentPlanRequired(uiLicenseDetails.getPrInstallmentPlanRequired());
        licenseDetails.setPrLostBuys(uiLicenseDetails.getPrLostBuys() != null ? new BigDecimal(uiLicenseDetails.getPrLostBuys()) : null);
        licenseDetails.setPrRevenueShare(uiLicenseDetails.getPrRevenueShare() != null ? new BigDecimal(uiLicenseDetails.getPrRevenueShare()) : null);
        licenseDetails.setPrMinimumLicenseFee(uiLicenseDetails.getPrMinimumLicenseFee() != null ? new BigDecimal(uiLicenseDetails.getPrMinimumLicenseFee()) : null);
        licenseDetails.setPrOverage(uiLicenseDetails.getPrOverage() != null ? new BigDecimal(uiLicenseDetails.getPrOverage()) : null);
        licenseDetails.setPrOverageRequired(uiLicenseDetails.getPrOverageRequired());
        licenseDetails.setPrRevenueShareRequired(uiLicenseDetails.getPrRevenueShareRequired());
        licenseDetails.setPrTieredPricingRequired(uiLicenseDetails.getPrTieredPricingRequired());
        licenseDetails.setPrUpfrontPayment(uiLicenseDetails.getPrUpfrontPayment() != null ? new BigDecimal(uiLicenseDetails.getPrUpfrontPayment()) : null);
        licenseDetails.setPrUpfrontPaymentRequired(uiLicenseDetails.getPrUpfrontPaymentRequired());
        licenseDetails.setSmEffectiveDate(ObjectsConverter.dateFromString(uiLicenseDetails.getSmEffectiveDate()));
        licenseDetails.setSmExpiryDate(ObjectsConverter.dateFromString(uiLicenseDetails.getSmExpiryDate()));
        licenseDetails.setSmPosterArtRequired(uiLicenseDetails.getSmPosterArtRequired());
        licenseDetails.setSmPreviewRequired(uiLicenseDetails.getSmPreviewRequired());
        HashSet<CustomLicFieldValue> customLicFieldValues = new HashSet<CustomLicFieldValue>();
        for (UiUserDefinedFieldValue uiUserDefinedFieldValue : uiLicenseDetails.getUserDefinedFieldValues()) {
            customLicFieldValues.add(ObjectsConverter.createCustomLicFieldValue(uiUserDefinedFieldValue));
        }
        licenseDetails.setLicenseDetailsCustomLicFieldValues(customLicFieldValues);
        HashSet<DistributionManagement> distributionManagements = new HashSet<DistributionManagement>();
        for (UiDistributionManagement uiDistributionManagement : uiLicenseDetails.getDistributionManagementList()) {
            distributionManagements.add(ObjectsConverter.createDistributionManagement(uiDistributionManagement));
        }
        licenseDetails.setDistributionManagements(distributionManagements);
        HashSet<Language> languages = new HashSet<Language>();
        for (UiLanguage uiLanguage : uiLicenseDetails.getLanguageList()) {
            languages.add(new Language(uiLanguage.getKey()));
        }
        licenseDetails.setLanguages(languages);
        HashSet<RevenuePricing> revenuePricings = new HashSet<RevenuePricing>();
        for (UiRevenuePricing uiRevenuePricing : uiLicenseDetails.getRevenueSharedList()) {
            revenuePricings.add(ObjectsConverter.createRevenuePricing(uiRevenuePricing, RevenuePricingType.RS));
        }
        for (UiRevenuePricing uiRevenuePricing : uiLicenseDetails.getTieredPricingList()) {
            revenuePricings.add(ObjectsConverter.createRevenuePricing(uiRevenuePricing, RevenuePricingType.TP));
        }
        licenseDetails.setRevenuePricings(revenuePricings);
        return licenseDetails;
    }

    private static SmAssets createSmAssets(UiAsset uiAsset, License license) {
        SmAssets smAssets = new SmAssets();
        smAssets.setId(new SmAssetsId(uiAsset.getKey().toString(), license.getIdLicense()));
        return smAssets;
    }

    public static RevenuePricing createRevenuePricing(UiRevenuePricing uiRevenuePricing, RevenuePricingType type) {
        RevenuePricing revenuePricing = new RevenuePricing();
        if (uiRevenuePricing.getCurrency() != null) {
            revenuePricing.setCurrency(new Currency(uiRevenuePricing.getCurrency().getKey()));
        }
        revenuePricing.setFromDt(ObjectsConverter.dateFromString(uiRevenuePricing.getFromDate()));
        revenuePricing.setIdRevenuePricing(uiRevenuePricing.getKey());
        revenuePricing.setPenalty(uiRevenuePricing.getPenalty() != null ? new BigDecimal(uiRevenuePricing.getPenalty()) : null);
        revenuePricing.setPrice(uiRevenuePricing.getPrice() != null ? new BigDecimal(uiRevenuePricing.getPrice()) : null);
        revenuePricing.setThreshold(uiRevenuePricing.getThreshold() != null ? new BigDecimal(uiRevenuePricing.getThreshold()) : null);
        revenuePricing.setToDt(ObjectsConverter.dateFromString(uiRevenuePricing.getToDate()));
        revenuePricing.setType(type);
        return revenuePricing;
    }

    public static DistributionManagement createDistributionManagement(UiDistributionManagement uiDistributionManagement) {
        DistributionManagement dm = new DistributionManagement();
        dm.setDeliveryCost(uiDistributionManagement.getCost() != null ? new BigDecimal(uiDistributionManagement.getCost()) : null);
        dm.setDeliveryDate(ObjectsConverter.dateFromString(uiDistributionManagement.getDeliveryDate()));
        if (uiDistributionManagement.getDeliveryMethod() != null && uiDistributionManagement.getDeliveryMethod().getKey() != null) {
            dm.setDeliveryMethod(new DeliveryMethod(uiDistributionManagement.getDeliveryMethod().getKey()));
        }
        dm.setDueDate(ObjectsConverter.dateFromString(uiDistributionManagement.getDueDate()));
        dm.setIdDistributionManagement(uiDistributionManagement.getKey());
        if (uiDistributionManagement.getMediaType() != null && uiDistributionManagement.getMediaType().getKey() != null) {
            dm.setMedia(new Media(uiDistributionManagement.getMediaType().getKey()));
        }
        if (uiDistributionManagement.getMetaFormat() != null && uiDistributionManagement.getMetaFormat().getName() != null) {
            dm.setMetadataFormat(uiDistributionManagement.getMetaFormat().getName());
        }
        if (uiDistributionManagement.getOwnership() != null && uiDistributionManagement.getOwnership().getKey() != null) {
            dm.setOwnership(new Ownership(uiDistributionManagement.getOwnership().getKey()));
        }
        dm.setReturnDate(ObjectsConverter.dateFromString(uiDistributionManagement.getReturnDate()));
        return dm;
    }

    public static CustomLicFieldValue createCustomLicFieldValue(UiUserDefinedFieldValue uiUserDefinedFieldValue) {
        CustomLicFieldValue customLicFieldValue = new CustomLicFieldValue();
        customLicFieldValue.setField(new Field(uiUserDefinedFieldValue.getIdUserDefinedField()));
        customLicFieldValue.setIdValue(uiUserDefinedFieldValue.getId());
        customLicFieldValue.setValue(uiUserDefinedFieldValue.getValue());
        if (customLicFieldValue.getValue() == null) {
            customLicFieldValue.setValue("");
        }
        return customLicFieldValue;
    }

    public static LicenseDocuments createLicenseDocuments(UiDocument document) {
        LicenseDocuments licenseDocuments = new LicenseDocuments();
        licenseDocuments.setIdDocument(document.getKey());
        licenseDocuments.setFileName(document.getFileName());
        return licenseDocuments;
    }

    public static UiLicense createUiLicense(License license) {
        UiLicense uiLicense = ObjectsConverter.createBasicUiLicense(license);
        uiLicense.setContentProvider(ObjectsConverter.createUiContentProvider(license.getContentProvider()));
        uiLicense.setCreationDate(ObjectsConverter.dateToString(license.getCreationDate()));
        if (!license.getLicenseCustomLicFieldValues().isEmpty()) {
            for (CustomLicFieldValue customLicFieldValue : license.getLicenseCustomLicFieldValues()) {
                uiLicense.getUserDefinedFieldsValues().add(ObjectsConverter.createUiUserDefinedFieldValue(customLicFieldValue));
            }
        }
        uiLicense.setDeal(ObjectsConverter.createUiDeal(license.getDeal()));
        uiLicense.setEffectiveDate(ObjectsConverter.dateToString(license.getEffectiveDate()));
        uiLicense.setAllAssets(license.getAllAssets());
        uiLicense.getDocumentsList().addAll(ObjectsConverter.createUiDocumentList(new ArrayList<Document>(license.getLicenseDocuments())));
        uiLicense.setNotes(license.getNotes());
        for (SmAssets asset : license.getSmAssets()) {
            UiAsset uiAsset = new UiAsset(Long.parseLong(asset.getId().getIdAsset()));
            uiLicense.getAssetList().add(uiAsset);
        }
        return uiLicense;
    }

    public static UiLicense createFullUiLicense(License license) {
        UiLicense uiLicense = ObjectsConverter.createUiLicense(license);
        HashSet<String> deliverLocations = new HashSet<String>();
        HashSet<Platform> platforms = new HashSet<Platform>();
        HashSet<Device> devices = new HashSet<Device>();
        for (LicenseDetails licenseDetails : license.getLicenseDetails()) {
            uiLicense.getLicenseDetailsList().add(ObjectsConverter.createUiLicenseDetails(licenseDetails));
            if (licenseDetails.getDeliveryLocation() != null) {
                deliverLocations.add(licenseDetails.getDeliveryLocation());
            }
            if (licenseDetails.getPlatform() != null) {
                platforms.add(licenseDetails.getPlatform());
            }
            if (licenseDetails.getDevice() == null) continue;
            devices.add(licenseDetails.getDevice());
        }
        for (String deliveryLocation : deliverLocations) {
            uiLicense.getDeliveryLocations().add(ObjectsConverter.createUiDeliveryLocation(deliveryLocation));
        }
        for (Platform platform : platforms) {
            uiLicense.getPlatforms().add(ObjectsConverter.createUiPlatform(platform));
        }
        for (Device device : devices) {
            uiLicense.getDevices().add(ObjectsConverter.createUiDevice(device));
        }
        return uiLicense;
    }

    private static UiContentProvider createUiContentProvider(String contentProvider) {
        UiContentProvider uiContentProvider = new UiContentProvider();
        uiContentProvider.setProviderId(contentProvider);
        return uiContentProvider;
    }

    private static UiDeliveryLocation createUiDeliveryLocation(String deliveryLocation) {
        UiDeliveryLocation uiDeliveryLocation = new UiDeliveryLocation();
        uiDeliveryLocation.setName(deliveryLocation);
        return uiDeliveryLocation;
    }

    private static UiLicenseDetails createUiLicenseDetails(LicenseDetails licenseDetails) {
        UiLicenseDetails uiLicenseDetails = new UiLicenseDetails();
        uiLicenseDetails.setKey(licenseDetails.getIdLicensedetails());
        uiLicenseDetails.setAeAdRemoval(licenseDetails.getAeAdRemoval());
        uiLicenseDetails.setAeContentEdit(licenseDetails.getAeContentEdit());
        uiLicenseDetails.setAeContentSecurity(licenseDetails.getAeContentSecurity());
        uiLicenseDetails.setAeFingerPrinting(licenseDetails.getAeFingerprinting());
        uiLicenseDetails.setAeQualityCheck(licenseDetails.getAeQualityCheck());
        uiLicenseDetails.setAeTranscoding(licenseDetails.getAeTranscoding());
        uiLicenseDetails.setAeWaterMarking(licenseDetails.getAeWatermarking());
        if (licenseDetails.getCurrency() != null) {
            uiLicenseDetails.setPrCurrency(new UiCurrency(licenseDetails.getCurrency().getIdCurrency()));
        }
        if (licenseDetails.getDeliveryLocation() != null) {
            uiLicenseDetails.setDeliveryLocation(ObjectsConverter.createUiDeliveryLocation(licenseDetails.getDeliveryLocation()));
            if (licenseDetails.getDeliveryLocationId() == null) {
                Site site = siteManager.getSiteByName(licenseDetails.getDeliveryLocation());
                if (site != null) {
                    uiLicenseDetails.getDeliveryLocation().setKey(site.getId().longValue());
                }
            } else {
                uiLicenseDetails.getDeliveryLocation().setKey(licenseDetails.getDeliveryLocationId());
            }
        }
        if (licenseDetails.getDevice() != null) {
            uiLicenseDetails.setDevice(ObjectsConverter.createUiDevice(licenseDetails.getDevice()));
        }
        if (licenseDetails.getPlatform() != null) {
            uiLicenseDetails.setPlatform(ObjectsConverter.createUiPlatform(licenseDetails.getPlatform()));
        }
        uiLicenseDetails.setPrActualLicenseFee(licenseDetails.getPrActualLicenseFee() != null ? licenseDetails.getPrActualLicenseFee().toString() : null);
        uiLicenseDetails.setPrActualRetailPrice(licenseDetails.getPrActualRetailPrice() != null ? licenseDetails.getPrActualRetailPrice().toString() : null);
        uiLicenseDetails.setPrDeemedRetailPrice(licenseDetails.getPrDeemedRetailPrice() != null ? licenseDetails.getPrDeemedRetailPrice().toString() : null);
        uiLicenseDetails.setPrGuaranteedBuyRate(licenseDetails.getPrGuaranteedBuyRate() != null ? licenseDetails.getPrGuaranteedBuyRate().toString() : null);
        uiLicenseDetails.setPrGuaranteedSubscribers(licenseDetails.getPrGuaranteedSubscribers());
        uiLicenseDetails.setPrInstallmentPlan(licenseDetails.getPrInstallmentPlan() != null ? licenseDetails.getPrInstallmentPlan().toString() : null);
        uiLicenseDetails.setPrInstallmentPlanRequired(licenseDetails.getPrInstallmentPlanRequired());
        uiLicenseDetails.setPrLostBuys(licenseDetails.getPrLostBuys() != null ? licenseDetails.getPrLostBuys().toString() : null);
        uiLicenseDetails.setPrRevenueShare(licenseDetails.getPrRevenueShare() != null ? licenseDetails.getPrRevenueShare().toString() : null);
        uiLicenseDetails.setPrMinimumLicenseFee(licenseDetails.getPrMinimumLicenseFee() != null ? licenseDetails.getPrMinimumLicenseFee().toString() : null);
        uiLicenseDetails.setPrOverage(licenseDetails.getPrOverage() != null ? licenseDetails.getPrOverage().toString() : null);
        uiLicenseDetails.setPrOverageRequired(licenseDetails.getPrOverageRequired());
        uiLicenseDetails.setPrRevenueShareRequired(licenseDetails.getPrRevenueShareRequired());
        uiLicenseDetails.setPrTieredPricingRequired(licenseDetails.getPrTieredPricingRequired());
        uiLicenseDetails.setPrUpfrontPayment(licenseDetails.getPrUpfrontPayment() != null ? licenseDetails.getPrUpfrontPayment().toString() : null);
        uiLicenseDetails.setPrUpfrontPaymentRequired(licenseDetails.getPrUpfrontPaymentRequired());
        uiLicenseDetails.setSmEffectiveDate(ObjectsConverter.dateToString(licenseDetails.getSmEffectiveDate()));
        uiLicenseDetails.setSmExpiryDate(ObjectsConverter.dateToString(licenseDetails.getSmExpiryDate()));
        uiLicenseDetails.setSmPosterArtRequired(licenseDetails.getSmPosterArtRequired());
        uiLicenseDetails.setSmPreviewRequired(licenseDetails.getSmPreviewRequired());
        for (CustomLicFieldValue customLicFieldValue : licenseDetails.getLicenseDetailsCustomLicFieldValues()) {
            uiLicenseDetails.getUserDefinedFieldValues().add(ObjectsConverter.createUiUserDefinedFieldValue(customLicFieldValue));
        }
        for (DistributionManagement distributionManagement : licenseDetails.getDistributionManagements()) {
            uiLicenseDetails.getDistributionManagementList().add(ObjectsConverter.createUiDistributionManagement(distributionManagement));
        }
        ObjectsConverter.sortDistributionManagementList(uiLicenseDetails.getDistributionManagementList());
        for (Language language : licenseDetails.getLanguages()) {
            uiLicenseDetails.getLanguageList().add(new UiLanguage(language.getIdLanguage()));
        }
        for (RevenuePricing revenuePricing : licenseDetails.getRevenuePricings()) {
            if (RevenuePricingType.RS.equals((Object)revenuePricing.getType())) {
                uiLicenseDetails.getRevenueSharedList().add(ObjectsConverter.createUiRevenuePricing(revenuePricing));
                continue;
            }
            if (!RevenuePricingType.TP.equals((Object)revenuePricing.getType())) continue;
            uiLicenseDetails.getTieredPricingList().add(ObjectsConverter.createUiRevenuePricing(revenuePricing));
        }
        return uiLicenseDetails;
    }

    private static void sortDistributionManagementList(List<UiDistributionManagement> distributionManagementList) {
        Collections.sort(distributionManagementList, new ComparatorImpl());
    }

    private static UiRevenuePricing createUiRevenuePricing(RevenuePricing revenuePricing) {
        UiRevenuePricing uiRevenuePricing = new UiRevenuePricing(revenuePricing.getIdRevenuePricing());
        if (revenuePricing.getCurrency() != null) {
            uiRevenuePricing.setCurrency(ObjectsConverter.createUiCurrency(revenuePricing.getCurrency()));
        }
        uiRevenuePricing.setFromDate(ObjectsConverter.dateToString(revenuePricing.getFromDt()));
        uiRevenuePricing.setPenalty(revenuePricing.getPenalty() != null ? revenuePricing.getPenalty().toString() : null);
        uiRevenuePricing.setPrice(revenuePricing.getPrice() != null ? revenuePricing.getPrice().toString() : null);
        uiRevenuePricing.setThreshold(revenuePricing.getThreshold() != null ? revenuePricing.getThreshold().toString() : null);
        uiRevenuePricing.setToDate(ObjectsConverter.dateToString(revenuePricing.getToDt()));
        return uiRevenuePricing;
    }

    private static UiDistributionManagement createUiDistributionManagement(DistributionManagement distributionManagement) {
        UiDistributionManagement uiDistMgmt = new UiDistributionManagement();
        uiDistMgmt.setCost(distributionManagement.getDeliveryCost() != null ? distributionManagement.getDeliveryCost().toString() : null);
        uiDistMgmt.setDeliveryDate(ObjectsConverter.dateToString(distributionManagement.getDeliveryDate()));
        if (distributionManagement.getDeliveryMethod() != null) {
            UiDeliveryMethod uiDeliveryMethod = new UiDeliveryMethod(distributionManagement.getDeliveryMethod().getIdDeliveryMethod());
            uiDeliveryMethod.setName(distributionManagement.getDeliveryMethod().getDeliveryMethod());
            uiDistMgmt.setDeliveryMethod(uiDeliveryMethod);
        }
        uiDistMgmt.setDueDate(ObjectsConverter.dateToString(distributionManagement.getDueDate()));
        uiDistMgmt.setKey(distributionManagement.getIdDistributionManagement());
        if (distributionManagement.getMedia() != null) {
            UiMediaType uiMediaType = new UiMediaType(distributionManagement.getMedia().getIdMedia());
            uiMediaType.setName(distributionManagement.getMedia().getMediaType());
            uiDistMgmt.setMediaType(uiMediaType);
        }
        uiDistMgmt.setMetaFormat(ObjectsConverter.createUiMetadataFormat(distributionManagement.getMetadataFormat()));
        if (distributionManagement.getOwnership() != null) {
            uiDistMgmt.setOwnership(new UiOwnership(distributionManagement.getOwnership().getIdOwnership()));
        }
        uiDistMgmt.setReturnDate(ObjectsConverter.dateToString(distributionManagement.getReturnDate()));
        return uiDistMgmt;
    }

    private static UiMetaFormat createUiMetadataFormat(String metadataFormat) {
        UiMetaFormat uiMetaFormat = null;
        if (metadataFormat != null && !metadataFormat.trim().equals("")) {
            uiMetaFormat = new UiMetaFormat();
            uiMetaFormat.setName(metadataFormat);
        }
        return uiMetaFormat;
    }

    public static UiLicense createBasicUiLicense(License license) {
        UiLicense uiLicense = new UiLicense();
        uiLicense.setKey(license.getIdLicense());
        uiLicense.setExternalId(license.getExternalId());
        uiLicense.setActive(license.getActive());
        uiLicense.setExpiryDate(ObjectsConverter.dateToString(license.getExpiryDate()));
        uiLicense.setName(license.getName());
        uiLicense.setType(ObjectsConverter.createUiKeyName(license.getLicenseType().getIdType(), license.getLicenseType().getType()));
        return uiLicense;
    }

    public static UiDeal createUiDeal(Deal deal) {
        UiDeal uiDeal = new UiDeal(deal.getIdDeal());
        uiDeal.setExternalId(deal.getExternalId());
        uiDeal.setActive(deal.getActive());
        uiDeal.setCreationDate(ObjectsConverter.dateToString(deal.getCreationDate()));
        uiDeal.setEffectiveDate(ObjectsConverter.dateToString(deal.getEffectiveDate()));
        uiDeal.setExpiryDate(ObjectsConverter.dateToString(deal.getExpiryDate()));
        uiDeal.setLicenseExpiryReminder(deal.getLicenseExpiryReminder());
        uiDeal.setName(deal.getName());
        uiDeal.setContract(ObjectsConverter.createUiContract(deal.getContract()));
        uiDeal.setType(ObjectsConverter.createUiDealType(deal.getDealType()));
        uiDeal.setUiContactList(ObjectsConverter.createUiDealContactList(new ArrayList<DealContacts>(deal.getDealContacts())));
        uiDeal.setUserDefinedFieldsValues(ObjectsConverter.createUiUserDefinedFieldValueList(new ArrayList<CustomLicFieldValue>(deal.getDealCustomLicFieldValues())));
        uiDeal.setUiDocumentList(ObjectsConverter.createUiDocumentList(new ArrayList<Document>(deal.getDealDocuments())));
        return uiDeal;
    }

    public static UiContract createUiContract(Contract contract) {
        UiContract uiContract = new UiContract(contract.getIdContract());
        uiContract.setExternalId(contract.getExternalId());
        uiContract.setActive(contract.getActive());
        uiContract.setCreationDate(ObjectsConverter.dateToString(contract.getCreationDate()));
        uiContract.setDealExpiryReminder(contract.getDealExpiryReminder());
        uiContract.setEffectiveDate(ObjectsConverter.dateToString(contract.getEffectiveDate()));
        uiContract.setExpiryDate(ObjectsConverter.dateToString(contract.getExpiryDate()));
        uiContract.setName(contract.getName());
        uiContract.setCopyrightHolder(ObjectsConverter.createUiCopyrightHolder(contract.getCopyrightHolder()));
        uiContract.setType(ObjectsConverter.createUiContractType(contract.getContractType()));
        uiContract.setUserDefinedFieldsValues(ObjectsConverter.createUiUserDefinedFieldValueList(new ArrayList<CustomLicFieldValue>(contract.getContractCustomLicFieldValues())));
        uiContract.setUiContactList(ObjectsConverter.createUiContractContactList(new ArrayList<ContractContacts>(contract.getContractContacts())));
        uiContract.setUiDocumentList(ObjectsConverter.createUiDocumentList(new ArrayList<Document>(contract.getContractDocuments())));
        return uiContract;
    }

    public static UiCopyrightHolder createUiCopyrightHolder(CopyrightHolder copyrightHolder) {
        UiCopyrightHolder uiCopyrightHolder = new UiCopyrightHolder(copyrightHolder.getIdCopyrightHolder());
        uiCopyrightHolder.setExternalId(copyrightHolder.getExternalId());
        uiCopyrightHolder.setAddress(copyrightHolder.getAddress());
        uiCopyrightHolder.setAffiliation(copyrightHolder.getAffiliation());
        uiCopyrightHolder.setName(copyrightHolder.getName());
        uiCopyrightHolder.setUiContactList(ObjectsConverter.createUiCopyHolderContactList(new ArrayList<CopyHolderContacts>(copyrightHolder.getCopyHolderContacts())));
        uiCopyrightHolder.setUiDocumentList(ObjectsConverter.createUiDocumentList(new ArrayList<Document>(copyrightHolder.getCopyHolderDocuments())));
        uiCopyrightHolder.setUserDefinedFieldsValues(ObjectsConverter.createUiUserDefinedFieldValueList(new ArrayList<CustomLicFieldValue>(copyrightHolder.getCopyHolderCustomLicFieldValues())));
        return uiCopyrightHolder;
    }

    public static CopyrightHolder createCopyrightHolder(UiCopyrightHolder uiCopyrightHolder) throws ParseException {
        CopyrightHolder copyrightHolder = new CopyrightHolder();
        copyrightHolder.setIdCopyrightHolder(uiCopyrightHolder.getKey());
        copyrightHolder.setExternalId(uiCopyrightHolder.getExternalId());
        copyrightHolder.setAddress(uiCopyrightHolder.getAddress());
        copyrightHolder.setAffiliation(uiCopyrightHolder.getAffiliation());
        copyrightHolder.setContracts(new HashSet<Contract>(ObjectsConverter.createContractList(uiCopyrightHolder.getUiContractList(), copyrightHolder)));
        copyrightHolder.setCopyHolderContacts(new HashSet<CopyHolderContacts>(ObjectsConverter.createCopyrightHolderContactsList(uiCopyrightHolder.getUiContactList(), copyrightHolder)));
        copyrightHolder.setCopyHolderCustomLicFieldValues(new HashSet<CustomLicFieldValue>(ObjectsConverter.createCustomLicFieldValue(uiCopyrightHolder.getUserDefinedFieldsValues())));
        copyrightHolder.setName(uiCopyrightHolder.getName());
        return copyrightHolder;
    }

    public static void setUiDeal(List<UiLicense> licenseList, UiDeal uiDeal) {
        for (UiLicense uiLicense : licenseList) {
            uiLicense.setDeal(uiDeal);
        }
    }

    public static void setUiContract(List<UiDeal> dealList, UiContract contract) {
        for (UiDeal uiDeal : dealList) {
            uiDeal.setContract(contract);
        }
    }

    public static void setUiCopyrightHolder(List<UiContract> contractList, UiCopyrightHolder copyrightHolder) {
        for (UiContract uiContract : contractList) {
            uiContract.setCopyrightHolder(copyrightHolder);
        }
    }

    public static List<Contract> createContractList(List<UiContract> uiContractList, CopyrightHolder copyrightHolder) throws ParseException {
        ArrayList<Contract> contractList = new ArrayList<Contract>();
        if (uiContractList != null) {
            for (UiContract uiContract : uiContractList) {
                contractList.add(ObjectsConverter.createContract(uiContract, copyrightHolder));
            }
        }
        return contractList;
    }

    public static List<UiContract> createUiContractList(List<Contract> contractList) {
        ArrayList<UiContract> uiContractList = new ArrayList<UiContract>();
        for (Contract contract : contractList) {
            uiContractList.add(ObjectsConverter.createUiContract(contract));
        }
        return uiContractList;
    }

    public static List<UiDeal> createUiDealList(List<Deal> dealList) {
        ArrayList<UiDeal> uiDealList = new ArrayList<UiDeal>();
        for (Deal deal : dealList) {
            uiDealList.add(ObjectsConverter.createUiDeal(deal));
        }
        return uiDealList;
    }

    private static UiKeyName createUiKeyName(long key, String name) {
        UiKeyName uiKeyName = new UiKeyName();
        uiKeyName.setKey(key);
        uiKeyName.setName(name);
        return uiKeyName;
    }

    public static Contract createContract(UiContract uiContract, CopyrightHolder copyrightHolder) throws ParseException {
        Contract contract = new Contract();
        contract.setName(uiContract.getName());
        contract.setIdContract(uiContract.getKey());
        contract.setExternalId(uiContract.getExternalId());
        contract.setActive(Boolean.valueOf(uiContract.isActive()));
        contract.setContractContacts(new HashSet<ContractContacts>(ObjectsConverter.createContractContactsList(uiContract.getUiContactList(), contract)));
        contract.setContractType(ObjectsConverter.createContractType(uiContract.getType()));
        contract.setEffectiveDate(ObjectsConverter.dateFromString(uiContract.getEffectiveDate()));
        contract.setExpiryDate(ObjectsConverter.dateFromString(uiContract.getExpiryDate()));
        contract.setCreationDate(ObjectsConverter.dateFromString(uiContract.getCreationDate()));
        contract.setCopyrightHolder(copyrightHolder);
        contract.setContractCustomLicFieldValues(new HashSet<CustomLicFieldValue>(ObjectsConverter.createCustomLicFieldValue(uiContract.getUserDefinedFieldsValues())));
        contract.setDealExpiryReminder(uiContract.getDealExpiryReminder());
        return contract;
    }

    public static List<License> createLicenseList(List<UiLicense> uiLicenseList) throws ParseException {
        ArrayList<License> licenseList = new ArrayList<License>();
        for (UiLicense uiLicense : uiLicenseList) {
            licenseList.add(ObjectsConverter.createLicense(uiLicense));
        }
        return licenseList;
    }

    public static List<Deal> createDealList(List<UiDeal> uiDealList, Contract contract) throws ParseException {
        ArrayList<Deal> dealList = new ArrayList<Deal>();
        for (UiDeal uiLicense : uiDealList) {
            dealList.add(ObjectsConverter.createDeal(uiLicense, contract));
        }
        return dealList;
    }

    public static List<UiLicense> createUiLicenseList(List<License> licenseList) {
        ArrayList<UiLicense> uiLicenseList = new ArrayList<UiLicense>();
        for (License license : licenseList) {
            uiLicenseList.add(ObjectsConverter.createUiLicense(license));
        }
        return uiLicenseList;
    }

    public static Deal createDeal(UiDeal uiDeal, Contract contract) throws ParseException {
        Deal deal = new Deal();
        deal.setActive(Boolean.valueOf(uiDeal.isActive()));
        deal.setIdDeal(uiDeal.getKey());
        deal.setExternalId(uiDeal.getExternalId());
        deal.setContract(contract);
        deal.setCreationDate(ObjectsConverter.dateFromString(uiDeal.getCreationDate()));
        deal.setDealCustomLicFieldValues(new HashSet<CustomLicFieldValue>(ObjectsConverter.createCustomLicFieldValue(uiDeal.getUserDefinedFieldsValues())));
        deal.setDealType(ObjectsConverter.createDealType(uiDeal.getType()));
        deal.setEffectiveDate(ObjectsConverter.dateFromString(uiDeal.getEffectiveDate()));
        deal.setExpiryDate(ObjectsConverter.dateFromString(uiDeal.getExpiryDate()));
        deal.setDealContacts(new HashSet<DealContacts>(ObjectsConverter.createDealContactsList(uiDeal.getUiContactList(), deal)));
        deal.setLicenseExpiryReminder(uiDeal.getLicenseExpiryReminder());
        deal.setLicenses(new HashSet<License>(ObjectsConverter.createLicenseList(uiDeal.getUiLicenseList())));
        deal.setName(uiDeal.getName());
        return deal;
    }

    public static DealType createDealType(UiDealType uiDealType) {
        DealType dealType = new DealType();
        if (uiDealType != null) {
            dealType.setIdType(uiDealType.getKey());
            dealType.setType(uiDealType.getName());
        }
        return dealType;
    }

    public static List<CustomLicFieldValue> createCustomLicFieldValue(List<UiUserDefinedFieldValue> uiUserDefinedFieldValueList) {
        ArrayList<CustomLicFieldValue> customLicFieldValueList = new ArrayList<CustomLicFieldValue>();
        for (UiUserDefinedFieldValue uiUserDefinedFieldValue : uiUserDefinedFieldValueList) {
            customLicFieldValueList.add(ObjectsConverter.createCustomLicFieldValue(uiUserDefinedFieldValue));
        }
        return customLicFieldValueList;
    }

    public static ContractType createContractType(UiContractType uiContractType) {
        ContractType contractType = new ContractType();
        contractType.setIdType(uiContractType.getKey());
        contractType.setType(uiContractType.getName());
        return contractType;
    }

    public static UiContractType createUiContractType(ContractType contractType) {
        UiContractType uiContractType = new UiContractType();
        uiContractType.setKey(contractType.getIdType());
        uiContractType.setName(contractType.getType());
        return uiContractType;
    }

    public static UiDealType createUiDealType(DealType dealType) {
        UiDealType uiDealType = new UiDealType();
        uiDealType.setKey(dealType.getIdType());
        uiDealType.setName(dealType.getType());
        return uiDealType;
    }

    public static List<ContractContacts> createContractContactsList(List<UiContact> uiContactList, Contract contract) {
        ArrayList<ContractContacts> contractList = new ArrayList<ContractContacts>();
        for (UiContact ui : uiContactList) {
            ContractContacts cc = (ContractContacts)ObjectsConverter.createContact(ui, contract, ContactType.CONTRACT);
            contractList.add(cc);
        }
        return contractList;
    }

    public static List<DealContacts> createDealContactsList(List<UiContact> uiContactList, Deal deal) {
        ArrayList<DealContacts> contractList = new ArrayList<DealContacts>();
        for (UiContact ui : uiContactList) {
            DealContacts dealContacts = (DealContacts)ObjectsConverter.createContact(ui, deal, ContactType.DEAL);
            contractList.add(dealContacts);
        }
        return contractList;
    }

    public static List<CopyHolderContacts> createCopyrightHolderContactsList(List<UiContact> uiContactList, CopyrightHolder cp) {
        ArrayList<CopyHolderContacts> contractList = new ArrayList<CopyHolderContacts>();
        for (UiContact ui : uiContactList) {
            CopyHolderContacts cpContacts = (CopyHolderContacts)ObjectsConverter.createContact(ui, cp, ContactType.COPYRIGHT_HOLDER);
            contractList.add(cpContacts);
        }
        return contractList;
    }

    public static Contact createContact(UiContact uiContact, Object parent, ContactType contractType) {
        if (contractType.equals((Object)ContactType.CONTRACT)) {
            Contract contract = (Contract)parent;
            ContractContacts contractContacts = new ContractContacts();
            contractContacts.setContract(contract);
            contractContacts.setEmail(uiContact.getEmail());
            contractContacts.setIdContact(uiContact.getKey());
            contractContacts.setMobile(uiContact.getPhoneMobile());
            contractContacts.setName(uiContact.getName());
            contractContacts.setNotify(Boolean.valueOf(uiContact.isNotify()));
            contractContacts.setOffice(uiContact.getPhoneOffice());
            contractContacts.setWork(uiContact.getPhoneWork());
            return contractContacts;
        }
        if (contractType.equals((Object)ContactType.COPYRIGHT_HOLDER)) {
            CopyrightHolder copyrightHolder = (CopyrightHolder)parent;
            CopyHolderContacts copyrightHolderContacts = new CopyHolderContacts();
            copyrightHolderContacts.setCopyrightHolder(copyrightHolder);
            copyrightHolderContacts.setEmail(uiContact.getEmail());
            copyrightHolderContacts.setIdContact(uiContact.getKey());
            copyrightHolderContacts.setMobile(uiContact.getPhoneMobile());
            copyrightHolderContacts.setName(uiContact.getName());
            copyrightHolderContacts.setNotify(Boolean.valueOf(uiContact.isNotify()));
            copyrightHolderContacts.setOffice(uiContact.getPhoneOffice());
            copyrightHolderContacts.setWork(uiContact.getPhoneWork());
            return copyrightHolderContacts;
        }
        if (contractType.equals((Object)ContactType.DEAL)) {
            Deal deal = (Deal)parent;
            DealContacts dealContacts = new DealContacts();
            dealContacts.setDeal(deal);
            dealContacts.setEmail(uiContact.getEmail());
            dealContacts.setIdContact(uiContact.getKey());
            dealContacts.setMobile(uiContact.getPhoneMobile());
            dealContacts.setName(uiContact.getName());
            dealContacts.setNotify(Boolean.valueOf(uiContact.isNotify()));
            dealContacts.setOffice(uiContact.getPhoneOffice());
            dealContacts.setWork(uiContact.getPhoneWork());
            return dealContacts;
        }
        return null;
    }

    public static UiContact createUiContact(Contact contact) {
        UiContact uiContact = new UiContact();
        if (contact instanceof CopyHolderContacts) {
            uiContact.setEmail(((CopyHolderContacts)contact).getEmail());
            uiContact.setKey(((CopyHolderContacts)contact).getIdContact());
            uiContact.setName(((CopyHolderContacts)contact).getName());
            uiContact.setNotify(((CopyHolderContacts)contact).getNotify());
            uiContact.setPhoneMobile(((CopyHolderContacts)contact).getMobile());
            uiContact.setPhoneOffice(((CopyHolderContacts)contact).getOffice());
            uiContact.setPhoneWork(((CopyHolderContacts)contact).getWork());
            return uiContact;
        }
        if (contact instanceof DealContacts) {
            uiContact.setEmail(((DealContacts)contact).getEmail());
            uiContact.setKey(((DealContacts)contact).getIdContact());
            uiContact.setName(((DealContacts)contact).getName());
            uiContact.setNotify(((DealContacts)contact).getNotify());
            uiContact.setPhoneMobile(((DealContacts)contact).getMobile());
            uiContact.setPhoneOffice(((DealContacts)contact).getOffice());
            uiContact.setPhoneWork(((DealContacts)contact).getWork());
            return uiContact;
        }
        if (contact instanceof ContractContacts) {
            uiContact.setEmail(((ContractContacts)contact).getEmail());
            uiContact.setKey(((ContractContacts)contact).getIdContact());
            uiContact.setName(((ContractContacts)contact).getName());
            uiContact.setNotify(((ContractContacts)contact).getNotify());
            uiContact.setPhoneMobile(((ContractContacts)contact).getMobile());
            uiContact.setPhoneOffice(((ContractContacts)contact).getOffice());
            uiContact.setPhoneWork(((ContractContacts)contact).getWork());
            return uiContact;
        }
        return null;
    }

    public static List<UiContact> createUiContractContactList(List<ContractContacts> list) {
        ArrayList<UiContact> uiContactList = new ArrayList<UiContact>();
        for (Contact contact : list) {
            uiContactList.add(ObjectsConverter.createUiContact(contact));
        }
        return uiContactList;
    }

    public static List<UiContact> createUiDealContactList(List<DealContacts> list) {
        ArrayList<UiContact> uiContactList = new ArrayList<UiContact>();
        for (Contact contact : list) {
            uiContactList.add(ObjectsConverter.createUiContact(contact));
        }
        return uiContactList;
    }

    public static List<UiContact> createUiCopyHolderContactList(List<CopyHolderContacts> list) {
        ArrayList<UiContact> uiContactList = new ArrayList<UiContact>();
        for (Contact contact : list) {
            uiContactList.add(ObjectsConverter.createUiContact(contact));
        }
        return uiContactList;
    }

    private static UiUserDefinedFieldValue createUiUserDefinedFieldValue(CustomLicFieldValue customLicFieldValue) {
        UiUserDefinedFieldValue uiUserDefinedFieldValue = new UiUserDefinedFieldValue(customLicFieldValue.getIdValue());
        uiUserDefinedFieldValue.setIdUserDefinedField(customLicFieldValue.getField().getIdField());
        uiUserDefinedFieldValue.setValue(customLicFieldValue.getValue());
        return uiUserDefinedFieldValue;
    }

    private static List<UiUserDefinedFieldValue> createUiUserDefinedFieldValueList(List<CustomLicFieldValue> customLicFieldValueList) {
        ArrayList<UiUserDefinedFieldValue> uiUserDefinedFieldValueList = new ArrayList<UiUserDefinedFieldValue>();
        for (CustomLicFieldValue customLicFieldValue : customLicFieldValueList) {
            uiUserDefinedFieldValueList.add(ObjectsConverter.createUiUserDefinedFieldValue(customLicFieldValue));
        }
        return uiUserDefinedFieldValueList;
    }

    public static UiDevice createUiDevice(Device device) {
        UiDevice uiDevice = new UiDevice(device.getIdDevice());
        uiDevice.setName(device.getDeviceName());
        uiDevice.setPlatform(ObjectsConverter.createUiPlatform(device.getPlatform()));
        return uiDevice;
    }

    public static UiPlatform createUiPlatform(Platform platform) {
        UiPlatform uiPlatform = new UiPlatform(platform.getIdPlatform());
        uiPlatform.setName(platform.getDescription());
        return uiPlatform;
    }

    public static UiCurrency createUiCurrency(Currency currency) {
        UiCurrency uiCurrency = new UiCurrency(currency.getIdCurrency());
        uiCurrency.setName(currency.getName());
        uiCurrency.setSymbol(currency.getSymbol());
        return uiCurrency;
    }

    public static UiUserDefinedField createUiUserDefinedField(Field field, List<UiKeyName> frequencies, List<UiCurrency> currencies) {
        UiUserDefinedField uiUserDefinedField = new UiUserDefinedField();
        uiUserDefinedField.setDefaultValue(field.getDefaultValue());
        uiUserDefinedField.setDropDown(field.getDropdown());
        uiUserDefinedField.setIdUserDefinedField(field.getIdField());
        uiUserDefinedField.setLabel(field.getName());
        uiUserDefinedField.setMaxChars(field.getMaxChars());
        uiUserDefinedField.setMinChars(field.getMinChars());
        uiUserDefinedField.setOrder(field.getFieldOrder());
        uiUserDefinedField.setRequired(field.getRequired());
        uiUserDefinedField.setScreenName(field.getScreenName().toString());
        uiUserDefinedField.setType(FieldTypeEnum.valueOf(field.getType().toString()));
        if (field.getType().equals((Object)FieldType.Frequency)) {
            uiUserDefinedField.setKeyNames(new HashSet<UiKeyName>(frequencies));
        } else if (field.getType().equals((Object)FieldType.Currency)) {
            for (UiCurrency currency : currencies) {
                UiKeyName uiKeyName = new UiKeyName(currency.getKey());
                uiKeyName.setName(String.valueOf(currency.getName()) + "(" + currency.getSymbol() + ")");
                uiUserDefinedField.getKeyNames().add(uiKeyName);
            }
        } else {
            for (FieldDropdown fieldDropdown : field.getFieldDropdowns()) {
                UiKeyName uiKeyName = new UiKeyName(fieldDropdown.getIdFieldDropdown());
                uiKeyName.setName(fieldDropdown.getValue());
                uiUserDefinedField.getKeyNames().add(uiKeyName);
            }
        }
        return uiUserDefinedField;
    }

    public static Field createField(UiUserDefinedField userDefinedField) {
        Field dbField = new Field(FieldType.valueOf((String)userDefinedField.getType().toString()), userDefinedField.getLabel(), ScreenName.valueOf((String)userDefinedField.getScreenName()), userDefinedField.isDropDown(), userDefinedField.isRequired(), userDefinedField.getDefaultValue(), userDefinedField.getMinChars(), userDefinedField.getMaxChars(), userDefinedField.getOrder(), null);
        dbField.setIdField(userDefinedField.getIdUserDefinedField());
        if (userDefinedField.getKeyNames() != null) {
            HashSet<FieldDropdown> dropDowns = new HashSet<FieldDropdown>();
            for (UiKeyName keyName : userDefinedField.getKeyNames()) {
                FieldDropdown fieldDropDown = new FieldDropdown(dbField, keyName.getName());
                fieldDropDown.setIdFieldDropdown(keyName.getKey());
                dropDowns.add(fieldDropDown);
            }
            dbField.setFieldDropdowns(dropDowns);
        }
        return dbField;
    }

    public static DealDocuments createDealDocuments(UiDocument uiDocument, File file) {
        DealDocuments dealDocuments = new DealDocuments();
        dealDocuments.setFileName(file.getName());
        try {
            FileInputStream is = new FileInputStream(file);
            byte[] fileByte = new byte[(int)file.length()];
            ((InputStream)is).read(fileByte);
            dealDocuments.setFileBytes(fileByte);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"Internal exception while create Deal Document.", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"Internal exception while create Deal Document.", (Throwable)e);
        }
        dealDocuments.setIdDocument(uiDocument.getKey());
        return dealDocuments;
    }

    public static LicenseDocuments createLicenseDocuments(UiDocument uiDocument, File file) {
        LicenseDocuments licenseDocuments = new LicenseDocuments();
        licenseDocuments.setFileName(file.getName());
        try {
            FileInputStream is = new FileInputStream(file);
            byte[] fileByte = new byte[(int)file.length()];
            ((InputStream)is).read(fileByte);
            licenseDocuments.setFileBytes(fileByte);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"Internal exception while create License Document.", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"Internal exception while create License Document.", (Throwable)e);
        }
        licenseDocuments.setIdDocument(uiDocument.getKey());
        return licenseDocuments;
    }

    public static ContractDocuments createContractDocuments(UiDocument uiDocument, File file) {
        ContractDocuments contractDocuments = new ContractDocuments();
        contractDocuments.setFileName(file.getName());
        try {
            FileInputStream is = new FileInputStream(file);
            byte[] fileByte = new byte[(int)file.length()];
            ((InputStream)is).read(fileByte);
            contractDocuments.setFileBytes(fileByte);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"Internal exception while create Contract Document.", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"Internal exception while create Contract Document.", (Throwable)e);
        }
        contractDocuments.setIdDocument(uiDocument.getKey());
        return contractDocuments;
    }

    public static CopyHolderDocuments createCopyRightHolderDocuments(UiDocument uiDocument, File file) {
        CopyHolderDocuments cpDocuments = new CopyHolderDocuments();
        cpDocuments.setFileName(file.getName());
        try {
            FileInputStream is = new FileInputStream(file);
            byte[] fileByte = new byte[(int)file.length()];
            ((InputStream)is).read(fileByte);
            cpDocuments.setFileBytes(fileByte);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"Internal exception while create CopyRightHolder Document.", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"Internal exception while create CopyRightHolder Document.", (Throwable)e);
        }
        cpDocuments.setIdDocument(uiDocument.getKey());
        return cpDocuments;
    }

    public static UiDocument createUiDocument(Document document) {
        UiDocument uiDocument = new UiDocument();
        if (document instanceof CopyHolderDocuments) {
            uiDocument.setDocumentType(UiDocumentType.COPYRIGHT_HOLDER);
            uiDocument.setParentId(((CopyHolderDocuments)document).getCopyrightHolder().getIdCopyrightHolder());
            uiDocument.setFileName(((CopyHolderDocuments)document).getFileName());
            uiDocument.setKey(((CopyHolderDocuments)document).getIdDocument());
        } else if (document instanceof ContractDocuments) {
            uiDocument.setDocumentType(UiDocumentType.CONTRACT);
            uiDocument.setFileName(((ContractDocuments)document).getFileName());
            uiDocument.setKey(((ContractDocuments)document).getIdDocument());
            uiDocument.setParentId(((ContractDocuments)document).getContract().getIdContract());
        } else if (document instanceof DealDocuments) {
            uiDocument.setDocumentType(UiDocumentType.DEAL);
            uiDocument.setFileName(((DealDocuments)document).getFileName());
            uiDocument.setKey(((DealDocuments)document).getIdDocument());
            uiDocument.setParentId(((DealDocuments)document).getDeal().getIdDeal());
        } else if (document instanceof LicenseDocuments) {
            uiDocument.setDocumentType(UiDocumentType.LICENSE);
            uiDocument.setFileName(((LicenseDocuments)document).getFileName());
            uiDocument.setKey(((LicenseDocuments)document).getIdDocument());
            uiDocument.setParentId(((LicenseDocuments)document).getLicense().getIdLicense());
        }
        return uiDocument;
    }

    public static List<UiDocument> createUiDocumentList(List<Document> documentList) {
        ArrayList<UiDocument> uiDocumentList = new ArrayList<UiDocument>();
        for (Document document : documentList) {
            UiDocument uiDocument = ObjectsConverter.createUiDocument(document);
            uiDocumentList.add(uiDocument);
        }
        return uiDocumentList;
    }

    private static int compareStrings(String value1, String value2) {
        int result = 0;
        if (value1 == null && value2 != null) {
            result = -1;
        } else if (value1 != null && value2 == null) {
            result = 1;
        } else if (value1 != null && value2 != null) {
            result = value1.compareTo(value2);
        }
        return result;
    }

    public static Audit createAudit(UiAudit uiAudit) {
        Audit audit = new Audit();
        audit.setIdAudit(uiAudit.getKey());
        audit.setUserName(uiAudit.getUserName());
        audit.setAuditMessage(uiAudit.getAuditMessage());
        audit.setCreateDate(ObjectsConverter.dateFromString(uiAudit.getCreateDate()));
        audit.setAuditType(uiAudit.getAuditType());
        audit.setAuditAction(uiAudit.getAuditAction());
        return audit;
    }

    public static UiAudit createBasicUiAudit(Audit audit) {
        UiAudit uiAudit = new UiAudit();
        uiAudit.setUserName(audit.getUserName());
        uiAudit.setAuditMessage(audit.getAuditMessage());
        uiAudit.setCreateDate(ObjectsConverter.dateToString(audit.getCreateDate()));
        uiAudit.setAuditType(audit.getAuditType());
        uiAudit.setKey(audit.getIdAudit());
        uiAudit.setAuditAction(audit.getAuditAction());
        return uiAudit;
    }

    private static Date dateFromString(String str) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        Date date = null;
        try {
            date = simpleDateFormat.parse(str);
        }
        catch (Exception ex) {
            logger.error((Object)"Invalid date format.", (Throwable)ex);
        }
        return date;
    }

    private static String dateToString(Date date) {
        if (date == null) {
            return "";
        }
        return simpleDateFormat.format(date);
    }

    private static class ComparatorImpl
    implements Comparator<UiDistributionManagement> {
        @Override
        public int compare(UiDistributionManagement dm1, UiDistributionManagement dm2) {
            String methodKey1 = dm1.getDeliveryMethod() == null ? null : dm1.getDeliveryMethod().getName();
            String mediaKey1 = dm1.getMediaType() == null ? null : dm1.getMediaType().getName();
            String formatKey1 = dm1.getMetaFormat() == null ? null : dm1.getMetaFormat().getName();
            String methodKey2 = dm2.getDeliveryMethod() == null ? null : dm2.getDeliveryMethod().getName();
            String mediaKey2 = dm2.getMediaType() == null ? null : dm2.getMediaType().getName();
            String formatKey2 = dm2.getMetaFormat() == null ? null : dm2.getMetaFormat().getName();
            int result = ObjectsConverter.compareStrings(mediaKey1, mediaKey2);
            if (result == 0 && (result = ObjectsConverter.compareStrings(methodKey1, methodKey2)) == 0) {
                result = ObjectsConverter.compareStrings(formatKey1, formatKey2);
            }
            return result;
        }
    }

    public static enum ContactType {
        CONTRACT,
        COPYRIGHT_HOLDER,
        DEAL;

    }
}

