/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.me.plugin.util;

import com.ericsson.cms.me.plugin.exception.MEConnectException;
import com.ericsson.cms.me.plugin.exception.MEPluginException;
import com.ericsson.cms.me.plugin.util.QueryBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;

public class APIConnector {
    public static final String PROXY_HOST_PARAM = "proxyHost";
    public static final String PROXY_PORT_PARAM = "proxyPort";
    public static final String PROXY_USERNAME_PARAM = "proxyUsername";
    public static final String PROXY_PASSWORD_PARAM = "proxyPassword";

    public static String request(String urlStr, Map<String, String> props) throws MEConnectException, MEPluginException {
        String result = "";
        try {
            URL url = new URL(urlStr);
            result = APIConnector.request(url, props);
        }
        catch (MalformedURLException mue) {
            throw new MEPluginException(mue);
        }
        catch (MEConnectException mce) {
            throw mce;
        }
        catch (Exception e) {
            throw new MEPluginException(e);
        }
        return result;
    }

    public static String request(String urlStr) throws MEConnectException, MEPluginException {
        String result = "";
        try {
            URL url = new URL(urlStr);
            result = APIConnector.request(url);
        }
        catch (MalformedURLException mue) {
            throw new MEPluginException(mue);
        }
        catch (MEConnectException mce) {
            throw mce;
        }
        catch (Exception e) {
            throw new MEPluginException(e);
        }
        return result;
    }

    public static String request(URL url) throws IOException, MEConnectException, Exception {
        return APIConnector.request(url, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String request(URL url, Map<String, String> props) throws IOException, MEConnectException, Exception {
        StringBuilder resultBuilder = new StringBuilder();
        HttpURLConnection cnx = null;
        BufferedReader reader = null;
        try {
            cnx = APIConnector.getHttpURLConnection(url, props);
            InputStream is = cnx.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            reader = new BufferedReader(isr);
            String curLine = null;
            while ((curLine = reader.readLine()) != null) {
                resultBuilder.append(curLine);
            }
        }
        catch (Exception e) {
            if (cnx != null && cnx instanceof HttpURLConnection) {
                HttpURLConnection httpCnx = cnx;
                try {
                    int responseCode = httpCnx.getResponseCode();
                    InputStream errorStream = httpCnx.getErrorStream();
                    BufferedReader errorReader = new BufferedReader(new InputStreamReader(errorStream));
                    StringBuilder errorBuilder = new StringBuilder();
                    String errorLine = null;
                    while ((errorLine = errorReader.readLine()) != null) {
                        errorBuilder.append(errorLine);
                    }
                    throw new MEConnectException(responseCode, errorBuilder.toString());
                }
                catch (MEConnectException mpe) {
                    throw mpe;
                }
                catch (Exception exception) {
                    throw e;
                }
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
            if (cnx != null && cnx instanceof HttpURLConnection) {
                HttpURLConnection httpCnx = cnx;
                httpCnx.disconnect();
            }
        }
        return resultBuilder.toString();
    }

    private static HttpURLConnection getHttpURLConnection(URL url, Map<String, String> props) throws IOException, EncoderException {
        Proxy proxy = APIConnector.getProxy(props.get(PROXY_HOST_PARAM), props.get(PROXY_PORT_PARAM));
        if (props == null || proxy == null) {
            return (HttpURLConnection)url.openConnection();
        }
        HttpURLConnection cnx = (HttpURLConnection)url.openConnection(proxy);
        APIConnector.setAuthenticator(cnx, props.get(PROXY_USERNAME_PARAM), props.get(PROXY_PASSWORD_PARAM));
        return cnx;
    }

    private static Proxy getProxy(String proxyHost, String proxyPort) {
        if (StringUtils.isBlank((String)proxyPort) || StringUtils.isBlank((String)proxyHost)) {
            return null;
        }
        int proxyPortNum = 0;
        proxyPortNum = Integer.parseInt(proxyPort);
        if (proxyPortNum <= 0) {
            return null;
        }
        return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPortNum));
    }

    private static void setAuthenticator(HttpURLConnection cnx, String proxyUsername, String proxyPassword) throws EncoderException {
        if (StringUtils.isBlank((String)proxyUsername) || StringUtils.isBlank((String)proxyPassword)) {
            return;
        }
        String headerKey = "Proxy-Authorization";
        String headerValue = "Basic " + new Base64().encode((Object)(proxyUsername + ":" + proxyPassword));
        cnx.setRequestProperty(headerKey, headerValue);
    }

    public static void main(String[] args) {
        try {
            String baseurl = "http://api.rottentomatoes.com/api/public/v1.0/movies/771205893.json";
            LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
            params.put("apiKey", "yu5js4uv82uv294exrcczb2k");
            String url = QueryBuilder.create(baseurl, params);
            System.out.println("Querying " + url);
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(PROXY_HOST_PARAM, "www-proxy.exu.ericsson.se");
            props.put(PROXY_PORT_PARAM, "8080");
            System.out.println(APIConnector.request(url, props));
            System.out.println(APIConnector.request("http://147.128.104.22"));
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }
}

