/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.me.plugin.util;

import com.ericsson.cms.me.service.Fields;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ResultTranslator {
    public static final String STRING_DATATYPE = "string";
    public static final String INTEGER_DATATYPE = "integer";
    public static final String FLOAT_DATATYPE = "float";
    public static final String TIME_DATATYPE = "time";
    public static final String RATING_DATATYPE = "RatingValuesType";
    public static final String DATE_DATATYPE = "date";
    public static final String SOURCE_DATATYPE = "SourcesType";
    public static final String AWARD_DATATYPE = "AwardType";
    public static final String REVIEW_DATATYPE = "ReviewType";
    public static final String IMAGE_DATATYPE = "ImageType";
    public static final String DISPLAY_DATATYPE = "DisplayType";
    public static final String GENRES_DATATYPE = "GenresType";
    public static final String REVIEWS_DATATYPE = "ReviewsType";
    public static final List<String> COMPLEX_DATATYPES = Arrays.asList("RatingValuesType", "SourcesType", "AwardType", "ReviewType", "ImageType", "DisplayType", "GenresType", "ReviewsType");
    private Map<String, Object> dictionary = null;
    Map<String, Set<Fields>> ecmfMappings = null;

    public ResultTranslator() {
    }

    public ResultTranslator(String dictionaryLoc) {
        try {
            this.dictionary = this.loadDictionary(dictionaryLoc);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ResultTranslator(Map<String, Set<Fields>> ecmfMappings) {
        this.ecmfMappings = ecmfMappings;
    }

    public ResultTranslator(String dictionaryLoc, Map<String, Set<Fields>> ecmfMappings) {
        this.ecmfMappings = ecmfMappings;
        try {
            this.dictionary = this.loadDictionary(dictionaryLoc);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Map<String, Object> loadDictionary(String dictionaryLoc) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        return (Map)mapper.readValue(new File(dictionaryLoc), Map.class);
    }

    public Map<String, Object> translateMap(String parentKey, Map<String, Object> map) throws ParseException {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        if (map != null) {
            Iterator<String> iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                Collection<Fields> translatedFields;
                String key;
                String fullKey = key = iterator.next();
                if (parentKey != null && parentKey.length() > 0) {
                    fullKey = parentKey + "." + key;
                }
                if ((translatedFields = this.lookupECMFFields(fullKey)) == null) continue;
                for (Fields translatedField : translatedFields) {
                    returnMap.put(translatedField.getName(), this.translateObj(fullKey, translatedField, map.get(key)));
                }
            }
        }
        return returnMap;
    }

    public Object translateObj(String parentKey, Fields translatedField, Object obj) throws ParseException {
        if (obj != null) {
            if (obj instanceof Map) {
                Map map = (Map)((Object)obj);
                return this.translateMap(parentKey, map);
            }
            if (obj instanceof List) {
                List list = obj;
                ArrayList<Object> newList = new ArrayList<Object>();
                for (Object curObj : list) {
                    newList.add(this.translateObj(parentKey, translatedField, curObj));
                }
                obj = newList;
            }
        }
        return obj;
    }

    public Map<String, Object> transformMap(Map<String, Object> map) throws ParseException {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        if (map != null) {
            for (String key : map.keySet()) {
                Fields field = this.lookupField(key, false);
                returnMap.put(key, this.transformObj(field, map.get(key)));
            }
        }
        return returnMap;
    }

    public Object transformObj(Fields translatedField, Object obj) throws ParseException {
        if (obj != null) {
            if (this.dictionary != null) {
                obj = this.normalizeValue(obj, translatedField);
            }
            if (translatedField != null) {
                if (DATE_DATATYPE.equals(translatedField.getDatatype())) {
                    obj = this.convertObjToDate(obj);
                } else if (TIME_DATATYPE.equals(translatedField.getDatatype())) {
                    obj = this.convertObjToTime(obj);
                } else if (COMPLEX_DATATYPES.contains(translatedField.getDatatype())) {
                    obj = this.convertComplexObj(obj, translatedField);
                }
            }
        }
        return obj;
    }

    protected Object convertComplexObj(Object obj, Fields field) {
        return obj;
    }

    public abstract String convertObjToTime(Object var1);

    public abstract String convertObjToDate(Object var1) throws ParseException;

    public Fields lookupField(String name, boolean byProviderName) {
        Fields fields = null;
        if (name != null && this.ecmfMappings != null) {
            block0: for (String curKey : this.ecmfMappings.keySet()) {
                Set<Fields> curFieldSet = this.ecmfMappings.get(curKey);
                for (Fields curFields : curFieldSet) {
                    String comparisonName = null;
                    comparisonName = byProviderName ? curFields.getProviderFieldName() : curFields.getName();
                    if (comparisonName == null || !name.equals(comparisonName)) continue;
                    fields = curFields;
                    break block0;
                }
            }
        }
        return fields;
    }

    public Collection<Fields> lookupECMFFields(String name) {
        ArrayList<Fields> fields = new ArrayList<Fields>();
        if (name != null && this.ecmfMappings != null) {
            for (String curKey : this.ecmfMappings.keySet()) {
                Set<Fields> curFieldSet = this.ecmfMappings.get(curKey);
                for (Fields curFields : curFieldSet) {
                    String comparisonName = curFields.getProviderFieldName();
                    if (comparisonName == null || !name.equals(comparisonName)) continue;
                    fields.add(curFields);
                }
            }
        }
        return fields;
    }

    public Object normalizeValue(Object value, Fields field) {
        Object dictionaryValue;
        Object normalizedValue = value;
        Map fieldDictionary = (Map)this.dictionary.get(field.getName());
        if (fieldDictionary != null && (dictionaryValue = fieldDictionary.get(String.valueOf(value))) != null) {
            normalizedValue = dictionaryValue;
        }
        return normalizedValue;
    }

    public static String convertToXML(String key, Object obj) {
        StringBuilder xml = new StringBuilder();
        if (obj != null) {
            if (obj instanceof List) {
                List listObj = (List)obj;
                for (Object curObj : listObj) {
                    xml.append(ResultTranslator.convertToXML(key, curObj));
                }
            } else if (obj instanceof Map) {
                if (key != null && key.trim().length() > 0) {
                    xml.append("<" + key + ">");
                }
                Map curMap = (Map)obj;
                for (String curKey : curMap.keySet()) {
                    xml.append(ResultTranslator.convertToXML(curKey, curMap.get(curKey)));
                }
                if (key != null && key.trim().length() > 0) {
                    xml.append("</" + key + ">");
                }
            } else {
                if (key != null && key.trim().length() > 0) {
                    xml.append("<" + key + ">");
                }
                xml.append(obj);
                if (key != null && key.trim().length() > 0) {
                    xml.append("</" + key + ">");
                }
            }
        }
        return xml.toString();
    }
}

