/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.me.service.dto;

import com.ericsson.cms.me.entity.MECacheResult;
import com.ericsson.cms.me.exception.CacheResultException;
import com.ericsson.cms.me.exception.MetadataEnhancementException;
import com.ericsson.cms.me.service.dto.Request;
import com.ericsson.cms.me.service.dto.SubscriptionProfile;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CacheResult
implements Serializable {
    private static final long serialVersionUID = -2609667176446256654L;
    private Long dbId;
    private SubscriptionProfile profile;
    private String id;
    private String title;
    private Integer year;
    private String type;
    private Integer ranking;
    private String cast;
    private String posterThumbnail;
    private Map<String, Object> otherMetadata;
    private Request request;
    private String status = "AVAILABLE";
    private static final Logger logger = Logger.getLogger(CacheResult.class);

    public CacheResult() {
    }

    public CacheResult(MECacheResult meCacheResult) throws CacheResultException {
        this();
        if (meCacheResult != null) {
            this.setDbId(meCacheResult.getId());
            this.setProfile(SubscriptionProfile.toSubscriptionProfile(meCacheResult.getMeSubsProfile()));
            this.setId(meCacheResult.getRemoteId());
            this.setTitle(meCacheResult.getTitle());
            this.setYear(meCacheResult.getYear());
            this.setType(meCacheResult.getType());
            this.setPosterThumbnail(meCacheResult.getThumbnail());
            this.setCast(meCacheResult.getActors());
            this.setRanking(meCacheResult.getRanking() == null ? null : Integer.valueOf(meCacheResult.getRanking().intValueExact()));
            this.setStatus(meCacheResult.getStatus());
            try {
                ObjectMapper mapper = new ObjectMapper();
                Map newOtherMetadata = (Map)mapper.readValue(meCacheResult.getMetadata(), (TypeReference)new TypeReference<Map<String, Object>>(){});
                this.setOtherMetadata(newOtherMetadata);
            }
            catch (Exception e) {
                throw new CacheResultException(e);
            }
        }
    }

    public Long getDbId() {
        return this.dbId;
    }

    public void setDbId(long id) {
        this.dbId = id;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Integer getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getRanking() {
        return this.ranking;
    }

    public int getRankingIntValue() {
        return this.ranking == null ? 0 : this.ranking;
    }

    public void setRanking(int ranking) {
        this.ranking = ranking;
    }

    public String getCast() {
        return this.cast;
    }

    public void setCast(String cast) {
        this.cast = cast;
    }

    public String getPosterThumbnail() {
        return this.posterThumbnail;
    }

    public void setPosterThumbnail(String posterThumbnail) {
        this.posterThumbnail = posterThumbnail;
    }

    public Map<String, Object> getOtherMetadata() {
        if (this.otherMetadata == null) {
            this.otherMetadata = new HashMap<String, Object>();
        }
        return this.otherMetadata;
    }

    public void setOtherMetadata(Map<String, Object> otherMetadata) {
        this.otherMetadata = otherMetadata;
    }

    public JsonNode toJsonNode() {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.valueToTree(this.getOtherMetadata());
    }

    public String toJsonString() throws CacheResultException {
        try {
            ObjectMapper mapper = new ObjectMapper();
            StringWriter jsonStringWriter = new StringWriter();
            mapper.writeValue((Writer)jsonStringWriter, this.getOtherMetadata());
            return jsonStringWriter.toString();
        }
        catch (JsonMappingException jme) {
            throw new CacheResultException(jme);
        }
        catch (JsonGenerationException jge) {
            throw new CacheResultException(jge);
        }
        catch (IOException ie) {
            throw new CacheResultException(ie);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CacheResult[");
        sb.append("id=").append(this.getId());
        sb.append(";ranking=").append(this.getRanking());
        sb.append(";title=").append(this.getTitle());
        sb.append(";year=").append(this.getYear());
        sb.append(";type=").append(this.getType());
        sb.append(";cast=").append(this.getCast());
        sb.append(";status=").append(this.getStatus());
        sb.append(";othermetadata=").append(this.getOtherMetadata());
        sb.append("]");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cast == null ? 0 : this.cast.hashCode());
        result = 31 * result + (this.dbId == null ? 0 : this.dbId.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.otherMetadata == null ? 0 : this.otherMetadata.hashCode());
        result = 31 * result + (this.posterThumbnail == null ? 0 : this.posterThumbnail.hashCode());
        result = 31 * result + (this.ranking == null ? 0 : this.ranking.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.title == null ? 0 : this.title.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.year == null ? 0 : this.year.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CacheResult)) {
            return false;
        }
        CacheResult other = (CacheResult)obj;
        if (this.cast == null ? other.cast != null : !this.cast.equals(other.cast)) {
            return false;
        }
        if (this.dbId == null ? other.dbId != null : !this.dbId.equals(other.dbId)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.otherMetadata == null ? other.otherMetadata != null : !this.otherMetadata.equals(other.otherMetadata)) {
            return false;
        }
        if (this.posterThumbnail == null ? other.posterThumbnail != null : !this.posterThumbnail.equals(other.posterThumbnail)) {
            return false;
        }
        if (this.profile == null ? other.profile != null : !this.profile.equals(other.profile)) {
            return false;
        }
        if (this.ranking == null ? other.ranking != null : !this.ranking.equals(other.ranking)) {
            return false;
        }
        if (this.request == null ? other.request != null : !this.request.equals(other.request)) {
            return false;
        }
        if (this.status == null ? other.status != null : !this.status.equals(other.status)) {
            return false;
        }
        if (this.title == null ? other.title != null : !this.title.equals(other.title)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return !(this.year == null ? other.year != null : !this.year.equals(other.year));
    }

    public void setYear(Integer year) {
        this.year = year;
    }

    public MECacheResult toMeCacheResult() {
        MECacheResult meCacheResult = new MECacheResult();
        meCacheResult.setId(this.getDbId());
        meCacheResult.setRemoteId(this.getId());
        meCacheResult.setTitle(this.getTitle());
        meCacheResult.setYear(this.getYear());
        meCacheResult.setType(this.getType());
        meCacheResult.setThumbnail(this.getPosterThumbnail());
        meCacheResult.setActors(this.getCast());
        meCacheResult.setRanking(BigDecimal.valueOf(this.getRanking()));
        meCacheResult.setStatus(this.getStatus());
        try {
            meCacheResult.setMetadata(this.toJsonString());
        }
        catch (MetadataEnhancementException mee) {
            throw mee;
        }
        catch (CacheResultException e) {
            MetadataEnhancementException mee = this.fail("toMeCacheResult() failed: ", e);
            logger.error((Object)mee, (Throwable)mee);
            throw mee;
        }
        return meCacheResult;
    }

    public static CacheResult toCacheResult(MECacheResult meCacheResult) throws CacheResultException {
        CacheResult cacheResult = null;
        if (meCacheResult != null) {
            cacheResult = new CacheResult(meCacheResult);
        }
        return cacheResult;
    }

    public SubscriptionProfile getProfile() {
        return this.profile;
    }

    public void setProfile(SubscriptionProfile profile) {
        this.profile = profile;
    }

    public Request getRequest() {
        return this.request;
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    private MetadataEnhancementException fail(String message, Exception e) {
        if (e instanceof MetadataEnhancementException) {
            return (MetadataEnhancementException)e;
        }
        return new MetadataEnhancementException(message + " " + e, e);
    }
}

