/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.me.service.dto;

import com.ericsson.cms.me.exception.MetadataEnhancementException;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class Duration
implements Serializable {
    private static final long serialVersionUID = -8393096762109061892L;
    private static final Logger logger = Logger.getLogger(Duration.class);
    private static final String DEFAULT_FORMAT = "HH:mm:ss.SSS";
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;
    private static final SimpleDateFormat HHmmssSSS = Duration.gmt("HH:mm:ss.SSS");
    private static final SimpleDateFormat HHmmss = Duration.gmt("HH:mm:ss");
    private static final SimpleDateFormat mmss = Duration.gmt("mm:ss");
    private static final SimpleDateFormat ss = Duration.gmt("s");
    private long time = 0L;
    private SimpleDateFormat format = HHmmssSSS;

    private static SimpleDateFormat gmt(String format) {
        SimpleDateFormat result = new SimpleDateFormat(format);
        result.setTimeZone(TimeZone.getTimeZone("UTC"));
        return result;
    }

    public Duration() {
    }

    public Duration(long millis) {
        this.setTime(millis);
    }

    public Duration(String format) {
        this.setFormat(format);
    }

    public Duration(String format, long millis) {
        this.setFormat(format);
        this.setTime(millis);
    }

    public void setTime(long millis) {
        this.time = millis;
    }

    public void setFormat(String format) {
        this.format = Duration.gmt(format);
    }

    public void setSeconds(long seconds) {
        this.setTime(seconds * 1000L);
    }

    public void setMinutes(long minutes) {
        this.setTime(minutes * 60L * 1000L);
    }

    public void setHours(long hours) {
        this.setTime(hours * 60L * 60L * 1000L);
    }

    public void setDays(long days) {
        this.setTime(days * 24L * 60L * 60L * 1000L);
    }

    public void setSeconds(double seconds) {
        this.setTime((long)seconds * 1000L);
    }

    public void setMinutes(double minutes) {
        this.setTime((long)minutes * 60L * 1000L);
    }

    public void setHours(double hours) {
        this.setTime((long)hours * 60L * 60L * 1000L);
    }

    public void setDays(double days) {
        this.setTime((long)days * 24L * 60L * 60L * 1000L);
    }

    public void setDuration(Date date) {
        this.setTime(date.getTime());
    }

    public static Duration getDuration(String value) throws ParseException {
        Duration result = new Duration();
        result.setTime(value);
        return result;
    }

    public static Duration getDuration(String simpleDateFormat, String value) throws ParseException {
        Duration result = new Duration(simpleDateFormat);
        result.setTime(value);
        return result;
    }

    public String getFormat() {
        return this.format.toPattern();
    }

    public Date getDate() {
        return new Date(this.getTime());
    }

    public long getTime() {
        return this.time;
    }

    public double getSeconds() {
        return (double)this.getTime() / 1000.0;
    }

    public double getMinutes() {
        return (double)this.getTime() / 1000.0 / 60.0;
    }

    public double getHours() {
        return (double)this.getTime() / 1000.0 / 60.0 / 60.0;
    }

    public double getDays() {
        return (double)this.getTime() / 1000.0 / 60.0 / 60.0 / 24.0;
    }

    public void setTime(String duration) throws ParseException {
        String s = duration;
        long days = 0L;
        int plus = s.indexOf("+");
        if (plus > 0) {
            days = Long.valueOf(s.substring(0, s.indexOf("+"))) * 86400000L;
            s = s.substring(plus + 1);
        }
        try {
            this.setTime(this.format.parse(s).getTime());
        }
        catch (ParseException e) {
            try {
                this.setTime(HHmmssSSS.parse(s).getTime());
            }
            catch (ParseException e1) {
                try {
                    this.setTime(HHmmss.parse(s).getTime());
                }
                catch (ParseException e2) {
                    try {
                        this.setTime(mmss.parse(s).getTime());
                    }
                    catch (ParseException e3) {
                        this.setTime(ss.parse(s).getTime());
                    }
                }
            }
        }
        this.setTime(this.getTime() + days);
    }

    public String toHHmmss() {
        if (this.getTime() > 86400000L) {
            MetadataEnhancementException mee = this.fail("Duration exceeds requested format: HH:mm:ss");
            logger.error((Object)mee, (Throwable)mee);
            throw mee;
        }
        return HHmmss.format(this.getDate());
    }

    public String toMmss() {
        if (this.getTime() > 3600000L) {
            MetadataEnhancementException mee = this.fail("Duration exceeds requested format: mm:ss");
            logger.error((Object)mee, (Throwable)mee);
            throw mee;
        }
        return mmss.format(this.getDate());
    }

    public String toString() {
        return new Double(this.getDays()).longValue() + "+" + this.format.format(this.getDate());
    }

    public String toString(String format) {
        SimpleDateFormat sdf = Duration.gmt(format);
        return sdf.format(this.getDate());
    }

    public static void main(String[] args) {
        int s = 0;
        while ((long)s < 86401L) {
            long i = s * 1000;
            Duration d = new Duration(i);
            try {
                System.out.println("i=" + i + " time=" + d.getTime() + " string=" + d.toString() + " HHmmss=" + d.toString("HH:mm:ss") + " mmss=" + d.toString("mm:ss") + " hours=" + d.getHours() + " min=" + d.getMinutes() + " seconds=" + d.getSeconds() + " parse=" + Duration.getDuration(d.toString()).getTime());
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            s += 10;
        }
    }

    private MetadataEnhancementException fail(String message) {
        return new MetadataEnhancementException(message);
    }

    private MetadataEnhancementException fail(Exception e) {
        return this.fail("Unexpected exception: " + e, e);
    }

    private MetadataEnhancementException fail(String message, Exception e) {
        if (e instanceof MetadataEnhancementException) {
            return (MetadataEnhancementException)e;
        }
        return new MetadataEnhancementException(message + " " + e, e);
    }
}

