/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.me.service.dto;

import com.ericsson.cms.me.entity.MEFieldDefinition;
import com.ericsson.cms.me.service.Fields;
import com.ericsson.cms.me.service.dto.SubscriptionProfile;
import com.ericsson.rules.fieldprovider.metadataenhancement.IMetadataEnhancementField;
import com.tandbergtv.marvin.udt.DataTypes;
import java.io.Serializable;

public class FieldDefinition
implements IMetadataEnhancementField,
Serializable {
    private static final long serialVersionUID = -9200271195445348857L;
    public static final String TIME = "time";
    public static final String HOURS = "hours";
    public static final String MINUTES = "minutes";
    public static final String SECONDS = "seconds";
    private Long id;
    private SubscriptionProfile profile;
    private String mapping;
    private String name;
    private String datatype;
    private String path;

    public FieldDefinition() {
    }

    public FieldDefinition(MEFieldDefinition meFieldDef) {
        this();
        if (meFieldDef != null) {
            this.setId(meFieldDef.getId());
            this.setMapping(meFieldDef.getMapping());
            this.setName(meFieldDef.getName());
            this.setDatatype(meFieldDef.getDatatype());
            this.setPath(meFieldDef.getPath());
        }
    }

    public FieldDefinition(Fields pluginField) {
        this();
        if (pluginField != null) {
            this.setMapping(pluginField.getEndPointMapping());
            this.setName(pluginField.getName());
            this.setDatatype(pluginField.getDatatype());
            this.setPath(pluginField.getPath());
        }
    }

    public String getDisplayName() {
        return this.getName();
    }

    public String getFieldIdentifier() {
        return this.getName();
    }

    public DataTypes getDataType() {
        String dataType = this.getDatatype();
        if (HOURS.equalsIgnoreCase(dataType)) {
            return DataTypes.fromValue((String)TIME);
        }
        if (MINUTES.equalsIgnoreCase(dataType)) {
            return DataTypes.fromValue((String)TIME);
        }
        if (SECONDS.equalsIgnoreCase(dataType)) {
            return DataTypes.fromValue((String)TIME);
        }
        for (DataTypes c : DataTypes.values()) {
            if (!c.value().equalsIgnoreCase(dataType)) continue;
            return c;
        }
        return DataTypes.COMPLEX;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public SubscriptionProfile getProfile() {
        return this.profile;
    }

    public void setProfile(SubscriptionProfile profile) {
        this.profile = profile;
    }

    public String getMapping() {
        return this.mapping;
    }

    public void setMapping(String mapping) {
        this.mapping = mapping;
    }

    public String getDatatype() {
        return this.datatype;
    }

    public void setDatatype(String datatype) {
        this.datatype = datatype;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return "FieldDefinition [id=" + this.id + ", profile=" + (this.profile == null ? null : this.profile.getName()) + ", mapping=" + this.mapping + ", name=" + this.name + ", datatype=" + this.datatype + ", path=" + this.path + "]";
    }

    public MEFieldDefinition toMEFieldDefinition() {
        MEFieldDefinition result = new MEFieldDefinition();
        result.setId(this.getId());
        result.setMapping(this.getMapping());
        result.setName(this.getName());
        result.setDatatype(this.getDatatype());
        result.setPath(this.getPath());
        return result;
    }

    public static FieldDefinition toFieldDefinition(MEFieldDefinition meFieldDef) {
        FieldDefinition result = null;
        if (meFieldDef != null) {
            result = new FieldDefinition(meFieldDef);
        }
        return result;
    }

    public static FieldDefinition toFieldDefinition(Fields pluginField) {
        FieldDefinition result = null;
        if (pluginField != null) {
            result = new FieldDefinition(pluginField);
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.datatype == null ? 0 : this.datatype.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.mapping == null ? 0 : this.mapping.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldDefinition)) {
            return false;
        }
        FieldDefinition other = (FieldDefinition)obj;
        if (this.datatype == null ? other.datatype != null : !this.datatype.equals(other.datatype)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.mapping == null ? other.mapping != null : !this.mapping.equals(other.mapping)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        return !(this.profile == null ? other.profile != null : !this.profile.getId().equals(other.getId()));
    }
}

