/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.me.service.dto;

import com.ericsson.cms.me.entity.MECacheResult;
import com.ericsson.cms.me.entity.MERequest;
import com.ericsson.cms.me.exception.CacheResultException;
import com.ericsson.cms.me.exception.MetadataEnhancementException;
import com.ericsson.cms.me.service.dto.CacheResult;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.DatatypeConverter;
import org.apache.log4j.Logger;

public class Request
implements Serializable {
    private static final long serialVersionUID = -4042677089709376715L;
    private static final Logger logger = Logger.getLogger(Request.class);
    private Long id;
    private String requestKey;
    private Title title;
    private Set<CacheResult> cacheResults;

    public Request() {
    }

    public Request(MERequest meRequest) {
        this();
        if (meRequest != null) {
            this.id = meRequest.getId();
            this.requestKey = meRequest.getRequestKey();
            if (meRequest.getTitle() != null) {
                try {
                    this.setTitle(this.toTitle(meRequest.getTitle()));
                }
                catch (MetadataEnhancementException mee) {
                    throw mee;
                }
                catch (Exception e) {
                    MetadataEnhancementException mee = this.fail("Title deserialization failed: ", e);
                    logger.error((Object)mee, (Throwable)mee);
                    throw mee;
                }
            }
            if (meRequest.getMeCacheResults() != null) {
                this.cacheResults = new HashSet<CacheResult>();
                if (meRequest.getMeCacheResults() != null) {
                    for (MECacheResult meCacheResult : meRequest.getMeCacheResults()) {
                        CacheResult cacheResult = CacheResult.toCacheResult(meCacheResult);
                        cacheResult.setRequest(this);
                        this.cacheResults.add(CacheResult.toCacheResult(meCacheResult));
                    }
                }
            }
        }
    }

    public static Request toRequest(MERequest meRequest) throws CacheResultException {
        Request request = null;
        if (meRequest != null) {
            request = new Request(meRequest);
        }
        return request;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getRequestKey() {
        return this.requestKey;
    }

    public void setRequestKey(String requestKey) {
        this.requestKey = requestKey;
    }

    public Title getTitle() {
        return this.title;
    }

    public void setTitle(Title title) {
        this.title = title;
    }

    public String toString(Title title) throws IOException {
        String result = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(title);
        oos.flush();
        oos.close();
        result = DatatypeConverter.printBase64Binary((byte[])bos.toByteArray());
        return result;
    }

    public String toString() {
        return "Request [id=" + this.id + ", requestKey=" + this.requestKey + ", title=" + this.title + ", cacheResults=" + this.cacheResults + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cacheResults == null ? 0 : this.cacheResults.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.requestKey == null ? 0 : this.requestKey.hashCode());
        result = 31 * result + (this.title == null ? 0 : this.title.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Request)) {
            return false;
        }
        Request other = (Request)obj;
        if (this.cacheResults == null ? other.cacheResults != null : !this.cacheResults.equals(other.cacheResults)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.requestKey == null ? other.requestKey != null : !this.requestKey.equals(other.requestKey)) {
            return false;
        }
        return !(this.title == null ? other.title != null : !this.title.equals((Object)other.title));
    }

    public Title toTitle(String title) throws IOException, ClassNotFoundException {
        Title result = null;
        ByteArrayInputStream bis = new ByteArrayInputStream(DatatypeConverter.parseBase64Binary((String)title));
        ObjectInputStream ois = new ObjectInputStream(bis);
        result = (Title)ois.readObject();
        ois.close();
        return result;
    }

    public Set<CacheResult> getCacheResults() {
        return this.cacheResults;
    }

    public void setCacheResults(Set<CacheResult> cacheResults) {
        this.cacheResults = cacheResults;
    }

    public MERequest toMeRequest() throws IOException {
        MERequest meRequest = new MERequest();
        meRequest.setId(this.getId());
        meRequest.setRequestKey(this.getRequestKey());
        meRequest.setTitle(this.toString(this.getTitle()));
        if (this.cacheResults != null) {
            HashSet<MECacheResult> meCacheResults = new HashSet<MECacheResult>();
            for (CacheResult cacheResult : this.cacheResults) {
                MECacheResult meCacheResult = cacheResult.toMeCacheResult();
                meCacheResult.setMeSubsProfile(cacheResult.getProfile() == null ? null : cacheResult.getProfile().toMESubsProfile());
                meCacheResults.add(meCacheResult);
            }
            meRequest.setMeCacheResults(meCacheResults);
        }
        return meRequest;
    }

    private MetadataEnhancementException fail(String message, Exception e) {
        if (e instanceof MetadataEnhancementException) {
            return (MetadataEnhancementException)e;
        }
        return new MetadataEnhancementException(message + " " + e, e);
    }
}

