/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.me.service.dto;

import com.ericsson.cms.me.entity.MEIdentifierCriteria;
import com.ericsson.cms.me.service.dto.FieldDefinition;
import java.io.Serializable;

public class SearchFieldCriteria
implements Serializable {
    private static final long serialVersionUID = 8961098920999613431L;
    private Long id;
    private FieldDefinition field;
    private String assetType;
    private String value;
    private int weight;

    public SearchFieldCriteria() {
    }

    public SearchFieldCriteria(MEIdentifierCriteria meIdentifierCriteria) {
        this();
        if (meIdentifierCriteria != null) {
            this.setId(meIdentifierCriteria.getId());
            this.setField(new FieldDefinition(meIdentifierCriteria.getMeFieldDefinition()));
            this.setAssetType(meIdentifierCriteria.getAssetType());
            this.setValue(meIdentifierCriteria.getValueFieldPath());
        }
    }

    public SearchFieldCriteria(Long id, FieldDefinition keyField, String value, int weight) {
        this();
        this.setId(id);
        this.setField(keyField);
        this.setValue(value);
        this.setWeight(weight);
    }

    public SearchFieldCriteria(FieldDefinition keyField, String value) {
        this();
        this.setField(keyField);
        this.setValue(value);
    }

    public SearchFieldCriteria(String name, String value, int weight) {
        this();
        FieldDefinition fieldDef = new FieldDefinition();
        fieldDef.setName(name);
        this.setField(fieldDef);
        this.setValue(value);
        this.setWeight(weight);
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public String toString() {
        return "SearchFieldCriteria [id=" + this.id + ", field=" + this.field + ", assetType=" + this.assetType + ", value=" + this.value + ", weight=" + this.weight + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.field == null ? 0 : this.field.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.assetType == null ? 0 : this.assetType.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + this.weight;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchFieldCriteria)) {
            return false;
        }
        SearchFieldCriteria other = (SearchFieldCriteria)obj;
        if (this.field == null ? other.field != null : !this.field.equals(other.field)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.assetType == null ? other.assetType != null : !this.assetType.equals(other.assetType)) {
            return false;
        }
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return this.weight == other.weight;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public FieldDefinition getField() {
        return this.field;
    }

    public void setField(FieldDefinition field) {
        this.field = field;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public MEIdentifierCriteria toMEIdentifierCriteria() {
        MEIdentifierCriteria result = new MEIdentifierCriteria();
        result.setId(this.getId());
        result.setMeFieldDefinition(this.getField() == null ? null : this.getField().toMEFieldDefinition());
        result.setAssetType(this.getAssetType());
        result.setValueFieldPath(this.getValue());
        return result;
    }

    public static SearchFieldCriteria toSearchFieldCriteria(MEIdentifierCriteria meIdentifierCriteria) {
        SearchFieldCriteria result = null;
        if (meIdentifierCriteria != null) {
            result = new SearchFieldCriteria(meIdentifierCriteria);
        }
        return result;
    }

    public String getAssetType() {
        return this.assetType;
    }

    public void setAssetType(String assetType) {
        this.assetType = assetType;
    }
}

