/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.me.service.dto;

import com.ericsson.cms.me.entity.MEEnhancedField;
import com.ericsson.cms.me.entity.MEIdentifierCriteria;
import com.ericsson.cms.me.entity.MESubsProfile;
import com.ericsson.cms.me.entity.MESubsProfileParameter;
import com.ericsson.cms.me.service.dto.EnhancedField;
import com.ericsson.cms.me.service.dto.FieldDefinition;
import com.ericsson.cms.me.service.dto.SearchFieldCriteria;
import com.ericsson.cms.me.service.dto.SubscriptionProfileParam;
import com.ericsson.rules.fieldprovider.metadataenhancement.IMetadataEnhancementField;
import com.ericsson.rules.fieldprovider.metadataenhancement.ISubscriptionProfile;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class SubscriptionProfile
implements ISubscriptionProfile,
Serializable {
    private static final long serialVersionUID = -9185478773161579807L;
    private Long id;
    private String name;
    private String pluginName;
    private Set<EnhancedField> enhancedFields;
    private Set<SearchFieldCriteria> searchCriteria;
    private Set<SubscriptionProfileParam> params;

    public SubscriptionProfile() {
    }

    public SubscriptionProfile(MESubsProfile meSubsProfile) {
        this();
        if (meSubsProfile != null) {
            FieldDefinition fd;
            this.setId(meSubsProfile.getId());
            this.setName(meSubsProfile.getName());
            this.setPluginName(meSubsProfile.getPluginName());
            HashSet<SearchFieldCriteria> newSearchCriteria = new HashSet<SearchFieldCriteria>();
            HashSet<EnhancedField> newEnhancedFields = new HashSet<EnhancedField>();
            HashSet<SubscriptionProfileParam> newParams = new HashSet<SubscriptionProfileParam>();
            if (meSubsProfile.getMeIdentifierCriterias() != null) {
                for (MEIdentifierCriteria meIdentifierCriteria : meSubsProfile.getMeIdentifierCriterias()) {
                    fd = new FieldDefinition(meIdentifierCriteria.getMeFieldDefinition());
                    SearchFieldCriteria sfc = new SearchFieldCriteria(meIdentifierCriteria);
                    fd.setProfile(this);
                    sfc.setField(fd);
                    newSearchCriteria.add(sfc);
                }
                this.setSearchCriteria(newSearchCriteria);
            }
            if (meSubsProfile.getMeEnhancedFields() != null) {
                for (MEEnhancedField meEnhancedField : meSubsProfile.getMeEnhancedFields()) {
                    fd = new FieldDefinition(meEnhancedField.getMeFieldDefinition());
                    EnhancedField ef = new EnhancedField(meEnhancedField);
                    fd.setProfile(this);
                    ef.setFieldDefinition(fd);
                    newEnhancedFields.add(ef);
                }
                this.setEnhancedFields(newEnhancedFields);
            }
            if (meSubsProfile.getMeSubsProfileParameters() != null) {
                for (MESubsProfileParameter meSubsProfileParameter : meSubsProfile.getMeSubsProfileParameters()) {
                    newParams.add(new SubscriptionProfileParam(meSubsProfileParameter));
                }
                this.setParams(newParams);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    public Set<EnhancedField> getEnhancedFields() {
        return this.enhancedFields;
    }

    public void setEnhancedFields(Set<EnhancedField> enhancedFields) {
        this.enhancedFields = enhancedFields;
    }

    public Set<SearchFieldCriteria> getSearchCriteria() {
        return this.searchCriteria;
    }

    public void setSearchCriteria(Set<SearchFieldCriteria> searchCriteria) {
        this.searchCriteria = searchCriteria;
    }

    public Set<SubscriptionProfileParam> getParams() {
        return this.params;
    }

    public void setParams(Set<SubscriptionProfileParam> params) {
        this.params = params;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Set<IMetadataEnhancementField> getFields() {
        HashSet<IMetadataEnhancementField> result = new HashSet<IMetadataEnhancementField>();
        for (EnhancedField enhancedField : this.getEnhancedFields()) {
            result.add(enhancedField.getFieldDefinition());
        }
        return result;
    }

    public MESubsProfile toMESubsProfile() {
        MESubsProfile result = new MESubsProfile();
        result.setId(this.getId());
        result.setName(this.getName());
        result.setPluginName(this.getPluginName());
        if (this.getSearchCriteria() != null) {
            HashSet<MEIdentifierCriteria> meIdentifierCriterias = new HashSet<MEIdentifierCriteria>();
            for (SearchFieldCriteria criteria : this.getSearchCriteria()) {
                MEIdentifierCriteria meIdentifierCriteria = criteria.toMEIdentifierCriteria();
                meIdentifierCriteria.setMeSubsProfile(result);
                meIdentifierCriteria.getMeFieldDefinition().setMeSubsProfile(result);
                meIdentifierCriterias.add(meIdentifierCriteria);
            }
            result.setMeIdentifierCriterias(meIdentifierCriterias);
        }
        if (this.getEnhancedFields() != null) {
            HashSet<MEEnhancedField> meEnhancedFields = new HashSet<MEEnhancedField>();
            for (EnhancedField enhancedField : this.getEnhancedFields()) {
                MEEnhancedField meEnhancedField = enhancedField.toMEEnhancedField();
                meEnhancedField.setMeSubsProfile(result);
                meEnhancedField.getMeFieldDefinition().setMeSubsProfile(result);
                meEnhancedFields.add(meEnhancedField);
            }
            result.setMeEnhancedFields(meEnhancedFields);
        }
        if (this.getParams() != null) {
            HashSet<MESubsProfileParameter> meSubsProfileParameters = new HashSet<MESubsProfileParameter>();
            for (SubscriptionProfileParam parameter : this.getParams()) {
                MESubsProfileParameter meSubsProfileParameter = new MESubsProfileParameter();
                meSubsProfileParameter.setMeSubsProfile(result);
                meSubsProfileParameter.setId(parameter.getId());
                meSubsProfileParameter.setName(parameter.getName());
                meSubsProfileParameter.setValue(parameter.getValue());
                meSubsProfileParameters.add(meSubsProfileParameter);
            }
            result.setMeSubsProfileParameters(meSubsProfileParameters);
        }
        return result;
    }

    public static SubscriptionProfile toSubscriptionProfile(MESubsProfile meSubsProfile) {
        SubscriptionProfile result = null;
        if (meSubsProfile != null) {
            result = new SubscriptionProfile(meSubsProfile);
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.enhancedFields == null ? 0 : this.enhancedFields.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.params == null ? 0 : this.params.hashCode());
        result = 31 * result + (this.pluginName == null ? 0 : this.pluginName.hashCode());
        result = 31 * result + (this.searchCriteria == null ? 0 : this.searchCriteria.hashCode());
        return result;
    }

    public String toString() {
        return "SubscriptionProfile [id=" + this.id + ", name=" + this.name + ", pluginName=" + this.pluginName + ", enhancedFields=" + this.enhancedFields + ", searchCriteria=" + this.searchCriteria + ", params=" + this.params + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubscriptionProfile)) {
            return false;
        }
        SubscriptionProfile other = (SubscriptionProfile)obj;
        if (this.enhancedFields == null ? other.enhancedFields != null : !this.enhancedFields.equals(other.enhancedFields)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.params == null ? other.params != null : !this.params.equals(other.params)) {
            return false;
        }
        if (this.pluginName == null ? other.pluginName != null : !this.pluginName.equals(other.pluginName)) {
            return false;
        }
        return !(this.searchCriteria == null ? other.searchCriteria != null : !this.searchCriteria.equals(other.searchCriteria));
    }
}

