/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.me.service.util;

import com.ericsson.cms.me.exception.MetadataEnhancementException;
import com.ericsson.cms.me.service.Fields;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ECMFMappingReader {
    private static final Logger logger = Logger.getLogger(ECMFMappingReader.class);
    private static final String ELEMENT_MAPPING = "Mapping";
    private static final String ATTRIBUTE_MAPPING_NAME = "name";
    private static final String ELEMENT_FIELD = "Field";
    private static final String ATTRIBUTE_FIELD_NAME = "name";
    private static final String ATTRIBUTE_FIELD_ASSETTYPE = "assettype";
    private static final String ATTRIBUTE_FIELD_DATATYPE = "datatype";
    private static final String ATTRIBUTE_FIELD_PATH = "path";
    private static final String ATTRIBUTE_FIELD_PROVIDERFIELDNAME = "providerfieldname";
    private static final String ATTRIBUTE_FIELD_DISPLAY = "display";
    private static final String ATTRIBUTE_FIELD_ISREQUIRED = "isrequired";
    private static final String ATTRIBUTE_FIELD_ISSEARCHABLE = "isSearchable";

    public static HashMap<String, Set<Fields>> getMappings(String fileName) {
        HashMap<String, Set<Fields>> fieldMappings = new HashMap<String, Set<Fields>>();
        try {
            File xmlInputFile = new File(fileName);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(xmlInputFile);
            NodeList nodeList = document.getElementsByTagName("*");
            document.getDocumentElement().normalize();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !node.getNodeName().equalsIgnoreCase(ELEMENT_MAPPING)) continue;
                Element element = (Element)node;
                String endPoint = element.getAttribute("name");
                NodeList childNodes = element.getChildNodes();
                fieldMappings.put(endPoint, ECMFMappingReader.extractFields(childNodes, endPoint));
            }
        }
        catch (MetadataEnhancementException mee) {
            throw mee;
        }
        catch (Exception e) {
            MetadataEnhancementException mee = ECMFMappingReader.fail("Error while reading the ECMFMapping file: " + fileName + " - ", e);
            logger.error((Object)mee, (Throwable)mee);
            throw mee;
        }
        return fieldMappings;
    }

    private static Set<Fields> extractFields(NodeList childNodes, String endPoint) {
        HashSet<Fields> fields = new HashSet<Fields>();
        for (int c = 0; c < childNodes.getLength(); ++c) {
            Node child = childNodes.item(c);
            if (child.getNodeType() == 3 || !child.getNodeName().equalsIgnoreCase(ELEMENT_FIELD)) continue;
            Element fieldElement = (Element)child;
            Fields field = new Fields();
            field.setName(fieldElement.getAttribute("name"));
            field.setAssetType(fieldElement.getAttribute(ATTRIBUTE_FIELD_ASSETTYPE));
            field.setDatatype(fieldElement.getAttribute(ATTRIBUTE_FIELD_DATATYPE));
            field.setPath(fieldElement.getAttribute(ATTRIBUTE_FIELD_PATH));
            field.setProviderFieldName(fieldElement.getAttribute(ATTRIBUTE_FIELD_PROVIDERFIELDNAME));
            field.setEndPointMapping(endPoint);
            if (fieldElement.getAttribute(ATTRIBUTE_FIELD_DISPLAY) != null && !fieldElement.getAttribute(ATTRIBUTE_FIELD_DISPLAY).isEmpty()) {
                if (fieldElement.getAttribute(ATTRIBUTE_FIELD_DISPLAY).equalsIgnoreCase("true")) {
                    field.setDisplay(Boolean.TRUE);
                } else {
                    field.setDisplay(Boolean.FALSE);
                }
            } else {
                field.setDisplay(Boolean.FALSE);
            }
            if (fieldElement.getAttribute(ATTRIBUTE_FIELD_ISREQUIRED) != null && !fieldElement.getAttribute(ATTRIBUTE_FIELD_ISREQUIRED).isEmpty()) {
                if (fieldElement.getAttribute(ATTRIBUTE_FIELD_ISREQUIRED).equalsIgnoreCase("true")) {
                    field.setRequired(Boolean.TRUE);
                } else {
                    field.setRequired(Boolean.FALSE);
                }
            } else {
                field.setRequired(Boolean.FALSE);
            }
            if (fieldElement.getAttribute(ATTRIBUTE_FIELD_ISSEARCHABLE) != null && !fieldElement.getAttribute(ATTRIBUTE_FIELD_ISSEARCHABLE).isEmpty()) {
                if (fieldElement.getAttribute(ATTRIBUTE_FIELD_ISSEARCHABLE).equalsIgnoreCase("true")) {
                    field.setSearchable(Boolean.TRUE);
                } else {
                    field.setSearchable(Boolean.FALSE);
                }
            } else {
                field.setSearchable(Boolean.FALSE);
            }
            fields.add(field);
        }
        return fields;
    }

    private static MetadataEnhancementException fail(String message, Exception e) {
        if (e instanceof MetadataEnhancementException) {
            return (MetadataEnhancementException)e;
        }
        return new MetadataEnhancementException(message + " " + e, e);
    }
}

