/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.me.service.util;

import com.ericsson.cms.me.service.dto.CacheResult;
import com.ericsson.cms.me.service.dto.SearchFieldCriteria;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class MESearchUtils {
    public static final String DEFAULT_RUNTIME_NAME = "Run_Time";
    public static final String DEFAULT_YEAR_NAME = "Year";
    public static final String DEFAULT_RATING_NAME = "Rating";
    public static final String DEFAULT_TYPE_NAME = "type";
    public static final String DEFAULT_TITLE_NAME = "Title";
    public static final String DEFAULT_RELEASEDATE_NAME = "Release_Dates";
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-DD";
    List<String> bogusEnds = new ArrayList<String>();
    List<String> bogusStarts = new ArrayList<String>();
    Map<String, String> translate = new HashMap<String, String>();
    Map<String, Integer> ratingsAll = new HashMap<String, Integer>();
    List<String> noises = new ArrayList<String>();
    List<String> ratings = new ArrayList<String>();
    private String runtimeName = "Run_Time";
    private String yearName = "Year";
    private String ratingName = "Rating";
    private String typeName = "type";
    private String titleName = "Title";
    private String releaseDateName = "Release_Dates";
    private String dateFormat = "yyyy-MM-DD";

    public MESearchUtils() {
    }

    public MESearchUtils(List<String> bogusEnds, List<String> bogusStarts, Map<String, String> translate, Map<String, Integer> ratingsAll, List<String> noises, List<String> ratings) {
        this.bogusEnds = bogusEnds;
        this.bogusStarts = bogusStarts;
        this.translate = translate;
        this.ratingsAll = ratingsAll;
        this.noises = noises;
        this.ratings = ratings;
    }

    public MESearchUtils(String configLoc) {
        File configFile = new File(configLoc);
        ObjectMapper mapper = new ObjectMapper();
        try {
            Map noiseMap = (Map)mapper.readValue(configFile, Map.class);
            this.bogusEnds = (List)noiseMap.get("bogusEnds");
            this.bogusStarts = (List)noiseMap.get("bogusStarts");
            this.translate = (Map)noiseMap.get("translate");
            this.ratingsAll = (Map)noiseMap.get("ratingsAll");
            this.noises = (List)noiseMap.get("noises");
            this.ratings = (List)noiseMap.get("ratings");
        }
        catch (JsonMappingException jme) {
            jme.printStackTrace(System.err);
        }
        catch (JsonParseException jpe) {
            jpe.printStackTrace(System.err);
        }
        catch (IOException io) {
            io.printStackTrace(System.err);
        }
    }

    private double compareTitles(String in, String out) {
        if (in == null || out == null) {
            return 1.0;
        }
        if (in.equals(out) && in.length() == out.length()) {
            return 1.0;
        }
        if (in.equalsIgnoreCase(out) && in.length() == out.length()) {
            return 0.99;
        }
        String normalizedIn = this.normalizedTitle(in).trim();
        String normalizedOut = this.normalizedTitle(out).trim();
        double distance = StringUtils.getLevenshteinDistance((String)normalizedIn, (String)normalizedOut);
        double maxLen = Math.max(normalizedIn.length(), normalizedOut.length());
        if (distance == 0.0) {
            return 0.98;
        }
        if (normalizedIn.length() > normalizedOut.length()) {
            if (normalizedIn.indexOf(normalizedOut) > -1) {
                return 0.9;
            }
        } else if (normalizedOut.indexOf(normalizedIn) > -1) {
            return 0.85;
        }
        return (maxLen - distance / 2.0) / maxLen;
    }

    private double compareRating(String rating, CacheResult movie) throws Exception {
        String mpaaRating = this.getStringValue(this.ratingName, movie.getOtherMetadata());
        if (rating == null || mpaaRating == null) {
            return 1.0;
        }
        String normRating = this.normalizeRating(rating);
        String normMovieRating = this.normalizeRating(mpaaRating);
        return this.getFactor(normRating, normMovieRating);
    }

    public String normalizeRating(String rating) {
        rating = rating.toLowerCase();
        return rating.replace("-", "").trim();
    }

    private float getFactor(String searchRating, String movieRating) {
        float distance = 0.0f;
        float searchMovieRatingPosition = this.ratingsAll.get(searchRating).intValue();
        float movieRatingPosition = this.ratingsAll.get(movieRating).intValue();
        distance = Math.abs(searchMovieRatingPosition - movieRatingPosition) / movieRatingPosition;
        return 1.0f - distance;
    }

    private double compareYear(Integer year, CacheResult movie) throws Exception {
        if (year == null || movie.getYear() == null) {
            return 1.0;
        }
        if (this.getReleaseYears(movie).contains(year)) {
            return 1.0;
        }
        if (this.getReleaseYearsPlusMinusOne(movie).contains(year)) {
            return 0.95;
        }
        return 0.5;
    }

    private double compareRuntime(Integer runtime, CacheResult movie) throws Exception {
        Double movieRuntime = null;
        String runtimeStr = this.getStringValue(this.runtimeName, movie.getOtherMetadata());
        if (runtimeStr != null && runtimeStr.trim().length() > 0 && !"null".equals(runtimeStr)) {
            movieRuntime = Double.parseDouble(runtimeStr);
        }
        if (runtime == null || movieRuntime == null) {
            return 1.0;
        }
        return 1.0 - Math.abs(movieRuntime - (double)runtime.intValue()) / movieRuntime;
    }

    private Integer seconds(String hhmmss) {
        Integer result = null;
        if (hhmmss != null) {
            String[] s = hhmmss.split(":");
            switch (s.length) {
                case 1: {
                    result = Integer.parseInt(s[0]);
                    break;
                }
                case 2: {
                    result = Integer.parseInt(s[0]) * 60 + Integer.parseInt(s[1]);
                    break;
                }
                case 3: {
                    result = Integer.parseInt(s[0]) * 3600 + Integer.parseInt(s[1]) * 60 + Integer.parseInt(s[2]);
                }
            }
        }
        return result;
    }

    private double compareRuntime(String hhmmss, CacheResult movie) throws Exception {
        Double rank = 1.0;
        try {
            Integer tgtSeconds = this.seconds(hhmmss);
            Integer movieSeconds = this.seconds(this.getStringValue(this.runtimeName, movie.getOtherMetadata()));
            rank = 1.0 - (double)(Math.abs(movieSeconds - tgtSeconds) / movieSeconds);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rank;
    }

    public Integer compare(Set<SearchFieldCriteria> fieldCriteria, CacheResult movie) throws Exception {
        HashMap<String, SearchFieldCriteria> fieldCriteriaMap = new HashMap<String, SearchFieldCriteria>();
        for (SearchFieldCriteria sfc : fieldCriteria) {
            if (sfc == null) continue;
            fieldCriteriaMap.put(sfc.getField().getName(), sfc);
        }
        String title = null;
        if (fieldCriteriaMap.containsKey(this.titleName) && fieldCriteriaMap.get(this.titleName) != null && ((SearchFieldCriteria)fieldCriteriaMap.get(this.titleName)).getValue().length() > 0) {
            title = ((SearchFieldCriteria)fieldCriteriaMap.get(this.titleName)).getValue();
        }
        Integer year = null;
        if (fieldCriteriaMap.containsKey(this.yearName) && fieldCriteriaMap.get(this.yearName) != null && ((SearchFieldCriteria)fieldCriteriaMap.get(this.yearName)).getValue().length() > 0) {
            year = Integer.parseInt(((SearchFieldCriteria)fieldCriteriaMap.get(this.yearName)).getValue());
        }
        String mpaaRating = null;
        if (fieldCriteriaMap.containsKey(this.ratingName) && fieldCriteriaMap.get(this.ratingName) != null && ((SearchFieldCriteria)fieldCriteriaMap.get(this.ratingName)).getValue().length() > 0) {
            mpaaRating = ((SearchFieldCriteria)fieldCriteriaMap.get(this.ratingName)).getValue();
        }
        Integer runtime = null;
        String hhmmss = null;
        if (fieldCriteriaMap.containsKey(this.runtimeName) && fieldCriteriaMap.get(this.runtimeName) != null && ((SearchFieldCriteria)fieldCriteriaMap.get(this.runtimeName)).getValue().length() > 0) {
            try {
                runtime = Integer.parseInt(((SearchFieldCriteria)fieldCriteriaMap.get(this.runtimeName)).getValue());
            }
            catch (NumberFormatException nfe) {
                hhmmss = ((SearchFieldCriteria)fieldCriteriaMap.get(this.runtimeName)).getValue();
            }
        }
        String type = null;
        if (fieldCriteriaMap.containsKey(this.typeName) && fieldCriteriaMap.get(this.typeName) != null && ((SearchFieldCriteria)fieldCriteriaMap.get(this.typeName)).getValue().length() > 0) {
            type = ((SearchFieldCriteria)fieldCriteriaMap.get(this.typeName)).getValue();
        }
        double ranking = this.compareTitles(title, movie.getTitle());
        ranking *= this.compareYear(year, movie);
        ranking *= this.compareRating(mpaaRating, movie);
        if (runtime != null) {
            ranking *= this.compareRuntime(runtime, movie);
        } else if (hhmmss != null) {
            ranking *= this.compareRuntime(hhmmss, movie);
        }
        if (type != null && !type.equals(movie.getType())) {
            try {
                ranking *= 1.0 - (double)((SearchFieldCriteria)fieldCriteriaMap.get(this.typeName)).getWeight() / 100.0;
            }
            catch (NullPointerException npe) {
                ranking *= 0.9;
            }
        }
        return new Integer((int)(ranking * 100.0));
    }

    public String normalizedTitle(String str) {
        return this.removeBogusEndPhrases(this.normalizeNoise(this.insertSpaceForInnerCaps(str)));
    }

    public String normalizeNoise(String str) {
        StringBuffer sb = new StringBuffer();
        for (String token : str.split("\\s+")) {
            if (this.noises.contains(token)) continue;
            String t = this.translate.get(token);
            if (t == null) {
                sb.append(token);
            } else {
                sb.append(t);
            }
            sb.append(" ");
        }
        return sb.toString().trim();
    }

    public String removeBogusEndPhrases(String str) {
        for (String bogusEnd : this.bogusEnds) {
            if (!str.endsWith(bogusEnd)) continue;
            return this.removeBogusEndPhrases(str.substring(0, str.length() - bogusEnd.length()));
        }
        for (String bogusStart : this.bogusStarts) {
            if (!str.startsWith(bogusStart)) continue;
            return this.removeBogusEndPhrases(str.substring(bogusStart.length(), str.length()));
        }
        try {
            String[] tokens = str.split("\\s+");
            String lastToken = tokens[tokens.length - 1];
            int year = Integer.parseInt(lastToken);
            if (year > 1920 && year < 2012) {
                return this.removeBogusEndPhrases(str.substring(0, str.length() - lastToken.length()));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return str;
    }

    public String insertSpaceForInnerCaps(String strIn) {
        boolean needsSpaces = strIn.length() > 12 && strIn.indexOf(32) == -1;
        String str = strIn.replaceAll(":", ": ");
        str = str.replaceAll("[^A-Za-z0-9-/ ]", "");
        StringBuffer sb = new StringBuffer(str.substring(0, 1).toLowerCase());
        char[] stringArray = str.toCharArray();
        boolean prevUpperOrNum = true;
        for (int index = 1; index < stringArray.length; ++index) {
            boolean isUpperOrNum;
            boolean bl = isUpperOrNum = stringArray[index] >= 'A' && stringArray[index] <= 'Z' || stringArray[index] >= '0' && stringArray[index] <= '9' || stringArray[index] == '-' || stringArray[index] == '/';
            if (needsSpaces && !prevUpperOrNum && isUpperOrNum && stringArray[index] != '-' && stringArray[index] != '/') {
                sb.append(" ");
            }
            sb.append(Character.toLowerCase(stringArray[index]));
            prevUpperOrNum = isUpperOrNum;
        }
        return sb.toString().trim();
    }

    public String asString(CacheResult result) {
        StringWriter sw = new StringWriter();
        ObjectMapper mapper = new ObjectMapper();
        try {
            mapper.writeValue((Writer)sw, (Object)result);
        }
        catch (JsonGenerationException e) {
            throw new RuntimeException(e);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sw.toString();
    }

    public JsonNode getMetadata(CacheResult result) {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.valueToTree((Object)result);
    }

    public String getStringValue(String key, Map<String, Object> map) throws Exception {
        String value = null;
        Object foundValue = this.getValue(key, map);
        if (foundValue != null) {
            value = String.valueOf(foundValue);
        }
        return value;
    }

    public Double getDoubleValue(String key, Map<String, Object> map) throws Exception {
        Double value = null;
        String foundValue = this.getStringValue(key, map);
        if (foundValue != null) {
            value = Double.parseDouble(foundValue);
        }
        return value;
    }

    public Integer getIntegerValue(String key, Map<String, Object> map) throws Exception {
        Integer value = null;
        String foundValue = this.getStringValue(key, map);
        if (foundValue != null) {
            value = Integer.parseInt(foundValue);
        }
        return value;
    }

    public Date getDateValue(String key, Map<String, Object> map) throws Exception {
        Date value = null;
        String foundValue = this.getStringValue(key, map);
        if (foundValue != null) {
            Long timeInMillis = Long.parseLong(foundValue);
            value = new Date(timeInMillis);
        }
        return value;
    }

    public List<Map<String, Object>> getListValue(String key, Map<String, Object> map) throws Exception {
        List list = null;
        Object foundValue = this.getValue(key, map);
        if (foundValue != null) {
            list = (List)foundValue;
        }
        return list;
    }

    public Object getValue(String key, Map<String, Object> movieMap) throws Exception {
        List<Object> valueList = this.getValueList(key, movieMap);
        if (valueList != null) {
            if (valueList.size() == 1) {
                return valueList.get(0);
            }
            if (valueList.size() > 1) {
                return valueList;
            }
            return null;
        }
        return valueList;
    }

    public List<Object> getValueList(String key, Map<String, Object> movieMap) throws Exception {
        ArrayList<Object> valueList = new ArrayList<Object>();
        if (movieMap.containsKey(key)) {
            valueList.add(movieMap.get(key));
        } else {
            for (String curKey : movieMap.keySet()) {
                Object curObj = movieMap.get(curKey);
                if (curObj instanceof Map) {
                    Map curMap = (Map)curObj;
                    valueList.addAll(this.getValueList(key, curMap));
                    continue;
                }
                if (!(curObj instanceof List)) continue;
                List curList = (List)curObj;
                for (Object curListObj : curList) {
                    if (!(curListObj instanceof Map)) continue;
                    Map curMap = (Map)curListObj;
                    valueList.addAll(this.getValueList(key, curMap));
                }
            }
        }
        return valueList;
    }

    public Map<String, Object> getSubMap(String key, Map<String, Object> movieMap) throws Exception {
        Map curMap = movieMap;
        if (key != null) {
            if (key.contains(".")) {
                String[] keys = key.split("\\.");
                for (int i = 0; i < keys.length; ++i) {
                    Object curVal = curMap.get(keys[i]);
                    if (curVal == null || !(curVal instanceof Map)) {
                        throw new Exception("Invalid path [" + key + "]");
                    }
                    curMap = (Map)curVal;
                }
            } else {
                Object curVal = curMap.get(key);
                if (curVal != null && curVal instanceof Map) {
                    curMap = (Map)curVal;
                } else {
                    throw new Exception("Invalid path [" + key + "]");
                }
            }
        }
        return curMap;
    }

    public Set<Integer> getReleaseYears(CacheResult movie) throws Exception {
        HashSet<Integer> years = new HashSet<Integer>();
        years.add(movie.getYear());
        try {
            Map<String, Object> releaseYears = this.getSubMap(this.releaseDateName, movie.getOtherMetadata());
            for (String curKey : releaseYears.keySet()) {
                Object curObj = releaseYears.get(curKey);
                if (curObj instanceof Integer) {
                    years.add((Integer)curObj);
                    continue;
                }
                if (!(curObj instanceof String)) continue;
                SimpleDateFormat sdf = new SimpleDateFormat(this.dateFormat);
                long dateInMillis = sdf.parse((String)curObj).getTime();
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(dateInMillis);
                years.add(cal.get(1));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return years;
    }

    public Set<Integer> getReleaseYearsPlusMinusOne(CacheResult movie) throws Exception {
        Set<Integer> years = this.getReleaseYears(movie);
        HashSet<Integer> newYears = new HashSet<Integer>();
        for (Integer i : years) {
            newYears.add(i + 1);
            newYears.add(i - 1);
        }
        years.addAll(newYears);
        return years;
    }

    public void setTitleName(String titleName) {
        this.titleName = titleName;
    }

    public void setYearName(String yearName) {
        this.yearName = yearName;
    }

    public void setRuntimeName(String runtimeName) {
        this.runtimeName = runtimeName;
    }

    public void setRatingName(String ratingName) {
        this.ratingName = ratingName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public void setReleaseDateName(String releaseDateName) {
        this.releaseDateName = releaseDateName;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }
}

