/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.me.client.view.custom;

import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.List;

public class ErrorPanel
extends SimpleContainer {
    private String ERROR_MESSAGE_STYLE = "me-ValidationView-error ";
    private String SECTION_HEADING1_STYLE = "me-ValidationView-sectionHeading1";
    private String SECTION_HEADING2_STYLE = "me-ValidationView-sectionHeading2";
    private String PANEL_STYLE = "me-ValidationView";
    private int PANEL_SPACING = 5;
    protected VerticalContainer mainContainer = new VerticalContainer();
    private VerticalContainer messageContainer;

    public ErrorPanel() {
        this.mainContainer.addStyleName(this.PANEL_STYLE);
        this.mainContainer.addStyleName(this.ERROR_MESSAGE_STYLE);
        this.mainContainer.setSpacing(this.PANEL_SPACING);
        this.mainContainer.setVisible(false);
        this.messageContainer = new VerticalContainer();
        this.mainContainer.add((Widget)this.messageContainer);
        this.add((Widget)this.mainContainer);
    }

    public void showMessage(String message) {
        this.messageContainer.clear();
        this.addMessage(message);
    }

    public void showErrorHeader(String header) {
        this.messageContainer.clear();
        this.addHeading1(header + "\n");
    }

    public void addMessage(String message) {
        if (message != null && !message.trim().equals("")) {
            this.mainContainer.setVisible(true);
            this.messageContainer.add((Widget)this.createMessageLabel("", message, this.SECTION_HEADING1_STYLE));
        }
    }

    public void addHeading1(String message) {
        if (message != null && !message.trim().equals("")) {
            this.mainContainer.setVisible(true);
            this.messageContainer.add((Widget)this.createMessageLabel("", message, this.SECTION_HEADING1_STYLE));
        }
    }

    public void addHeading2(String message) {
        if (message != null && !message.trim().equals("")) {
            this.mainContainer.setVisible(true);
            this.messageContainer.add((Widget)this.createMessageLabel("- ", message, this.SECTION_HEADING2_STYLE));
        }
    }

    public void addError(String message) {
        if (message != null && !message.trim().equals("")) {
            this.mainContainer.setVisible(true);
            this.messageContainer.add((Widget)this.createMessageLabel("- ", message, this.SECTION_HEADING2_STYLE));
        }
    }

    public void addErrors(List<String> errors) {
        this.addHeading1("Errors(" + errors.size() + ")");
        for (String curError : errors) {
            this.addError("\t" + curError + "");
        }
    }

    private LabelWidget createMessageLabel(String prefix, String message, String style) {
        LabelWidget messageLabel = new LabelWidget();
        messageLabel.setText(prefix + message);
        messageLabel.addStyleName(style);
        messageLabel.addStyleName(this.ERROR_MESSAGE_STYLE);
        messageLabel.setWordWrap(true);
        return messageLabel;
    }

    public void reset() {
        this.messageContainer.clear();
        this.mainContainer.setVisible(false);
    }
}

