/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.me.client.view.custom;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;

public class MECustomTableWidget
extends Composite {
    private static final String TABLE_STYLE = "me-ConflictResultTable";
    private static final String ROW_STYLE = "me-ConflictResultTable-row";
    private static final String ROW_HEADER_STYLE = "me-ConflictResultTable-row-header";
    private static final String ROW_BODY_STYLE = "me-ConflictResultTable-row-body";
    private static final String CELL_STYLE = "me-ConflictResultTable-cell";
    private static final String CELL_HEADER_STYLE = "me-ConflictResultTable-cell-header";
    private static final String CELL_BODY_STYLE = "me-ConflictResultTable-cell-body";
    private static final String CELL_HEADER_LABEL_STYLE = "me-ConflictResultTable-header-text";
    public static final String CELL_DELETE_COLUMN_STYLE = "me-ConflictResultTable-cell-body-delete";
    private FlexTableContainer table = new FlexTableContainer();

    public MECustomTableWidget() {
        this.initialize();
    }

    public FlexTableContainer getTable() {
        return this.table;
    }

    public void initialize() {
        this.table.addStyleName(TABLE_STYLE);
        this.table.insertRow(0);
        this.table.getRowFormatter().addStyleName(0, ROW_STYLE);
        this.table.getRowFormatter().addStyleName(0, ROW_HEADER_STYLE);
        this.initWidget((Widget)this.table);
    }

    public void addHeading(String heading) {
        int column = this.table.getCellCount(0);
        this.table.insertCell(0, column);
        this.table.getCellFormatter().addStyleName(0, column, CELL_STYLE);
        this.table.getCellFormatter().addStyleName(0, column, CELL_HEADER_STYLE);
        this.updateHeading(heading, column);
    }

    public void updateHeading(String heading, int column) {
        LabelWidget label = this.getHeadingWidget(column);
        if (label == null) {
            label = new LabelWidget(heading);
            label.addStyleName(CELL_HEADER_LABEL_STYLE);
            this.table.setWidget(0, column, (Widget)label);
        } else {
            label.setText(heading);
        }
    }

    public LabelWidget getHeadingWidget(int column) {
        Widget widget = this.table.getWidget(0, column);
        return widget instanceof LabelWidget ? (LabelWidget)widget : null;
    }

    private void validateBodyRow(int row) {
        if (row < 0) {
            throw new IllegalArgumentException("The row index cannot be less than 0.");
        }
    }

    public int addRow(int row) {
        this.validateBodyRow(row);
        int tableRow = row + 1;
        this.table.insertRow(tableRow);
        this.table.getRowFormatter().addStyleName(tableRow, ROW_STYLE);
        this.table.getRowFormatter().addStyleName(tableRow, ROW_BODY_STYLE);
        return row;
    }

    public int addRow() {
        return this.addRow(this.getRowCount());
    }

    public int getRowCount() {
        return this.table.getRowCount() - 1;
    }

    public int getCellCount(int row) {
        return this.table.getCellCount(row + 1);
    }

    public void addCell(int row, Widget widget) {
        this.addCell(row, this.getCellCount(row), widget);
    }

    public void addCell(int row, int column, Widget widget) {
        int tableRow = row + 1;
        this.table.insertCell(tableRow, column);
        this.table.getCellFormatter().addStyleName(tableRow, column, CELL_STYLE);
        this.table.getCellFormatter().addStyleName(tableRow, column, CELL_BODY_STYLE);
        this.updateCell(row, column, widget);
    }

    public void updateCell(int row, int column, Widget widget) {
        int tableRow = row + 1;
        this.table.clearCell(tableRow, column);
        this.table.setWidget(tableRow, column, widget);
    }

    public void removeAllRows() {
        int rowCount = this.getRowCount();
        for (int i = rowCount - 1; i >= 0; --i) {
            this.removeRow(i);
        }
    }

    public void removeRow(int row) {
        this.validateBodyRow(row);
        this.table.removeRow(row + 1);
    }
}

