/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.me.client.view.custom;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HTMLTable;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import java.util.ArrayList;
import java.util.List;

public class ResizeableTable
extends FlexTableContainer {
    private List<List<Widget>> valueTable = new ArrayList<List<Widget>>();
    private TemplateRowGenerator templateRowGen;
    private boolean hasHeaders = false;
    private int maxWidth = 0;
    private static final boolean CONFIRM_REMOVE = false;
    private boolean editable = true;

    public ResizeableTable() {
    }

    public ResizeableTable(TemplateRowGenerator templateRowGen) {
        this.templateRowGen = templateRowGen;
        this.addRow(templateRowGen.getTemplateRow());
        this.resetAddButtons();
    }

    public ResizeableTable(TemplateRowGenerator templateRowGen, List<List<Widget>> existingValues, boolean editable) {
        this.templateRowGen = templateRowGen;
        this.setEditable(editable);
        this.valueTable = existingValues;
        this.maxWidth = this.calcMaxWidth(this.valueTable);
        if (existingValues.size() > 0) {
            int i = 0;
            for (List<Widget> curList : existingValues) {
                this.setRow(i, curList);
                ++i;
            }
        } else {
            this.setRow(0, templateRowGen.getTemplateRow());
        }
        this.resetAddButtons();
    }

    public void setHeaders(List<String> headers) {
        if (!this.hasHeaders) {
            this.insertRow(0);
            this.hasHeaders = true;
        }
        int i = 0;
        for (String header : headers) {
            LabelWidget label = new LabelWidget(header);
            this.setWidget(0, i, (Widget)label);
            label.getElement().addClassName("first-row-label");
            ++i;
        }
    }

    private void setRow(int rowIndex, List<Widget> row) {
        if (row != null) {
            int i = 0;
            for (Widget curWidget : row) {
                this.setWidget(rowIndex, i, curWidget);
                ++i;
            }
            if (row instanceof TableRow) {
                TableRow tableRow = (TableRow)row;
                if (tableRow.isRemovable()) {
                    this.setWidget(rowIndex, i, (Widget)new ResizeButton(Operation.remove));
                }
            } else {
                this.setWidget(rowIndex, i, (Widget)new ResizeButton(Operation.remove));
            }
        }
    }

    public List<List<Widget>> getValues() {
        return this.valueTable;
    }

    public void addRow(List<Widget> row) {
        this.valueTable.add(row);
        this.setRow(this.valueTable.size() - 1 + this.getHeaderOffset(), row);
        this.maxWidth = this.calcMaxWidth(this.valueTable);
        this.resetAddButtons();
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    private int calcMaxWidth(List<List<Widget>> valueTable) {
        int max = 0;
        for (List<Widget> curList : valueTable) {
            max = curList.size() > max ? curList.size() : max;
        }
        return max;
    }

    private int getHeaderOffset() {
        return this.hasHeaders ? 1 : 0;
    }

    private void resetAddButtons() {
        int headerOffset;
        for (int i = headerOffset = this.getHeaderOffset(); i < this.getRowCount(); ++i) {
            if (this.getCellCount(i) < this.maxWidth + 2) continue;
            this.removeCell(i, this.maxWidth + 1);
        }
        this.setWidget(this.getRowCount() - 1, this.maxWidth + 1, (Widget)new ResizeButton(Operation.add));
    }

    public class TableRow<T>
    extends ArrayList<T> {
        private boolean removable = true;

        public TableRow(boolean removable) {
            this.setRemovable(removable);
        }

        public void setRemovable(boolean removable) {
            this.removable = removable;
        }

        public boolean isRemovable() {
            return this.removable;
        }
    }

    public static interface TemplateRowGenerator {
        public List<Widget> getTemplateRow();
    }

    static enum Operation {
        add,
        remove;

    }

    class ResizeButtonClickHandler
    implements ClickHandler {
        ResizeButtonClickHandler() {
        }

        public void onClick(ClickEvent event) {
            ResizeButton source = (ResizeButton)((Object)event.getSource());
            switch (source.getOperation()) {
                case add: {
                    try {
                        ResizeableTable.this.addRow(ResizeableTable.this.templateRowGen.getTemplateRow());
                        source.setVisible(false);
                    }
                    catch (Exception e) {
                        Window.alert((String)("Unable to add row (" + e.getMessage() + ")"));
                    }
                    break;
                }
                case remove: {
                    if (ResizeableTable.this.valueTable.size() <= 1) break;
                    HTMLTable.Cell clickedCell = ResizeableTable.this.getCellForEvent(event);
                    ResizeableTable.this.removeRow(clickedCell.getRowIndex());
                    ResizeableTable.this.valueTable.remove(clickedCell.getRowIndex() - ResizeableTable.this.getHeaderOffset());
                    ResizeableTable.this.resetAddButtons();
                    break;
                }
                default: {
                    Window.alert((String)("Unknown operation: " + (Object)((Object)source.getOperation())));
                }
            }
        }
    }

    class ResizeButton
    extends Button {
        private static final String REMOVE_LABEL = "-";
        private static final String ADD_LABEL = "+";
        Operation operation;
        int rowNum;

        protected ResizeButton(Operation oper) {
            this.operation = oper;
            String label = REMOVE_LABEL;
            switch (this.operation) {
                case add: {
                    label = ADD_LABEL;
                    this.setStyleName("ebBtn plus_button_icon");
                    break;
                }
                case remove: {
                    label = REMOVE_LABEL;
                    this.setStyleName("ebBtn minus_button_icon");
                }
            }
            this.setHTML(label);
            this.addClickHandler(new ResizeButtonClickHandler());
            this.setVisible(ResizeableTable.this.editable);
        }

        protected int getRowNum() {
            return this.rowNum;
        }

        protected Operation getOperation() {
            return this.operation;
        }
    }
}

