/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.me.client.view.metadatadeconflict;

import com.ericsson.cms.me.client.i18n.MEConstants;
import com.ericsson.cms.me.client.model.UiCacheResult;
import com.ericsson.cms.me.client.model.UiCacheResultRecord;
import com.ericsson.cms.me.client.model.UiCacheResultStatus;
import com.ericsson.cms.me.client.rpc.IMEManagerService;
import com.ericsson.cms.me.client.rpc.IMEManagerServiceAsync;
import com.ericsson.cms.me.client.view.metadatadeconflict.MetadataConflictSelectionPanel;
import com.ericsson.cms.me.client.view.metadatadeconflict.viewwidget.ImageView;
import com.ericsson.cms.me.client.view.metadatadeconflict.viewwidget.MetadataProgressBarWidget;
import com.ericsson.cms.me.client.view.metadatadeconflict.viewwidget.RadioButtonLabelView;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.RadioButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelStringView;
import java.util.ArrayList;
import java.util.List;

public class MetadataConflictSelectionDataProvider
implements DataProvider<Long, UiCacheResultRecord> {
    private final List<Column<?, UiCacheResultRecord>> columns;
    private final ColumnBase<String, UiCacheResultRecord> thirdPartyIdColumn;
    private final ColumnBase<String, UiCacheResultRecord> thumbnailColumn;
    private final ColumnBase<String, UiCacheResultRecord> nameColumn;
    private final ColumnBase<String, UiCacheResultRecord> yearColumn;
    private final ColumnBase<String, UiCacheResultRecord> typeColumn;
    private final ColumnBase<String, UiCacheResultRecord> actorsColumn;
    private final ColumnBase<String, UiCacheResultRecord> rankingColumn;
    private static final String THIRDPARTY_COLUMN = "ThirdPartyId";
    private static final String THUMBNAIL_COLUMN = "Thumbnail";
    private static final String NAME_COLUMN = "Name";
    private static final String YEAR_COLUMN = "Year";
    private static final String TYPE_COLUMN = "Type";
    private static final String ACTORS_COLUMN = "Actors";
    private static final String RANKING_COLUMN = "BestMatchRating";
    private final IMEManagerServiceAsync meManagerService = (IMEManagerServiceAsync)GWT.create(IMEManagerService.class);
    private final MEConstants constants = (MEConstants)GWT.create(MEConstants.class);
    private final MetadataConflictSelectionPanel panel;
    private final Long profileId;
    private final String requestKey;
    private boolean isRadioButtonEnabled = true;
    private SortFeatureImpl<Long, UiCacheResultRecord> parentSortFeature;

    public MetadataConflictSelectionDataProvider(MetadataConflictSelectionPanel panel, Long profileId, String requestKey) {
        this.panel = panel;
        this.profileId = profileId;
        this.requestKey = requestKey;
        this.columns = new ArrayList();
        this.thirdPartyIdColumn = new ColumnBase<String, UiCacheResultRecord>(THIRDPARTY_COLUMN, this.constants.thirdPartyId()){

            public View<String> getView(final UiCacheResultRecord record) {
                RadioButtonLabelView view = new RadioButtonLabelView(record.getUiCacheResult().getRemoteId(), MetadataConflictSelectionDataProvider.this.isRadioButtonEnabled);
                RadioButtonWidget radioButton = (RadioButtonWidget)view.getWidget();
                boolean selected = record.getUiCacheResult().getStatus().equalsIgnoreCase(UiCacheResultStatus.SELECTED.toString());
                radioButton.setValue(Boolean.valueOf(selected));
                radioButton.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        MetadataConflictSelectionDataProvider.this.updatePanelSelectionResultId(record.getUiCacheResult().getId());
                    }
                });
                return view;
            }
        };
        this.thirdPartyIdColumn.setCellStyle("gwt-RadioButton");
        this.columns.add((Column<?, UiCacheResultRecord>)this.thirdPartyIdColumn);
        this.thumbnailColumn = new ColumnBase<String, UiCacheResultRecord>(THUMBNAIL_COLUMN, this.constants.thumbnail()){

            public View<String> getView(UiCacheResultRecord record) {
                return new ImageView(record.getUiCacheResult().getThumbnail());
            }
        };
        this.thumbnailColumn.setCellStyle("nwt-TableColumnPanel-dataCell-icon");
        this.columns.add((Column<?, UiCacheResultRecord>)this.thumbnailColumn);
        this.nameColumn = new ColumnBase<String, UiCacheResultRecord>(NAME_COLUMN, this.constants.name()){

            public View<String> getView(UiCacheResultRecord record) {
                return new LabelStringView(record.getUiCacheResult().getTitle());
            }
        };
        this.nameColumn.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        this.columns.add((Column<?, UiCacheResultRecord>)this.nameColumn);
        this.yearColumn = new ColumnBase<String, UiCacheResultRecord>(YEAR_COLUMN, this.constants.year()){

            public View<String> getView(UiCacheResultRecord record) {
                return new LabelStringView(record.getUiCacheResult().getYear());
            }
        };
        this.yearColumn.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        this.columns.add((Column<?, UiCacheResultRecord>)this.yearColumn);
        this.typeColumn = new ColumnBase<String, UiCacheResultRecord>(TYPE_COLUMN, this.constants.type()){

            public View<String> getView(UiCacheResultRecord record) {
                return new LabelStringView(record.getUiCacheResult().getType());
            }
        };
        this.typeColumn.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        this.columns.add((Column<?, UiCacheResultRecord>)this.typeColumn);
        this.actorsColumn = new ColumnBase<String, UiCacheResultRecord>(ACTORS_COLUMN, this.constants.actors()){

            public View<String> getView(UiCacheResultRecord record) {
                return new LabelStringView(record.getUiCacheResult().getActors());
            }
        };
        this.actorsColumn.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        this.columns.add((Column<?, UiCacheResultRecord>)this.actorsColumn);
        this.rankingColumn = new ColumnBase<String, UiCacheResultRecord>(RANKING_COLUMN, this.constants.ranking()){

            public View<String> getView(UiCacheResultRecord record) {
                return new MetadataProgressBarWidget(String.valueOf(record.getUiCacheResult().getRanking()));
            }
        };
        this.rankingColumn.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        this.columns.add((Column<?, UiCacheResultRecord>)this.rankingColumn);
    }

    public ColumnBase<String, UiCacheResultRecord> getDefaultSortColumn() {
        return this.rankingColumn;
    }

    public List<Column<?, UiCacheResultRecord>> getSortColumns() {
        return this.columns;
    }

    public void initialize(AsyncCallback<Void> callback) {
        callback.onSuccess(null);
    }

    public List<Column<?, UiCacheResultRecord>> getColumns() {
        return this.columns;
    }

    public void getRecords(final AsyncCallback<List<UiCacheResultRecord>> callback) {
        this.meManagerService.getConflictsToResolve(this.profileId, this.requestKey, new AsyncCallback<List<UiCacheResult>>(){

            public void onFailure(Throwable caught) {
                Window.alert((String)caught.getLocalizedMessage());
            }

            public void onSuccess(List<UiCacheResult> result) {
                if (result != null) {
                    ArrayList<UiCacheResultRecord> uiCacheResultRecordList = new ArrayList<UiCacheResultRecord>();
                    for (UiCacheResult cacheResult : result) {
                        UiCacheResultRecord cacheResultRecord = new UiCacheResultRecord();
                        cacheResultRecord.setUiCacheResult(cacheResult);
                        uiCacheResultRecordList.add(cacheResultRecord);
                    }
                    if (uiCacheResultRecordList.size() == 1 && MetadataConflictSelectionDataProvider.this.isRadioButtonEnabled) {
                        ((UiCacheResultRecord)uiCacheResultRecordList.get(0)).getUiCacheResult().setStatus(UiCacheResultStatus.SELECTED.toString());
                    }
                    callback.onSuccess(uiCacheResultRecordList);
                }
            }
        });
    }

    public void getRecord(Long key, AsyncCallback<UiCacheResultRecord> callback) {
    }

    private void updatePanelSelectionResultId(Long id) {
        this.panel.setSelectedResultId(id);
        this.panel.updateSelection(UiCacheResultStatus.SELECTED.toString());
        this.panel.updateTabHeader();
    }

    public boolean isRecordCountEnabled() {
        return false;
    }

    public boolean isCheckboxEnabled() {
        return false;
    }

    public SortFeatureImpl<Long, UiCacheResultRecord> getParentSortFeature() {
        return this.parentSortFeature;
    }

    public void setParentSortFeature(SortFeatureImpl<Long, UiCacheResultRecord> parentSortFeature) {
        this.parentSortFeature = parentSortFeature;
    }

    public boolean isRadioButtonEnabled() {
        return this.isRadioButtonEnabled;
    }

    public void setRadioButtonEnabled(boolean isRadioButtonEnabled) {
        this.isRadioButtonEnabled = isRadioButtonEnabled;
    }
}

