/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.me.client.view.metadatadeconflict;

import com.ericsson.cms.me.client.i18n.MEConstants;
import com.ericsson.cms.me.client.model.UiCacheResultRecord;
import com.ericsson.cms.me.client.model.UiCacheResultStatus;
import com.ericsson.cms.me.client.rpc.IMEManagerService;
import com.ericsson.cms.me.client.rpc.IMEManagerServiceAsync;
import com.ericsson.cms.me.client.view.metadatadeconflict.MetadataConflictSelectionDataProvider;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ToggleButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.ScrollContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.TabContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class MetadataConflictSelectionPanel
extends Composite {
    private final IMEManagerServiceAsync meManagerService = (IMEManagerServiceAsync)GWT.create(IMEManagerService.class);
    private final MEConstants constants = (MEConstants)GWT.create(MEConstants.class);
    private final VerticalContainer searchPanel;
    private final ScrollContainer scrollPanel = new ScrollContainer();
    private final TabContainer tabContainer;
    private final MetadataConflictSelectionDataProvider dataProvider;
    private final Table<Long, UiCacheResultRecord> table;
    private final HorizontalContainer buttonContainer;
    private final Long profileId;
    private Long selectedResultId = null;
    private final String requestKey;
    private String tabName;
    private static final String STYLE_SCROLL_CONTAINER = "me-SearchResult-scrollContainer";
    private static final String STYLE_ME_TOGGLE_BUTTON = "me-yes-no-button";

    public MetadataConflictSelectionPanel(Long profileId, String requestKey, TabContainer tabContainer) {
        this.searchPanel = new VerticalContainer();
        this.searchPanel.setWidth("97.5%");
        this.profileId = profileId;
        this.requestKey = requestKey;
        this.tabContainer = tabContainer;
        this.scrollPanel.addStyleName(STYLE_SCROLL_CONTAINER);
        this.dataProvider = new MetadataConflictSelectionDataProvider(this, this.profileId, this.requestKey);
        this.table = new Table((DataProvider)this.dataProvider);
        this.table.getElement().setId("metadataConflictSelectTable");
        this.table.initialize(null);
        this.scrollPanel.add(this.table);
        this.buttonContainer = new HorizontalContainer();
        this.buttonContainer.setStyleName("metadata-deconflict-panel-button-container");
        this.buildButtonHeaderPanel();
        this.searchPanel.add((Widget)this.buttonContainer);
        this.searchPanel.setCellHorizontalAlignment((Widget)this.buttonContainer, HasHorizontalAlignment.ALIGN_RIGHT);
        this.searchPanel.add((Widget)this.scrollPanel);
        this.initWidget((Widget)this.searchPanel);
    }

    private void buildButtonHeaderPanel() {
        LabelWidget useProfileLabel = new LabelWidget(this.constants.deConflictIgnoreButton());
        LabelWidget emptyWidget = new LabelWidget("");
        emptyWidget.setWidth("5px");
        final ToggleButtonWidget toggleButton = new ToggleButtonWidget("YES", "NO");
        toggleButton.setStylePrimaryName(STYLE_ME_TOGGLE_BUTTON);
        toggleButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (toggleButton.isDown()) {
                    MetadataConflictSelectionPanel.this.ignoreProfile();
                    MetadataConflictSelectionPanel.this.updateTabHeader();
                    MetadataConflictSelectionPanel.this.dataProvider.setRadioButtonEnabled(false);
                } else {
                    MetadataConflictSelectionPanel.this.setProfileToAvailable();
                    MetadataConflictSelectionPanel.this.dataProvider.setRadioButtonEnabled(true);
                }
                MetadataConflictSelectionPanel.this.table.refresh();
            }
        });
        this.buttonContainer.add((Widget)useProfileLabel);
        this.buttonContainer.setCellVerticalAlignment((Widget)useProfileLabel, HasVerticalAlignment.ALIGN_MIDDLE);
        this.buttonContainer.add((Widget)emptyWidget);
        this.buttonContainer.add((Widget)toggleButton);
    }

    public void searchResultToDeconflict() {
        this.table.refresh();
    }

    private void ignoreProfile() {
        this.updateSelection(UiCacheResultStatus.IGNORED.toString());
    }

    private void setProfileToAvailable() {
        this.updateSelection(UiCacheResultStatus.AVAILABLE.toString());
    }

    public void updateSelection(String status) {
        this.meManagerService.updateCacheResultStatus(this.requestKey, this.profileId, this.selectedResultId, status, new AsyncCallback<Void>(){

            public void onFailure(Throwable caught) {
                Window.alert((String)caught.getLocalizedMessage());
            }

            public void onSuccess(Void result) {
                MetadataConflictSelectionPanel.this.searchResultToDeconflict();
            }
        });
    }

    public void updateTabHeader() {
        int index = 0;
        index = this.tabContainer.getTabBar().getSelectedTab();
        this.tabContainer.getTabBar().setTabText(index, "*" + this.getTabName());
    }

    public Long getSelectedResultId() {
        return this.selectedResultId;
    }

    public void setSelectedResultId(Long selectedResultId) {
        this.selectedResultId = selectedResultId;
    }

    public String getTabName() {
        return this.tabName;
    }

    public void setTabName(String tabName) {
        this.tabName = tabName;
    }

    public void setHeight(int height) {
        int scrollHeight = height - (this.buttonContainer.getOffsetHeight() + 10 + 32);
        this.scrollPanel.setHeight(scrollHeight + "px");
    }
}

